/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.ctrl.semantic.common.client.TreeBuilder;
import com.kingdee.bos.ctrl.semantic.common.client.icon.SemanticIcons;
import com.kingdee.bos.ctrl.semantic.design.ISemanticDesignFacade;
import com.kingdee.bos.ctrl.semantic.design.client.CustomTreeCellRenderer;
import com.kingdee.bos.ctrl.semantic.design.client.action.EditEntity;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.manage.client.EditingContext;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SchemaTree {
    private static final Logger log = LogUtil.getPackageLogger(SchemaTree.class);
    private KDTree _tree;
    private KDTreeView _treeView;
    private TreeBuilder _treeBuilder;
    private EditingContext _editingContext;

    public SchemaTree() {
        this.initTree();
    }

    private void initTree() {
        DefaultKingdeeTreeNode root = SchemaTree.createFolderNode("", "");
        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)root);
        treeModel.setAsksAllowsChildren(true);
        this._tree = new KDTree();
        this._tree.setModel((TreeModel)treeModel);
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer((TreeCellRenderer)((Object)new CustomTreeCellRenderer()));
        this._treeView = new KDTreeView(this._tree);
        this._treeView.setShowButton(false);
        this._treeBuilder = new TreeBuilder(this._tree);
    }

    public void addAction(Action action) {
        KDWorkButton btn = new KDWorkButton(action);
        btn.setToolTipText(btn.getText());
        btn.setText(null);
        this._treeView.getControlPane().add((Component)btn);
    }

    public void addDoubleClickAction(final EditEntity action) {
        this._tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    TreePath treePath = SchemaTree.this._tree.getSelectionPath();
                    if (treePath == null) {
                        return;
                    }
                    DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
                    LazyInfo info = (LazyInfo)selectedNode.getUserObject();
                    if (info.getType() != 0) {
                        action.doAction(info);
                    }
                }
            }
        });
    }

    private DefaultKingdeeTreeNode getTreeRoot() {
        return (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
    }

    public KDTree getTree() {
        return this._tree;
    }

    public JComponent getUI() {
        return this._treeView;
    }

    public void setEditingContext(EditingContext editingContext) {
        this._editingContext = editingContext;
        this.updateNodeText(this.getTreeRoot(), this._editingContext.getSchemaName());
        try {
            this.refresh(this.getTreeRoot());
        }
        catch (SemanticDesignException ex) {
            log.error((Object)"Refresh semantic schema tree error.", (Throwable)ex);
        }
    }

    public void updateNodeText(DefaultKingdeeTreeNode node, String lName, String pName, boolean isDirty) {
        this.updateNodeText(node, this.makeNodeText(lName, pName, isDirty));
    }

    private void updateNodeText(DefaultKingdeeTreeNode node, String text) {
        node.setText(text);
        ((DefaultTreeModel)this.getTree().getModel()).nodeChanged((TreeNode)node);
    }

    private String makeNodeText(String lName, String pName, boolean isDirty) {
        StringBuffer text = new StringBuffer();
        if (isDirty) {
            text.append("\u2605 ");
        }
        text.append(lName);
        if (!StringUtil.equals((String)lName, (String)pName)) {
            text.append(" (");
            text.append(pName);
            text.append(")");
        }
        return text.toString();
    }

    private String getSchemaId() {
        return this._editingContext.getSchemaId();
    }

    private ISemanticDesignFacade getFacade() throws SemanticDesignException {
        return this._editingContext.getDesigntimeFacade();
    }

    public void refresh(DefaultKingdeeTreeNode parentNode) throws SemanticDesignException {
        String path = this.lookupPath(parentNode);
        LazyInfo[] infos = this.getFacade().refreshTree(this.getSchemaId(), path);
        HashMap editings = new HashMap();
        this.removeOriNodes(parentNode, editings);
        TreeBuilder.NodesMap parentCache = new TreeBuilder.NodesMap();
        this.storeCache(parentNode, parentCache);
        TreeBuilderBehavior behavior = new TreeBuilderBehavior();
        behavior.setEditing(editings);
        this._treeBuilder.setCustomBehavior(behavior);
        this._treeBuilder.refresh(parentNode, path, infos, parentCache);
        TreeBuilder.sort(this._tree, this.getTreeRoot());
        this._tree.expandPath(new TreePath(parentNode.getPath()));
    }

    private String lookupPath(DefaultKingdeeTreeNode parentNode) {
        TreeNode[] nodes = parentNode.getPath();
        StringBuffer sbPath = new StringBuffer();
        for (int i = 1; i < nodes.length; ++i) {
            LazyInfo info = (LazyInfo)((DefaultKingdeeTreeNode)nodes[i]).getUserObject();
            if (i > 1) {
                sbPath.append(Util.PATH_SPLIT);
            }
            sbPath.append(info.getPhysicalName());
        }
        return sbPath.toString();
    }

    private void removeOriNodes(DefaultKingdeeTreeNode parentNode, Map editings) {
        for (int i = parentNode.getChildCount() - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
            LazyInfo info = (LazyInfo)node.getUserObject();
            if (info.getType() == 0) {
                this.removeOriNodes(node, editings);
                if (node.getChildCount() != 0) continue;
                this._tree.removeNodeFromParent((MutableTreeNode)node);
                continue;
            }
            if (info.getId() == null) continue;
            if (Boolean.TRUE == info.getProperty("editing")) {
                editings.put(info.getId(), info);
                continue;
            }
            this._tree.removeNodeFromParent((MutableTreeNode)node);
        }
    }

    private void storeCache(DefaultKingdeeTreeNode folder, TreeBuilder.NodesMap cache) {
        int c = folder.getChildCount();
        for (int i = 0; i < c; ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)folder.getChildAt(i);
            LazyInfo childInfo = (LazyInfo)child.getUserObject();
            if (childInfo.getType() != 0) continue;
            TreeBuilder.NodesMap childCache = cache.putNode(childInfo.getPhysicalName(), child);
            this.storeCache(child, childCache);
        }
    }

    public boolean checkLogicalNameExist(String name, LazyInfo self) {
        Enumeration e = this.getTreeRoot().breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)e.nextElement();
            LazyInfo tempInfo = (LazyInfo)tempNode.getUserObject();
            if (tempInfo.getType() == 0 || tempInfo == self || !tempInfo.getLogicalName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPhysicalNameExist(String name, LazyInfo self) {
        Enumeration e = this.getTreeRoot().breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)e.nextElement();
            LazyInfo tempInfo = (LazyInfo)tempNode.getUserObject();
            if (tempInfo.getType() == 0 || tempInfo == self || !StringUtil.equalsIgnoreCase((String)tempInfo.getPhysicalName(), (String)name)) continue;
            return true;
        }
        return false;
    }

    public static DefaultKingdeeTreeNode createFolderNode(String path, String name) {
        LazyInfo tempInfo = new LazyInfo();
        tempInfo.setType(0);
        tempInfo.setPhysicalName(name);
        tempInfo.setPath(path);
        DefaultKingdeeTreeNode tempNode = new DefaultKingdeeTreeNode();
        tempNode.setAllowsChildren(true);
        tempNode.setUserObject((Object)tempInfo);
        tempNode.setText(name);
        return tempNode;
    }

    public DefaultKingdeeTreeNode createEntityNode(LazyInfo info) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
        node.setAllowsChildren(false);
        node.setText(this.makeNodeText(info.getLogicalName(), info.getPhysicalName(), false));
        node.setUserObject((Object)info);
        info.putProperty("tree", this);
        info.putProperty("treeNode", node);
        if (info.getType() == 1) {
            node.setCustomIcon(SemanticIcons.ICN_TABLE);
        } else if (info.getType() == 2) {
            node.setCustomIcon(SemanticIcons.ICN_VIEW);
        }
        return node;
    }

    private class TreeBuilderBehavior
    implements TreeBuilder.ICustomBehavior {
        private Map editings;

        private TreeBuilderBehavior() {
        }

        public void setEditing(Map editings) {
            this.editings = editings;
        }

        @Override
        public void addEntityNode(DefaultKingdeeTreeNode parent, LazyInfo info) {
            if (!this.editings.containsKey(info.getId())) {
                DefaultKingdeeTreeNode nodeEntity = SchemaTree.this.createEntityNode(info);
                SchemaTree.this._tree.addNodeInto((MutableTreeNode)nodeEntity, (MutableTreeNode)parent);
            }
        }

        @Override
        public DefaultKingdeeTreeNode createFolder(String path, String name) {
            return SchemaTree.createFolderNode(path, name);
        }
    }
}

