/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client;

import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.CheckinFromBos;
import com.kingdee.bos.ctrl.semantic.design.client.action.CheckinFromDb;
import com.kingdee.bos.ctrl.semantic.design.client.action.Exit;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.manage.client.EditingContext;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;

public class SemanticDesigner
extends KDFrame {
    private DesignPane _designPane;
    private EditingContext _editingContext;

    public SemanticDesigner() throws SemanticDesignException {
        this.init();
        this.initMenu();
        this.initToolbar();
    }

    private void init() {
        this._designPane = new DesignPane();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)((Object)this._designPane), "Center");
        this.setSize(800, 600);
        this.setExtendedState(6);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SemanticDesigner.this.exit();
            }
        });
    }

    private void initMenu() {
        KDMenuBar mb = new KDMenuBar();
        mb.hideLogo();
        this.setJMenuBar((JMenuBar)mb);
        KDMenu menuSchema = new KDMenu("\u65b9\u6848(S)");
        menuSchema.setMnemonic('S');
        mb.add((JMenu)menuSchema);
        menuSchema.add((JMenuItem)new KDMenuItem((Action)new CheckinFromDb(this._designPane)));
        menuSchema.add((JMenuItem)new KDMenuItem((Action)new CheckinFromBos(this._designPane)));
        menuSchema.addSeparator();
        menuSchema.add((JMenuItem)this.createMenuItem("exit"));
        KDMenu menuEntity = new KDMenu("\u8868/\u89c6\u56fe(T)");
        menuEntity.setMnemonic('T');
        mb.add((JMenu)menuEntity);
        menuEntity.add((JMenuItem)this.createMenuItem("save"));
        menuEntity.add((JMenuItem)this.createMenuItem("saveAll"));
        menuEntity.addSeparator();
        menuEntity.add((JMenuItem)this.createMenuItem("closeOne"));
        menuEntity.add((JMenuItem)this.createMenuItem("closeAll"));
        KDMenu menuRelation = new KDMenu("\u5173\u7cfb(R)");
        menuRelation.setMnemonic('R');
        mb.add((JMenu)menuRelation);
        menuRelation.add((JMenuItem)this.createMenuItem("deleteRelation"));
    }

    private void initToolbar() {
        KDToolBar tb = new KDToolBar();
        this.addToolBar((JToolBar)tb);
        tb.add((Component)this.createButton("save"));
        tb.add((Component)this.createButton("saveAll"));
        tb.addSeparator();
        tb.add((Component)this.createButton("exit"));
    }

    private KDWorkButton createButton(String key) {
        Action action = this._designPane.getDefaultAction(key);
        KDWorkButton btn = new KDWorkButton(action);
        btn.setToolTipText((String)action.getValue("Name"));
        return btn;
    }

    private KDMenuItem createMenuItem(String key) {
        return new KDMenuItem(this._designPane.getDefaultAction(key));
    }

    public void setEditingContext(EditingContext ec) {
        this._editingContext = ec;
        ec.setOwner((Component)((Object)this));
        this._designPane.setEditingContext(ec);
        this.setTitle("\u6269\u5c55\u62a5\u8868\u8bed\u4e49\u5c42\u65b9\u6848\u8bbe\u8ba1\u5668 - " + ec.getSchemaName());
    }

    public void exit() {
        Exit action = (Exit)this._designPane.getDefaultAction("exit");
        action.exit();
    }
}

