/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client;

import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.CloseTab;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabbedPane
extends KDTabbedPane {
    private DesignPane _designPane;
    private ChangeListener _listener;
    private KDPopupMenu _closeTabMenu;

    public TabbedPane(DesignPane dp) {
        this._designPane = dp;
        this.init();
    }

    private void init() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabbedPane.this.fireTabChangeEvent();
            }
        });
        this.addHeadMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    ((CloseTab)TabbedPane.this._designPane.getDefaultAction("closeOne")).doAction();
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    KDPopupMenu pop = TabbedPane.this.getCloseTabMenu();
                    pop.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
    }

    private void fireTabChangeEvent() {
        this._listener.stateChanged(new ChangeEvent((Object)this));
    }

    public void setTabChangeListener(ChangeListener l) {
        this._listener = l;
    }

    public void closeTab(int idx) {
        this.removeTabAt(idx);
        this.fireTabChangeEvent();
    }

    private KDPopupMenu getCloseTabMenu() {
        if (this._closeTabMenu == null) {
            this._closeTabMenu = new KDPopupMenu();
            this._closeTabMenu.add((JMenuItem)new KDMenuItem(this._designPane.getDefaultAction("closeOne")));
            this._closeTabMenu.addSeparator();
            this._closeTabMenu.add((JMenuItem)new KDMenuItem(this._designPane.getDefaultAction("closeAll")));
            this._closeTabMenu.add((JMenuItem)new KDMenuItem(this._designPane.getDefaultAction("closeOthers")));
        }
        return this._closeTabMenu;
    }
}

