/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.ctrl.semantic.design.ISemanticDesignFacade;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.SchemaTree;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.manage.client.EditingContext;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

abstract class AbstractAction
extends javax.swing.AbstractAction {
    protected static final Logger log = LogUtil.getPackageLogger(AbstractAction.class);
    private DesignPane _designPane;

    public AbstractAction(DesignPane dp) {
        this._designPane = dp;
    }

    protected DesignPane getDesignPane() {
        return this._designPane;
    }

    protected EditingContext getEditingContext() {
        return this._designPane.getEditingContext();
    }

    protected SchemaTree getSchemaTree() {
        return this._designPane.getSchemaTree();
    }

    protected KDTree getTree() {
        return this.getSchemaTree().getTree();
    }

    protected String getSchemaId() {
        return this.getEditingContext().getSchemaId();
    }

    protected ISemanticDesignFacade getFacade() throws SemanticDesignException {
        return this.getEditingContext().getDesigntimeFacade();
    }

    protected void setText(String text) {
        this.putValue("Name", text);
    }

    protected void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    protected void setQuickKey(KeyStroke ks) {
        this.putValue("AcceleratorKey", ks);
    }

    private void dealSessionException(SemanticDesignException ex) {
        Throwable ori = ex.getCause();
        if (ori instanceof IllegalStateException) {
            throw (IllegalStateException)ori;
        }
    }

    protected void showException(String text, SemanticDesignException ex) {
        this.dealSessionException(ex);
        log.error((Object)text, (Throwable)ex);
        MessageUtil.msgboxWarning((Component)((Object)this.getDesignPane()), (String)text);
    }

    protected void showWarning(String text) {
        MessageUtil.msgboxWarning((Component)((Object)this.getDesignPane()), (String)text);
    }

    protected void showInfo(String text) {
        MessageUtil.msgboxInfo((Component)((Object)this.getDesignPane()), (String)text);
    }

    protected DefaultKingdeeTreeNode getSelectedNode() {
        TreePath treePath = this.getTree().getSelectionPath();
        if (treePath != null) {
            return (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    protected static DefaultKingdeeTreeNode getSelectedFolderNode(DefaultKingdeeTreeNode selectedNode) {
        LazyInfo info = (LazyInfo)selectedNode.getUserObject();
        if (info.getType() == 0) {
            return selectedNode;
        }
        return (DefaultKingdeeTreeNode)selectedNode.getParent();
    }

    protected static String getSelectedFolderPath(DefaultKingdeeTreeNode selectedNode) {
        LazyInfo info = (LazyInfo)selectedNode.getUserObject();
        String path = info.getPath();
        if (info.getType() == 0) {
            path = Util.makePath(path, info.getPhysicalName());
        }
        return path;
    }
}

