/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.bosmetaselector.BosEntitySelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.client.Progress;
import com.kingdee.bos.ctrl.extcommon.client.ProgressUI;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.AbstractAction;
import com.kingdee.bos.ctrl.semantic.design.exception.BosCheckinException;
import com.kingdee.bos.ctrl.semantic.design.exception.ExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.trans.checkin.BosCheckinModel;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class CheckinFromBos
extends AbstractAction {
    private static String NonPath = "NonPath";
    private ResultPromptUI _resultUI;

    public CheckinFromBos(DesignPane dp) {
        super(dp);
        this.setText("\u4eceBOS\u5b9e\u4f53\u5bfc\u5165");
    }

    private void initResultDialog() {
        if (this._resultUI == null) {
            this._resultUI = new ResultPromptUI();
            SimpleDialog dlgResult = SimpleDialog.create((Component)((Object)this.getDesignPane()));
            dlgResult.setComponent((Component)((Object)this._resultUI));
            dlgResult.setTitle((String)this.getValue("Name") + "-\u7ed3\u679c\u67e5\u770b");
            dlgResult.hideCancelButton();
            dlgResult.setWindowAlign(0);
            WindowUtil.makeDialogFullScreen((KDDialog)dlgResult);
            this._resultUI.bindDialog((TypicalDialog)dlgResult);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.initResultDialog();
        UI ui = new UI();
        DefaultKingdeeTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            ui.setPath(NonPath);
        } else {
            ui.setPath(CheckinFromBos.getSelectedFolderPath(selectedNode));
        }
        SimpleDialog dlg = SimpleDialog.create((Component)((Object)this.getDesignPane()));
        dlg.setComponent((Component)((Object)ui));
        dlg.setTitle("\u4eceBOS\u5b9e\u4f53\u5bfc\u5165");
        dlg.setSize(800, 600);
        if (dlg.showDialog()) {
            BosCheckinModel.Preference preference = ui.getPreference();
            preference.setStandardMaker(this.getEditingContext().isStandardMaker());
            BosCheckinModel.Request[] requests = this.prepare(ui.getSelectedNodes());
            ProgressUI progressUi = ProgressUI.create((Component)dlg);
            progressUi.setIndeterminate(true);
            progressUi.setText("BOS\u5b9e\u4f53\u5bfc\u5165\u4e2d\uff0c\u8bf7\u7a0d\u5019...");
            Core core = new Core(progressUi, preference, requests);
            core.startAndShowUi("SemanticCheckinFromBos");
            if (!core.isOk()) {
                Exception ex = core.getException();
                if (!(ex instanceof SemanticDesignException)) {
                    ex = SemanticDesignException.wrap(ex);
                }
                this.showException("\u5bfc\u5165\u5931\u8d25", (SemanticDesignException)ex);
                return;
            }
            BosCheckinModel.Response[] responses = core.getResult();
            this.showResult(dlg.getTitle(), responses, preference);
            this.refreshTree();
        }
    }

    private BosCheckinModel.Request[] prepare(List selecteds) {
        int size = selecteds.size();
        BosCheckinModel.Request[] requests = new BosCheckinModel.Request[size];
        for (int idx = 0; idx < size; ++idx) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)selecteds.get(idx);
            TreeNode[] nodes = node.getPath();
            StringBuffer sbPath = new StringBuffer();
            int c = nodes.length - 1;
            for (int i = 1; i < c; ++i) {
                String pkgAlias;
                DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)nodes[i];
                MetaDataBriefInfo mdbi = (MetaDataBriefInfo)tempNode.getUserObject();
                if (i > 1) {
                    sbPath.append(Util.PATH_SPLIT);
                }
                if (StringUtil.isEmptyString((String)(pkgAlias = mdbi.getAlias()))) {
                    sbPath.append(mdbi.getName());
                    continue;
                }
                sbPath.append(pkgAlias);
            }
            MetaDataBriefInfo mdbi = (MetaDataBriefInfo)node.getUserObject();
            String pk = mdbi.getMetaDataPK().getFullName();
            BosCheckinModel.Request request = new BosCheckinModel.Request();
            request.setPk(pk);
            request.setPath(sbPath.toString());
            requests[idx] = request;
        }
        return requests;
    }

    private void showResult(String title, BosCheckinModel.Response[] responses, BosCheckinModel.Preference preference) {
        log.info((Object)"Semantic checkin from BOS Entity result...");
        this._resultUI.reset();
        for (BosCheckinModel.Response response : responses) {
            String prompt;
            String pk = response.getPk();
            String lName = response.getLName();
            String pName = response.getPName();
            Color color = null;
            switch (response.getResultType()) {
                case 1: {
                    prompt = "\u521b\u5efa";
                    break;
                }
                case 2: {
                    color = Color.BLUE;
                    if (preference.getExistPolicy() == 0) {
                        prompt = "\u5df2\u5b58\u5728\uff0c\u672a\u5904\u7406";
                        break;
                    }
                    StringBuffer sb = new StringBuffer("\u5df2\u66f4\u65b0");
                    if (preference.isContainsExistPolicy(1)) {
                        sb.append("\u3000");
                        sb.append("\u6982\u5ff5\u540d\u79f0");
                    }
                    boolean isFO = preference.isContainsExistPolicy(2);
                    boolean isFM = preference.isContainsExistPolicy(4);
                    boolean isRO = preference.isContainsExistPolicy(8);
                    boolean isRM = preference.isContainsExistPolicy(16);
                    if (isFO || isFM) {
                        sb.append("\u3000");
                        sb.append("\u5b57\u6bb5");
                    }
                    if (isRO || isRM) {
                        sb.append("\u3000");
                        sb.append("\u5173\u7cfb");
                    }
                    prompt = sb.toString();
                    break;
                }
                case 3: {
                    prompt = "\u6807\u51c6\u4ea7\u54c1\u4e0d\u5141\u8bb8\u5bfc\u5165\u66f4\u65b0";
                    color = Color.RED;
                    break;
                }
                case 4: {
                    prompt = "\u7c7b\u578b\u51b2\u7a81\uff1a\u5df2\u5b58\u5728\u4e00\u4e2a\u76f8\u540c\u540d\u79f0\u7684\u89c6\u56fe";
                    color = Color.RED;
                    break;
                }
                case 5: {
                    SemanticDesignException ex = response.getException();
                    if (ex instanceof LockedException) {
                        prompt = "\u7528\u6237 " + ((LockedException)ex).getUser() + " \u6b63\u5728\u7f16\u8f91\u6b64\u5bf9\u8c61\uff0c\u6682\u4e0d\u80fd\u66f4\u65b0\u3002";
                    } else if (ex instanceof ExistException) {
                        prompt = ((ExistException)ex).getType() == 2 ? "\u6982\u5ff5\u540d\u79f0\u88ab\u5360\u7528" : "\u7269\u7406\u540d\u79f0\u88ab\u5360\u7528";
                    } else if (ex instanceof BosCheckinException) {
                        BosCheckinException exp = (BosCheckinException)ex;
                        StringBuffer sb = new StringBuffer("BOS\u5143\u6570\u636e\u4e0d\u89c4\u8303\uff1a");
                        switch (exp.getType()) {
                            case 4: {
                                sb.append("\u8fde\u63a5\u5c5e\u6027");
                                sb.append(exp.getInfo());
                                sb.append("\u7684client\u7aef\u5fc5\u987b\u662f\u5b9e\u4f53\u81ea\u8eab\u3002");
                                break;
                            }
                            case 3: {
                                sb.append("\u8fde\u63a5\u5c5e\u6027");
                                sb.append(exp.getInfo());
                                sb.append("\u4e0d\u5b8c\u6574\u3002");
                                break;
                            }
                            case 1: {
                                sb.append("\u5b9e\u4f53\u6ca1\u6709\u6620\u5c04\u8868\u3002");
                                break;
                            }
                            case 2: {
                                sb = new StringBuffer();
                                sb.append("\u4e0e\u5176\u5b83\u5b9e\u4f53\u91cd\u590d\u6620\u5c04\u5230\u540c\u4e00\u4e2a\u8868\u3002");
                                break;
                            }
                        }
                        prompt = sb.toString();
                    } else {
                        log.error((Object)("Semantic checkin from BOS Entity:" + pk), (Throwable)ex);
                        prompt = "\u5f02\u5e38\uff1a" + ex.getMessage();
                    }
                    color = Color.RED;
                    break;
                }
                default: {
                    prompt = "";
                }
            }
            this._resultUI.addResult(pk, lName, pName, prompt, color);
        }
        log.info((Object)"End of Semantic checkin from BOS Entity result.");
        this._resultUI.showDialog();
    }

    private void refreshTree() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTree().getModel().getRoot();
        try {
            this.getSchemaTree().refresh(root);
        }
        catch (SemanticDesignException ex) {
            this.showException("", ex);
        }
    }

    public BosCheckinModel.Request[] forInitDemoData() {
        UI ui = new UI();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)ui._tree.getModel().getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            ((DefaultKingdeeTreeNode)root.getChildAt(i)).setChecked(true);
            ((DefaultKingdeeTreeNode)root.getChildAt(i)).syncChecked();
        }
        return this.prepare(ui.getSelectedNodes());
    }

    private static class ResultPromptUI
    extends KDPanel {
        private static final Color COLOR_PACKAGE = new Color(255, 255, 153);
        private TypicalDialog _dlg;
        private KDTable _table = new KDTable();
        private String _lastPackage;

        public ResultPromptUI() {
            this._table.addColumns(4);
            this._table.getColumn(0).setWidth(180);
            this._table.getColumn(1).setWidth(180);
            this._table.getColumn(2).setWidth(360);
            this._table.getColumn(3).setWidth(400);
            this._table.getTreeColumn().setDepth(2);
            this._table.getTreeColumn().setOrientation(0);
            this._table.getStyleAttributes().setLocked(true);
            IRow head = this._table.addHeadRow();
            head.getCell(0).setValue((Object)"\u5b9e\u4f53\u540d\u79f0");
            head.getCell(1).setValue((Object)"\u8868\u540d\u79f0");
            head.getCell(2).setValue((Object)"\u7ed3\u679c");
            head.getCell(3).setValue((Object)"\u5b9e\u4f53PK");
            this.setLayout(new BorderLayout());
            this.add((Component)this._table, "Center");
        }

        public void reset() {
            this._table.removeRows();
        }

        public void addResult(String pk, String lName, String pName, String prompt, Color color) {
            int lastDot = pk.lastIndexOf(".");
            String thePackage = pk.substring(0, lastDot);
            if (!thePackage.equals(this._lastPackage)) {
                this._lastPackage = thePackage;
                IRow row = this._table.addRow();
                row.setTreeLevel(0);
                row.getStyleAttributes().setBackground(COLOR_PACKAGE);
                row.getCell(0).setValue((Object)thePackage);
                int rowIdx = this._table.getRowCount() - 1;
                this._table.getMergeManager().mergeBlock(rowIdx, 0, rowIdx, 3);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(pk);
            sb.append(", ");
            sb.append(lName);
            sb.append(", ");
            sb.append(pName);
            sb.append(", ");
            sb.append(prompt);
            AbstractAction.log.info((Object)sb.toString());
            IRow row = this._table.addRow();
            row.getCell(0).setValue((Object)lName);
            row.getCell(1).setValue((Object)pName);
            row.getCell(2).setValue((Object)prompt);
            row.getCell(3).setValue((Object)pk);
            if (color != null) {
                row.getCell(2).getStyleAttributes().setFontColor(color);
            }
            row.setTreeLevel(1);
        }

        public void bindDialog(TypicalDialog dlg) {
            this._dlg = dlg;
        }

        public void showDialog() {
            this._dlg.showDialog();
        }
    }

    private class UI
    extends KDPanel {
        private KDTree _tree;
        private KDRadioButton _radKeepOriPath;
        private KDRadioButton _radToSelectedPath;
        private KDLabel _labPath;
        private String _path;
        private KDCheckBox _chkExistUpdateLName;
        private KDCheckBox _chkExistUpdateField;
        private KDCheckBox _chkExistUpdateRelation;
        private KDRadioButton _radEUF_Overwrite;
        private KDRadioButton _radEUF_Merge;
        private KDRadioButton _radEUR_Overwrite;
        private KDRadioButton _radEUR_Merge;
        private KDRadioButton _radErrCancel;
        private KDRadioButton _radErrIgnore;
        private KDWorkButton _btnShowResult;

        public UI() {
            this.init();
            this.initData();
        }

        private void init() {
            this._btnShowResult = new KDWorkButton("\u67e5\u770b\u4e0a\u4e00\u6b21\u7684\u7ed3\u679c");
            this._btnShowResult.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckinFromBos.this._resultUI.showDialog();
                }
            });
            this._tree = new KDTree();
            KDTreeView tv = new KDTreeView(this._tree);
            tv.setTitle("BOS\u5143\u6570\u636e--\u5b9e\u4f53");
            tv.setShowButton(false);
            this._labPath = new KDLabel();
            this._radKeepOriPath = new KDRadioButton("\u4fdd\u6301\u5b9e\u4f53\u539f\u8def\u5f84", true);
            this._radToSelectedPath = new KDRadioButton("\u5168\u90e8\u5bfc\u5165\u5230\u5f53\u524d\u9009\u62e9\u6587\u4ef6\u5939\u4e0b\uff1a");
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this._radKeepOriPath);
            bg.add((AbstractButton)this._radToSelectedPath);
            this._chkExistUpdateLName = new KDCheckBox("\u66f4\u65b0\u6982\u5ff5\u540d\u79f0");
            this._chkExistUpdateField = new KDCheckBox("\u66f4\u65b0\u5b57\u6bb5");
            this._chkExistUpdateRelation = new KDCheckBox("\u66f4\u65b0\u5173\u7cfb", true);
            this._radEUF_Overwrite = new KDRadioButton("\u8986\u76d6\uff08\u6e05\u9664\u539f\u6765\u6240\u6709\u5b57\u6bb5\uff09");
            this._radEUF_Merge = new KDRadioButton("\u5408\u5e76", true);
            bg = new ButtonGroup();
            bg.add((AbstractButton)this._radEUF_Overwrite);
            bg.add((AbstractButton)this._radEUF_Merge);
            this._radEUR_Overwrite = new KDRadioButton("\u8986\u76d6\uff08\u6e05\u9664\u539f\u6765\u6240\u6709\u5173\u7cfb\uff09");
            this._radEUR_Merge = new KDRadioButton("\u5408\u5e76", true);
            bg = new ButtonGroup();
            bg.add((AbstractButton)this._radEUR_Overwrite);
            bg.add((AbstractButton)this._radEUR_Merge);
            this._radErrCancel = new KDRadioButton("\u62a5\u9519-\u4e0d\u5bfc\u5165\u5b9e\u4f53");
            this._radErrIgnore = new KDRadioButton("\u5ffd\u7565-\u4e22\u5f03\u9519\u8bef\u90e8\u5206", true);
            ButtonGroup bg3 = new ButtonGroup();
            bg3.add((AbstractButton)this._radErrCancel);
            bg3.add((AbstractButton)this._radErrIgnore);
            TableLayout2 ly = new TableLayout2(5, 1);
            ly.setFixedHeight(0, 100);
            ly.setFixedHeight(1, 200);
            ly.setFixedHeight(2, 80);
            ly.setRatableHeight(3, 1);
            ly.setFixedHeight(4, 23);
            ly.setRowsSpacing(TableLayout2.ALL, 6);
            KDPanel leftPan = new KDPanel((LayoutManager)ly);
            leftPan.add((Component)this.createPathPreference(), (Object)TableLayout2.param((int)0, (int)0));
            leftPan.add((Component)this.createExistPreference(), (Object)TableLayout2.param((int)1, (int)0));
            leftPan.add((Component)this.createErrPreference(), (Object)TableLayout2.param((int)2, (int)0));
            leftPan.add((Component)this._btnShowResult, (Object)TableLayout2.param((int)4, (int)0));
            KDSplitPane splitPan = new KDSplitPane();
            splitPan.setDividerLocation(240);
            splitPan.setLeftComponent((Component)leftPan);
            splitPan.setRightComponent((Component)tv);
            this.setLayout(new BorderLayout());
            this.add((Component)splitPan, "Center");
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UI.this.syncEnabled();
                }
            };
            this._chkExistUpdateField.addActionListener(listener);
            this._chkExistUpdateRelation.addActionListener(listener);
            this.syncEnabled();
        }

        private KDContainer createPathPreference() {
            TableLayout2 ly = new TableLayout2(4, 2);
            ly.setFixedHeight(TableLayout2.ALL, 20);
            ly.setRatableHeight(3, 1);
            ly.setFixedWidth(0, 20);
            ly.setRatableWidth(1, 1);
            KDPanel pan = new KDPanel((LayoutManager)ly);
            pan.setOpaque(false);
            pan.setCustomInsets(new Insets(6, 8, 0, 8));
            pan.setLayout((LayoutManager)ly);
            pan.add((Component)this._radKeepOriPath, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)1));
            pan.add((Component)this._radToSelectedPath, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
            pan.add((Component)this._labPath, (Object)TableLayout2.param((int)2, (int)1));
            KDContainer ctn = new KDContainer();
            ctn.setTitle("\u65b0\u5efa\u5bf9\u8c61\u7684\u4f4d\u7f6e");
            ctn.setEnableActive(false);
            JPanel c = ctn.getContentPane();
            c.setLayout(new BorderLayout());
            c.add((Component)pan, "Center");
            return ctn;
        }

        private KDContainer createExistPreference() {
            TableLayout2 ly = new TableLayout2(8, 2);
            ly.setFixedWidth(0, 24);
            ly.setRatableWidth(1, 100);
            ly.setFixedHeight(TableLayout2.ALL, 20);
            ly.setRatableHeight(7, 1);
            ly.setRowsSpacing(TableLayout2.ALL, 0);
            ly.setRowsSpacing(new int[]{0, 3}, 3);
            KDPanel pan = new KDPanel((LayoutManager)ly);
            pan.setOpaque(false);
            pan.setCustomInsets(new Insets(6, 4, 0, 8));
            pan.setLayout((LayoutManager)ly);
            pan.add((Component)this._chkExistUpdateLName, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)1));
            pan.add((Component)this._chkExistUpdateField, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
            pan.add((Component)this._radEUF_Overwrite, (Object)TableLayout2.param((int)2, (int)1));
            pan.add((Component)this._radEUF_Merge, (Object)TableLayout2.param((int)3, (int)1));
            pan.add((Component)this._chkExistUpdateRelation, (Object)TableLayout2.param((int)4, (int)0, (int)4, (int)1));
            pan.add((Component)this._radEUR_Overwrite, (Object)TableLayout2.param((int)5, (int)1));
            pan.add((Component)this._radEUR_Merge, (Object)TableLayout2.param((int)6, (int)1));
            KDContainer ctn = new KDContainer();
            ctn.setTitle("\u5f53\u7269\u7406\u540d\u79f0\u5b58\u5728\u65f6");
            ctn.setEnableActive(false);
            JPanel c = ctn.getContentPane();
            c.setLayout(new BorderLayout());
            c.add((Component)pan, "Center");
            return ctn;
        }

        private KDContainer createErrPreference() {
            TableLayout2 ly = new TableLayout2(3, 1);
            ly.setFixedHeight(TableLayout2.ALL, 20);
            ly.setRatableHeight(2, 1);
            KDPanel pan = new KDPanel((LayoutManager)ly);
            pan.setOpaque(false);
            pan.setCustomInsets(new Insets(6, 8, 0, 8));
            pan.setLayout((LayoutManager)ly);
            pan.add((Component)this._radErrCancel, (Object)TableLayout2.param((int)0, (int)0));
            pan.add((Component)this._radErrIgnore, (Object)TableLayout2.param((int)1, (int)0));
            KDContainer ctn = new KDContainer();
            ctn.setTitle("\u5f53\u5173\u7cfb\u5b9a\u4e49\u5b58\u5728\u903b\u8f91\u9519\u8bef\u65f6");
            ctn.setEnableActive(false);
            JPanel c = ctn.getContentPane();
            c.setLayout(new BorderLayout());
            c.add((Component)pan, "Center");
            return ctn;
        }

        private void initData() {
            DefaultKingdeeTreeNode root = BosEntitySelector.createKDTreeRoot();
            root.setChecked(64);
            root.setCheckBoxVisible(false);
            this._tree.setShowsRootHandles(true);
            this._tree.setShowCheckBox(true);
            this._tree.setSyncChecked(true);
            this._tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        }

        public void setPath(String path) {
            if (path == NonPath) {
                this._labPath.setForeground(Color.GRAY);
                this._radToSelectedPath.setEnabled(false);
                this._labPath.setText("\uff08\u672a\u9009\u4e2d\u76ee\u6807\u6587\u4ef6\u5939\uff09");
            } else {
                this._path = path;
                this._labPath.setForeground(Color.BLACK);
                this._radToSelectedPath.setEnabled(true);
                if (StringUtil.isEmptyString((String)path)) {
                    this._labPath.setText("\u6839\u76ee\u5f55");
                } else {
                    this._labPath.setText(path);
                }
            }
        }

        public List getSelectedNodes() {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this._tree.getModel().getRoot();
            ArrayList selecteds = new ArrayList();
            this.searchSelectedNode(root, selecteds);
            return selecteds;
        }

        private void searchSelectedNode(DefaultKingdeeTreeNode node, List result) {
            if (node.getCheckedValue() == 16) {
                return;
            }
            if (node.getChildCount() > 0) {
                int c = node.getChildCount();
                for (int i = 0; i < c; ++i) {
                    this.searchSelectedNode((DefaultKingdeeTreeNode)node.getChildAt(i), result);
                }
            } else {
                result.add(node);
            }
        }

        public BosCheckinModel.Preference getPreference() {
            BosCheckinModel.Preference result = new BosCheckinModel.Preference();
            if (this._radKeepOriPath.isSelected()) {
                result.setPathPolicy(1);
            } else {
                result.setPathPolicy(2);
                result.setPath(this._path);
            }
            int existPolicy = 0;
            if (this._chkExistUpdateLName.isSelected()) {
                ++existPolicy;
            }
            if (this._chkExistUpdateField.isSelected()) {
                existPolicy = this._radEUF_Overwrite.isSelected() ? (existPolicy += 2) : (existPolicy += 4);
            }
            if (this._chkExistUpdateRelation.isSelected()) {
                existPolicy = this._radEUR_Overwrite.isSelected() ? (existPolicy += 8) : (existPolicy += 16);
            }
            result.setExistPolicy(existPolicy);
            if (this._radErrCancel.isSelected()) {
                result.setErrorPolicy(0);
            } else {
                result.setErrorPolicy(1);
            }
            return result;
        }

        private void syncEnabled() {
            boolean isCheckedEUF = this._chkExistUpdateField.isSelected();
            this._radEUF_Overwrite.setEnabled(isCheckedEUF);
            this._radEUF_Merge.setEnabled(isCheckedEUF);
            boolean isCheckedEUR = this._chkExistUpdateRelation.isSelected();
            this._radEUR_Overwrite.setEnabled(isCheckedEUR);
            this._radEUR_Merge.setEnabled(isCheckedEUR);
        }
    }

    private class Core
    extends Progress {
        private BosCheckinModel.Preference preference;
        private BosCheckinModel.Request[] requests;
        private BosCheckinModel.Response[] responses;

        public Core(ProgressUI ui, BosCheckinModel.Preference preference, BosCheckinModel.Request[] requests) {
            super(ui);
            this.preference = preference;
            this.requests = requests;
        }

        public BosCheckinModel.Response[] getResult() {
            return this.responses;
        }

        @Override
        protected void work() throws SemanticDesignException {
            this.responses = CheckinFromBos.this.getEditingContext().getDesigntimeFacade().bosMetaCheckin(CheckinFromBos.this.getSchemaId(), this.requests, this.preference);
        }
    }
}

