/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.client.Progress;
import com.kingdee.bos.ctrl.extcommon.client.ProgressUI;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.AbstractAction;
import com.kingdee.bos.ctrl.semantic.design.exception.ExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.MultiException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;

public class CheckinFromDb
extends AbstractAction {
    private UI _ui;

    public CheckinFromDb(DesignPane dp) {
        super(dp);
        this.setText("\u4ece\u6570\u636e\u5e93\u767b\u8bb0");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectCount = this.getTree().getSelectionCount();
        if (selectCount != 1) {
            this.showInfo("\u8981\u767b\u8bb0\u7684\u8868\u5c06\u521b\u5efa\u5230\u54ea\u4e2a\u6587\u4ef6\u5939\u4e2d\uff1f\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u6587\u4ef6\u5939\u3002");
            return;
        }
        DefaultKingdeeTreeNode selectedNode = this.getSelectedNode();
        String path = CheckinFromDb.getSelectedFolderPath(selectedNode);
        if (this._ui == null) {
            this._ui = new UI();
        }
        this._ui.clear();
        this._ui.setPath(path);
        SimpleDialog dlg = SimpleDialog.create((Component)((Object)this.getDesignPane()));
        dlg.setComponent((Component)((Object)this._ui));
        dlg.setTitle("\u4ece\u6570\u636e\u5e93\u767b\u8bb0");
        dlg.setSize(800, 600);
        if (dlg.showDialog()) {
            LazyInfo info;
            ProgressUI progressUi = ProgressUI.create((Component)((Object)this.getDesignPane()));
            progressUi.setIndeterminate(true);
            progressUi.setText("\u4ece\u6570\u636e\u5e93\u767b\u8bb0\uff0c\u8bf7\u7a0d\u5019...");
            Progress progress = new Progress(progressUi){

                @Override
                protected void work() throws Exception {
                    CheckinFromDb.this._ui.checkin();
                }
            };
            progress.startAndShowUi("SemanticCheckinFromDb");
            if (!progress.isOk()) {
                Exception exp = progress.getException();
                if (exp instanceof MultiException) {
                    MultiException ex = (MultiException)exp;
                    StringBuffer sb = new StringBuffer();
                    sb.append("\u4ee5\u4e0b\u8868\u767b\u8bb0\u65f6\u53d1\u751f\u5f02\u5e38\uff1a");
                    int c = ex.getExCount();
                    for (int i = 0; i < c; ++i) {
                        SemanticDesignException innerEx = ex.getEx(i);
                        log.error((Object)ex.getPrompt(i), (Throwable)innerEx);
                        sb.append(StringUtil.RETURN);
                        sb.append(ex.getPrompt(i));
                        if (!(innerEx instanceof ExistException)) continue;
                        ExistException ee = (ExistException)innerEx;
                        sb.append(":  ");
                        if (ee.getType() == 2) {
                            sb.append("\u6982\u5ff5\u540d\u79f0");
                            sb.append("\u3010");
                            sb.append(ee.getExistName());
                            sb.append("\u3011");
                            sb.append("\u5df2\u5b58\u5728");
                            continue;
                        }
                        if (ee.getType() != 1) continue;
                        sb.append("\u7269\u7406\u540d\u79f0\u5df2\u88ab\u5360\u7528");
                    }
                    sb.append(StringUtil.RETURN);
                    sb.append("\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u9605\u65e5\u5fd7\u3002");
                    this.showWarning(sb.toString());
                } else if (exp instanceof SemanticDesignException) {
                    this.showException("", (SemanticDesignException)exp);
                } else {
                    this.showException("", SemanticDesignException.wrap(exp));
                }
            }
            if ((info = (LazyInfo)selectedNode.getUserObject()).getType() != 0) {
                selectedNode = (DefaultKingdeeTreeNode)selectedNode.getParent();
            }
            try {
                this.getSchemaTree().refresh(selectedNode);
            }
            catch (SemanticDesignException ex) {
                this.showException("", ex);
            }
        }
    }

    private static class CheckboxRender
    implements IBasicRender {
        private KDCheckBox _chk = new KDCheckBox();

        public void draw(Graphics g, Shape clip, Object object, Style cellStyle) {
            this._chk.setSelected(Boolean.TRUE.equals(object));
            this._chk.setEnabled(!cellStyle.isLocked());
            Rectangle rect = clip.getBounds();
            this._chk.setSize(rect.width - 1, rect.height - 1);
            this._chk.setHorizontalAlignment(0);
            Graphics gra = g.create(rect.x, rect.y, rect.width, rect.height);
            this._chk.paint(gra);
        }
    }

    private class UI
    extends KDPanel {
        private static final int COL_SELECT = 0;
        private static final int COL_TYPE = 1;
        private static final int COL_PNAME = 2;
        private static final int COL_LNAME = 3;
        private KDCheckBox _chkTable;
        private KDCheckBox _chkView;
        private KDTextField _txtFilter;
        private KDWorkButton _btnRefresh;
        private KDLabel _labPath;
        private KDTable _table;
        private String _path;

        public UI() {
            this.init();
        }

        private void init() {
            this._chkTable = new KDCheckBox("\u8868");
            this._chkView = new KDCheckBox("\u89c6\u56fe");
            this._txtFilter = new KDTextField();
            KDLabelContainer lbcFilter = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtFilter, (String)"\u540d\u79f0\u8fc7\u6ee4", (int)80);
            KDLabel labPrompt = new KDLabel("\u8bf4\u660e\uff1a\u540d\u79f0\u8fc7\u6ee4\u652f\u6301\u901a\u914d\u7b26\uff1a? \u8868\u793a\u4e00\u4e2a\u5b57\u7b26\uff1b* \u8868\u793a\u591a\u4e2a\u5b57\u7b26\u3002");
            this._btnRefresh = new KDWorkButton("\u5237\u65b0");
            this._btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UI.this.refresh();
                }
            });
            this._labPath = new KDLabel();
            this._table = new KDTable();
            this._table.addColumns(4);
            this._table.getColumn(0).setWidth(40);
            this._table.getColumn(1).setWidth(50);
            this._table.getColumn(2).setWidth(300);
            this._table.getColumn(3).setWidth(300);
            this._table.getColumn(1).getStyleAttributes().setLocked(true);
            this._table.getColumn(2).getStyleAttributes().setLocked(true);
            this._table.getColumn(0).setRenderer((IBasicRender)new CheckboxRender());
            this._table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editValueChanged(KDTEditEvent e) {
                    if (e.getType() == 0 && e.getColIndex() == 0) {
                        Boolean isSelected = (Boolean)e.getValue();
                        int c = UI.this._table.getRowCount();
                        for (int i = 0; i < c && !UI.this._table.getRow(i).getCell(0).getStyleAttributes().isLocked(); ++i) {
                            UI.this._table.getRow(i).getCell(0).setValue((Object)isSelected);
                        }
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    if (e.getColIndex() == 3) {
                        LazyInfo info = (LazyInfo)UI.this._table.getRow(e.getRowIndex()).getUserObject();
                        String lName = (String)e.getValue();
                        if (lName != null) {
                            info.setLogicalName(lName.trim());
                        }
                    }
                }
            });
            IRow head = this._table.addHeadRow();
            head.getCell(0).setValue((Object)Boolean.FALSE);
            head.getCell(1).setValue((Object)"\u7c7b\u578b");
            head.getCell(2).setValue((Object)"\u7269\u7406\u540d\u79f0");
            head.getCell(3).setValue((Object)"\u6982\u5ff5\u540d\u79f0");
            TableLayout2 ly = new TableLayout2(4, 4);
            ly.setFixedHeight(0, 20);
            ly.setRowSpacing(0, 3);
            ly.setFixedHeight(1, 20);
            ly.setRowSpacing(1, 8);
            ly.setFixedHeight(2, 20);
            ly.setRatableHeight(3, 1);
            ly.setFixedWidth(0, 40);
            ly.setColSpacing(0, 6);
            ly.setFixedWidth(1, 60);
            ly.setColSpacing(1, 20);
            ly.setRatableWidth(2, 1);
            ly.setColSpacing(2, 10);
            ly.setFixedWidth(3, 80);
            this.setLayout((LayoutManager)ly);
            this.add((Component)this._chkTable, TableLayout2.param((int)0, (int)0));
            this.add((Component)this._chkView, TableLayout2.param((int)0, (int)1));
            this.add((Component)lbcFilter, TableLayout2.param((int)0, (int)2));
            this.add((Component)this._btnRefresh, TableLayout2.param((int)0, (int)3));
            this.add((Component)labPrompt, TableLayout2.param((int)1, (int)0, (int)1, (int)3));
            this.add((Component)this._labPath, TableLayout2.param((int)2, (int)0, (int)2, (int)3));
            this.add((Component)this._table, TableLayout2.param((int)3, (int)0, (int)3, (int)3));
        }

        public void setPath(String path) {
            this._path = path;
            this._labPath.setText("\u4ee5\u4e0b\u9009\u62e9\u7684\u8868/\u89c6\u56fe\u5c06\u521b\u5efa\u5230\u6b64\u6587\u4ef6\u5939\u4e2d\uff1a" + (StringUtil.isEmptyString((String)path) ? "\u6839\u76ee\u5f55" : path));
        }

        public void clear() {
            this._table.removeRows();
        }

        private void refresh() {
            LazyInfo[] infos;
            boolean isT = this._chkTable.isSelected();
            boolean isV = this._chkView.isSelected();
            this._table.removeRows();
            if (!isT && !isV) {
                return;
            }
            int type = 0;
            if (isT) {
                ++type;
            }
            if (isV) {
                type += 2;
            }
            try {
                infos = CheckinFromDb.this.getEditingContext().getDesigntimeFacade().dbCheckinRefresh(CheckinFromDb.this.getSchemaId(), type, this._txtFilter.getText());
            }
            catch (SemanticDesignException ex) {
                CheckinFromDb.this.showException("", ex);
                return;
            }
            boolean isAnyCanOperate = false;
            for (int i = 0; i < infos.length; ++i) {
                IRow row = this._table.addRow();
                LazyInfo info = infos[i];
                row.setUserObject((Object)info);
                row.getCell(1).setValue((Object)(info.getType() == 2 ? "\u89c6\u56fe" : "\u8868"));
                row.getCell(2).setValue((Object)info.getPhysicalName());
                boolean exist = info.getLogicalName() != null;
                row.getCell(0).setValue((Object)new Boolean(exist));
                if (exist) {
                    row.getCell(3).setValue((Object)info.getLogicalName());
                    row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                    row.getCell(0).getStyleAttributes().setLocked(true);
                    row.getCell(3).getStyleAttributes().setLocked(true);
                }
                isAnyCanOperate = isAnyCanOperate || !exist;
            }
            this._table.getHeadRow(0).getCell(0).setValue((Object)new Boolean(infos.length != 0 && !isAnyCanOperate));
            this._table.getHeadRow(0).getCell(0).getStyleAttributes().setLocked(infos.length == 0 || !isAnyCanOperate);
        }

        public void checkin() throws SemanticDesignException {
            ArrayList<LazyInfo> selecteds = new ArrayList<LazyInfo>();
            int c = this._table.getRowCount();
            for (int i = 0; i < c && !this._table.getRow(i).getCell(0).getStyleAttributes().isLocked(); ++i) {
                IRow row = this._table.getRow(i);
                if (!Boolean.TRUE.equals(row.getCell(0).getValue())) continue;
                LazyInfo info = (LazyInfo)row.getUserObject();
                info.setPath(this._path);
                info.setStandard(CheckinFromDb.this.getEditingContext().isStandardMaker());
                if (info.getLogicalName() == null) {
                    info.setLogicalName(info.getPhysicalName());
                }
                selecteds.add(info);
            }
            LazyInfo[] infos = selecteds.toArray(new LazyInfo[0]);
            CheckinFromDb.this.getEditingContext().getDesigntimeFacade().dbCheckin(CheckinFromDb.this.getSchemaId(), infos);
        }
    }
}

