/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.SchemaTree;
import com.kingdee.bos.ctrl.semantic.design.client.TabbedPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.AbstractAction;
import com.kingdee.bos.ctrl.semantic.design.client.action.Save;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.EntityShower;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.tree.MutableTreeNode;

public abstract class CloseTab
extends AbstractAction {
    protected TabbedPane _tabPan;

    public CloseTab(DesignPane dp, TabbedPane tabPan) {
        super(dp);
        this._tabPan = tabPan;
        this.init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doAction();
    }

    protected abstract void init();

    public abstract void doAction();

    protected boolean checkDirty(int tabIdx) {
        EntityShower entityShower = this.getDesignPane().getEntityShower(tabIdx);
        return entityShower.isModelDirty();
    }

    protected int askSave() {
        return this.askSave(null);
    }

    protected int askSave(String name) {
        return MessageUtil.msgboxYesNoCancel((Component)((Object)this.getDesignPane()), (Object)((name == null ? "" : name) + StringUtil.RETURN + "\u662f\u5426\u4fdd\u5b58\u6b63\u5728\u7f16\u8f91\u7684\u5185\u5bb9\uff1f"));
    }

    protected boolean save(int tabIdx) {
        EntityShower entityShower = this.getDesignPane().getEntityShower(tabIdx);
        Save save = (Save)this.getDesignPane().getDefaultAction("save");
        try {
            return save.saveOne(entityShower);
        }
        catch (SemanticDesignException ex) {
            this.showException("", ex);
            return false;
        }
    }

    protected void removeTab(int tabIdx) {
        EntityShower entityShower = this.getDesignPane().getEntityShower(tabIdx);
        LazyInfo info = entityShower.getInfo();
        info.putProperty("editing", null);
        this.getDesignPane().removeTab(tabIdx, info.getId());
    }

    protected void removeTabWithoutSave(int tabIdx) {
        EntityShower entityShower = this.getDesignPane().getEntityShower(tabIdx);
        LazyInfo info = entityShower.getInfo();
        SchemaTree st = (SchemaTree)info.getProperty("tree");
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)info.getProperty("treeNode");
        if (info.getId() == null) {
            st.getTree().removeNodeFromParent((MutableTreeNode)node);
        } else {
            st.updateNodeText(node, info.getLogicalName(), info.getPhysicalName(), false);
        }
        info.putProperty("editing", null);
        this.getDesignPane().removeTab(tabIdx, info.getId());
    }

    public static class CloseOthers
    extends CloseTab {
        public CloseOthers(DesignPane dp, TabbedPane tabPan) {
            super(dp, tabPan);
        }

        @Override
        protected void init() {
            this.setText("\u5173\u95ed\u5176\u5b83");
        }

        @Override
        public void doAction() {
            int i;
            int idx = this._tabPan.getSelectedIndex();
            boolean isAnyDirty = false;
            for (i = this._tabPan.getTabCount() - 1; i > idx; --i) {
                isAnyDirty = isAnyDirty || this.checkDirty(i);
            }
            for (i = idx - 1; i >= 0; --i) {
                isAnyDirty = isAnyDirty || this.checkDirty(i);
            }
            if (isAnyDirty) {
                int ask = this.askSave();
                if (ask == 0) {
                    int i2;
                    for (i2 = this._tabPan.getTabCount() - 1; i2 > idx; --i2) {
                        if (!this.save(i2)) continue;
                        this.removeTab(i2);
                    }
                    for (i2 = idx - 1; i2 >= 0; --i2) {
                        if (!this.save(i2)) continue;
                        this.removeTab(i2);
                    }
                    return;
                }
                if (ask == 2) {
                    return;
                }
            }
            for (i = this._tabPan.getTabCount() - 1; i > idx; --i) {
                this.removeTabWithoutSave(i);
            }
            for (i = idx - 1; i >= 0; --i) {
                this.removeTabWithoutSave(i);
            }
        }
    }

    public static class CloseAll
    extends CloseTab {
        public CloseAll(DesignPane dp, TabbedPane tabPan) {
            super(dp, tabPan);
        }

        @Override
        protected void init() {
            this.setText("\u5173\u95ed\u5168\u90e8");
            this.setQuickKey(KeyStroke.getKeyStroke(115, 192));
        }

        @Override
        public void doAction() {
            int i;
            boolean isAnyDirty = false;
            int c = this._tabPan.getTabCount();
            for (i = 0; i < c; ++i) {
                isAnyDirty = isAnyDirty || this.checkDirty(i);
            }
            if (isAnyDirty) {
                int ask = this.askSave();
                if (ask == 0) {
                    for (int i2 = this._tabPan.getTabCount() - 1; i2 >= 0; --i2) {
                        if (!this.save(i2)) continue;
                        this.removeTab(i2);
                    }
                    return;
                }
                if (ask == 2) {
                    return;
                }
            }
            for (i = this._tabPan.getTabCount() - 1; i >= 0; --i) {
                this.removeTabWithoutSave(i);
            }
        }
    }

    public static class CloseOne
    extends CloseTab {
        public CloseOne(DesignPane dp, TabbedPane tabPan) {
            super(dp, tabPan);
        }

        @Override
        protected void init() {
            this.setText("\u5173\u95ed");
            this.setQuickKey(KeyStroke.getKeyStroke(115, 128));
        }

        @Override
        public void doAction() {
            int idx = this._tabPan.getSelectedIndex();
            if (idx >= 0) {
                if (this.checkDirty(idx)) {
                    EntityShower entityShower = this.getDesignPane().getEntityShower(idx);
                    int ask = this.askSave(entityShower.getModel().getLogicalName());
                    if (ask == 0) {
                        if (this.save(idx)) {
                            this.removeTab(idx);
                        }
                        return;
                    }
                    if (ask == 2) {
                        return;
                    }
                }
                this.removeTabWithoutSave(idx);
            }
        }
    }
}

