/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.extcommon.client.Progress;
import com.kingdee.bos.ctrl.extcommon.client.ProgressUI;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.AbstractAction;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.EntityShower;
import com.kingdee.bos.ctrl.semantic.design.exception.ConflictException;
import com.kingdee.bos.ctrl.semantic.design.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.design.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class DeleteEntity
extends AbstractAction {
    public DeleteEntity(DesignPane dp) {
        super(dp);
        this.setIcon(Resource.ICON_DELETE);
        this.setText("\u5220\u9664 \u8868/\u89c6\u56fe");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LazyInfo info;
        int selectCount = this.getTree().getSelectionCount();
        if (selectCount == 0) {
            this.showInfo("\u8bf7\u9009\u62e9\u5c06\u8981\u5220\u9664\u7684\u8868\u3001\u89c6\u56fe\u6216\u6587\u4ef6\u5939\u3002");
            return;
        }
        if (!MessageUtil.msgboxOkCancel((Component)((Object)this.getDesignPane()), (String)"\u5220\u9664\u5c06\u4e0d\u53ef\u6062\u590d\u3002\u60a8\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u7684 \u8868/\u89c6\u56fe \u6216 \u6587\u4ef6\u5939 \u5417\uff1f")) {
            return;
        }
        TreePath[] allSelecteds = this.getTree().getSelectionPaths();
        HashSet<LazyInfo> allInfos = new HashSet<LazyInfo>();
        HashSet<LazyInfo> allNoSavedInfos = new HashSet<LazyInfo>();
        Object root = this.getTree().getModel().getRoot();
        for (int i = 0; i < allSelecteds.length; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)allSelecteds[i].getLastPathComponent();
            if (node == root) {
                this.showInfo("\u6839\u76ee\u5f55\u4e0d\u80fd\u5220\u9664\u3002");
                return;
            }
            info = (LazyInfo)node.getUserObject();
            if (info.getType() != 0) {
                if (this.isStandardCannotDelete(info)) {
                    return;
                }
                if (info.getId() == null) {
                    allNoSavedInfos.add(info);
                    continue;
                }
                allInfos.add(info);
                continue;
            }
            Enumeration enums = node.breadthFirstEnumeration();
            while (enums.hasMoreElements()) {
                DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)enums.nextElement();
                LazyInfo subInfo = (LazyInfo)subNode.getUserObject();
                if (subInfo.getType() == 0) continue;
                if (this.isStandardCannotDelete(subInfo)) {
                    return;
                }
                if (subInfo.getId() == null) {
                    allNoSavedInfos.add(subInfo);
                    continue;
                }
                allInfos.add(subInfo);
            }
        }
        if (allInfos.size() > 0) {
            LazyInfo[] infos = allInfos.toArray(new LazyInfo[0]);
            ProgressUI progressUi = ProgressUI.create((Component)((Object)this.getDesignPane()));
            progressUi.setIndeterminate(true);
            progressUi.setText("\u6b63\u5728\u5220\u9664\uff0c\u8bf7\u7a0d\u5019...");
            CoreWork progress = new CoreWork(progressUi, infos);
            progress.startAndShowUi("SemanticDeleteEntities");
            if (!progress.isOk()) {
                Exception ex = progress.getException();
                if (ex instanceof ConflictException) {
                    this.showWarning("\u5bf9\u8c61\u540d\u79f0\u6216\u8def\u5f84\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
                } else if (ex instanceof NotExistException) {
                    this.showWarning("\u5bf9\u8c61\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
                } else if (ex instanceof LockedException) {
                    this.showWarning("\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
                } else if (ex instanceof SemanticDesignException) {
                    this.showException("", (SemanticDesignException)ex);
                } else {
                    this.showException("", SemanticDesignException.wrap(ex));
                }
                return;
            }
        }
        EntityShower[] entityShowers = this.getDesignPane().getAllEntityShower();
        for (int i = entityShowers.length - 1; i >= 0; --i) {
            info = entityShowers[i].getInfo();
            if (allInfos.contains(info)) {
                this.getDesignPane().removeTab(i, info.getId());
                continue;
            }
            if (!allNoSavedInfos.contains(info)) continue;
            this.getDesignPane().removeTab(i, info.getId());
        }
        DefaultKingdeeTreeNode[] ndoesToRemove = DeleteEntity.getSingleNodes(allSelecteds);
        int c = ndoesToRemove.length;
        for (int i = 0; i < c; ++i) {
            this.getTree().removeNodeFromParent((MutableTreeNode)ndoesToRemove[i]);
        }
    }

    private boolean isStandardCannotDelete(LazyInfo info) {
        if (info.isStandard() && !this.getEditingContext().isStandardMaker()) {
            this.showWarning("\u60a8\u9009\u62e9\u7684\u9879\u76ee\u5305\u542b\u6807\u51c6\u4ea7\u54c1\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
            return true;
        }
        return false;
    }

    private static DefaultKingdeeTreeNode[] getSingleNodes(TreePath[] allSelecteds) {
        ArrayList<String> selectedPaths = new ArrayList<String>();
        HashMap<String, DefaultKingdeeTreeNode> path_Node = new HashMap<String, DefaultKingdeeTreeNode>();
        for (int i = 0; i < allSelecteds.length; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)allSelecteds[i].getLastPathComponent();
            LazyInfo info = (LazyInfo)node.getUserObject();
            boolean isFolder = info.getType() == 0;
            String fullPath = isFolder ? Util.makePath(info.getPath(), info.getPhysicalName()) : Util.makePath(info.getPath(), "@" + info.hashCode());
            boolean isAccpet = true;
            for (int j = selectedPaths.size() - 1; j >= 0; --j) {
                String existPath = (String)selectedPaths.get(j);
                if (Util.isSubPath(existPath, fullPath)) {
                    isAccpet = false;
                    break;
                }
                if (!isFolder || !Util.isSubPath(fullPath, existPath)) continue;
                selectedPaths.remove(existPath);
                path_Node.remove(existPath);
            }
            if (!isAccpet) continue;
            selectedPaths.add(fullPath);
            path_Node.put(fullPath, node);
        }
        return path_Node.values().toArray(new DefaultKingdeeTreeNode[0]);
    }

    private class CoreWork
    extends Progress {
        private LazyInfo[] infos;

        public CoreWork(ProgressUI bindUI, LazyInfo[] infos) {
            super(bindUI);
            this.infos = infos;
        }

        @Override
        protected void work() throws Exception {
            LazyInfo[] errs = DeleteEntity.this.getFacade().deleteEntities(DeleteEntity.this.getSchemaId(), this.infos);
        }
    }
}

