/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.AbstractAction;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.EntityShower;
import com.kingdee.bos.ctrl.semantic.design.exception.ConflictException;
import com.kingdee.bos.ctrl.semantic.design.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.design.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.event.ActionEvent;

public class EditEntity
extends AbstractAction {
    public EditEntity(DesignPane dp) {
        super(dp);
        this.setIcon(Resource.ICON_EDIT);
        this.setText("\u7f16\u8f91");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectCount = this.getTree().getSelectionCount();
        if (selectCount == 0) {
            this.showInfo("\u8bf7\u9009\u62e9\u8868/\u89c6\u56fe\u8fdb\u884c\u7f16\u8f91\u3002");
            return;
        }
        if (selectCount > 1) {
            this.showInfo("\u9009\u4e2d\u76ee\u6807\u4e0d\u660e\u786e\u3002");
            return;
        }
        DefaultKingdeeTreeNode selectedNode = this.getSelectedNode();
        LazyInfo info = (LazyInfo)selectedNode.getUserObject();
        if (info.getType() == 0) {
            this.showInfo("\u8bf7\u9009\u62e9\u8868/\u89c6\u56fe\u8fdb\u884c\u7f16\u8f91\u3002");
            return;
        }
        this.doAction(info);
    }

    public void doAction(LazyInfo info) {
        InfoWrapper wrapper;
        EntityShower[] all = this.getDesignPane().getAllEntityShower();
        for (int i = 0; i < all.length; ++i) {
            if (info != all[i].getInfo()) continue;
            this.getDesignPane().selectTab(i);
            return;
        }
        try {
            wrapper = this.getFacade().loadEntity(this.getSchemaId(), info, true);
        }
        catch (LockedException ex) {
            this.showWarning("\u7528\u6237 " + ex.getUser() + " \u6b63\u5728\u7f16\u8f91\u6b64\u5bf9\u8c61\uff0c\u60a8\u4e0d\u80fd\u540c\u65f6\u64cd\u4f5c\u3002");
            return;
        }
        catch (NotExistException ex) {
            this.showWarning("\u8be5\u5bf9\u8c61\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5c1d\u8bd5\u5237\u65b0\u540e\u7ee7\u7eed\u64cd\u4f5c\u3002");
            return;
        }
        catch (ConflictException ex) {
            this.showWarning("\u8be5\u5bf9\u8c61\u540d\u79f0\u6216\u8def\u5f84\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u5c1d\u8bd5\u5237\u65b0\u540e\u7ee7\u7eed\u64cd\u4f5c\u3002");
            return;
        }
        catch (SemanticDesignException ex) {
            this.showException("\u8bfb\u53d6\u5185\u5bb9\u5931\u8d25\u3002", ex);
            return;
        }
        info.setContent(wrapper.getContent());
        info.putProperty("mapSuppliers", wrapper.getSuppliers());
        try {
            this.getDesignPane().addTab(info);
        }
        catch (SemanticDesignException ex) {
            this.showException("\u52a0\u8f7d\u5931\u8d25\u3002", ex);
        }
    }
}

