/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.AbstractAction;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.tree.MutableTreeNode;

public class NewEntity
extends AbstractAction {
    public NewEntity(DesignPane dp) {
        super(dp);
        this.setIcon(Resource.ICON_NEW_FILE);
        this.setText("\u65b0\u5efa\u8868/\u89c6\u56fe");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectCount = this.getTree().getSelectionCount();
        if (selectCount == 0) {
            this.showInfo("\u8bf7\u5148\u9009\u62e9\u65b0\u5efa\u76ee\u6807\u7684\u6587\u4ef6\u5939\u3002");
            return;
        }
        if (selectCount > 1) {
            this.showInfo("\u9009\u4e2d\u76ee\u6807\u4e0d\u660e\u786e\u3002");
            return;
        }
        DefaultKingdeeTreeNode selectedNode = this.getSelectedNode();
        String path = NewEntity.getSelectedFolderPath(selectedNode);
        UI ui = new UI(path);
        SimpleDialog dlg = SimpleDialog.create((Component)this.getTree());
        dlg.setComponent((Component)((Object)ui));
        dlg.setTitle("\u65b0\u5efa\u8868/\u89c6\u56fe");
        dlg.setSize(480, 240);
        if (dlg.showDialog()) {
            LazyInfo info = new LazyInfo();
            info.setPath(path);
            info.setType(ui.getType());
            info.setLogicalName("\u672a\u547d\u540d");
            info.setStandard(this.getEditingContext().isStandardMaker());
            DefaultKingdeeTreeNode parentNode = NewEntity.getSelectedFolderNode(selectedNode);
            DefaultKingdeeTreeNode node = this.getSchemaTree().createEntityNode(info);
            this.getTree().addNodeInto((MutableTreeNode)node, (MutableTreeNode)parentNode);
            try {
                this.getDesignPane().addTab(info);
            }
            catch (SemanticDesignException ex) {
                log.error((Object)"", (Throwable)ex);
                this.getTree().removeNodeFromParent((MutableTreeNode)node);
            }
            this.getTree().setSelectionNode(node);
        }
    }

    private static class UI
    extends KDPanel {
        private KDRadioButton _radTable;
        private KDRadioButton _radView;

        public UI(String path) {
            if (StringUtil.isEmptyString((String)path)) {
                path = "\u6839\u76ee\u5f55";
            }
            KDLabel labPrompt1 = new KDLabel("\u76ee\u6807\u6587\u4ef6\u5939\uff1a");
            KDLabel labPrompt2 = new KDLabel(path);
            KDLabel labPrompt3 = new KDLabel("\u60a8\u5c06\u5728\u4e0a\u8ff0\u6587\u4ef6\u5939\u4e2d\u521b\u5efa\uff1a");
            this._radTable = new KDRadioButton("\u8868");
            this._radView = new KDRadioButton("\u89c6\u56fe");
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this._radTable);
            bg.add((AbstractButton)this._radView);
            this._radTable.setSelected(true);
            TableLayout2 ly = new TableLayout2(6, 2);
            ly.setFixedHeight(TableLayout2.ALL, 20);
            ly.setRatableHeight(5, 100);
            ly.setRowSpacing(1, 12);
            ly.setRowSpacing(2, 6);
            ly.setFixedWidth(0, 20);
            ly.setRatableWidth(1, 1);
            this.setLayout((LayoutManager)ly);
            this.add((Component)labPrompt1, TableLayout2.param((int)0, (int)0, (int)0, (int)1));
            this.add((Component)labPrompt2, TableLayout2.param((int)1, (int)1));
            this.add((Component)labPrompt3, TableLayout2.param((int)2, (int)0, (int)2, (int)1));
            this.add((Component)this._radTable, TableLayout2.param((int)3, (int)1));
            this.add((Component)this._radView, TableLayout2.param((int)4, (int)1));
        }

        public int getType() {
            if (this._radTable.isSelected()) {
                return 1;
            }
            if (this._radView.isSelected()) {
                return 2;
            }
            throw new RuntimeException("You must modify code.");
        }
    }
}

