/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.SchemaTree;
import com.kingdee.bos.ctrl.semantic.design.client.action.AbstractAction;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class NewFolder
extends AbstractAction {
    public NewFolder(DesignPane dp) {
        super(dp);
        this.setIcon(Resource.ICON_NEW_FOLDER);
        this.setText("\u65b0\u5efa\u6587\u4ef6\u5939");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultKingdeeTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            MessageUtil.msgboxInfo((Component)this.getTree(), (String)"\u8bf7\u5148\u9009\u62e9\u4e0a\u7ea7\u6587\u4ef6\u5939\u3002");
            return;
        }
        String path = NewFolder.getSelectedFolderPath(selectedNode);
        DefaultKingdeeTreeNode folderNode = NewFolder.getSelectedFolderNode(selectedNode);
        UI ui = new UI(path);
        ui.setFolderNode(folderNode);
        SimpleDialog dlg = SimpleDialog.create((Component)this.getTree());
        dlg.setComponent((Component)((Object)ui));
        dlg.setTitle("\u65b0\u5efa\u6587\u4ef6\u5939");
        dlg.setSize(480, 180);
        if (dlg.showDialog()) {
            DefaultKingdeeTreeNode node = SchemaTree.createFolderNode(path, ui.getInputName());
            this.getTree().addNodeInto((MutableTreeNode)node, (MutableTreeNode)folderNode);
            this.getTree().expandPath(new TreePath(node.getPath()));
            this.getTree().setSelectionNode(node);
        }
    }

    private static class UI
    extends KDPanel
    implements SimpleDialog.PanelOfSimpleDialog {
        private KDTextField _txtName;
        private DefaultKingdeeTreeNode _folderNode;

        public UI(String parentPath) {
            if (StringUtil.isEmptyString((String)parentPath)) {
                parentPath = "\u6839\u76ee\u5f55";
            }
            KDLabel labPrompt1 = new KDLabel("\u4e0a\u7ea7\u6587\u4ef6\u5939\uff1a" + parentPath);
            KDLabel labPrompt2 = new KDLabel("\uff08\u8bf7\u6ce8\u610f\uff0c\u7a7a\u6587\u4ef6\u5939\u5c06\u4e0d\u4e88\u4fdd\u5b58\u3002\uff09");
            this._txtName = new KDTextField();
            KDLabelContainer labName = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtName, (String)"\u540d\u79f0", (int)60);
            TableLayout2 ly = new TableLayout2(4, 1);
            ly.setFixedHeight(new int[]{0, 1, 2}, 20);
            ly.setRatableHeight(3, 1);
            ly.setRowSpacing(0, 6);
            ly.setRowSpacing(1, 18);
            this.setLayout((LayoutManager)ly);
            this.add((Component)labPrompt1, TableLayout2.param((int)0, (int)0));
            this.add((Component)labName, TableLayout2.param((int)1, (int)0));
            this.add((Component)labPrompt2, TableLayout2.param((int)2, (int)0));
        }

        public String getInputName() {
            return this._txtName.getText();
        }

        public void setFolderNode(DefaultKingdeeTreeNode folderNode) {
            this._folderNode = folderNode;
        }

        public boolean verify() {
            String editedResult = this.getInputName();
            if (StringUtil.isEmptyString((String)editedResult)) {
                return false;
            }
            if (editedResult.indexOf(46) != -1 || editedResult.indexOf(47) != -1 || editedResult.indexOf(92) != -1) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u540d\u79f0\u4e0d\u5141\u8bb8\u5305\u542b\u70b9\u3001\u659c\u6746\u7b49\u5b57\u7b26\u3002");
                return false;
            }
            for (int i = this._folderNode.getChildCount() - 1; i >= 0; --i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this._folderNode.getChildAt(i);
                if (!editedResult.equalsIgnoreCase(((LazyInfo)node.getUserObject()).getPhysicalName())) continue;
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u540d\u79f0\u5df2\u5b58\u5728\u3002");
                return false;
            }
            return true;
        }
    }
}

