/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.semantic.common.Util;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.AbstractAction;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.EntityShower;
import com.kingdee.bos.ctrl.semantic.design.exception.ConflictException;
import com.kingdee.bos.ctrl.semantic.design.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.design.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Refactor
extends AbstractAction {
    public Refactor(DesignPane dp) {
        super(dp);
        this.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.setText("\u79fb\u52a8\u5230...");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectCount = this.getTree().getSelectionCount();
        if (selectCount == 0) {
            this.showInfo("\u8bf7\u9009\u62e9\u8981\u79fb\u52a8\u7684\u8868\u3001\u89c6\u56fe\u6216\u6587\u4ef6\u5939\u3002");
            return;
        }
        HashMap<LazyInfo, String> mapSubPath = new HashMap<LazyInfo, String>();
        String oldPath = null;
        int oldPathLen = 0;
        TreePath[] allSelecteds = this.getTree().getSelectionPaths();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTree().getModel().getRoot();
        DefaultKingdeeTreeNode parentNode = null;
        for (int i = 0; i < allSelecteds.length; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)allSelecteds[i].getLastPathComponent();
            if (node == root) {
                this.showInfo("\u6839\u76ee\u5f55\u4e0d\u80fd\u79fb\u52a8\u3002");
                return;
            }
            LazyInfo info = (LazyInfo)node.getUserObject();
            if (oldPath == null) {
                oldPath = info.getPath();
                oldPathLen = StringUtil.isEmptyString((String)oldPath) ? 0 : oldPath.length() + 1;
                parentNode = (DefaultKingdeeTreeNode)node.getParent();
            } else if (!StringUtil.equalsIgnoreCase((String)oldPath, (String)info.getPath())) {
                this.showInfo("\u591a\u9009\u64cd\u4f5c\u5fc5\u987b\u9009\u4e2d\u76f8\u540c\u76ee\u5f55\u4e0b\u7684\u540c\u7ea7\u8282\u70b9\u3002");
                return;
            }
            if (info.getType() == 0) {
                Enumeration enums = node.breadthFirstEnumeration();
                while (enums.hasMoreElements()) {
                    DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)enums.nextElement();
                    LazyInfo subInfo = (LazyInfo)subNode.getUserObject();
                    if (subInfo.getType() == 0) continue;
                    if (this.isStandardCannotModify(subInfo) || this.isLockedCannotModify(subInfo) || this.isEditingCannotModify(subInfo)) {
                        return;
                    }
                    String p = subInfo.getPath();
                    mapSubPath.put(subInfo, p.substring(oldPathLen));
                }
                continue;
            }
            if (this.isStandardCannotModify(info) || this.isLockedCannotModify(info) || this.isEditingCannotModify(info)) {
                return;
            }
            mapSubPath.put(info, null);
        }
        int size = mapSubPath.size();
        if (size == 0) {
            this.showInfo("\u6ca1\u6709\u53ef\u79fb\u52a8\u7684\u8868/\u89c6\u56fe\u3002");
            return;
        }
        UI ui = new UI();
        ui.setValue(oldPath);
        SimpleDialog dlg = SimpleDialog.create((Component)this.getTree());
        dlg.setComponent((Component)((Object)ui));
        dlg.setTitle("\u79fb\u52a8\u5230...");
        dlg.setSize(560, 150);
        if (dlg.showDialog()) {
            String newPath = ui.getValue();
            if (StringUtil.equalsIgnoreCase((String)oldPath, (String)newPath)) {
                return;
            }
            LazyInfo[] infos = new LazyInfo[size];
            String[] newPaths = new String[size];
            int idx = 0;
            for (LazyInfo info : mapSubPath.keySet()) {
                String subPath = (String)mapSubPath.get(info);
                newPaths[idx] = StringUtil.isEmptyString((String)subPath) ? newPath : Util.makePath(newPath, subPath);
                infos[idx++] = info;
            }
            try {
                this.getFacade().moveEntities(this.getSchemaId(), infos, newPaths, this.getEditingContext().isStandardMaker());
            }
            catch (NotExistException ex) {
                this.showWarning("\u5bf9\u8c61\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
                return;
            }
            catch (LockedException ex) {
                this.showWarning("\u5bf9\u8c61\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u4e0d\u80fd\u4fee\u6539\u3002");
                return;
            }
            catch (ConflictException ex) {
                this.showWarning("\u5bf9\u8c61\u540d\u79f0\u6216\u8def\u5f84\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
                return;
            }
            catch (SemanticDesignException ex) {
                this.showException("", ex);
                return;
            }
            TreeNode[] oriParentNodes = parentNode.getPath();
            String[] ps = Util.splitPath(newPath);
            DefaultKingdeeTreeNode newParentNode = Refactor.searchTreeNodeByPath(root, ps);
            try {
                this.getSchemaTree().refresh(parentNode);
                this.getSchemaTree().refresh(newParentNode);
            }
            catch (SemanticDesignException ex) {
                log.error((Object)"", (Throwable)ex);
            }
            parentNode = Refactor.searchTreeNodeByOldNode(root, oriParentNodes);
            if (parentNode != null) {
                this.getSchemaTree().getTree().expandPath(new TreePath(parentNode.getPath()));
            }
            newParentNode = Refactor.searchTreeNodeByPath(root, ps);
            this.getSchemaTree().getTree().expandPath(new TreePath(newParentNode.getPath()));
            TreePath[] newSelection = new TreePath[allSelecteds.length];
            for (int i = 0; i < allSelecteds.length; ++i) {
                DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)allSelecteds[i].getLastPathComponent();
                LazyInfo tempInfo = (LazyInfo)tempNode.getUserObject();
                DefaultKingdeeTreeNode newNode = Refactor.getTreeChildNodeByName(newParentNode, tempInfo.getPhysicalName());
                newSelection[i] = new TreePath(newNode.getPath());
            }
            this.getSchemaTree().getTree().setSelectionPaths(newSelection);
        }
    }

    private static DefaultKingdeeTreeNode searchTreeNodeByOldNode(DefaultKingdeeTreeNode root, TreeNode[] nodes) {
        DefaultKingdeeTreeNode parent = root;
        for (int i = 1; i < nodes.length; ++i) {
            LazyInfo tempInfo = (LazyInfo)((DefaultKingdeeTreeNode)nodes[i]).getUserObject();
            DefaultKingdeeTreeNode tempNode = Refactor.getTreeChildNodeByName(parent, tempInfo.getPhysicalName());
            if (tempNode == null) {
                return null;
            }
            parent = tempNode;
        }
        return parent;
    }

    private static DefaultKingdeeTreeNode searchTreeNodeByPath(DefaultKingdeeTreeNode root, String[] splitPath) {
        DefaultKingdeeTreeNode tempNode;
        DefaultKingdeeTreeNode parent = root;
        for (int i = 0; i < splitPath.length && (tempNode = Refactor.getTreeChildNodeByName(parent, splitPath[i])) != null; ++i) {
            parent = tempNode;
        }
        return parent;
    }

    private static DefaultKingdeeTreeNode getTreeChildNodeByName(DefaultKingdeeTreeNode parent, String name) {
        for (int j = parent.getChildCount() - 1; j >= 0; --j) {
            DefaultKingdeeTreeNode tempNode = (DefaultKingdeeTreeNode)parent.getChildAt(j);
            LazyInfo tempInfo = (LazyInfo)tempNode.getUserObject();
            if (!StringUtil.equalsIgnoreCase((String)name, (String)tempInfo.getPhysicalName())) continue;
            return tempNode;
        }
        return null;
    }

    private boolean isEditingCannotModify(LazyInfo info) {
        EntityShower[] all = this.getDesignPane().getAllEntityShower();
        for (int i = 0; i < all.length; ++i) {
            if (info != all[i].getInfo()) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("\u3010");
            sb.append(info.getLogicalName());
            sb.append("\u3011");
            sb.append("\u6b63\u5728\u7f16\u8f91\uff0c\u8bf7\u5173\u95ed\u540e\u518d\u8fdb\u884c\u79fb\u52a8\u64cd\u4f5c\u3002");
            this.showInfo(sb.toString());
            return true;
        }
        return false;
    }

    private boolean isStandardCannotModify(LazyInfo info) {
        if (info.isStandard() && !this.getEditingContext().isStandardMaker()) {
            this.showWarning("\u60a8\u9009\u62e9\u7684\u9879\u76ee\u5305\u542b\u6807\u51c6\u4ea7\u54c1\uff0c\u4e0d\u80fd\u79fb\u52a8\u3002");
            return true;
        }
        return false;
    }

    private boolean isLockedCannotModify(LazyInfo info) {
        if (info.isLocked()) {
            StringBuffer sb = new StringBuffer();
            sb.append("\u3010");
            sb.append(info.getLogicalName());
            sb.append("\u3011");
            sb.append("\u6b63\u88ab\u5176\u4ed6\u7528\u6237\u7f16\u8f91\uff0c\u60a8\u53ef\u4ee5\u5237\u65b0\u540e\u518d\u505a\u5c1d\u8bd5\u3002");
            this.showInfo(sb.toString());
            return true;
        }
        return false;
    }

    private static class UI
    extends KDPanel
    implements SimpleDialog.PanelOfSimpleDialog {
        private KDTextField _txtOld = new KDTextField();
        private KDTextField _txtNew;

        public UI() {
            this._txtOld.setEditable(false);
            this._txtNew = new KDTextField();
            KDLabelContainer lbcOld = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtOld, (String)"\u539f\u6587\u4ef6\u5939", (int)80);
            KDLabelContainer lbcNew = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtNew, (String)"\u65b0\u6587\u4ef6\u5939", (int)80);
            TableLayout2 ly = new TableLayout2(3, 1);
            ly.setFixedHeight(TableLayout2.ALL, 20);
            ly.setRatableHeight(2, 100);
            ly.setRowSpacing(0, 6);
            this.setLayout((LayoutManager)ly);
            this.add((Component)lbcNew, TableLayout2.param((int)1, (int)0));
            this.add((Component)lbcOld, TableLayout2.param((int)0, (int)0));
        }

        public void setValue(String oldPath) {
            this._txtOld.setText(oldPath);
            this._txtNew.setText(oldPath);
        }

        public String getValue() {
            return this._txtNew.getText().trim();
        }

        public boolean verify() {
            String editedResult = this.getValue();
            if (editedResult.indexOf(46) != -1 || editedResult.indexOf(92) != -1) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u8def\u5f84\u4e0d\u5141\u8bb8\u5305\u542b\u70b9\u3001\u53cd\u659c\u6746\u7b49\u5b57\u7b26\u3002");
                return false;
            }
            if (editedResult.startsWith("/") || editedResult.endsWith("/")) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u8def\u5f84\u4e0d\u80fd\u4ee5\u659c\u6746\u5f00\u5934\u6216\u7ed3\u5c3e\u3002");
                return false;
            }
            int lastIdx = -1;
            int idx = 0;
            do {
                if ((idx = editedResult.indexOf("/", lastIdx + 1)) == lastIdx + 1) {
                    MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u8def\u5f84\u4e0d\u5141\u8bb8\u51fa\u73b0\u8fde\u7eed\u7684\u659c\u6746\u3002");
                    return false;
                }
                lastIdx = idx;
            } while (idx != -1);
            return true;
        }
    }
}

