/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.action;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.semantic.common.client.icon.SemanticIcons;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.action.AbstractAction;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.EntityShower;
import com.kingdee.bos.ctrl.semantic.design.exception.ExistException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class Save
extends AbstractAction {
    public Save(DesignPane dp) {
        super(dp);
        this.setIcon(SemanticIcons.ICN_SAVE);
        this.setText("\u4fdd\u5b58");
        this.setQuickKey(KeyStroke.getKeyStroke(83, 128));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        EntityShower entityShower = this.getDesignPane().getCurrentEntityShower();
        if (entityShower == null || !entityShower.isModelDirty()) {
            return;
        }
        try {
            this.saveOne(entityShower);
        }
        catch (SemanticDesignException ex) {
            String name = entityShower.getModel().getPhysicalName();
            this.showException("\u4fdd\u5b58\u5931\u8d25: " + name, ex);
        }
    }

    protected boolean saveOne(EntityShower entityShower) throws SemanticDesignException {
        boolean isOk = entityShower.save();
        if (isOk) {
            LazyInfo[] returnInfos;
            LazyInfo info = entityShower.getInfo();
            try {
                returnInfos = this.getFacade().saveEntity(this.getSchemaId(), info, info.getContent(), this.getEditingContext().isStandardMaker());
            }
            catch (ExistException ex) {
                StringBuffer sb = new StringBuffer();
                if (ex.getType() == 2) {
                    sb.append("\u6982\u5ff5\u540d\u79f0");
                } else if (ex.getType() == 1) {
                    sb.append("\u7269\u7406\u540d\u79f0");
                }
                sb.append("\uff1a");
                sb.append(ex.getExistName());
                sb.append(StringUtil.RETURN);
                sb.append("\u5df2\u88ab\u5176\u5b83\u6b63\u7f16\u8f91\u7684\u5bf9\u8c61\u5360\u7528\uff0c\u8bf7\u5168\u65b9\u6848\u5237\u65b0\u540e\u91cd\u65b0\u8bbe\u7f6e\u3002");
                this.showWarning(sb.toString());
                return false;
            }
            info.setId(returnInfos[0].getId());
            entityShower.setModelDirty(false);
            return true;
        }
        return false;
    }
}

