/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.entitydetail;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.semantic.common.client.icon.SemanticIcons;
import com.kingdee.bos.ctrl.semantic.design.client.DesignPane;
import com.kingdee.bos.ctrl.semantic.design.client.SchemaTree;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.SelectionModel;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.ShowerOperator;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.ShowerRenderer;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.PropertyArea;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.manage.client.EditingContext;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContentIO;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class EntityShower
extends KDPanel {
    private static final Logger log = LogUtil.getPackageLogger(EntityShower.class);
    private DesignPane _designPane;
    private LazyInfo _info;
    private AbstractSemanticEntity _model;
    private CellRendererPane _cellRendererPane;
    private ShowerRenderer _render;
    private SelectionModel _selectionModel;

    public EntityShower(DesignPane designPane) {
        this._designPane = designPane;
        this.initDrag();
        this.initListener();
        this.setBackground(new Color(241, 245, 247));
        this.setFocusable(true);
    }

    private void initDrag() {
        DragHandler handler = new DragHandler();
        this._designPane.getSchemaTree().getTree().addMouseListener((MouseListener)handler);
        this._designPane.getSchemaTree().getTree().addMouseMotionListener((MouseMotionListener)handler);
    }

    private void initListener() {
        ShowerOperator handler = new ShowerOperator(this);
        this.addMouseListener(handler);
        this.addMouseMotionListener(handler);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    public LazyInfo getInfo() {
        return this._info;
    }

    public void setInfo(LazyInfo info) throws SemanticDesignException {
        this._info = info;
        boolean isNew = StringUtil.isEmptyString((String)info.getId());
        Map mapSuppliers = (Map)info.getProperty("mapSuppliers");
        this._model = EntityShower.info2Model(info, isNew, mapSuppliers);
        this.updateSize();
        this.repaint();
        PropertyArea pa = (PropertyArea)((Object)this._model.getProperty("propertyArea"));
        pa.model2Ui(this);
        this._designPane.changePropertyArea(pa);
    }

    private static AbstractSemanticEntity info2Model(LazyInfo info, boolean isNew, Map mapSuppliers) throws SemanticDesignException {
        AbstractSemanticEntity model = EntityShower.innerInfo2Model(info);
        model.setStandard(info.isStandard());
        if (isNew) {
            model.setProperty("rect", new Rectangle(40, 30, 120, 180));
        } else {
            HeavyContent content = info.getContent();
            HeavyContentIO.load(content, model, mapSuppliers);
        }
        return model;
    }

    private static AbstractSemanticEntity innerInfo2Model(LazyInfo info) {
        AbstractSemanticEntity model = AbstractSemanticEntity.create(info.getType());
        if (info.getType() == 1) {
            model.setProperty("propertyArea", (Object)PropertyArea.createForTable());
        } else if (info.getType() == 2) {
            model.setProperty("propertyArea", (Object)PropertyArea.createForView());
        } else {
            throw new RuntimeException("You must modify code.");
        }
        model.setProperty("id", info.getId());
        model.setLogicalName(info.getLogicalName());
        model.setPhysicalName(info.getPhysicalName());
        return model;
    }

    public boolean save() throws SemanticDesignException {
        PropertyArea pa = (PropertyArea)((Object)this._model.getProperty("propertyArea"));
        if (!pa.check()) {
            return false;
        }
        pa.ui2Model(this);
        int c = this._model.getRelationsCount();
        for (int i = 0; i < c; ++i) {
            pa = (PropertyArea)((Object)this._model.getRelation(i).getProperty("propertyArea"));
            if (pa == null) continue;
            if (!pa.check()) {
                return false;
            }
            pa.ui2Model(this);
        }
        this.model2Info();
        return true;
    }

    private void model2Info() throws SemanticDesignException {
        this._info.setPhysicalName(this._model.getPhysicalName());
        this._info.setLogicalName(this._model.getLogicalName());
        if (this._info.getContent() == null) {
            this._info.setContent(new HeavyContent());
        }
        HeavyContentIO.save(this._model, this._info.getContent());
    }

    public EditingContext getEditingContext() {
        return this._designPane.getEditingContext();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this._render == null) {
            this._render = ShowerRenderer.create();
        }
        this._render.setShower(this);
        this._render.draw(g);
        this.getCellRendererPane().removeAll();
    }

    CellRendererPane getCellRendererPane() {
        if (this._cellRendererPane == null) {
            this._cellRendererPane = new CellRendererPane();
        }
        if (this._cellRendererPane.getParent() != this) {
            this.add(this._cellRendererPane);
        }
        return this._cellRendererPane;
    }

    public AbstractSemanticEntity getModel() {
        return this._model;
    }

    SelectionModel getSelectionModel() {
        if (this._selectionModel == null) {
            this._selectionModel = new SelectionModel(this._model);
        }
        return this._selectionModel;
    }

    public SemanticRelation getSelectedRelation() {
        return this.getSelectionModel().getSelectedRelation();
    }

    public void setModelDirty(boolean isDirty) {
        Object oldValue = this._info.getProperty("dirty");
        Boolean newValue = new Boolean(isDirty);
        this._info.putProperty("dirty", newValue);
        if (!new Boolean(isDirty).equals(oldValue)) {
            this.updateTitle();
        }
    }

    public boolean isModelDirty() {
        return Boolean.TRUE.equals(this._info.getProperty("dirty"));
    }

    public void updateTitle() {
        String lName = this._model.getLogicalName();
        String tabTitle = this.isModelDirty() ? "* " + lName : lName;
        this.changeTabTitle(tabTitle);
        SchemaTree st = (SchemaTree)this._info.getProperty("tree");
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this._info.getProperty("treeNode");
        st.updateNodeText(node, lName, this._model.getPhysicalName(), this.isModelDirty());
    }

    private void changeTabTitle(String title) {
        int idx = this._designPane.getIndexOfEntityShower(this);
        if (idx >= 0) {
            this._designPane.setTabTitle(idx, title);
        }
    }

    public void select(Object obj) {
        PropertyArea oriPa = this.getCurrentPropertyArea();
        if (obj == this._model) {
            this.getSelectionModel().setSelectedClient();
        } else if (obj instanceof SemanticRelation) {
            SemanticRelation relation = (SemanticRelation)obj;
            this.getSelectionModel().setSelectedSupplier(relation);
        }
        PropertyArea newPa = this.getCurrentPropertyArea();
        if (oriPa != newPa && oriPa == this._model.getProperty("propertyArea")) {
            oriPa.ui2Model(this);
            int c = this._model.getRelationsCount();
            for (int i = 0; i < c; ++i) {
                PropertyArea tempPa = (PropertyArea)((Object)this._model.getRelation(i).getProperty("propertyArea"));
                if (tempPa == null) continue;
                tempPa.entityInnerInteraction();
            }
        }
        this._designPane.changePropertyArea(newPa);
    }

    public PropertyArea getCurrentPropertyArea() {
        if (this.getSelectionModel().isSupplier()) {
            SemanticRelation relation = this.getSelectionModel().getSelectedRelation();
            PropertyArea pa = (PropertyArea)((Object)relation.getProperty("propertyArea"));
            if (pa == null) {
                pa = PropertyArea.createForRelation(relation);
                relation.setProperty("propertyArea", (Object)pa);
                pa.model2Ui(this);
            }
            return pa;
        }
        return (PropertyArea)((Object)this._model.getProperty("propertyArea"));
    }

    public boolean checkLogicalNameExist(String name) {
        SchemaTree st = (SchemaTree)this._info.getProperty("tree");
        return st.checkLogicalNameExist(name, this._info);
    }

    public boolean checkPhysicalNameExist(String name) {
        SchemaTree st = (SchemaTree)this._info.getProperty("tree");
        return st.checkPhysicalNameExist(name, this._info);
    }

    void updateSize() {
        int maxRight = 0;
        int maxBottom = 0;
        Rectangle rect = (Rectangle)this._model.getProperty("rect");
        int right = rect.x + rect.width;
        int bottom = rect.y + rect.height;
        if (right > maxRight) {
            maxRight = right;
        }
        if (bottom > maxBottom) {
            maxBottom = bottom;
        }
        int c = this._model.getRelationsCount();
        for (int i = 0; i < c; ++i) {
            SemanticRelation relation = this._model.getRelation(i);
            rect = (Rectangle)relation.getSupplier().getProperty("rect");
            right = rect.x + rect.width;
            bottom = rect.y + rect.height;
            if (right > maxRight) {
                maxRight = right;
            }
            if (bottom <= maxBottom) continue;
            maxBottom = bottom;
        }
        this.setPreferredSize(new Dimension(maxRight + 300, maxBottom + 200));
        this.invalidate();
        KDTabbedPane tabPan = this.getOwner();
        if (tabPan != null) {
            tabPan.revalidate();
        }
    }

    private KDTabbedPane getOwner() {
        Object parent = this;
        while ((parent = ((Component)parent).getParent()) != null && !(parent instanceof KDTabbedPane)) {
        }
        return (KDTabbedPane)parent;
    }

    public Action getDefaultAction(String key) {
        return this._designPane.getDefaultAction(key);
    }

    class DragHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private Point mouseStart;
        private LazyInfo dragTarget;

        DragHandler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (EntityShower.this.isShowing()) {
                this.mouseStart = evt.getPoint();
            }
            this.dragTarget = null;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.mouseStart = null;
            if (this.dragTarget != null && this.checkCanDrop(evt)) {
                this.createRelation(evt);
            }
            ((KDTree)evt.getSource()).setCursor(Cursor.getDefaultCursor());
            EntityShower.this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (this.mouseStart != null) {
                Point pt = evt.getPoint();
                if (Math.abs(pt.x - this.mouseStart.x) > 10 || Math.abs(pt.y - this.mouseStart.y) > 5) {
                    this.checkCanDrag(evt);
                    this.mouseStart = null;
                }
            }
            if (this.dragTarget != null) {
                if (this.checkCanDrop(evt)) {
                    EntityShower.this.setCursor(SemanticIcons.CURSOR_DRAGRELATION);
                } else {
                    ((KDTree)evt.getSource()).setCursor(SemanticIcons.CURSOR_FORBIDRELATION);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        private void checkCanDrag(MouseEvent evt) {
            KDTree tree = (KDTree)evt.getSource();
            TreePath path = tree.getSelectionPath();
            if (path != null && evt.getX() > tree.getPathBounds((TreePath)path).x) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                LazyInfo info = (LazyInfo)node.getUserObject();
                if (info.getType() == 0) {
                    return;
                }
                if (info.getId() == null) {
                    MessageUtil.msgboxWarning((Component)((Object)EntityShower.this), (String)"\u60a8\u62d6\u62fd\u7684\u76ee\u6807\u5bf9\u8c61\u521a\u65b0\u5efa\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u7528\u4e8e\u5efa\u7acb\u5173\u7cfb\u3002");
                    return;
                }
                try {
                    EntityShower.this.getEditingContext().getDesigntimeFacade().lifeDetector();
                }
                catch (SemanticDesignException ex) {
                    log.error((Object)"", (Throwable)ex);
                    return;
                }
                this.dragTarget = info;
            }
        }

        private boolean checkCanDrop(MouseEvent evt) {
            MouseEvent evt2 = SwingUtilities.convertMouseEvent((Component)((KDTree)evt.getSource()), evt, (Component)((Object)EntityShower.this));
            return EntityShower.this.contains(evt2.getPoint());
        }

        private void createRelation(MouseEvent evt) {
            InfoWrapper infoWrapper;
            evt = SwingUtilities.convertMouseEvent((Component)((KDTree)evt.getSource()), evt, (Component)((Object)EntityShower.this));
            try {
                infoWrapper = EntityShower.this.getEditingContext().getDesigntimeFacade().loadEntity(EntityShower.this.getEditingContext().getSchemaId(), this.dragTarget, false);
            }
            catch (SemanticDesignException ex) {
                log.error((Object)"", (Throwable)ex);
                MessageUtil.msgboxWarning((Component)((Object)EntityShower.this), (String)"\u62d6\u62fd\u5bf9\u8c61\u8bfb\u53d6\u5931\u8d25\u3002", (Exception)ex);
                return;
            }
            this.dragTarget.setContent(infoWrapper.getContent());
            AbstractSemanticEntity supplier = EntityShower.innerInfo2Model(this.dragTarget);
            try {
                HeavyContentIO.loadEntity(this.dragTarget.getContent(), supplier);
            }
            catch (SemanticDesignException ex) {
                log.error((Object)"", (Throwable)ex);
                MessageUtil.msgboxWarning((Component)((Object)EntityShower.this), (String)"\u62d6\u62fd\u5bf9\u8c61\u8bfb\u53d6\u5931\u8d25\u3002", (Exception)ex);
                return;
            }
            supplier.setProperty("rect", new Rectangle(evt.getX(), evt.getY(), 120, 80));
            SemanticRelation relation = new SemanticRelation();
            relation.setStandard(EntityShower.this.getEditingContext().isStandardMaker() && EntityShower.this._model.isStandard());
            relation.setClient(EntityShower.this._model);
            relation.setSupplier(supplier);
            EntityShower.this._model.addRelation(relation);
            EntityShower.this.select(relation);
            EntityShower.this.repaint();
            EntityShower.this.setModelDirty(true);
        }
    }
}

