/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.entitydetail;

import com.kingdee.bos.ctrl.semantic.common.client.relation.RelationRenderModel;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.EntityShower;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.MouseState;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.OperatingRenderer;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.SelectionModel;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

class ShowerOperator
extends MouseAdapter
implements MouseMotionListener {
    private EntityShower _entityShower;
    private MouseState _mouseState = new MouseState();
    private OperatingRenderer opRender = new OperatingRenderer();
    private Point _dragStartPoint;
    private Rectangle _lastDragRect;
    private boolean _isDraged;
    private KDPopupMenu _popupMenu;

    public ShowerOperator(EntityShower entityShower) {
        this._entityShower = entityShower;
    }

    private AbstractSemanticEntity getModel() {
        return this._entityShower.getModel();
    }

    private SelectionModel getSelectionModel() {
        return this._entityShower.getSelectionModel();
    }

    private void clearState() {
        this._dragStartPoint = null;
        this._lastDragRect = null;
        this._isDraged = false;
        this._mouseState.setState(0);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int state = this.getOperateState(e.getPoint());
        this._mouseState.setState(state);
        this._entityShower.setCursor(this._mouseState.getCursor());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this._entityShower.requestFocus();
        this._dragStartPoint = e.getPoint();
        Object bingo = this.search(this._dragStartPoint);
        this._entityShower.select(bingo);
        this._entityShower.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (this._mouseState.isMove() && this._isDraged) {
            this.moving(e, true);
            this._entityShower.setModelDirty(true);
            this._entityShower.updateSize();
            this._entityShower.repaint();
        } else if (this._mouseState.isResize() && this._isDraged) {
            this.resizing(e, true);
            this._entityShower.setModelDirty(true);
            this._entityShower.updateSize();
            this._entityShower.repaint();
        }
        this.clearState();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this._isDraged = true;
        if (this._mouseState.isMove()) {
            this.moving(e, false);
        } else if (this._mouseState.isResize()) {
            this.resizing(e, false);
        }
    }

    private int getOperateState(Point pt) {
        for (int i = this.getModel().getRelationsCount() - 1; i >= 0; --i) {
            SemanticRelation relation = this.getModel().getRelation(i);
            Rectangle oriRect = (Rectangle)relation.getSupplier().getProperty("rect");
            if (!oriRect.contains(pt)) continue;
            return this.getOperateState(pt, oriRect);
        }
        Rectangle oriRect = (Rectangle)this.getModel().getProperty("rect");
        int result = this.getOperateState(pt, oriRect);
        return result;
    }

    private int getOperateState(Point pt, Rectangle oriRect) {
        Rectangle rect = new Rectangle(oriRect);
        rect.height = 40;
        if (rect.contains(pt)) {
            return 1;
        }
        rect = new Rectangle(oriRect.x + oriRect.width - 16, oriRect.y + oriRect.height - 16, 16, 16);
        if (rect.contains(pt)) {
            return 2;
        }
        return 0;
    }

    private Object search(Point pt) {
        for (int i = this.getModel().getRelationsCount() - 1; i >= 0; --i) {
            SemanticRelation relation = this.getModel().getRelation(i);
            Rectangle rect = (Rectangle)relation.getSupplier().getProperty("rect");
            if (!rect.contains(pt)) continue;
            return relation;
        }
        Rectangle rect = (Rectangle)this.getModel().getProperty("rect");
        if (rect.contains(pt)) {
            return this.getModel();
        }
        return null;
    }

    private Point getDelta(MouseEvent e) {
        Point delta = e.getPoint();
        delta.translate(-this._dragStartPoint.x, -this._dragStartPoint.y);
        return delta;
    }

    private void translateRect(Rectangle rect, Point delta) {
        rect.translate(delta.x, delta.y);
        if (rect.x <= 0) {
            delta.x = delta.x - rect.x + 1;
            rect.x = 1;
        }
        if (rect.y <= 0) {
            delta.y = delta.y - rect.y + 1;
            rect.y = 1;
        }
    }

    private void moving(MouseEvent e, boolean isEnd) {
        Point delta = this.getDelta(e);
        AbstractSemanticEntity selected = this.getSelectionModel().getSelected();
        Rectangle oriRect = (Rectangle)selected.getProperty("rect");
        Rectangle rect = null;
        if (!isEnd) {
            rect = new Rectangle(oriRect);
            this.translateRect(rect, delta);
        }
        this.opRender.drawRect(this._entityShower.getGraphics(), this._lastDragRect, rect);
        this._lastDragRect = rect;
        if (isEnd) {
            this.translateRect(oriRect, delta);
            if (e.isControlDown() && !this.getSelectionModel().isSupplier()) {
                int c = this.getModel().getRelationsCount();
                for (int i = 0; i < c; ++i) {
                    SemanticRelation relation = this.getModel().getRelation(i);
                    AbstractSemanticEntity supplier = relation.getSupplier();
                    Rectangle r = (Rectangle)supplier.getProperty("rect");
                    this.translateRect(r, delta);
                }
            }
            this.updateLine();
        }
    }

    private void resizing(MouseEvent e, boolean isEnd) {
        Point delta = this.getDelta(e);
        AbstractSemanticEntity selected = this.getSelectionModel().getSelected();
        Rectangle oriRect = (Rectangle)selected.getProperty("rect");
        Rectangle rect = null;
        if (!isEnd) {
            rect = new Rectangle(oriRect);
            this.resizeRect(rect, delta);
        }
        this.opRender.drawRect(this._entityShower.getGraphics(), this._lastDragRect, rect);
        this._lastDragRect = rect;
        if (isEnd) {
            this.resizeRect(oriRect, delta);
            this.updateLine();
        }
    }

    private void resizeRect(Rectangle rect, Point delta) {
        rect.width += delta.x;
        rect.height += delta.y;
        if (rect.width <= 80) {
            delta.x += 80 - rect.width;
            rect.width = 80;
        }
        if (rect.height <= 50) {
            delta.y += 50 - rect.height;
            rect.height = 50;
        }
    }

    private void updateLine() {
        if (this.getSelectionModel().isSupplier()) {
            SemanticRelation relation = this.getSelectionModel().getSelectedRelation();
            RelationRenderModel lineModel = (RelationRenderModel)relation.getProperty("lineModel");
            lineModel.update(relation);
        } else {
            int c = this.getModel().getRelationsCount();
            for (int i = 0; i < c; ++i) {
                SemanticRelation relation = this.getModel().getRelation(i);
                RelationRenderModel lineModel = (RelationRenderModel)relation.getProperty("lineModel");
                lineModel.update(relation);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        SemanticRelation relation;
        if (e.getClickCount() != 2 || SwingUtilities.isLeftMouseButton(e)) {
            // empty if block
        }
        if (SwingUtilities.isRightMouseButton(e) && (relation = this._entityShower.getSelectedRelation()) != null && relation == this.search(e.getPoint())) {
            this.getPopupMenu().show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private KDPopupMenu getPopupMenu() {
        if (this._popupMenu == null) {
            this._popupMenu = new KDPopupMenu();
            this._popupMenu.add((JMenuItem)new KDMenuItem(this._entityShower.getDefaultAction("deleteRelation")));
        }
        return this._popupMenu;
    }
}

