/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.entitydetail;

import com.kingdee.bos.ctrl.semantic.common.client.icon.SemanticIcons;
import com.kingdee.bos.ctrl.semantic.common.client.relation.RelationRenderModel;
import com.kingdee.bos.ctrl.semantic.common.client.relation.RelationRenderer;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.EntityShower;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.FieldsListCellRenderer;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.SelectionModel;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticTable;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticView;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.ListCellRenderer;

class ShowerRenderer {
    private static final Color COLOR_CLIENT_TITLE = new Color(182, 206, 225);
    private static final Color COLOR_SUPPLIER_TITLE = new Color(225, 225, 225);
    private EntityShower _shower;
    private InnerRenderer _ir = new InnerRenderer();

    public static ShowerRenderer create() {
        return new ShowerRenderer();
    }

    private ShowerRenderer() {
    }

    public void setShower(EntityShower shower) {
        this._shower = shower;
    }

    public void draw(Graphics g) {
        this.paintEntity(g);
        this.paintSuppliers(g);
        this.paintSelection(g);
    }

    private void paintCtrl(Graphics g, Component c, Rectangle rect) {
        this._shower.getCellRendererPane().paintComponent(g, c, (Container)((Object)this._shower), rect.x, rect.y, rect.width, rect.height, true);
    }

    private AbstractSemanticEntity getModel() {
        return this._shower.getModel();
    }

    private void paintEntity(Graphics g) {
        this._ir.setMain(true);
        this._ir.draw(g, this.getModel());
    }

    private void paintSuppliers(Graphics g) {
        this._ir.setMain(false);
        int c = this.getModel().getRelationsCount();
        for (int i = 0; i < c; ++i) {
            SemanticRelation relation = this.getModel().getRelation(i);
            AbstractSemanticEntity supplier = relation.getSupplier();
            this._ir.draw(g, supplier);
            RelationRenderModel line = this.getRelationRenderModel(relation);
            RelationRenderer.paintLine(g, line, relation.getDescription());
            if (line.getPointCount() <= 1 || !relation.isStandard()) continue;
            Point pt = this.calulateIconPos(line, new Point(8, 8), new Point(2, 2));
            g.drawImage(((ImageIcon)SemanticIcons.ICN_INFO).getImage(), pt.x, pt.y, null);
        }
    }

    private void paintSelection(Graphics g) {
        SelectionModel sm = this._shower.getSelectionModel();
        AbstractSemanticEntity selected = sm.getSelected();
        if (selected == null) {
            return;
        }
        Rectangle rect = (Rectangle)selected.getProperty("rect");
        Color oriColor = g.getColor();
        Stroke oriStroke = ((Graphics2D)g).getStroke();
        g.setColor(Color.BLUE);
        ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
        if (sm.isSupplier()) {
            SemanticRelation relation = sm.getSelectedRelation();
            RelationRenderModel line = this.getRelationRenderModel(relation);
            RelationRenderer.paintLine(g, line, relation.getDescription());
        }
        g.setColor(oriColor);
        ((Graphics2D)g).setStroke(oriStroke);
    }

    private RelationRenderModel getRelationRenderModel(SemanticRelation relation) {
        RelationRenderModel mo = (RelationRenderModel)relation.getProperty("lineModel");
        if (mo == null) {
            mo = new RelationRenderModel();
            mo.update(relation);
            relation.setProperty("lineModel", mo);
        }
        return mo;
    }

    private Point calulateIconPos(RelationRenderModel line, Point contentSize, Point spacing) {
        RelationRenderModel.Direction dir = line.getStartDirection();
        Point point = new Point(line.getPoint(0));
        if (dir == RelationRenderModel.Direction.WEST) {
            point.x -= contentSize.x;
            point.x -= spacing.x;
        } else {
            point.x += spacing.x;
        }
        if (dir == RelationRenderModel.Direction.SOUTH) {
            point.y += spacing.y;
        } else {
            point.y -= contentSize.y;
            point.y -= spacing.y;
        }
        return point;
    }

    private class InnerRenderer {
        private KDPanel _panAll = new KDPanel();
        private KDLabel _labTitle = new KDLabel();
        private KDLabel _labTitle2 = new KDLabel();
        private KDList _lstFields = new KDList();
        private KDSeparator _spt = new KDSeparator();

        private InnerRenderer() {
            this._panAll.setBorder(BorderFactory.createEtchedBorder());
            this._lstFields.setBorder(null);
            this._lstFields.setCellRenderer((ListCellRenderer)((Object)new FieldsListCellRenderer()));
            this._labTitle.setOpaque(true);
            this._labTitle2.setOpaque(true);
        }

        public void setMain(boolean isMain) {
            if (isMain) {
                this._labTitle.setBackground(COLOR_CLIENT_TITLE);
                this._labTitle2.setBackground(COLOR_CLIENT_TITLE);
            } else {
                this._labTitle.setBackground(COLOR_SUPPLIER_TITLE);
                this._labTitle2.setBackground(COLOR_SUPPLIER_TITLE);
            }
        }

        public void prepareList(AbstractSemanticEntity entity) {
            this._lstFields.removeAllElements();
            Rectangle rect = (Rectangle)entity.getProperty("rect");
            int count = (rect.height - 58) / 20 + 1;
            int c = Math.min(count, entity.getFieldCount());
            for (int i = 0; i < c; ++i) {
                SemanticField field = entity.getField(i);
                this._lstFields.addElement((Object)field);
            }
        }

        public void draw(Graphics g, AbstractSemanticEntity entity) {
            boolean isNotFound = Boolean.TRUE == entity.getProperty("notFound");
            this.prepareList(entity);
            Rectangle rect = (Rectangle)entity.getProperty("rect");
            ShowerRenderer.this.paintCtrl(g, (Component)this._panAll, rect);
            Rectangle rectForDraw = new Rectangle();
            rectForDraw.x = rect.x + 1;
            rectForDraw.y = rect.y + 1;
            rectForDraw.width = rect.width - 3;
            rectForDraw.height = 20;
            if (isNotFound) {
                this._labTitle.setIcon(SemanticIcons.ICN_ERROR);
                this._labTitle.setText((String)entity.getProperty("id"));
            } else {
                if (entity instanceof SemanticTable) {
                    this._labTitle.setIcon(SemanticIcons.ICN_TABLE);
                } else if (entity instanceof SemanticView) {
                    this._labTitle.setIcon(SemanticIcons.ICN_VIEW);
                }
                this._labTitle.setText(entity.getLogicalName());
            }
            ShowerRenderer.this.paintCtrl(g, (Component)this._labTitle, rectForDraw);
            if (isNotFound) {
                this._labTitle2.setText("Not found!");
            } else {
                this._labTitle2.setText(entity.getPhysicalName());
            }
            rectForDraw.y += rectForDraw.height;
            ShowerRenderer.this.paintCtrl(g, (Component)this._labTitle2, rectForDraw);
            rectForDraw.y += rectForDraw.height;
            rectForDraw.height = 2;
            ShowerRenderer.this.paintCtrl(g, (Component)this._spt, rectForDraw);
            rectForDraw.y += rectForDraw.height;
            rectForDraw.height = rect.height - 58;
            if (rectForDraw.height < 0) {
                rectForDraw.height = 0;
            }
            ShowerRenderer.this.paintCtrl(g, (Component)this._lstFields, rectForDraw);
            rectForDraw.y += rectForDraw.height;
            rectForDraw.height = 2;
            ShowerRenderer.this.paintCtrl(g, (Component)this._spt, rectForDraw);
            int x = rect.x + rect.width - 3;
            int y = rect.y + rect.height - 3;
            Color oriColor = g.getColor();
            for (int i = 1; i < 12; i += 4) {
                g.setColor(Color.GRAY);
                g.drawLine(x, y - i, x - i, y);
                g.setColor(Color.GRAY);
                g.drawLine(x, y - i - 1, x - i - 1, y);
                g.setColor(Color.WHITE);
                g.drawLine(x, y - i - 2, x - i - 2, y);
            }
            g.setColor(oriColor);
        }
    }
}

