/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property;

import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.AbstractPane;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.AbstractTableView;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticDataType;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComboBox;

abstract class AbstractFieldsPane
extends AbstractPane {
    protected static final int COL_STANDARD = 0;
    protected static final int COL_LNAME = 1;
    protected static final int COL_PNAME = 2;
    protected static final int COL_DATATYPE = 3;
    protected static final int COL_EXPR = 4;
    protected static final int COL_PK = 5;
    protected static final int COL_HIDE = 6;
    private TableView _tv = new TableView();
    private AbstractFieldsPane _associated;

    public AbstractFieldsPane() {
        this.initTable();
        this.setCustomInsets(new Insets(0, 0, 2, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this._tv), "Center");
    }

    protected KDTable getTable() {
        return this._tv.getTable();
    }

    protected void acceptTableEditValue() {
        this._tv.acceptEditValue();
    }

    private void initTable() {
        this.getTable().addColumns(7);
        this.getTable().getColumn(1).setWidth(160);
        this.getTable().getColumn(2).setWidth(160);
        this.getTable().getColumn(3).setWidth(100);
        this.getTable().getColumn(4).setWidth(260);
        this.getTable().getColumn(5).setWidth(40);
        this.getTable().getColumn(6).setWidth(40);
        this.getTable().getColumn(0).setWidth(80);
        this.getTable().getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])SemanticDataType.getAll())));
        IRow head = this.getTable().addHeadRow();
        head.getCell(1).setValue((Object)"\u6982\u5ff5\u540d\u79f0");
        head.getCell(2).setValue((Object)"\u7269\u7406\u540d\u79f0");
        head.getCell(3).setValue((Object)"\u6570\u636e\u7c7b\u578b");
        head.getCell(4).setValue((Object)"\u8868\u8fbe\u5f0f");
        head.getCell(5).setValue((Object)"PK");
        head.getCell(6).setValue((Object)"\u9690\u85cf");
        head.getCell(0).setValue((Object)"\u6807\u51c6\u4ea7\u54c1");
        this.getTable().getColumn(0).getStyleAttributes().setHided(true);
    }

    public void bindAssociated(AbstractFieldsPane another) {
        this._associated = another;
    }

    @Override
    public boolean check() {
        boolean isExprHide = this.getTable().getColumn(4).getStyleAttributes().isHided();
        this._tv.acceptEditValue();
        int c = this.getTable().getRowCount();
        for (int i = 0; i < c; ++i) {
            String expr;
            IRow row = this.getTable().getRow(i);
            String lName = (String)row.getCell(1).getValue();
            String prompt = this._tv.checkEmpty(lName, i, 1);
            if (prompt == null) {
                prompt = this._tv.checkExist(lName, i, 1, false);
            }
            if (prompt == null) {
                prompt = this.checkAssociated(lName, i, 1);
            }
            if (prompt != null) {
                this.showCheckResult(prompt);
                return false;
            }
            String pName = (String)row.getCell(2).getValue();
            prompt = this._tv.checkEmpty(pName, i, 2);
            if (prompt == null) {
                prompt = this._tv.checkExist(pName, i, 2, false);
            }
            if (prompt == null) {
                prompt = this.checkAssociated(pName, i, 2);
            }
            if (prompt != null) {
                this.showCheckResult(prompt);
                return false;
            }
            if (isExprHide || (prompt = this._tv.checkEmpty(expr = (String)row.getCell(4).getValue(), i, 4)) == null) continue;
            this.showCheckResult(prompt);
            return false;
        }
        return true;
    }

    private String checkAssociated(String value, int rowIdx, int colIdx) {
        if (this._associated != null && this._associated._tv.checkExist(value, -1, colIdx, true) != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("\u7b2c");
            sb.append(rowIdx + 1);
            sb.append("\u884c\uff0c");
            sb.append(this.getTable().getHeadRow(0).getCell(colIdx).getValue());
            sb.append("\u5df2\u5728");
            sb.append(this._associated.getTitle());
            sb.append("\u4e2d\u5b9a\u4e49\uff0c\u4e0d\u80fd\u91cd\u590d\u3002");
            return sb.toString();
        }
        return null;
    }

    private class TableView
    extends AbstractTableView {
        private int lastErrRow;
        private int lastErrCol;

        private TableView() {
        }

        @Override
        protected void doAddedRow(IRow row) {
            row.getCell(5).setValue((Object)Boolean.FALSE);
            row.getCell(6).setValue((Object)Boolean.FALSE);
            row.getCell(0).setValue((Object)new Boolean(AbstractFieldsPane.this.isStandardMaker() && AbstractFieldsPane.this.getModel().isStandard()));
            row.getCell(3).setValue((Object)SemanticDataType.VARCHAR);
            this.getTitleLabel().setText("");
        }

        @Override
        protected boolean doCanRemoveRows(int[] rowIdxs) {
            if (AbstractFieldsPane.this.isStandardMaker()) {
                return true;
            }
            for (int i = 0; i < rowIdxs.length; ++i) {
                Boolean std = (Boolean)this.getTable().getRow(rowIdxs[i]).getCell(0).getValue();
                if (!std.booleanValue()) continue;
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u6807\u51c6\u4ea7\u54c1\u7684\u5b57\u6bb5\u4e0d\u80fd\u5220\u9664\u3002");
                return false;
            }
            return true;
        }

        @Override
        protected void doRemovedRows() {
            this.getTitleLabel().setText("");
            AbstractFieldsPane.this.dirtyModel();
        }

        @Override
        protected void doUpOrDowned() {
            this.getTitleLabel().setText("");
            AbstractFieldsPane.this.dirtyModel();
        }

        @Override
        protected void doValueChanged(KDTEditEvent e) {
            AbstractFieldsPane.this.dirtyModel();
            if (e.getColIndex() == 5) {
                // empty if block
            }
        }

        @Override
        protected void doEditStopped(KDTEditEvent e) {
            String prompt;
            AbstractFieldsPane.this.dirtyModel();
            int rowIdx = e.getRowIndex();
            int colIdx = e.getColIndex();
            if (colIdx == 1 || colIdx == 2) {
                String prompt2 = this.checkEmpty((String)e.getValue(), rowIdx, colIdx);
                if (prompt2 == null) {
                    prompt2 = this.checkExist((String)e.getValue(), rowIdx, colIdx, true);
                }
                if (prompt2 == null) {
                    prompt2 = AbstractFieldsPane.this.checkAssociated((String)e.getValue(), rowIdx, colIdx);
                }
                if (prompt2 != null) {
                    this.getTitleLabel().setText(prompt2);
                    this.lastErrRow = rowIdx;
                    this.lastErrCol = colIdx;
                    return;
                }
            } else if (colIdx == 4 && (prompt = this.checkEmpty((String)e.getValue(), rowIdx, colIdx)) != null) {
                this.getTitleLabel().setText(prompt);
                this.lastErrRow = rowIdx;
                this.lastErrCol = colIdx;
                return;
            }
            if (rowIdx == this.lastErrRow && colIdx == this.lastErrCol) {
                this.getTitleLabel().setText("");
            }
            if (AbstractFieldsPane.this._associated != null) {
                AbstractFieldsPane.this._associated._tv.getTitleLabel().setText("");
            }
        }
    }
}

