/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

abstract class AbstractTableView
extends KDPanel {
    private KDWorkButton _btnAdd;
    private KDWorkButton _btnRemove;
    private KDWorkButton _btnUp;
    private KDWorkButton _btnDown;
    private KDTable _table;
    private KDLabel _labTitle;

    public AbstractTableView() {
        this.init();
        this.initListener();
    }

    private void init() {
        this.setOpaque(false);
        this._table = new KDTable();
        this._labTitle = new KDLabel();
        this._labTitle.setForeground(Color.RED);
        this._btnAdd = new KDWorkButton("\u6dfb\u52a0\u884c");
        this._btnRemove = new KDWorkButton("\u5220\u9664\u884c");
        this._btnUp = new KDWorkButton("\u4e0a\u79fb");
        this._btnDown = new KDWorkButton("\u4e0b\u79fb");
        TableLayout2 ly = new TableLayout2(2, 5);
        ly.setFixedWidth(TableLayout2.ALL, 60);
        ly.setRatableWidth(0, 1);
        ly.setColsSpacing(TableLayout2.ALL, 3);
        ly.setFixedHeight(0, 20);
        ly.setRatableHeight(1, 1);
        ly.setRowSpacing(0, 3);
        this.setLayout((LayoutManager)ly);
        this.add((Component)this._labTitle, TableLayout2.param((int)0, (int)0));
        this.add((Component)this._btnAdd, TableLayout2.param((int)0, (int)1));
        this.add((Component)this._btnRemove, TableLayout2.param((int)0, (int)2));
        this.add((Component)this._btnUp, TableLayout2.param((int)0, (int)3));
        this.add((Component)this._btnDown, TableLayout2.param((int)0, (int)4));
        this.add((Component)this._table, TableLayout2.param((int)1, (int)0, (int)1, (int)4));
    }

    private void initListener() {
        this._btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTableView.this.addEmptyRow();
            }
        });
        this._btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rowIdxs = KDTableUtil.getSelectedRows((KDTable)AbstractTableView.this._table);
                if (!AbstractTableView.this.doCanRemoveRows(rowIdxs)) {
                    return;
                }
                for (int i = rowIdxs.length - 1; i >= 0; --i) {
                    AbstractTableView.this._table.removeRow(rowIdxs[i]);
                }
                if (rowIdxs.length > 1) {
                    AbstractTableView.this._table.getSelectManager().removeAll();
                }
                AbstractTableView.this.doRemovedRows();
            }
        });
        this._btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTSelectBlock sel = AbstractTableView.this._table.getSelectManager().get();
                if (sel == null) {
                    return;
                }
                int idx = sel.getBeginRow();
                if (idx == 0) {
                    return;
                }
                int oriCol = sel.getBeginCol();
                IRow selRow = AbstractTableView.this._table.removeRow(idx);
                AbstractTableView.this._table.addRow(idx - 1, selRow);
                AbstractTableView.this._table.getSelectManager().select(idx - 1, oriCol);
                AbstractTableView.this.doUpOrDowned();
            }
        });
        this._btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTSelectBlock sel = AbstractTableView.this._table.getSelectManager().get();
                if (sel == null) {
                    return;
                }
                int idx = sel.getBeginRow();
                if (idx == AbstractTableView.this._table.getRowCount() - 1) {
                    return;
                }
                int oriCol = sel.getBeginCol();
                IRow selRow = AbstractTableView.this._table.removeRow(idx);
                AbstractTableView.this._table.addRow(idx + 1, selRow);
                AbstractTableView.this._table.getSelectManager().select(idx + 1, oriCol);
                AbstractTableView.this.doUpOrDowned();
            }
        });
        this._table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                AbstractTableView.this.doEditStopped(e);
            }

            public void editValueChanged(KDTEditEvent e) {
                AbstractTableView.this.doValueChanged(e);
            }
        });
    }

    public KDTable getTable() {
        return this._table;
    }

    protected KDLabel getTitleLabel() {
        return this._labTitle;
    }

    protected IRow addEmptyRow() {
        IRow row;
        if (this._table.getSelectManager().get() == null) {
            row = this._table.addRow();
        } else {
            int rowIdx = this._table.getSelectManager().get().getEndRow() + 1;
            int colIdx = this._table.getSelectManager().get().getBeginCol();
            row = this._table.addRow(rowIdx);
            this._table.getSelectManager().select(rowIdx, colIdx);
        }
        this.doAddedRow(row);
        return row;
    }

    protected abstract void doAddedRow(IRow var1);

    protected abstract boolean doCanRemoveRows(int[] var1);

    protected abstract void doRemovedRows();

    protected abstract void doUpOrDowned();

    protected abstract void doEditStopped(KDTEditEvent var1);

    protected abstract void doValueChanged(KDTEditEvent var1);

    public void acceptEditValue() {
        this.getTable().getEditManager().stopEditing();
    }

    protected String checkEmpty(String value, int rowIdx, int colIdx) {
        if (value == null || value.trim().length() == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("\u7b2c");
            sb.append(rowIdx + 1);
            sb.append("\u884c");
            sb.append("\uff0c");
            sb.append(this.getTable().getHeadRow(0).getCell(colIdx).getValue());
            sb.append("\u4e0d\u80fd\u4e3a\u7a7a");
            sb.append("\u3002");
            return sb.toString();
        }
        return null;
    }

    protected String checkExist(String value, int rowIdx, int colIdx, boolean isFullCompare) {
        int c = this.getTable().getRowCount();
        for (int i = 0; i < c; ++i) {
            if (i == rowIdx) {
                if (!isFullCompare) break;
                continue;
            }
            if (!StringUtil.equalsIgnoreCase((String)value, (String)((String)this.getTable().getRow(i).getCell(colIdx).getValue()))) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("\u7b2c");
            sb.append(rowIdx + 1);
            sb.append("\u884c");
            sb.append("\u4e0e");
            sb.append("\u7b2c");
            sb.append(i + 1);
            sb.append("\u884c");
            sb.append("\uff0c");
            sb.append(this.getTable().getHeadRow(0).getCell(colIdx).getValue());
            sb.append("\u91cd\u590d");
            sb.append("\u3002");
            return sb.toString();
        }
        return null;
    }
}

