/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.AbstractPane;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class EntityDef
extends AbstractPane {
    private KDTextField _txtPhyName;
    private KDTextField _txtLogName;
    private KDLabel _labPhyNamePrompt;
    private KDLabel _labLogNamePrompt;
    private boolean _toFireHandler = true;

    public EntityDef() {
        this.init();
        this.initListener();
    }

    @Override
    public String getTitle() {
        return "\u5b9a\u4e49";
    }

    private void init() {
        this.setCustomInsets(new Insets(16, 8, 0, 8));
        this._txtPhyName = new KDTextField();
        this._txtLogName = new KDTextField();
        KDLabelContainer lbcPhyName = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtPhyName, (String)"\u7269\u7406\u540d\u79f0", (int)80);
        KDLabelContainer lbcLogName = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtLogName, (String)"\u6982\u5ff5\u540d\u79f0", (int)80);
        this._labLogNamePrompt = new KDLabel();
        this._labPhyNamePrompt = new KDLabel();
        this._labLogNamePrompt.setForeground(Color.RED);
        this._labPhyNamePrompt.setForeground(Color.RED);
        TableLayout2 ly = new TableLayout2(3, 2);
        ly.setFixedHeight(0, 20);
        ly.setFixedHeight(1, 20);
        ly.setRatableHeight(2, 100);
        ly.setRowsSpacing(TableLayout2.ALL, 6);
        ly.setRatableWidth(0, 1);
        ly.setFixedWidth(1, 120);
        this.setLayout((LayoutManager)ly);
        this.add((Component)lbcLogName, TableLayout2.param((int)0, (int)0));
        this.add((Component)lbcPhyName, TableLayout2.param((int)1, (int)0));
        this.add((Component)this._labLogNamePrompt, TableLayout2.param((int)0, (int)1));
        this.add((Component)this._labPhyNamePrompt, TableLayout2.param((int)1, (int)1));
    }

    private void initListener() {
        this._txtLogName.getDocument().addDocumentListener(new LNameChangeHandler());
        this._txtPhyName.getDocument().addDocumentListener(new PNameChangeHandler());
    }

    @Override
    protected void innerModel2Ui(AbstractSemanticEntity model) {
        this._toFireHandler = false;
        this._txtPhyName.setText(model.getPhysicalName());
        this._txtLogName.setText(model.getLogicalName());
        this._toFireHandler = true;
        boolean isEnabled = !this.isReadOnlyControl(model.isStandard());
        this._txtPhyName.setEnabled(isEnabled);
        this._txtLogName.setEnabled(isEnabled);
    }

    @Override
    protected void innerUi2Model(AbstractSemanticEntity model) {
    }

    @Override
    public boolean check() {
        String prompt = this.checkLogName();
        if (prompt != null) {
            this.showCheckResult(prompt);
            return false;
        }
        prompt = this.checkPhyName();
        if (prompt != null) {
            this.showCheckResult(prompt);
            return false;
        }
        return true;
    }

    private String checkLogName() {
        String logName = this._txtLogName.getText().trim();
        if (StringUtil.isEmptyString((String)logName)) {
            return "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (this.getEntityShower().checkLogicalNameExist(logName)) {
            return "\u540d\u79f0\u5df2\u5b58\u5728";
        }
        return null;
    }

    private String checkPhyName() {
        String phyName = this._txtPhyName.getText().trim();
        if (StringUtil.isEmptyString((String)phyName)) {
            return "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (this.getEntityShower().checkPhysicalNameExist(phyName)) {
            return "\u540d\u79f0\u5df2\u5b58\u5728";
        }
        return null;
    }

    private class PNameChangeHandler
    implements DocumentListener {
        private PNameChangeHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tryAccept();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tryAccept();
        }

        private void tryAccept() {
            if (!EntityDef.this._toFireHandler) {
                return;
            }
            EntityDef.this.dirtyModel();
            String prompt = EntityDef.this.checkPhyName();
            if (prompt != null) {
                EntityDef.this._labPhyNamePrompt.setText(prompt);
                return;
            }
            EntityDef.this._labPhyNamePrompt.setText("");
            String phyName = EntityDef.this._txtPhyName.getText().trim();
            EntityDef.this.getModel().setPhysicalName(phyName);
            EntityDef.this.getEntityShower().updateTitle();
            EntityDef.this.getEntityShower().repaint();
        }
    }

    private class LNameChangeHandler
    implements DocumentListener {
        private LNameChangeHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.tryAccept();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.tryAccept();
        }

        private void tryAccept() {
            if (!EntityDef.this._toFireHandler) {
                return;
            }
            EntityDef.this.dirtyModel();
            String prompt = EntityDef.this.checkLogName();
            if (prompt != null) {
                EntityDef.this._labLogNamePrompt.setText(prompt);
                return;
            }
            EntityDef.this._labLogNamePrompt.setText("");
            String logName = EntityDef.this._txtLogName.getText().trim();
            EntityDef.this.getModel().setLogicalName(logName);
            EntityDef.this.getEntityShower().updateTitle();
        }
    }
}

