/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.FieldsListCellRenderer;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.AbstractPane;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.RelationDef;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class RelationConditionNormal
extends AbstractPane {
    private KDWorkButton _btnLink;
    private KDLabel _labClientTitle;
    private KDLabel _labSupplierTitle;
    private KDList _lstClientFields;
    private KDList _lstSupplierFields;
    private KDScrollPane _scpClientFields;
    private KDScrollPane _scpSupplierFields;
    private List _linkModels = new ArrayList();
    private LinkModel _currentLine;
    private SemanticRelation _relation;
    private boolean _isThisDirty;
    private ILinkListener _linkListener;

    public RelationConditionNormal(SemanticRelation relation) {
        this._relation = relation;
        this.init();
    }

    private void init() {
        this.setCustomInsets(new Insets(0, 0, 2, 0));
        this._btnLink = new KDWorkButton();
        this._btnLink.addActionListener((ActionListener)new LinkButtonHandler());
        this.changeLinkButtonText(0);
        this._labClientTitle = new KDLabel();
        this._labSupplierTitle = new KDLabel();
        this._lstClientFields = new KDList();
        this._lstSupplierFields = new KDList();
        this._lstClientFields.setSelectionMode(0);
        this._lstSupplierFields.setSelectionMode(0);
        FieldsListCellRenderer render = new FieldsListCellRenderer();
        this._lstClientFields.setCellRenderer((ListCellRenderer)((Object)render));
        this._lstSupplierFields.setCellRenderer((ListCellRenderer)((Object)render));
        ListSelectionHandler listHandler = new ListSelectionHandler();
        this._lstClientFields.addListSelectionListener((ListSelectionListener)listHandler);
        this._lstSupplierFields.addListSelectionListener((ListSelectionListener)listHandler);
        this._scpClientFields = new KDScrollPane((Component)this._lstClientFields);
        this._scpSupplierFields = new KDScrollPane((Component)this._lstSupplierFields);
        this._scpClientFields.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RelationConditionNormal.this.repaint();
            }
        });
        this._scpSupplierFields.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RelationConditionNormal.this.repaint();
            }
        });
        TableLayout2 ly = new TableLayout2(2, 5);
        ly.setFixedHeight(0, 20);
        ly.setRatableHeight(1, 1);
        ly.setRatableWidth(new int[]{0, 4}, 50);
        ly.setFixedWidth(new int[]{1, 3}, 10);
        ly.setFixedWidth(2, 100);
        this.setLayout((LayoutManager)ly);
        this.add((Component)this._labClientTitle, TableLayout2.param((int)0, (int)0));
        this.add((Component)this._btnLink, TableLayout2.param((int)0, (int)2));
        this.add((Component)this._labSupplierTitle, TableLayout2.param((int)0, (int)4));
        this.add((Component)this._scpClientFields, TableLayout2.param((int)1, (int)0));
        this.add((Component)this._scpSupplierFields, TableLayout2.param((int)1, (int)4));
    }

    private SemanticRelation getRelation() {
        return this._relation;
    }

    @Override
    protected void innerModel2Ui(AbstractSemanticEntity model) {
        SemanticRelation relation = this.getRelation();
        AbstractSemanticEntity client = relation.getClient();
        AbstractSemanticEntity supplier = relation.getSupplier();
        this.updateClientFields(client);
        this.updateSupplierFields(supplier);
        int c = relation.getConditionCount();
        for (int i = 0; i < c; ++i) {
            SemanticRelation.ICondition condition = relation.getCondition(i);
            if (!(condition instanceof SemanticRelation.JoinLine)) continue;
            SemanticField cf = client.getField(((SemanticRelation.JoinLine)condition).getClientField());
            SemanticField sf = supplier.getField(((SemanticRelation.JoinLine)condition).getSupplierField());
            if (cf == null && sf == null) continue;
            this._linkModels.add(new LinkModel(cf, sf));
        }
        this._isThisDirty = false;
    }

    private void updateClientFields(AbstractSemanticEntity client) {
        this._labClientTitle.setText("\u5f53\u524d\u5bf9\u8c61\uff1a" + client.getLogicalName());
        this._lstClientFields.removeAllElements();
        int c = client.getFieldCount();
        for (int i = 0; i < c; ++i) {
            this._lstClientFields.addElement((Object)client.getField(i));
        }
    }

    private void updateSupplierFields(AbstractSemanticEntity supplier) {
        this._labSupplierTitle.setText("\u4f9d\u8d56\u5bf9\u8c61\uff1a" + supplier.getLogicalName());
        this._lstSupplierFields.removeAllElements();
        int c = supplier.getFieldCount();
        for (int i = 0; i < c; ++i) {
            this._lstSupplierFields.addElement((Object)supplier.getField(i));
        }
    }

    private void updateLinkModels(AbstractSemanticEntity client, AbstractSemanticEntity supplier) {
        for (int i = this._linkModels.size() - 1; i >= 0; --i) {
            LinkModel lm = (LinkModel)this._linkModels.get(i);
            SemanticField newCf = null;
            if (lm.getCF() != null) {
                newCf = client.getField(lm.getCF().getPhysicalName());
            }
            SemanticField newSf = null;
            if (lm.getSF() != null) {
                newSf = supplier.getField(lm.getSF().getPhysicalName());
            }
            if (newCf == null && newSf == null) {
                this._linkModels.remove(i);
            }
            lm.updateField(newCf, newSf);
        }
    }

    @Override
    protected void innerUi2Model(AbstractSemanticEntity model) {
        if (!this._isThisDirty) {
            return;
        }
        SemanticRelation relation = this.getRelation();
        relation.removeAllCondition();
        int c = this._linkModels.size();
        for (int i = 0; i < c; ++i) {
            LinkModel lm = (LinkModel)this._linkModels.get(i);
            SemanticRelation.JoinLine joinLine = new SemanticRelation.JoinLine(lm.getCF().getPhysicalName(), lm.getSF().getPhysicalName());
            relation.addCondition(joinLine);
        }
    }

    @Override
    public void interactionUpdate() {
        this.updateClientFields(this.getRelation().getClient());
        this.updateLinkModels(this.getRelation().getClient(), this.getRelation().getSupplier());
    }

    @Override
    public boolean check() {
        if (this._linkModels.size() == 0) {
            this.showCheckResult("\u672a\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\u3002");
            return false;
        }
        return true;
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    protected String getCheckResultPromptTitle() {
        return RelationDef.getCheckResultPromptTitle(this.getRelation());
    }

    public void paint(Graphics g) {
        super.paint(g);
        int c = this._linkModels.size();
        for (int i = 0; i < c; ++i) {
            LinkModel lm = (LinkModel)this._linkModels.get(i);
            int x1 = this._scpClientFields.getX() + this._scpClientFields.getWidth();
            int y1 = this.calculateFieldY(this._scpClientFields, this._lstClientFields, lm.getCF());
            int x2 = this._scpSupplierFields.getX();
            int y2 = this.calculateFieldY(this._scpSupplierFields, this._lstSupplierFields, lm.getSF());
            boolean isLeftFound = true;
            boolean isRightFound = true;
            if (y1 == Integer.MIN_VALUE) {
                y1 = y2;
                x1 = (x1 + x2) / 2 + 10;
                isLeftFound = false;
            } else if (y2 == Integer.MIN_VALUE) {
                y2 = y1;
                x2 = (x1 + x2) / 2 - 10;
                isRightFound = false;
            }
            Color oriColor = g.getColor();
            if (!isLeftFound || !isRightFound) {
                g.setColor(Color.RED);
                g.drawString("?", isLeftFound ? x2 : x1 - 8, y1 + 4);
            }
            int x1a = x1 + 4;
            int x2a = x2 - 4;
            g.drawLine(x1a, y1, x2a, y2);
            if (isLeftFound) {
                g.drawPolygon(new int[]{x1, x1a, x1a}, new int[]{y1, y1 - 4, y1 + 4}, 3);
            }
            if (isRightFound) {
                g.drawPolygon(new int[]{x2, x2a, x2a}, new int[]{y2, y2 - 4, y2 + 4}, 3);
            }
            g.setColor(oriColor);
        }
    }

    private int calculateFieldY(KDScrollPane scp, KDList list, SemanticField field) {
        int idx = list.getIndexOfElement((Object)field);
        if (idx < 0) {
            return Integer.MIN_VALUE;
        }
        Point pt = list.indexToLocation(idx);
        int top = scp.getY();
        int y = pt.y - scp.getViewport().getViewPosition().y;
        if (y < 0) {
            return top;
        }
        int viewHeight = scp.getViewport().getViewRect().height;
        if (y > viewHeight) {
            return viewHeight + top + 2;
        }
        return y + top + 10;
    }

    private void changeLinkButtonText(int state) {
        boolean isReadOnly;
        StringBuffer sb = new StringBuffer();
        sb.append("\u2190 ");
        switch (state) {
            case 1: {
                this._btnLink.setEnabled(true);
                sb.append("\u5173\u8054");
                this._btnLink.setUserObject((Object)Boolean.TRUE);
                break;
            }
            case 2: {
                this._btnLink.setEnabled(true);
                sb.append("\u65ad\u5f00");
                this._btnLink.setUserObject((Object)Boolean.FALSE);
                break;
            }
            default: {
                this._btnLink.setEnabled(false);
                sb.append("\u5173\u8054/\u65ad\u5f00");
            }
        }
        sb.append(" \u2192");
        this._btnLink.setText(sb.toString());
        if (this._btnLink.isEnabled() && (isReadOnly = this.isReadOnlyControl(this.getRelation().isStandard()))) {
            this._btnLink.setEnabled(false);
        }
    }

    private void checkLinkButtonState() {
        SemanticField cf = (SemanticField)this._lstClientFields.getSelectedValue();
        SemanticField sf = (SemanticField)this._lstSupplierFields.getSelectedValue();
        for (LinkModel lm : this._linkModels) {
            boolean bingo2;
            boolean bingo1 = lm.getCF() == cf;
            boolean bl = bingo2 = lm.getSF() == sf;
            if (!bingo1 && !bingo2) continue;
            if (lm.getCF() == null) {
                bingo1 = true;
            }
            if (lm.getSF() == null) {
                bingo2 = true;
            }
            if (bingo1 && bingo2) {
                this._currentLine = lm;
                this.changeLinkButtonText(2);
                return;
            }
            this.changeLinkButtonText(0);
            return;
        }
        if (cf == null || sf == null) {
            this.changeLinkButtonText(0);
        } else if (StringUtil.isEmptyString((String)cf.getPhysicalName()) || StringUtil.isEmptyString((String)sf.getPhysicalName())) {
            this.changeLinkButtonText(0);
        } else {
            this.changeLinkButtonText(1);
        }
    }

    public void setLinkListener(ILinkListener l) {
        this._linkListener = l;
    }

    static interface ILinkListener {
        public void linked(LinkModel var1);
    }

    private class LinkButtonHandler
    implements ActionListener {
        private LinkButtonHandler() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (Boolean.TRUE == RelationConditionNormal.this._btnLink.getUserObject()) {
                SemanticField cf = (SemanticField)RelationConditionNormal.this._lstClientFields.getSelectedValue();
                SemanticField sf = (SemanticField)RelationConditionNormal.this._lstSupplierFields.getSelectedValue();
                if (!cf.getDataType().typeEquals(sf.getDataType())) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("\u5b57\u6bb5\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u5efa\u7acb\u5173\u8054\u5173\u7cfb\u3002");
                    sb.append(StringUtil.RETURN);
                    sb.append(cf.getLogicalName());
                    sb.append(": ");
                    sb.append(cf.getDataType());
                    sb.append(StringUtil.RETURN);
                    sb.append(sf.getLogicalName());
                    sb.append(": ");
                    sb.append(sf.getDataType());
                    MessageUtil.msgboxWarning((Component)((Object)RelationConditionNormal.this), (String)sb.toString());
                    return;
                }
                LinkModel lm = new LinkModel(cf, sf);
                RelationConditionNormal.this._linkModels.add(lm);
                RelationConditionNormal.this._linkListener.linked(lm);
            } else {
                RelationConditionNormal.this._linkModels.remove(RelationConditionNormal.this._currentLine);
            }
            RelationConditionNormal.this.checkLinkButtonState();
            RelationConditionNormal.this.repaint();
            RelationConditionNormal.this.getEntityShower().setModelDirty(true);
            RelationConditionNormal.this._isThisDirty = true;
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener {
        private ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            RelationConditionNormal.this.checkLinkButtonState();
        }
    }

    static class LinkModel {
        private SemanticField _clientField;
        private SemanticField _supplierField;

        public LinkModel(SemanticField cf, SemanticField sf) {
            this.updateField(cf, sf);
        }

        public void updateField(SemanticField cf, SemanticField sf) {
            this._clientField = cf;
            this._supplierField = sf;
        }

        public SemanticField getCF() {
            return this._clientField;
        }

        public SemanticField getSF() {
            return this._supplierField;
        }
    }
}

