/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.EntityShower;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.AbstractPane;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.RelationConditionCustom;
import com.kingdee.bos.ctrl.semantic.design.client.entitydetail.property.RelationConditionNormal;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class RelationDef
extends AbstractPane {
    private KDTextField _txtDescription;
    private ButtonGroup _groupJoins;
    private KDRadioButton _radNormal;
    private KDRadioButton _radCustom;
    private KDPanel _panSubOwner;
    private SemanticRelation _relation;
    private boolean _toFireHandler = true;

    public RelationDef(SemanticRelation relation) {
        this._relation = relation;
        this.setCustomInsets(new Insets(10, 0, 0, 0));
        this.init();
        this.initListener();
    }

    private void init() {
        this._txtDescription = new KDTextField();
        KDLabelContainer lbcDesc = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtDescription, (String)"\u7b80\u8981\u63cf\u8ff0\uff08\u5916\u952e\u89d2\u8272\uff09", (int)160);
        KDRadioButton radInnerJoin = new KDRadioButton("\u5185\u8054\u63a5", true);
        KDRadioButton radLeftJoin = new KDRadioButton("\u5de6\u8054\u63a5");
        KDRadioButton radRightJoin = new KDRadioButton("\u53f3\u8054\u63a5");
        KDRadioButton radFullJoin = new KDRadioButton("\u5168\u8054\u63a5");
        radInnerJoin.setUserObject((Object)SemanticRelation.JoinType.INNER);
        radLeftJoin.setUserObject((Object)SemanticRelation.JoinType.LEFT);
        radRightJoin.setUserObject((Object)SemanticRelation.JoinType.RIGHT);
        radFullJoin.setUserObject((Object)SemanticRelation.JoinType.FULL);
        this._groupJoins = new ButtonGroup();
        this._groupJoins.add((AbstractButton)radInnerJoin);
        this._groupJoins.add((AbstractButton)radLeftJoin);
        this._groupJoins.add((AbstractButton)radRightJoin);
        this._groupJoins.add((AbstractButton)radFullJoin);
        this._panSubOwner = new KDPanel((LayoutManager)new BorderLayout());
        this._panSubOwner.setOpaque(false);
        this._radNormal = new KDRadioButton("\u901a\u7528", true);
        this._radCustom = new KDRadioButton("\u81ea\u5b9a\u4e49");
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this._radNormal);
        bg.add((AbstractButton)this._radCustom);
        RelationConditionNormal rcn = new RelationConditionNormal(this.getRelation());
        rcn.setLinkListener(new LinkHandler());
        this._radNormal.setUserObject((Object)rcn);
        this._radCustom.setUserObject((Object)new RelationConditionCustom(this.getRelation()));
        ConditionRaddioHandler handler = new ConditionRaddioHandler();
        this._radNormal.addActionListener((ActionListener)handler);
        this._radCustom.addActionListener((ActionListener)handler);
        TableLayout2 ly = new TableLayout2(4, 6);
        ly.setFixedHeight(new int[]{0, 1, 2}, 20);
        ly.setRatableHeight(3, 1);
        ly.setRowSpacing(0, 6);
        ly.setRowSpacing(1, 6);
        ly.setFixedWidth(new int[]{0, 1, 2, 3, 4}, 80);
        ly.setRatableWidth(5, 1);
        this.setLayout((LayoutManager)ly);
        this.add((Component)lbcDesc, TableLayout2.param((int)0, (int)0, (int)0, (int)4));
        this.add((Component)new KDLabel("\u8054\u63a5\u7c7b\u578b\uff1a"), TableLayout2.param((int)1, (int)0));
        this.add((Component)radInnerJoin, TableLayout2.param((int)1, (int)1));
        this.add((Component)radLeftJoin, TableLayout2.param((int)1, (int)2));
        this.add((Component)radRightJoin, TableLayout2.param((int)1, (int)3));
        this.add((Component)radFullJoin, TableLayout2.param((int)1, (int)4));
        this.add((Component)new KDLabel("\u5173\u8054\u6761\u4ef6\uff1a"), TableLayout2.param((int)2, (int)0));
        this.add((Component)this._radNormal, TableLayout2.param((int)2, (int)1));
        this.add((Component)this._radCustom, TableLayout2.param((int)2, (int)2));
        this.add((Component)this._panSubOwner, TableLayout2.param((int)3, (int)0, (int)3, (int)5));
    }

    private void initListener() {
        this._txtDescription.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.accept();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.accept();
            }

            private void accept() {
                if (!RelationDef.this._toFireHandler) {
                    return;
                }
                RelationDef.this.dirtyModel();
                RelationDef.this.getRelation().setDescription(RelationDef.this.getDescription());
                RelationDef.this.getEntityShower().repaint();
            }
        });
        Enumeration<AbstractButton> enums = this._groupJoins.getElements();
        while (enums.hasMoreElements()) {
            KDRadioButton rad = (KDRadioButton)enums.nextElement();
            rad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RelationDef.this.dirtyModel();
                }
            });
        }
    }

    @Override
    public String getTitle() {
        return "\u5173\u7cfb";
    }

    @Override
    protected String getCheckResultPromptTitle() {
        return RelationDef.getCheckResultPromptTitle(this.getRelation());
    }

    static String getCheckResultPromptTitle(SemanticRelation relation) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u5173\u7cfb");
        sb.append("\uff08");
        sb.append("\u4f9d\u8d56\u5bf9\u8c61\uff1a");
        AbstractSemanticEntity supplier = relation.getSupplier();
        if (supplier.getLogicalName() == null) {
            sb.append(supplier.getProperty("id"));
        } else {
            sb.append(supplier.getLogicalName());
        }
        sb.append("\uff09");
        return sb.toString();
    }

    private SemanticRelation getRelation() {
        return this._relation;
    }

    private SemanticRelation.JoinType getSelectedJoinType() {
        Enumeration<AbstractButton> enums = this._groupJoins.getElements();
        while (enums.hasMoreElements()) {
            KDRadioButton rad = (KDRadioButton)enums.nextElement();
            if (!rad.isSelected()) continue;
            return (SemanticRelation.JoinType)rad.getUserObject();
        }
        return SemanticRelation.JoinType.INNER;
    }

    @Override
    public void model2Ui(EntityShower entityShower) {
        this._toFireHandler = false;
        super.model2Ui(entityShower);
        SemanticRelation relation = this.getRelation();
        boolean isEnabled = !this.isReadOnlyControl(relation.isStandard());
        this._txtDescription.setText(relation.getDescription());
        this._txtDescription.setEnabled(isEnabled);
        SemanticRelation.JoinType type = relation.getJoinType();
        Enumeration<AbstractButton> enums = this._groupJoins.getElements();
        while (enums.hasMoreElements()) {
            KDRadioButton rad = (KDRadioButton)enums.nextElement();
            if (type == rad.getUserObject()) {
                rad.setSelected(true);
            }
            rad.setEnabled(isEnabled);
        }
        ((AbstractPane)this._radCustom.getUserObject()).model2Ui(entityShower);
        ((AbstractPane)this._radNormal.getUserObject()).model2Ui(entityShower);
        this._radCustom.setEnabled(isEnabled);
        this._radNormal.setEnabled(isEnabled);
        if (relation.getConditionCount() > 0 && relation.isCustomExpr()) {
            this._radCustom.setSelected(true);
            this.changeSubPane(this._radCustom);
        } else {
            this._radNormal.setSelected(true);
            this.changeSubPane(this._radNormal);
        }
        this._toFireHandler = true;
    }

    @Override
    public void ui2Model(EntityShower entityShower) {
        super.ui2Model(entityShower);
        if (!this._txtDescription.isEnabled()) {
            return;
        }
        SemanticRelation relation = this.getRelation();
        relation.setDescription(this.getDescription());
        relation.setJoinType(this.getSelectedJoinType());
        if (this._radCustom.isSelected()) {
            ((AbstractPane)this._radCustom.getUserObject()).ui2Model(entityShower);
        } else {
            ((AbstractPane)this._radNormal.getUserObject()).ui2Model(entityShower);
        }
    }

    @Override
    protected void innerModel2Ui(AbstractSemanticEntity model) {
    }

    @Override
    protected void innerUi2Model(AbstractSemanticEntity model) {
    }

    @Override
    public boolean check() {
        if (StringUtil.isEmptyString((String)this.getDescription())) {
            this.showCheckResult("\u5916\u952e\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        if (this._radCustom.isSelected()) {
            return ((AbstractPane)this._radCustom.getUserObject()).check();
        }
        return ((AbstractPane)this._radNormal.getUserObject()).check();
    }

    @Override
    public void interactionUpdate() {
        ((AbstractPane)this._radNormal.getUserObject()).interactionUpdate();
    }

    private void changeSubPane(KDRadioButton rad) {
        AbstractPane pan = (AbstractPane)rad.getUserObject();
        this._panSubOwner.removeAll();
        this._panSubOwner.add((Component)((Object)pan), (Object)"Center");
        this._panSubOwner.validate();
        this._panSubOwner.repaint();
    }

    private String getDescription() {
        return this._txtDescription.getText().trim();
    }

    private class LinkHandler
    implements RelationConditionNormal.ILinkListener {
        private LinkHandler() {
        }

        @Override
        public void linked(RelationConditionNormal.LinkModel mo) {
            if (StringUtil.isEmptyString((String)RelationDef.this.getDescription())) {
                RelationDef.this._txtDescription.setText(mo.getCF().getLogicalName());
            }
        }
    }

    private class ConditionRaddioHandler
    implements ActionListener {
        private ConditionRaddioHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RelationDef.this.changeSubPane((KDRadioButton)e.getSource());
        }
    }
}

