/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.server;

import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.semantic.design.ISemanticDesignFacade;
import com.kingdee.bos.ctrl.semantic.design.exception.MultiException;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.DesigntimeManager;
import com.kingdee.bos.ctrl.semantic.design.server.SchemaDesigntimeState;
import com.kingdee.bos.ctrl.semantic.design.server.checkin.frombos.BosEntityCheckin;
import com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb.DbCheckin;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticTable;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticView;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContentIO;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.checkin.BosCheckinModel;
import com.kingdee.bos.orm.template.ORMObject;
import java.awt.Rectangle;
import java.util.Map;

public class SemanticDesignFacade
extends ORMObject
implements ISemanticDesignFacade {
    public SemanticDesignFacade() {
        this.registerInterface(ISemanticDesignFacade.class, this);
    }

    @Override
    public void lifeDetector() {
    }

    private SchemaDesigntimeState getState(String schemaId) throws SemanticDesignException {
        return DesigntimeManager.getInst().getState(schemaId);
    }

    @Override
    public LazyInfo[] refreshTree(String schemaId, String path) throws SemanticDesignException {
        return this.getState(schemaId).getSubTree(path);
    }

    @Override
    public void unlockEntity(String schemaId, String entityId, String user) throws SemanticDesignException {
        this.getState(schemaId).unlockEntity(entityId, user);
    }

    @Override
    public InfoWrapper loadEntity(String schemaId, LazyInfo info, boolean isWithSuppliers) throws SemanticDesignException {
        return this.getState(schemaId).loadEntity(info, isWithSuppliers, true);
    }

    @Override
    public LazyInfo[] saveEntity(String schemaId, LazyInfo info, HeavyContent heavyContent, boolean isUpdateStamp) throws SemanticDesignException {
        return this.getState(schemaId).saveEntity(info, heavyContent, isUpdateStamp);
    }

    @Override
    public void moveEntities(String schemaId, LazyInfo[] infos, String[] newPaths, boolean isUpdateStamp) throws SemanticDesignException {
        this.getState(schemaId).moveEntities(infos, newPaths, isUpdateStamp);
    }

    @Override
    public LazyInfo[] deleteEntities(String schemaId, LazyInfo[] infos) throws SemanticDesignException {
        return this.getState(schemaId).deleteEntities(infos);
    }

    @Override
    public boolean clearCache(String schemaId) throws SemanticDesignException {
        return this.getState(schemaId).clearCache();
    }

    @Override
    public LazyInfo[] dbCheckinRefresh(String schemaId, int type, String filter) throws SemanticDesignException {
        SchemaDesigntimeState state = this.getState(schemaId);
        Map pNameMap = state.getPNameMap();
        DataCenterInfo outDcInfo = state.getOutDcInfo();
        return DbCheckin.create(outDcInfo).lookForTables(type, filter, pNameMap);
    }

    @Override
    public void dbCheckin(String schemaId, LazyInfo[] infos) throws SemanticDesignException {
        SchemaDesigntimeState state = this.getState(schemaId);
        DataCenterInfo outDcInfo = state.getOutDcInfo();
        DbCheckin dbc = DbCheckin.create(outDcInfo);
        MultiException exs = null;
        for (int i = 0; i < infos.length; ++i) {
            try {
                AbstractSemanticEntity model;
                LazyInfo info = infos[i];
                if (info.getType() == 2) {
                    model = new SemanticView();
                    ((SemanticView)model).setDbView(true);
                    ((SemanticView)model).setSQL(dbc.lookForSqlWhenView(info.getPhysicalName()));
                } else {
                    model = new SemanticTable();
                }
                model.setLogicalName(info.getLogicalName());
                model.setPhysicalName(info.getPhysicalName());
                model.setProperty("rect", new Rectangle(10, 10, 120, 180));
                SemanticField[] fields = dbc.lookForFields(info);
                for (int j = 0; j < fields.length; ++j) {
                    model.addField(fields[j]);
                }
                HeavyContent heavyContent = new HeavyContent();
                HeavyContentIO.save(model, heavyContent);
                state.saveEntity(info, heavyContent);
                state.unlockEntity(info.getId(), null);
                continue;
            }
            catch (SemanticDesignException ex) {
                if (exs == null) {
                    exs = new MultiException();
                }
                exs.addEx(infos[i].getPhysicalName(), ex);
            }
        }
        if (exs != null) {
            throw exs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BosCheckinModel.Response[] bosMetaCheckin(String schemaId, BosCheckinModel.Request[] requests, BosCheckinModel.Preference preference) throws SemanticDesignException {
        SchemaDesigntimeState state = this.getState(schemaId);
        String tempUser = "CheckinFromBos_" + ServerUtil.getUserName();
        state.registerEdit(tempUser);
        Map pNameMap = state.getPNameMap();
        BosEntityCheckin bosEntityCheckin = new BosEntityCheckin(state, pNameMap, preference);
        try {
            BosCheckinModel.Response[] responseArray = bosEntityCheckin.checkin(requests);
            return responseArray;
        }
        finally {
            state.unregisterEdit(tempUser);
        }
    }
}

