/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb;

import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb.FromDb2;
import com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb.FromMsSql;
import com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb.FromOracle;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticDataType;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DbCheckin {
    private static final Logger log = LogUtil.getPackageLogger(DbCheckin.class);
    private DataCenterInfo _outDcInfo;

    public static DbCheckin create(DataCenterInfo outDcInfo) throws SemanticDesignException {
        Connection conn = null;
        try {
            conn = DbCheckin.getConn(outDcInfo);
            if (DbUtil.isDB2(conn)) {
                FromDb2 fromDb2 = new FromDb2(outDcInfo);
                return fromDb2;
            }
            if (DbUtil.isOracle(conn)) {
                FromOracle fromOracle = new FromOracle(outDcInfo);
                return fromOracle;
            }
            if (DbUtil.isMSSQL(conn)) {
                FromMsSql fromMsSql = new FromMsSql(outDcInfo);
                return fromMsSql;
            }
            try {
                throw new SemanticDesignException("Unknown db type.");
            }
            catch (SQLException ex) {
                throw SemanticDesignException.wrap(ex);
            }
        }
        finally {
            DbUtil.closeConnection(conn);
        }
    }

    protected static Connection getConn(DataCenterInfo outDcInfo) throws SQLException {
        if (outDcInfo == null) {
            return DbUtil.getConnection();
        }
        return DbUtil.getOutDbConn(outDcInfo);
    }

    protected Connection getConn() throws SQLException {
        return DbCheckin.getConn(this._outDcInfo);
    }

    protected DbCheckin(DataCenterInfo outDcInfo) {
        this._outDcInfo = outDcInfo;
    }

    public LazyInfo[] lookForTables(int type, String filter, Map pNameMap) throws SemanticDesignException {
        if (!StringUtil.isEmptyString((String)filter)) {
            if ((filter = filter.toUpperCase(Locale.ENGLISH)).indexOf(95) != -1) {
                filter = filter.replaceAll("_", "/_");
            }
            if (filter.indexOf(63) != -1) {
                filter = filter.replaceAll("\\?", "_");
            }
            if (filter.indexOf(42) != -1) {
                filter = filter.replaceAll("\\*", "%");
            }
            if (!filter.endsWith("%")) {
                filter = filter + "%";
            }
        }
        boolean isT = (type & 1) == 1;
        boolean isV = (type & 2) == 2;
        try {
            IRowSet rowSet = this.doLookForTables(isT, isV, filter);
            return this.wrapModel(rowSet, pNameMap);
        }
        catch (SQLException ex) {
            throw SemanticDesignException.wrap(ex);
        }
    }

    private LazyInfo[] wrapModel(IRowSet rowSet, Map pNameMap) throws SQLException {
        ArrayList<LazyInfo> result = new ArrayList<LazyInfo>();
        int idx = 0;
        while (rowSet.next()) {
            LazyInfo info = new LazyInfo();
            info.setType(this.getTableType(rowSet));
            String pName = this.getTableName(rowSet);
            info.setPhysicalName(pName);
            LazyInfo exist = (LazyInfo)pNameMap.get(pName.toUpperCase());
            if (exist == null) {
                result.add(idx++, info);
                continue;
            }
            info.setLogicalName(exist.getLogicalName());
            result.add(info);
        }
        return result.toArray(new LazyInfo[0]);
    }

    protected abstract IRowSet doLookForTables(boolean var1, boolean var2, String var3) throws SQLException;

    protected abstract int getTableType(IRowSet var1) throws SQLException;

    protected abstract String getTableName(IRowSet var1) throws SQLException;

    public SemanticField[] lookForFields(LazyInfo info) throws SemanticDesignException {
        List pkFields = null;
        try {
            pkFields = this.doSearchPk(info.getPhysicalName());
        }
        catch (SQLException ex) {
            log.error((Object)"", (Throwable)ex);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 * from ");
        sql.append(info.getPhysicalName());
        ArrayList<SemanticField> fields = new ArrayList<SemanticField>();
        boolean isStandard = info.isStandard();
        HashMap<String, SemanticDataType> pkFieldsType = new HashMap<String, SemanticDataType>();
        try {
            int i;
            IRowSet rowSet = DbUtil.executeQuery(this.getConn(), sql.toString(), null);
            ResultSetMetaData md = rowSet.getMetaData();
            int c = md.getColumnCount();
            for (i = 1; i <= c; ++i) {
                String fieldName = md.getColumnName(i);
                SemanticDataType dataType = DbCheckin.parseType(md.getColumnType(i));
                if (pkFields != null && pkFields.contains(fieldName)) {
                    pkFieldsType.put(fieldName, dataType);
                    continue;
                }
                fields.add(DbCheckin.createField(fieldName, dataType, isStandard));
            }
            if (pkFields != null) {
                for (i = pkFields.size() - 1; i >= 0; --i) {
                    String fieldName = (String)pkFields.get(i);
                    SemanticDataType dataType = (SemanticDataType)pkFieldsType.get(fieldName);
                    SemanticField field = DbCheckin.createField(fieldName, dataType, isStandard);
                    field.setPK(true);
                    fields.add(0, field);
                }
            }
        }
        catch (SQLException ex) {
            log.error((Object)"", (Throwable)ex);
            throw SemanticDesignException.wrap(ex);
        }
        return fields.toArray(new SemanticField[0]);
    }

    protected abstract List doSearchPk(String var1) throws SQLException;

    private static SemanticField createField(String name, SemanticDataType type, boolean isStandard) {
        SemanticField f = new SemanticField();
        f.setStandard(isStandard);
        f.setPhysicalName(name);
        f.setLogicalName(name);
        f.setDataType(type);
        return f;
    }

    public static SemanticDataType parseType(int sqlType) {
        switch (sqlType) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 16: {
                return SemanticDataType.INT;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return SemanticDataType.DECIMAL;
            }
            case 1: {
                return SemanticDataType.CHAR;
            }
            case -1: 
            case 12: {
                return SemanticDataType.VARCHAR;
            }
            case -2: {
                return SemanticDataType.BINARY;
            }
            case -4: 
            case -3: {
                return SemanticDataType.VARBINARY;
            }
            case 2004: {
                return SemanticDataType.BLOB;
            }
            case 2005: {
                return SemanticDataType.CLOB;
            }
            case 91: {
                return SemanticDataType.DATE;
            }
            case 92: {
                return SemanticDataType.TIME;
            }
            case 93: {
                return SemanticDataType.DATETIME;
            }
        }
        return SemanticDataType.Unsure;
    }

    public String lookForSqlWhenView(String viewName) {
        return null;
    }
}

