/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb;

import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.ctrl.semantic.design.server.checkin.fromdb.DbCheckin;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class FromDb2
extends DbCheckin {
    FromDb2(DataCenterInfo outDcInfo) {
        super(outDcInfo);
    }

    @Override
    protected IRowSet doLookForTables(boolean isT, boolean isV, String filter) throws SQLException {
        Object[] objectArray;
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/");
        sql.append("select NAME, TYPE");
        sql.append(" from SYSIBM.SYSTABLES");
        sql.append(" where");
        boolean hasFilter = false;
        if (!StringUtil.isEmptyString((String)filter)) {
            hasFilter = true;
            sql.append(" (NAME like ?");
            sql.append(" escape '/')");
            sql.append(" and");
        }
        sql.append(" CREATOR='DB2ADMIN' and");
        if (isT && isV) {
            sql.append(" (TYPE='T' or TYPE='V')");
        } else if (isT) {
            sql.append(" TYPE='T'");
        } else if (isV) {
            sql.append(" TYPE='V'");
        }
        sql.append(" order by NAME");
        Connection connection = this.getConn();
        String string = sql.toString();
        if (hasFilter) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = filter;
        } else {
            objectArray = null;
        }
        return DbUtil.executeQuery(connection, string, objectArray);
    }

    @Override
    protected int getTableType(IRowSet rowSet) throws SQLException {
        String str = rowSet.getString("TYPE");
        if ("T".equals(str)) {
            return 1;
        }
        if ("V".equals(str)) {
            return 2;
        }
        throw new RuntimeException("Impossible");
    }

    @Override
    protected String getTableName(IRowSet rowSet) throws SQLException {
        return rowSet.getString("NAME");
    }

    @Override
    protected List doSearchPk(String tableName) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/");
        sql.append("select COLNAME");
        sql.append(" from SYSIBM.SYSKEYCOLUSE");
        sql.append(" where TBNAME=?");
        sql.append(" order by COLSEQ asc");
        ArrayList<String> result = null;
        IRowSet rowSet = DbUtil.executeQuery(this.getConn(), sql.toString(), new Object[]{tableName});
        while (rowSet.next()) {
            if (result == null) {
                result = new ArrayList<String>();
            }
            result.add(rowSet.getString("COLNAME"));
        }
        return result;
    }
}

