/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.client;

import com.kingdee.bos.ctrl.common.util.CustomFileFilter;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.extcommon.client.Progress;
import com.kingdee.bos.ctrl.extcommon.client.ProgressUI;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.semantic.manage.ISemanticManageFacade;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ExportModel;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

class Exporter {
    private static final Logger log = LogUtil.getPackageLogger(Exporter.class);
    private static final String KEY_DIR = "com.kingdee.bos.ctrl.semantic.schema.ExportDir";
    static final String POSTFIX = ".semantic";
    private Component _owner;
    private ISemanticManageFacade _facade;
    private SchemaBriefModel _schemaModel;
    private OutputStreamWriter _fileWriter;

    public Exporter(Component owner, ISemanticManageFacade facade, SchemaBriefModel schemaModel) {
        this._owner = owner;
        this._facade = facade;
        this._schemaModel = schemaModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() {
        String lastPath = System.getProperty(KEY_DIR);
        KDFileChooser fc = new KDFileChooser(lastPath);
        fc.setSelectedFile(new File(this._schemaModel.getName() + POSTFIX));
        fc.setFileFilter((FileFilter)new CustomFileFilter(POSTFIX, "*.semantic"));
        if (fc.showSaveDialog(this._owner) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.getName().endsWith(POSTFIX)) {
            file = new File(file.getAbsolutePath() + POSTFIX);
        }
        if (file.exists()) {
            if (!MessageUtil.msgboxOkCancel((Component)this._owner, (String)(file.getName() + StringUtil.RETURN + "\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f"))) {
                return;
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                log.error((Object)"Semantic schema export.", (Throwable)ex);
                MessageUtil.msgboxWarning((Component)this._owner, (String)"\u6587\u4ef6\u4e0d\u53ef\u5199\u3002", (Exception)ex);
                return;
            }
        }
        System.setProperty(KEY_DIR, file.getParent());
        if (!file.canWrite()) {
            log.error((Object)("Semantic schema export. File can not write: " + file.getPath()));
            MessageUtil.msgboxWarning((Component)this._owner, (String)"\u6587\u4ef6\u4e0d\u53ef\u5199\u3002");
            return;
        }
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(file);
            zos = new ZipOutputStream(fos);
            zos.putNextEntry(new ZipEntry("data"));
            this._fileWriter = new OutputStreamWriter((OutputStream)zos, "UTF-8");
        }
        catch (IOException ex) {
            try {
                log.error((Object)"Semantic schema export.", (Throwable)ex);
                MessageUtil.msgboxWarning((Component)this._owner, (String)"", (Exception)ex);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{zos, fos});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{zos, fos});
            return;
        }
        CloseUtil.close((Closeable[])new Closeable[]{zos, fos});
        try {
            ProgressUI ui = ProgressUI.create(this._owner);
            ui.setText("\u6b63\u5728\u5bfc\u51fa\uff0c\u8bf7\u7a0d\u5019...");
            MyProgress progress = new MyProgress(ui);
            progress.startAndShowUi("SemanticSchemaExport");
            if (!progress.isOk()) {
                progress.dealException();
                Exception ex = progress.getException();
                log.error((Object)"", (Throwable)ex);
                MessageUtil.msgboxWarning((Component)this._owner, (String)"\u5bfc\u51fa\u5931\u8d25\u3002", (Exception)ex);
            }
        }
        finally {
            try {
                this._fileWriter.close();
            }
            catch (IOException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
    }

    private class MyProgress
    extends Progress {
        public MyProgress(ProgressUI bindUI) {
            super(bindUI);
        }

        @Override
        protected void work() throws Exception {
            this.start();
            String schemaId = Exporter.this._schemaModel.getId();
            boolean hasNext = true;
            int idx = 0;
            while (hasNext) {
                ExportModel em = Exporter.this._facade.export(schemaId, "", idx);
                idx = em.getSegmentIdx();
                int progressValue = 100 * idx / em.getSegmentCount();
                this.getUI().setProgressValue(progressValue);
                hasNext = em.hasNext();
                ++idx;
                this.writeSegment(em);
            }
            this.getUI().setProgressValue(100);
            this.end();
        }

        private void start() throws IOException {
            String outDb;
            Exporter.this._fileWriter.write("<Root");
            Exporter.this._fileWriter.write(32);
            Exporter.this._fileWriter.write("version");
            Exporter.this._fileWriter.write("=\"");
            Exporter.this._fileWriter.write("00.00.00");
            Exporter.this._fileWriter.write(34);
            if (!StringUtil.isEmptyString((String)"")) {
                Exporter.this._fileWriter.write(32);
                Exporter.this._fileWriter.write("ptInfo");
                Exporter.this._fileWriter.write("=\"");
                Exporter.this._fileWriter.write("");
                Exporter.this._fileWriter.write(34);
            }
            if (!StringUtil.isEmptyString((String)(outDb = Exporter.this._schemaModel.getOutsideDb()))) {
                Exporter.this._fileWriter.write(" outDb=");
                Exporter.this._fileWriter.write(34);
                Exporter.this._fileWriter.write(outDb);
                Exporter.this._fileWriter.write(34);
            }
            Exporter.this._fileWriter.write(">");
            Exporter.this._fileWriter.write(StringUtil.RETURN);
            Exporter.this._fileWriter.flush();
        }

        private void end() throws IOException {
            Exporter.this._fileWriter.write("</Root>");
            Exporter.this._fileWriter.flush();
        }

        private void writeSegment(ExportModel em) throws IOException {
            LazyInfo[] infos = em.getLazyInfos();
            HeavyContent[] hcs = em.getHeavyContents();
            for (int i = 0; i < infos.length; ++i) {
                LazyInfo info = infos[i];
                HeavyContent hc = hcs[i];
                StringBuffer sb = new StringBuffer();
                sb.append("<EWrap");
                sb.append(" id=");
                sb.append('\"').append(info.getId()).append('\"');
                sb.append(" pN=");
                sb.append('\"').append(info.getPhysicalName()).append('\"');
                sb.append(" lN=");
                sb.append('\"').append(info.getLogicalName()).append('\"');
                sb.append(" pa=");
                sb.append('\"').append(info.getPath()).append('\"');
                sb.append(" tp=");
                sb.append('\"').append(info.getType()).append('\"');
                String stamp = info.getStandardStamp();
                if (!StringUtil.isEmptyString((String)stamp)) {
                    sb.append(" st=");
                    sb.append('\"').append(stamp).append('\"');
                }
                sb.append(">");
                sb.append(StringUtil.RETURN);
                sb.append("<![CDATA[");
                sb.append(this.encodeCDATA(hc.getXml()));
                sb.append("]]>");
                sb.append(StringUtil.RETURN);
                for (int j = 0; j < hc.getRelationContentCount(); ++j) {
                    HeavyContent.RelationContent rc = hc.getRelationContent(j);
                    sb.append("<RWrap s=");
                    sb.append('\"').append(rc.getSupplierId()).append('\"');
                    sb.append(">");
                    sb.append("<![CDATA[");
                    sb.append(this.encodeCDATA(rc.getXml()));
                    sb.append("]]>");
                    sb.append("</RWrap>");
                    sb.append(StringUtil.RETURN);
                }
                sb.append("</EWrap>");
                sb.append(StringUtil.RETURN);
                Exporter.this._fileWriter.write(sb.toString());
                Exporter.this._fileWriter.flush();
            }
        }

        private String encodeCDATA(String xml) {
            if (xml.indexOf("]]>") >= 0) {
                return xml.replaceAll("]]>", "]]]]><![CDATA[>");
            }
            return xml;
        }
    }
}

