/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.client;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.CustomFileFilter;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.extcommon.client.Progress;
import com.kingdee.bos.ctrl.extcommon.client.ProgressUI;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.semantic.manage.ISemanticManageFacade;
import com.kingdee.bos.ctrl.semantic.manage.client.PropertyDialog;
import com.kingdee.bos.ctrl.semantic.manage.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.manage.exception.NameExistException;
import com.kingdee.bos.ctrl.semantic.manage.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.manage.exception.SemanticManageException;
import com.kingdee.bos.ctrl.semantic.manage.exception.UnknownVersionException;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.IImportModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportDecisionItem;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportDecisionModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportPreference;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportResultItem;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportResultModel;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

class Importer {
    private static final Logger log = LogUtil.getPackageLogger(Importer.class);
    private static final String KEY_DIR = "com.kingdee.bos.ctrl.semantic.schema.ImportDir";
    private Component _owner;
    private ISemanticManageFacade _facade;
    private ImportPreference _preference;
    private PropertyDialog.IChecker _nameExistChecker;
    private boolean _isStdMaker;

    public Importer(Component owner, ISemanticManageFacade facade, PropertyDialog.IChecker nameExistChecker, boolean isStdMaker) {
        this._owner = owner;
        this._facade = facade;
        this._nameExistChecker = nameExistChecker;
        this._isStdMaker = isStdMaker;
    }

    public boolean imports() {
        String lastPath = System.getProperty(KEY_DIR);
        KDFileChooser fc = new KDFileChooser(lastPath);
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(0);
        FileFilter[] ff = fc.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            fc.removeChoosableFileFilter(ff[i]);
        }
        fc.setFileFilter((FileFilter)new CustomFileFilter(".semantic", "*.semantic"));
        if (fc.showOpenDialog(this._owner) != 0) {
            return false;
        }
        File file = fc.getSelectedFile();
        System.setProperty(KEY_DIR, file.getParent());
        if (!file.exists()) {
            MessageUtil.msgboxWarning((Component)this._owner, (String)("\u6587\u4ef6" + file.getName() + "\u4e0d\u5b58\u5728\u3002"));
            return false;
        }
        String fileName = file.getName();
        if (!fileName.endsWith(".semantic")) {
            MessageUtil.msgboxWarning((Component)this._owner, (String)"\u4e0d\u53ef\u8bc6\u522b\u7684\u6587\u4ef6\u7c7b\u578b\uff08\u8bed\u4e49\u5c42\u65b9\u6848\u5bfc\u51fa\u6587\u4ef6\u4e3a*.semantic\uff09\u3002");
            return false;
        }
        if (this.checkExist(fileName = fileName.substring(0, fileName.length() - ".semantic".length())) && this.uploadFile(file, fileName)) {
            return this.importAndDecision(fileName);
        }
        return false;
    }

    private boolean checkExist(String fileName) {
        if (this._nameExistChecker.isNameExist(fileName)) {
            PreferenceUI ui = new PreferenceUI(fileName);
            SimpleDialog dlg = SimpleDialog.create((Component)this._owner);
            dlg.setComponent((Component)((Object)ui));
            dlg.setSize(400, 200);
            dlg.setTitle("\u5bfc\u5165\u65b9\u6848");
            if (dlg.showDialog()) {
                this._preference = ui.getPreference();
                this._preference.setStdMaker(this._isStdMaker);
                return true;
            }
            return false;
        }
        this._preference = new ImportPreference();
        this._preference.setPolicy(0);
        this._preference.setStdMaker(this._isStdMaker);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFile(File file, String fileName) {
        FileInputStream fileInputer;
        try {
            fileInputer = new FileInputStream(file);
        }
        catch (IOException ex) {
            log.error((Object)"Semantic schema import.", (Throwable)ex);
            MessageUtil.msgboxWarning((Component)this._owner, (String)"\u5bfc\u5165\u65b9\u6848", (Exception)ex);
            return false;
        }
        try {
            ProgressUI ui = ProgressUI.create(this._owner);
            ui.setText("\u6b63\u5728\u4e0a\u4f20\u6587\u4ef6...");
            UploadProgress progress = new UploadProgress(ui, fileInputer, fileName);
            progress.startAndShowUi("SemanticSchemaImport_Upload");
            if (!progress.isOk()) {
                String prompt;
                Exception ex = progress.getException();
                log.error((Object)"", (Throwable)ex);
                if (ex instanceof LockedException) {
                    prompt = "\u6b63\u88ab\u7f16\u8f91\uff0c\u6216\u5176\u4ed6\u4eba\u6b63\u8fdb\u884c\u5bfc\u5165\u64cd\u4f5c\uff0c\u60a8\u6682\u65f6\u4e0d\u80fd\u5bfc\u5165\u3002";
                    this.showSpecialException(prompt, fileName);
                } else if (ex instanceof NameExistException) {
                    prompt = "\u5df2\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c\u3002";
                    this.showSpecialException(prompt, fileName);
                } else if (ex instanceof NotExistException) {
                    prompt = "\u53ef\u80fd\u5df2\u88ab\u5176\u4ed6\u4eba\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c\u3002";
                    this.showSpecialException(prompt, fileName);
                } else {
                    progress.dealException();
                    MessageUtil.msgboxWarning((Component)this._owner, (String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", (Exception)ex);
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            try {
                fileInputer.close();
            }
            catch (IOException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
        return true;
    }

    private void showSpecialException(String prompt, String fileName) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u65b9\u6848");
        sb.append("\u3010");
        sb.append(fileName);
        sb.append("\u3011");
        sb.append(prompt);
        MessageUtil.msgboxWarning((Component)this._owner, (String)sb.toString());
    }

    private boolean importAndDecision(String fileName) {
        ProgressUI ui = ProgressUI.create(this._owner);
        ui.setIndeterminate(true);
        ui.setText("\u6b63\u5728\u5c1d\u8bd5\u5bfc\u5165\uff0c\u53ef\u80fd\u9700\u8981\u4e00\u4e9b\u65f6\u95f4\uff0c\u8bf7\u7a0d\u5019...");
        DecisionProgress progress = new DecisionProgress(ui, fileName);
        progress.setDelayAtTheEnd(false);
        progress.startAndShowUi("SemanticSchemaImport_Decision");
        if (!progress.isOk()) {
            progress.dealException();
            Exception ex = progress.getException();
            log.error((Object)"", (Throwable)ex);
            if (ex.getCause() instanceof UnknownVersionException) {
                MessageUtil.msgboxWarning((Component)this._owner, (String)this.parseUnknownVersionPrompt((UnknownVersionException)ex.getCause()));
            } else if (ex.getCause() instanceof SAXException) {
                MessageUtil.msgboxWarning((Component)this._owner, (String)"\u5bfc\u5165\u5931\u8d25\u3002\u4e0d\u53ef\u8bc6\u522b\u7684\u6587\u4ef6\u5185\u5bb9\u3002", (Exception)ex);
            } else {
                MessageUtil.msgboxWarning((Component)this._owner, (String)"\u5bfc\u5165\u5931\u8d25\u3002\u4e0d\u53ef\u8bc6\u522b\u7684\u6587\u4ef6\u5185\u5bb9\u3002", (Exception)ex);
            }
            return false;
        }
        return true;
    }

    private String parseUnknownVersionPrompt(UnknownVersionException ex) {
        String prompt = "\u4e0d\u53ef\u8bc6\u522b\u7684\u9ad8\u7248\u672c\u5185\u5bb9\u3002";
        StringBuffer sb = new StringBuffer(prompt);
        String info = ex.getPtInfo();
        if (info != null) {
            try {
                sb.append("\u81f3\u5c11\u9700\u8981\u66f4\u65b0\u5230\u4ee5\u4e0b\u73af\u5883\u624d\u53ef\u4ee5\u5bfc\u5165\u3002");
                String[] seg = info.split("\\$V:");
                for (int i = 1; i < seg.length; ++i) {
                    sb.append(StringUtil.RETURN);
                    sb.append(i == 1 ? "\u3000\u3000" : "\u6216\u3000");
                    sb.append("\u7248\u672c\uff1a");
                    int idx = seg[i].indexOf(59);
                    if (idx > 0) {
                        sb.append(seg[i].substring(0, idx).trim());
                        sb.append("\uff0c\u8865\u4e01\uff1a");
                        sb.append(seg[i].substring(idx + 1).trim());
                        continue;
                    }
                    sb.append(seg[i].trim());
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                return prompt;
            }
        }
        return sb.toString();
    }

    private static String getProblemText(int confilictCode) {
        switch (confilictCode) {
            case 1: {
                return "\u5c06\u8981\u5220\u9664\u7684\u6807\u51c6\u4ea7\u54c1\u8868\u4e2d\u88ab\u6dfb\u52a0\u4e86\u81ea\u5b9a\u4e49\u5185\u5bb9\uff08\u5b57\u6bb5\u3001\u5173\u7cfb\uff09\u3002";
            }
            case 2: {
                return "\u5bfc\u5165\u6587\u4ef6\u4e2d\u4e0d\u5305\u542b\u8be5\u8868\u3002";
            }
            case 6: {
                return "\u6982\u5ff5\u540d\u79f0\u88ab\u5360\u7528\u3002";
            }
            case 3: {
                return "\u6807\u51c6\u4ea7\u54c1\u8868\u7684\u7269\u7406\u540d\u79f0\u88ab\u81ea\u5b9a\u4e49\u8868\u5360\u7528\u3002";
            }
            case 4: {
                return "\u81ea\u5b9a\u4e49\u8868\u7684\u7269\u7406\u540d\u79f0\u88ab\u6807\u51c6\u4ea7\u54c1\u8868\u5360\u7528\u3002";
            }
            case 5: {
                return "\u81ea\u5b9a\u4e49\u8868\u7684\u7269\u7406\u540d\u79f0\u5df2\u5b58\u5728\u3002";
            }
        }
        return "";
    }

    private static class Choice {
        public static Choice Cancel = new Choice(0, "\u53d6\u6d88");
        public static Choice Keep = new Choice(1, "\u4fdd\u7559");
        public static Choice Delete = new Choice(3, "\u5220\u9664");
        public static Choice Overwrite = new Choice(2, "\u8986\u76d6");
        public static Choice ReLName = new Choice(4, "\u91cd\u547d\u540d\u6982\u5ff5\u540d\u79f0");
        private int _decisionCode;
        private String _text;

        private Choice(int code, String text) {
            this._decisionCode = code;
            this._text = text;
        }

        public String toString() {
            return this._text;
        }

        public int getCode() {
            return this._decisionCode;
        }
    }

    private static class DecisionDialog
    extends TypicalDialog {
        private static final int COL_LNAME = 0;
        private static final int COL_PNAME = 1;
        private static final int COL_PROBLEM = 2;
        private static final int COL_DECISION = 3;
        private KDTable _table;

        public DecisionDialog(KDDialog owner) {
            super((Dialog)owner);
        }

        protected void todoInit() {
            this._table = new KDTable();
            this._table.addColumns(4);
            this._table.getColumn(0).setWidth(180);
            this._table.getColumn(1).setWidth(180);
            this._table.getColumn(2).setWidth(360);
            this._table.getColumn(3).setWidth(120);
            IRow head = this._table.addHeadRow();
            head.getCell(0).setValue((Object)"\u6982\u5ff5\u540d\u79f0");
            head.getCell(1).setValue((Object)"\u7269\u7406\u540d\u79f0");
            head.getCell(2).setValue((Object)"\u95ee\u9898");
            head.getCell(3).setValue((Object)"\u4eba\u5de5\u51b3\u7b56");
            this._table.getColumn(0).getStyleAttributes().setLocked(true);
            this._table.getColumn(1).getStyleAttributes().setLocked(true);
            this._table.getColumn(2).getStyleAttributes().setLocked(true);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            parent.add((Component)this._table, thisCell);
        }

        protected void onCancel() {
            if (MessageUtil.msgboxOkCancel((Component)((Object)this), (String)"\u60a8\u786e\u5b9a\u53d6\u6d88\u6b64\u6b21\u5bfc\u5165\u64cd\u4f5c\u5417\uff1f")) {
                super.onCancel();
            }
        }

        public void setData(ImportDecisionModel model) {
            int c = model.getItemCount();
            for (int i = 0; i < c; ++i) {
                ImportDecisionItem item = model.getItem(i);
                LazyInfo info = DecisionDialog.getInfo(item);
                Object[] choices = DecisionDialog.getChoices(item.getConfilict());
                IRow row = this._table.addRow();
                row.setUserObject((Object)item);
                row.getCell(0).setValue((Object)info.getLogicalName());
                row.getCell(1).setValue((Object)info.getPhysicalName());
                row.getCell(2).setValue((Object)Importer.getProblemText(item.getConfilict()));
                row.getCell(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox(choices)));
                row.getCell(3).setValue(choices[0]);
                if (choices.length == 1) {
                    if (choices[0] == Choice.Cancel) {
                        row.getStyleAttributes().setFontColor(Color.RED);
                    } else {
                        row.getStyleAttributes().setFontColor(Color.BLUE);
                    }
                }
                if (item.getConfilict() != 6) continue;
                row.getCell(0).getStyleAttributes().setLocked(false);
                row.getCell(0).getStyleAttributes().setBackground(Color.YELLOW);
            }
        }

        public void acceptEdited() {
            int c = this._table.getRowCount();
            for (int i = 0; i < c; ++i) {
                IRow row = this._table.getRow(i);
                Choice choice = (Choice)row.getCell(3).getValue();
                ImportDecisionItem item = (ImportDecisionItem)row.getUserObject();
                item.setDecision(choice.getCode());
                if (choice.getCode() != 4) continue;
                String newLName = (String)row.getCell(0).getValue();
                item.getSrcInfo().setLogicalName(newLName);
            }
        }

        private static LazyInfo getInfo(ImportDecisionItem item) {
            int confilict = item.getConfilict();
            if (confilict == 1 || confilict == 2) {
                return item.getDestInfo();
            }
            return item.getSrcInfo();
        }

        private static Choice[] getChoices(int conflictCode) {
            switch (conflictCode) {
                case 1: {
                    return new Choice[]{Choice.Delete, Choice.Keep};
                }
                case 2: {
                    return new Choice[]{Choice.Keep, Choice.Delete};
                }
                case 6: {
                    return new Choice[]{Choice.ReLName};
                }
                case 3: {
                    return new Choice[]{Choice.Overwrite};
                }
                case 4: {
                    return new Choice[]{Choice.Cancel};
                }
                case 5: {
                    return new Choice[]{Choice.Overwrite, Choice.Keep};
                }
            }
            throw new RuntimeException("Unknown confilict code.");
        }
    }

    private static class ResultUI
    extends KDPanel {
        private static final int COL_LNAME = 0;
        private static final int COL_PNAME = 1;
        private static final int COL_PROBLEM = 2;
        private static final int COL_RESULT = 3;
        private KDTable _table;

        public ResultUI() {
            this.init();
        }

        private void init() {
            this._table = new KDTable();
            this._table.getStyleAttributes().setLocked(true);
            this._table.addColumns(4);
            this._table.getColumn(0).setWidth(180);
            this._table.getColumn(1).setWidth(180);
            this._table.getColumn(2).setWidth(360);
            this._table.getColumn(3).setWidth(200);
            IRow head = this._table.addHeadRow();
            head.getCell(0).setValue((Object)"\u6982\u5ff5\u540d\u79f0");
            head.getCell(1).setValue((Object)"\u7269\u7406\u540d\u79f0");
            head.getCell(2).setValue((Object)"\u95ee\u9898");
            head.getCell(3).setValue((Object)"\u5bfc\u5165\u7ed3\u679c");
            this.setLayout(new BorderLayout());
            this.add((Component)this._table, "Center");
        }

        public void setData(ImportResultModel result) {
            int c = result.getItemCount();
            for (int i = 0; i < c; ++i) {
                ImportResultItem item = result.getItem(i);
                IRow row = this._table.addRow();
                row.getCell(0).setValue((Object)item.getInfo().getLogicalName());
                row.getCell(1).setValue((Object)item.getInfo().getPhysicalName());
                row.getCell(2).setValue((Object)Importer.getProblemText(item.getConfilict()));
                row.getCell(3).setValue((Object)ResultUI.getResultText(item.getResult()));
                Color color = ResultUI.getResultColor(item.getResult());
                if (color == null) continue;
                row.getStyleAttributes().setFontColor(color);
            }
        }

        private static String getResultText(int code) {
            switch (code) {
                case 16385: {
                    return "\u4e0d\u53ef\u4fee\u590d\u7684\u51b2\u7a81\uff0c\u65e0\u6cd5\u5904\u7406";
                }
                case 4098: {
                    return "\u65b0\u589e";
                }
                case 4099: {
                    return "\u66f4\u65b0";
                }
                case 4100: {
                    return "\u5220\u9664";
                }
                case 8196: {
                    return "\u91cd\u547d\u540d\u6982\u5ff5\u540d\u79f0";
                }
                case 8195: {
                    return "\u4eba\u4e3a\u51b3\u5b9a\u5220\u9664";
                }
                case 8194: {
                    return "\u4eba\u4e3a\u51b3\u5b9a\u8986\u76d6";
                }
                case 8193: {
                    return "\u4eba\u4e3a\u51b3\u5b9a\u4fdd\u7559";
                }
                case 8192: {
                    return "\u4eba\u4e3a\u51b3\u5b9a\u53d6\u6d88";
                }
            }
            return "";
        }

        private static Color getResultColor(int code) {
            int level = code & 0xF000;
            if (level == 16384) {
                return Color.RED;
            }
            if (level == 8192) {
                return Color.BLUE;
            }
            return null;
        }
    }

    private class DecisionProgress
    extends Progress {
        private String fileName;

        public DecisionProgress(ProgressUI bindUI, String fileName) {
            super(bindUI);
            this.fileName = fileName;
        }

        @Override
        protected void work() throws Exception {
            try {
                ImportDecisionModel request = null;
                IImportModel response = null;
                do {
                    if (!((response = Importer.this._facade.importsDecision(this.fileName, request, false)) instanceof ImportResultModel)) continue;
                    this.showResult((ImportResultModel)response);
                    return;
                } while ((request = this.decision((ImportDecisionModel)response)) != null);
                return;
            }
            catch (NotExistException ex) {
                StringBuffer sb = new StringBuffer();
                sb.append("\u5bfc\u5165\u64cd\u4f5c\u81ea\u52a8\u4e2d\u6b62\uff0c");
                sb.append("\u53ef\u80fd\u7531\u4e8e\u60a8\u957f\u65f6\u95f4\u672a\u8fdb\u884c\u4eba\u5de5\u51b3\u7b56\u64cd\u4f5c\u3002");
                sb.append("\u60a8\u53ef\u4ee5\u5c1d\u8bd5\u91cd\u65b0\u8fdb\u884c\u3002");
                Importer.this.showSpecialException(sb.toString(), this.fileName);
            }
            catch (Exception ex) {
                Importer.this._facade.importsDecision(this.fileName, null, true);
                throw ex;
            }
        }

        private ImportDecisionModel decision(ImportDecisionModel model) throws SemanticManageException {
            DecisionDialog dlg = new DecisionDialog((KDDialog)this.getUI().getOwner());
            dlg.setTitle("\u5408\u5e76\u5f0f\u5bfc\u5165-\u51b2\u7a81\u4eba\u5de5\u51b3\u7b56");
            dlg.setWindowAlign(0);
            WindowUtil.makeDialogFullScreen((KDDialog)dlg);
            dlg.setData(model);
            if (!dlg.showDialog()) {
                Importer.this._facade.importsDecision(this.fileName, null, true);
                return null;
            }
            dlg.acceptEdited();
            return model;
        }

        private void showResult(ImportResultModel result) {
            if (!result.isNew()) {
                String title = "\u5408\u5e76\u5f0f\u5bfc\u5165\u7ed3\u679c";
                if (result.getItemCount() == 0) {
                    MessageUtil.msgboxInfo((Component)this.getUI().getOwner(), (String)"\u6ca1\u6709\u4efb\u4f55\u66f4\u65b0\u3002");
                } else {
                    ResultUI resultUi = new ResultUI();
                    resultUi.setData(result);
                    SimpleDialog dlg = SimpleDialog.create((Component)this.getUI().getOwner());
                    dlg.setTitle(title);
                    dlg.setComponent((Component)((Object)resultUi));
                    dlg.setWindowAlign(0);
                    dlg.hideCancelButton();
                    WindowUtil.makeDialogFullScreen((KDDialog)dlg);
                    dlg.showDialog();
                }
            }
        }
    }

    private class UploadProgress
    extends Progress {
        private static final int SegmentSize = 65536;
        private FileInputStream fileInputer;
        private String fileName;

        public UploadProgress(ProgressUI bindUI, FileInputStream fileInputer, String fileName) {
            super(bindUI);
            this.fileInputer = fileInputer;
            this.fileName = fileName;
        }

        @Override
        protected void work() throws Exception {
            int fileSize = this.fileInputer.available();
            this.getUI().setMaxValue(fileSize);
            int progressValue = 0;
            int segmentIdx = 0;
            boolean isFinish = false;
            while (!isFinish) {
                byte[] buf2;
                byte[] buf = new byte[65536];
                int size = this.fileInputer.read(buf, 0, 65536);
                if (size == -1) {
                    isFinish = true;
                    buf2 = new byte[]{};
                } else if (size == 65536) {
                    isFinish = false;
                    buf2 = buf;
                } else {
                    isFinish = true;
                    buf2 = new byte[size];
                    System.arraycopy(buf, 0, buf2, 0, size);
                }
                this.getUI().setProgressValue(progressValue += size == -1 ? 0 : size);
                Importer.this._facade.importsUpload(this.fileName, buf2, segmentIdx++, Importer.this._preference);
                if (!this.isForceCancel()) continue;
                Importer.this._facade.importsUpload(this.fileName, null, -1, null);
            }
        }
    }

    private static class PreferenceUI
    extends KDPanel {
        private KDRadioButton _radOverwrite;
        private KDRadioButton _radMerge;

        public PreferenceUI(String schemaName) {
            this.init(schemaName);
        }

        private void init(String schemaName) {
            StringBuffer sb = new StringBuffer();
            sb.append("\u65b9\u6848");
            sb.append("\u3010");
            sb.append(schemaName);
            sb.append("\u3011");
            sb.append("\u5df2\u5b58\u5728\uff0c\u91c7\u7528\u54ea\u79cd\u65b9\u5f0f\u5bfc\u5165\uff1f");
            KDLabel labPrompt = new KDLabel("\u5982\u679c\u60a8\u4e0d\u80fd\u51c6\u786e\u628a\u63e1\u64cd\u4f5c\uff0c\u5efa\u8bae\u5148\u5bfc\u51fa\u539f\u65b9\u6848\u4f5c\u4e3a\u5907\u4efd\u3002");
            this._radOverwrite = new KDRadioButton("\u8986\u76d6");
            this._radMerge = new KDRadioButton("\u5408\u5e76");
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this._radOverwrite);
            bg.add((AbstractButton)this._radMerge);
            this._radMerge.setSelected(true);
            TableLayout2 ly = new TableLayout2(5, 2);
            ly.setFixedHeight(TableLayout2.ALL, 20);
            ly.setRatableHeight(4, 100);
            ly.setRowsSpacing(TableLayout2.ALL, 3);
            ly.setFixedWidth(0, 20);
            ly.setRatableWidth(1, 100);
            this.setLayout((LayoutManager)ly);
            this.add((Component)new KDLabel(sb.toString()), TableLayout2.param((int)0, (int)0, (int)0, (int)1));
            this.add((Component)this._radOverwrite, TableLayout2.param((int)1, (int)1));
            this.add((Component)this._radMerge, TableLayout2.param((int)2, (int)1));
            this.add((Component)labPrompt, TableLayout2.param((int)4, (int)0, (int)4, (int)1));
        }

        public ImportPreference getPreference() {
            ImportPreference preference = new ImportPreference();
            if (this._radMerge.isSelected()) {
                preference.setPolicy(2);
            } else {
                preference.setPolicy(1);
            }
            return preference;
        }
    }
}

