/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.client;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.semantic.common.client.ClientUtil;
import com.kingdee.bos.ctrl.semantic.manage.ISemanticManageFacade;
import com.kingdee.bos.ctrl.semantic.manage.client.EditingContext;
import com.kingdee.bos.ctrl.semantic.manage.exception.SemanticManageException;
import com.kingdee.bos.ctrl.semantic.model.trans.kicker.KickerModel;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

class Kicker {
    private static final Logger log = LogUtil.getPackageLogger(Kicker.class);
    private UI _ui;

    Kicker() {
    }

    public void showUI(EditingContext ctx) throws SemanticManageException {
        if (this._ui != null) {
            Object parent = this._ui;
            while (!(parent instanceof KDFrame)) {
                if ((parent = ((Component)parent).getParent()) != null) continue;
                this._ui = null;
                return;
            }
            ((KDFrame)parent).requestFocus();
            return;
        }
        Password psw = new Password();
        SimpleDialog dlg = SimpleDialog.create((Component)ctx.getOwner());
        dlg.setComponent((Component)((Object)psw));
        dlg.setTitle("\u5de5\u7a0b\u83dc\u5355");
        dlg.setSize(320, 140);
        if (!dlg.showDialog()) {
            return;
        }
        this._ui = new UI(ctx.getManageFacade());
        this._ui.refresh();
        KDFrame frame = new KDFrame();
        frame.setTitle("\u6269\u5c55\u62a5\u8868\u8bed\u4e49\u5c42\u7ba1\u7406--\u5de5\u7a0b\u83dc\u5355--\u624b\u5de5\u89e3\u9501");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)this._ui), "Center");
        frame.setSize(800, 600);
        frame.setExtendedState(6);
        frame.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Kicker.this._ui = null;
            }
        });
        frame.setVisible(true);
    }

    private static class PreferenceUI
    extends KDPanel {
        private KDSpinner _spnCheckPeriod = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1.0, 0.5, 60.0, 1.0));
        private KDSpinner _spnInactiveLimit = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1.0, 0.5, 600.0, 1.0));

        public PreferenceUI() {
            KDLabelContainer lbcCheckPeriod = CtrlSwingUtilities.createLabelContainer((JComponent)this._spnCheckPeriod, (String)"\u81ea\u52a8\u89e3\u9501\u68c0\u6d4b\u5468\u671f\uff08\u5206\u949f\uff09", (int)200);
            KDLabelContainer lbcInactiveLimit = CtrlSwingUtilities.createLabelContainer((JComponent)this._spnInactiveLimit, (String)"\u65e0\u6d3b\u52a8\u53ef\u5b58\u6d3b\u65f6\u957f\uff08\u5206\u949f\uff09", (int)200);
            TableLayout2 ly = new TableLayout2(3, 1);
            ly.setFixedHeight(0, 20);
            ly.setFixedHeight(1, 20);
            ly.setRatableHeight(2, 1);
            ly.setRowsSpacing(TableLayout2.ALL, 6);
            this.setLayout((LayoutManager)ly);
            this.add((Component)lbcCheckPeriod, TableLayout2.param((int)0, (int)0));
            this.add((Component)lbcInactiveLimit, TableLayout2.param((int)1, (int)0));
        }

        public void setValues(int[] values) {
            this._spnCheckPeriod.setValue((Object)new Double((float)((int)((double)((float)values[0] / 6000.0f) + 0.5)) / 10.0f));
            this._spnInactiveLimit.setValue((Object)new Double((float)((int)((double)((float)values[1] / 6000.0f) + 0.5)) / 10.0f));
        }

        public int[] getValues() {
            double v1 = (Double)this._spnCheckPeriod.getValue();
            double v2 = (Double)this._spnInactiveLimit.getValue();
            return new int[]{(int)(v1 * 60000.0), (int)(v2 * 60000.0)};
        }
    }

    private static class UI
    extends KDPanel {
        private static final Color COLOR_SCHEMA = new Color(255, 255, 153);
        private static final int COL_SCHEMA = 0;
        private static final int COL_ENTITY = 1;
        private static final int COL_PATH = 2;
        private static final int COL_USER = 3;
        private static final int COL_INACTIVE = 4;
        private KDTable _table;
        private KDWorkButton _btnRefresh;
        private KDWorkButton _btnKick;
        private KDWorkButton _btnPreference;
        private ISemanticManageFacade _facade;

        public UI(ISemanticManageFacade facade) {
            this._facade = facade;
            this._table = new KDTable();
            this._table.getSelectManager().setSelectMode(10);
            this._table.setEditable(false);
            this._table.addColumns(5);
            this._table.getColumn(0).setWidth(160);
            this._table.getColumn(1).setWidth(160);
            this._table.getColumn(2).setWidth(400);
            this._table.getColumn(3).setWidth(120);
            this._table.getColumn(4).setWidth(100);
            this._table.getColumn(4).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            IRow head = this._table.addHeadRow();
            head.getCell(0).setValue((Object)"\u65b9\u6848\u540d\u79f0");
            head.getCell(1).setValue((Object)"\u5b9e\u4f53\u540d\u79f0");
            head.getCell(2).setValue((Object)"\u5b9e\u4f53\u8def\u5f84");
            head.getCell(3).setValue((Object)"\u7528\u6237\u5e10\u53f7");
            head.getCell(4).setValue((Object)"\u6700\u540e\u6d3b\u52a8");
            ActionHandler handler = new ActionHandler();
            this._btnRefresh = new KDWorkButton("\u5237\u65b0");
            this._btnRefresh.addActionListener((ActionListener)handler);
            this._btnKick = new KDWorkButton("\u89e3\u9501");
            this._btnKick.addActionListener((ActionListener)handler);
            boolean isInsedeNet = ClientUtil.isInsideNet();
            if (isInsedeNet) {
                this._btnPreference = new KDWorkButton("\u8bbe\u7f6e");
                this._btnPreference.addActionListener((ActionListener)handler);
            }
            TableLayout2 ly = new TableLayout2(2, 5);
            ly.setFixedHeight(0, 23);
            ly.setRowSpacing(0, 6);
            ly.setRatableHeight(1, 1);
            ly.setColsSpacing(TableLayout2.ALL, 6);
            ly.setFixedWidth(TableLayout2.ALL, 80);
            ly.setRatableWidth(4, 1);
            this.setCustomInsets(new Insets(10, 10, 10, 10));
            this.setLayout((LayoutManager)ly);
            this.add((Component)this._btnRefresh, TableLayout2.param((int)0, (int)0));
            this.add((Component)this._btnKick, TableLayout2.param((int)0, (int)1));
            if (isInsedeNet) {
                this.add((Component)this._btnPreference, TableLayout2.param((int)0, (int)2));
            }
            this.add((Component)this._table, TableLayout2.param((int)1, (int)0, (int)1, (int)4));
        }

        private void model2Ui(KickerModel[] models) {
            this._table.removeRows();
            for (int i = 0; i < models.length; ++i) {
                IRow row = this._table.addRow();
                KickerModel mo = models[i];
                row.setUserObject((Object)mo);
                row.getCell(0).setValue((Object)mo.getSchemaName());
                if (mo.isEntityLock()) {
                    row.getCell(1).setValue((Object)mo.getEntityName());
                    row.getCell(2).setValue((Object)mo.getPath());
                } else {
                    this._table.getMergeManager().mergeBlock(i, 0, i, 2);
                    row.getStyleAttributes().setBackground(COLOR_SCHEMA);
                }
                row.getCell(3).setValue((Object)mo.getUser());
                row.getCell(4).setValue((Object)((int)(mo.getInactive() / 1000L / 60L) + "\u5206\u949f\u524d"));
            }
        }

        public void refresh() {
            try {
                this.model2Ui(this._facade.kickerRefresh());
            }
            catch (SemanticManageException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }

        private void kick() {
            int[] rows = KDTableUtil.getSelectedRows((KDTable)this._table);
            if (rows.length > 0) {
                KickerModel[] models = new KickerModel[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    models[i] = (KickerModel)this._table.getRow(rows[i]).getUserObject();
                }
                try {
                    this._facade.kick(models);
                }
                catch (SemanticManageException ex) {
                    log.error((Object)"", (Throwable)ex);
                }
            }
        }

        private void perference() {
            PreferenceUI ui = new PreferenceUI();
            ui.setValues(this._facade.getAutoKickerPerference());
            SimpleDialog dlg = SimpleDialog.create((Component)((Object)this));
            dlg.setComponent((Component)((Object)ui));
            dlg.setTitle("\u8bbe\u7f6e");
            dlg.setSize(320, 160);
            if (dlg.showDialog()) {
                this._facade.setAutoKickerPerference(ui.getValues());
            }
        }

        private class ActionHandler
        implements ActionListener {
            private ActionHandler() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == UI.this._btnRefresh) {
                    UI.this.refresh();
                } else if (e.getSource() == UI.this._btnKick) {
                    UI.this.kick();
                    UI.this.refresh();
                } else if (e.getSource() == UI.this._btnPreference) {
                    UI.this.perference();
                }
            }
        }
    }

    private static class Password
    extends KDPanel
    implements SimpleDialog.PanelOfSimpleDialog {
        private KDTextField _txtInput;
        private KDLabel _labPrompt = new KDLabel();

        public Password() {
            this._labPrompt.setForeground(Color.RED);
            this._labPrompt.setHorizontalAlignment(0);
            this._txtInput = new KDTextField();
            KDLabelContainer lbcInput = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtInput, (String)"\u8bf7\u8f93\u5165\u6388\u6743\u9a8c\u8bc1\u7801", (int)120);
            TableLayout2 ly = new TableLayout2(3, 1);
            ly.setFixedHeight(0, 20);
            ly.setFixedHeight(1, 20);
            ly.setRatableHeight(2, 1);
            this.setLayout((LayoutManager)ly);
            this.add((Component)lbcInput, TableLayout2.param((int)0, (int)0));
            this.add((Component)this._labPrompt, TableLayout2.param((int)1, (int)0));
            this._txtInput.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    _labPrompt.setText("");
                }
            });
        }

        public boolean verify() {
            if ("kingdee".equals(this._txtInput.getText())) {
                return true;
            }
            this._labPrompt.setText("\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff01");
            return false;
        }
    }
}

