/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.client;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class PropertyDialog
extends TypicalDialog {
    private KDTextField _txtName;
    private KDComboBox _cmbOutsideDb;
    private KDLabel _labPrompt;
    private IChecker _checker;

    public static PropertyDialog create(Component parentCtrl) {
        Window win = SwingUtilities.getWindowAncestor(parentCtrl);
        if (win instanceof Frame) {
            return new PropertyDialog((Frame)win);
        }
        if (win instanceof Dialog) {
            return new PropertyDialog((Dialog)win);
        }
        return new PropertyDialog();
    }

    public PropertyDialog() {
    }

    public PropertyDialog(Dialog owner) {
        super(owner);
    }

    public PropertyDialog(Frame owner) {
        super(owner);
    }

    protected void todoInit() {
        this._txtName = new KDTextField();
        this._cmbOutsideDb = new KDComboBox();
        this._labPrompt = new KDLabel();
        this._labPrompt.setForeground(Color.BLUE);
        this.setSize(420, 160);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        KDLabelContainer lbcName = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtName, (String)"\u540d\u79f0", (int)80);
        KDLabelContainer lbcDs = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbOutsideDb, (String)"\u6570\u636e\u6e90", (int)80);
        Table layout = thisCell.splitRow(4);
        layout.rowStyle(0).setHeight(26);
        layout.rowStyle(0).setMarginBottom(6);
        layout.rowStyle(1).setHeight(26);
        layout.rowStyle(1).setMarginBottom(6);
        layout.rowStyle(2).setHeight(20);
        layout.rowStyle(3).setPriY(1);
        parent.add((Component)lbcName, layout.cell(0));
        parent.add((Component)lbcDs, layout.cell(1));
        parent.add((Component)this._labPrompt, layout.cell(2));
    }

    public void setChecker(IChecker checker) {
        this._checker = checker;
    }

    public void setOutsideDbList(String[] list) {
        this._cmbOutsideDb.removeAllItems();
        this._cmbOutsideDb.addItems((Object[])list);
        this._cmbOutsideDb.insertItemAt((Object)"\uff08\u5f53\u524dEAS\u6570\u636e\u4e2d\u5fc3\uff09", 0);
        this._cmbOutsideDb.setSelectedIndex(0);
    }

    public void setOutsideDbForbidance() {
        this._cmbOutsideDb.setEnabled(false);
        this._labPrompt.setText("\u8be5\u65b9\u6848\u6b63\u88ab\u7f16\u8f91\uff0c\u6570\u636e\u6e90\u7981\u6b62\u4fee\u6539\u3002");
    }

    protected boolean verify() {
        String name = this.getSchemaName();
        if (StringUtil.isEmptyString((String)name)) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return false;
        }
        if (this._checker.isNameExist(this.getSchemaName())) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002");
            return false;
        }
        return true;
    }

    public void updateEditedResult(SchemaBriefModel data) {
        data.setName(this.getSchemaName());
        boolean oldIsCurrent = data.isCurrentDs();
        boolean newIsCurrent = this._cmbOutsideDb.getSelectedIndex() == 0;
        String oldDbName = data.getOutsideDb();
        String newDbName = (String)this._cmbOutsideDb.getSelectedItem();
        if (this._cmbOutsideDb.isEnabled()) {
            if (newIsCurrent == oldIsCurrent && StringUtil.equals((String)newDbName, (String)oldDbName)) {
                data.setExtProperty("outDb_canModify", Boolean.FALSE);
            } else {
                data.setExtProperty("outDb_canModify", Boolean.TRUE);
                data.setCurrentDs(newIsCurrent);
                data.setOutsideDb(newDbName);
            }
        } else {
            data.setExtProperty("outDb_canModify", Boolean.FALSE);
        }
    }

    public void setEditData(SchemaBriefModel data) {
        this._txtName.setText(data.getName());
        if (data.isCurrentDs()) {
            this._cmbOutsideDb.setSelectedIndex(0);
        } else {
            this._cmbOutsideDb.setSelectedItem((Object)data.getOutsideDb());
        }
    }

    private String getSchemaName() {
        return this._txtName.getText();
    }

    public static interface IChecker {
        public boolean isNameExist(String var1);
    }
}

