/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.client;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.extcommon.client.Progress;
import com.kingdee.bos.ctrl.extcommon.client.ProgressUI;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.semantic.common.client.ClientUtil;
import com.kingdee.bos.ctrl.semantic.common.client.icon.SemanticIcons;
import com.kingdee.bos.ctrl.semantic.design.client.SemanticDesigner;
import com.kingdee.bos.ctrl.semantic.design.client.action.CheckinFromBos;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.manage.ISemanticManageFacade;
import com.kingdee.bos.ctrl.semantic.manage.client.EditingContext;
import com.kingdee.bos.ctrl.semantic.manage.client.Exporter;
import com.kingdee.bos.ctrl.semantic.manage.client.Importer;
import com.kingdee.bos.ctrl.semantic.manage.client.Kicker;
import com.kingdee.bos.ctrl.semantic.manage.client.PropertyDialog;
import com.kingdee.bos.ctrl.semantic.manage.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.manage.exception.NameExistException;
import com.kingdee.bos.ctrl.semantic.manage.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.manage.exception.SemanticManageException;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.bos.ctrl.semantic.model.trans.checkin.BosCheckinModel;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class SchemaManageUI
extends CoreUI {
    private static final Logger log = LogUtil.getPackageLogger(SchemaManageUI.class);
    private static final int COL_NAME = 0;
    private static final int COL_DS = 1;
    private static final int COL_UPDATOR = 2;
    private static final int COL_TIME = 3;
    private KDWorkButton _btnNew;
    private KDWorkButton _btnEdit;
    private KDWorkButton _btnDelete;
    private KDWorkButton _btnProperty;
    private KDWorkButton _btnRefresh;
    private KDWorkButton _btnImport;
    private KDWorkButton _btnExport;
    private KDWorkButton _btnStdMaker;
    private KDTable _table;
    private EditingContext _editingContext = new EditingContext();
    private Map _designers = new HashMap();

    public SchemaManageUI() throws Exception {
        this.init();
        this._editingContext.setOwner((Component)((Object)this));
    }

    private void init() throws Exception {
        this.setUITitle("\u8bed\u4e49\u5c42\u65b9\u6848\u7ba1\u7406");
        ButtonActionHandler action = new ButtonActionHandler();
        this._btnNew = new KDWorkButton();
        this._btnNew.setText("\u65b0\u5efa");
        this._btnNew.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this._btnNew.addActionListener((ActionListener)action);
        this._btnEdit = new KDWorkButton();
        this._btnEdit.setText("\u7f16\u8f91");
        this._btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this._btnEdit.addActionListener((ActionListener)action);
        this._btnDelete = new KDWorkButton();
        this._btnDelete.setText("\u5220\u9664");
        this._btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this._btnDelete.addActionListener((ActionListener)action);
        this._btnProperty = new KDWorkButton();
        this._btnProperty.setText("\u5c5e\u6027");
        this._btnProperty.setIcon(EASResource.getIcon((String)"imgTbtn_rename"));
        this._btnProperty.addActionListener((ActionListener)action);
        this._btnRefresh = new KDWorkButton();
        this._btnRefresh.setText("\u5237\u65b0");
        this._btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this._btnRefresh.addActionListener((ActionListener)action);
        this._btnImport = new KDWorkButton();
        this._btnImport.setText("\u5bfc\u5165");
        this._btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this._btnImport.addActionListener((ActionListener)action);
        this._btnExport = new KDWorkButton();
        this._btnExport.setText("\u5bfc\u51fa");
        this._btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this._btnExport.addActionListener((ActionListener)action);
        this._table = new KDTable();
        this._table.addColumns(4);
        this._table.getColumn(0).setWidth(240);
        this._table.getColumn(1).setWidth(200);
        this._table.getColumn(2).setWidth(160);
        this._table.getColumn(3).setWidth(120);
        this._table.getColumn(0).setSortable(true);
        this._table.getColumn(1).setSortable(true);
        this._table.getColumn(2).setSortable(true);
        this._table.getColumn(3).setSortable(true);
        KDTSortManager sm = new KDTSortManager(this._table);
        sm.setEnableSortable(true);
        sm.setSortAuto(true);
        sm.setClickCount(1);
        this._table.setSortMange(sm);
        IRow row = this._table.addHeadRow();
        row.getCell(0).setValue((Object)"\u65b9\u6848\u540d\u79f0");
        row.getCell(1).setValue((Object)"\u6570\u636e\u6e90");
        row.getCell(2).setValue((Object)"\u4fee\u6539\u8005");
        row.getCell(3).setValue((Object)"\u4fee\u6539\u65e5\u671f");
        this._table.setEditable(false);
        this._table.getSelectManager().setSelectMode(2);
        this._table.getColumn(3).getStyleAttributes().setNumberFormat("yyyy-MM-dd  HH:mm");
        KeyStroke ks = KeyStroke.getKeyStroke(75, 704);
        this.getInputMap(2).put(ks, "kick");
        this.getActionMap().put("kick", new AbstractAction(){
            private Kicker kicker = new Kicker();

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    this.kicker.showUI(SchemaManageUI.this._editingContext);
                }
                catch (SemanticManageException ex) {
                    log.error((Object)"", (Throwable)ex);
                }
            }
        });
    }

    public boolean destroyWindow() {
        boolean b = super.destroyWindow();
        if (b) {
            if (this._btnStdMaker != null && this._btnStdMaker.getUserObject() != null) {
                KDFrame frame = (KDFrame)this._btnStdMaker.getUserObject();
                frame.dispose();
            }
            Iterator it = this._designers.values().iterator();
            while (it.hasNext()) {
                SemanticDesigner designer = (SemanticDesigner)((Object)it.next());
                it.remove();
                designer.exit();
            }
        }
        return b;
    }

    public void addCommonMenusToTable(KDTable table) {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String params = (String)this.getUIContext().get("UIClassParam");
        if (!StringUtil.isEmptyString((String)params) && params.startsWith("isStandard=") && "true".equals(params.substring(11))) {
            this.setStandardMaker(true);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this._table, "Center");
        this.action_refresh();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (SchemaManageUI.this._editingContext.isStandardMaker() && !ClientUtil.isInsideNet()) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("\u53ea\u6709\u91d1\u8776\u7814\u53d1\u5185\u7f51\u53ef\u4ee5\u8fdb\u884c\u6807\u51c6\u4ea7\u54c1\u5236\u4f5c\u3002");
                    sb.append(StringUtil.RETURN);
                    sb.append("\u5982\u679c\u60a8\u7684\u8ba1\u7b97\u673a\u5df2\u8fde\u63a5\u5230\u7814\u53d1\u5185\u7f51\uff0c\u4f46\u4ecd\u51fa\u73b0\u6b64\u63d0\u793a\uff0c\u8bf7\u8054\u7cfb\u5546\u4e1a\u5206\u6790\u7cfb\u7edf\u90e8\u3002");
                    sb.append(StringUtil.RETURN);
                    MessageUtil.msgboxWarning((Component)((Object)SchemaManageUI.this), (String)sb.toString());
                    SchemaManageUI.this._btnNew.setEnabled(false);
                    SchemaManageUI.this._btnEdit.setEnabled(false);
                    SchemaManageUI.this._btnProperty.setEnabled(false);
                    SchemaManageUI.this._btnDelete.setEnabled(false);
                    SchemaManageUI.this._btnImport.setEnabled(false);
                    SchemaManageUI.this._btnExport.setEnabled(false);
                }
                SchemaManageUI.this.removeComponentListener(this);
                SchemaManageUI.this.tryInitDemoData();
            }
        });
        if (!this._editingContext.isStandardMaker() && ClientUtil.isInsideNet()) {
            String title = "\u6807\u51c6\u4ea7\u54c1\u7ef4\u62a4";
            this._btnStdMaker = new KDWorkButton(title);
            this._btnStdMaker.setIcon(SemanticIcons.ICN_CURRENT);
            this._btnStdMaker.setToolTipText(title);
            this._btnStdMaker.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDFrame frame = (KDFrame)SchemaManageUI.this._btnStdMaker.getUserObject();
                    if (frame == null) {
                        SchemaManageUI stdUi;
                        try {
                            stdUi = new SchemaManageUI();
                            stdUi.setStandardMaker(true);
                            stdUi.initUIToolBarLayout();
                            stdUi.onLoad();
                        }
                        catch (Exception ex) {
                            SchemaManageUI.this.handleException(ex);
                            return;
                        }
                        frame = new KDFrame();
                        frame.setSize(800, 600);
                        frame.setExtendedState(6);
                        frame.setTitle("\u8bed\u4e49\u5c42\u65b9\u6848\u6807\u51c6\u4ea7\u54c1\u7ef4\u62a4");
                        frame.addToolBar((JToolBar)stdUi.toolBar);
                        frame.addWindowListener((WindowListener)new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent evt) {
                                SchemaManageUI.this._btnStdMaker.setUserObject(null);
                            }
                        });
                        KDPanel pan = new KDPanel((LayoutManager)new BorderLayout());
                        pan.add((Component)((Object)stdUi), (Object)"Center");
                        pan.setCustomInsets(new Insets(8, 8, 8, 8));
                        frame.getContentPane().setLayout(new BorderLayout());
                        frame.getContentPane().add((Component)pan, "Center");
                        SchemaManageUI.this._btnStdMaker.setUserObject((Object)frame);
                    }
                    frame.setVisible(true);
                }
            });
            this.toolBar.add((Component)new KDSeparator(), 1);
            this.toolBar.add((Component)this._btnStdMaker, 1);
        }
    }

    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this._btnNew);
        this.toolBar.add((Component)this._btnEdit);
        this.toolBar.add((Component)this._btnProperty);
        this.toolBar.add((Component)this._btnRefresh);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnDelete);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this._btnImport);
        this.toolBar.add((Component)this._btnExport);
    }

    public void setStandardMaker(boolean isStandardMaker) {
        this._editingContext.setStandardMaker(isStandardMaker);
        if (isStandardMaker) {
            this.setUITitle("\u8bed\u4e49\u5c42\u65b9\u6848\u6807\u51c6\u4ea7\u54c1\u7ef4\u62a4");
        }
    }

    private void tryInitDemoData() {
        boolean ask = false;
        try {
            ask = this.getFacade().askInitDemoData();
        }
        catch (SemanticManageException ex) {
            log.error((Object)"", (Throwable)ex);
        }
        StringBuffer prompt = new StringBuffer();
        prompt.append("\u672a\u53d1\u73b0\u8bed\u4e49\u5c42\u65b9\u6848\uff0c\u7cfb\u7edf\u53ef\u4ee5\u81ea\u52a8\u751f\u6210\u4e00\u4e2a\u65b9\u6848\u6837\u4f8b\uff0c");
        prompt.append("\u4fe1\u606f\u6765\u6e90\u4e8e\u5f53\u524d\u7cfb\u7edf\u7684BOS\u5b9e\u4f53\u5143\u6570\u636e\u3002");
        prompt.append(StringUtil.RETURN);
        prompt.append(StringUtil.RETURN);
        prompt.append("\u662f\u5426\u81ea\u52a8\u751f\u6210\u65b9\u6848\u6837\u4f8b\uff1f");
        if (!ask || !MessageUtil.msgboxOkCancel((Component)((Object)this), (String)prompt.toString())) {
            return;
        }
        ProgressUI progressUI = ProgressUI.create((Component)((Object)this));
        progressUI.setIndeterminate(true);
        progressUI.setText("\u6b63\u5728\u521d\u59cb\u5316\u65b9\u6848\u6837\u4f8b\uff0c\u53ef\u80fd\u9700\u8981\u51e0\u5206\u949f\uff0c\u8bf7\u7a0d\u5019...");
        Progress progress = new Progress(progressUI){

            @Override
            protected void work() throws Exception {
                BosCheckinModel.Request[] requests = new CheckinFromBos(null).forInitDemoData();
                if (SchemaManageUI.this.getFacade().initDemoData(requests)) {
                    SchemaManageUI.this.action_refresh();
                }
            }
        };
        progress.startAndShowUi("SemanticInitDemoData");
        if (!progress.isOk()) {
            log.error((Object)"Semantic schema-manager init demo data error.", (Throwable)progress.getException());
        }
    }

    private ISemanticManageFacade getFacade() throws SemanticManageException {
        return this._editingContext.getManageFacade();
    }

    private void action_new() throws Exception {
        PropertyDialog dlg = this.createPropertyDialog("\u65b0\u5efa\u65b9\u6848", null, null);
        if (dlg.showDialog()) {
            SchemaBriefModel data = new SchemaBriefModel();
            dlg.updateEditedResult(data);
            try {
                data = this.getFacade().createSchema(data);
            }
            catch (NameExistException ex) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002");
                this.action_refresh();
                return;
            }
            this.refreshOneRow(this._table.addRow(), data);
            this._table.getSelectManager().select(this._table.getRowCount(), 0);
            try {
                this.showDesigner(data);
            }
            catch (Exception ex) {
                this.getFacade().unregisterEdit(data.getId());
                throw ex;
            }
        }
    }

    private void action_edit() throws Exception {
        String title = "\u7f16\u8f91\u65b9\u6848";
        IRow row = KDTableUtil.getSelectedRow((KDTable)this._table);
        if (row == null) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u8bf7\u9009\u4e2d\u76ee\u6807\u65b9\u6848\u3002");
            return;
        }
        SchemaBriefModel data = (SchemaBriefModel)row.getUserObject();
        SemanticDesigner designer = (SemanticDesigner)((Object)this._designers.get(data.getId()));
        if (designer != null) {
            designer.setVisible(true);
            return;
        }
        try {
            this.getFacade().registerEdit(data.getId());
        }
        catch (NotExistException ex) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u8be5\u65b9\u6848\u5df2\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u3002");
            this.action_refresh();
            return;
        }
        catch (LockedException ex) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u8be5\u65b9\u6848\u6b63\u5728\u8fdb\u884c\u5bfc\u5165\u64cd\u4f5c\uff0c\u6682\u65f6\u4e0d\u80fd\u7f16\u8f91\u3002");
            return;
        }
        try {
            this.showDesigner(data);
        }
        catch (Exception ex) {
            this.getFacade().unregisterEdit(data.getId());
            throw ex;
        }
    }

    private void showDesigner(final SchemaBriefModel data) throws SemanticDesignException {
        String schemaId = data.getId();
        EditingContext ec = this._editingContext.copy();
        ec.setSchemaId(schemaId);
        ec.setSchemaName(data.getName());
        SemanticDesigner designer = new SemanticDesigner();
        designer.setEditingContext(ec);
        designer.setVisible(true);
        this._designers.put(schemaId, designer);
        designer.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                SchemaManageUI.this._designers.remove(data.getId());
                if (SchemaManageUI.this._table.isShowing()) {
                    try {
                        SchemaManageUI.this.action_refresh();
                    }
                    catch (Exception ex) {
                        log.error((Object)"", (Throwable)ex);
                    }
                }
            }
        });
    }

    private void action_property() throws Exception {
        String title = "\u4fee\u6539\u65b9\u6848\u5c5e\u6027";
        IRow row = KDTableUtil.getSelectedRow((KDTable)this._table);
        if (row == null) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u8bf7\u9009\u4e2d\u76ee\u6807\u65b9\u6848\u3002");
            return;
        }
        SchemaBriefModel data = (SchemaBriefModel)row.getUserObject();
        SchemaBriefModel preAsk = new SchemaBriefModel();
        preAsk.setId(data.getId());
        try {
            preAsk = this.getFacade().preModifyProperty(preAsk);
        }
        catch (NotExistException ex) {
            MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u8be5\u65b9\u6848\u5df2\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u3002");
            this.action_refresh();
            return;
        }
        PropertyDialog dlg = this.createPropertyDialog(title, data.getId(), preAsk);
        dlg.setEditData(data);
        if (dlg.showDialog()) {
            dlg.updateEditedResult(data);
            try {
                data = this.getFacade().modifyProperty(data);
            }
            catch (NameExistException ex) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u65b9\u6848\u540d\u79f0\u5df2\u5b58\u5728\u3002");
                this.action_refresh();
                return;
            }
            catch (NotExistException ex) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u8be5\u65b9\u6848\u5df2\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u3002");
                this.action_refresh();
                return;
            }
            catch (LockedException ex) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u7f16\u8f91\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u636e\u6e90\u3002");
                this.action_refresh();
                return;
            }
            this.refreshOneRow(row, data);
        }
    }

    private void action_refresh() throws Exception {
        String oriSelectedId = null;
        IRow selected = KDTableUtil.getSelectedRow((KDTable)this._table);
        if (selected != null) {
            SchemaBriefModel model = (SchemaBriefModel)selected.getUserObject();
            oriSelectedId = model.getId();
        }
        this._table.removeRows();
        SchemaBriefModel[] schemas = this.getFacade().refresh();
        int c = schemas.length;
        for (int i = 0; i < c; ++i) {
            this.refreshOneRow(this._table.addRow(), schemas[i]);
        }
        KDTSortManager sm = this._table.getSortMange();
        sm.sort(sm.getColIndex(), sm.getSortType());
        int selectedIdx = -1;
        int c2 = this._table.getRowCount();
        for (int i = 0; i < c2; ++i) {
            SchemaBriefModel model = (SchemaBriefModel)this._table.getRow(i).getUserObject();
            if (!StringUtil.equals((String)oriSelectedId, (String)model.getId())) continue;
            selectedIdx = i;
            break;
        }
        if (selectedIdx != -1) {
            this._table.getSelectManager().select(selectedIdx, 0);
        }
    }

    private void refreshOneRow(IRow row, SchemaBriefModel data) {
        row.setUserObject((Object)data);
        row.getCell(0).setValue((Object)data.getName());
        if (data.isCurrentDs()) {
            row.getCell(1).setValue((Object)"\uff08\u5f53\u524dEAS\u6570\u636e\u4e2d\u5fc3\uff09");
        } else {
            row.getCell(1).setValue((Object)data.getOutsideDb());
        }
        row.getCell(2).setValue((Object)data.getUpdator());
        row.getCell(3).setValue((Object)data.getUpdateTime());
    }

    private void action_delete() throws Exception {
        String title = "\u5220\u9664";
        IRow row = KDTableUtil.getSelectedRow((KDTable)this._table);
        if (row == null) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u76ee\u6807\u65b9\u6848\u3002");
            return;
        }
        final SchemaBriefModel data = (SchemaBriefModel)row.getUserObject();
        if (!MessageUtil.msgboxOkCancel((Component)((Object)this), (String)("\u5220\u9664\u5c06\u4e0d\u53ef\u6062\u590d\u3002\u60a8\u786e\u5b9a\u8981\u5220\u9664\u9009\u4e2d\u7684\u65b9\u6848\u5417\uff1f" + StringUtil.RETURN + data.getName()))) {
            return;
        }
        ProgressUI progressUi = ProgressUI.create((Component)((Object)this));
        progressUi.setIndeterminate(true);
        progressUi.setText("\u6b63\u5728\u5220\u9664\u65b9\u6848\uff0c\u8bf7\u7a0d\u5019...");
        Progress progress = new Progress(progressUi){

            @Override
            protected void work() throws Exception {
                SchemaManageUI.this.getFacade().deleteSchema(data);
            }
        };
        progress.startAndShowUi("SemanticDeleteSchema");
        if (!progress.isOk()) {
            Exception ex = progress.getException();
            if (ex instanceof NotExistException) {
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u8be5\u65b9\u6848\u5df2\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u3002");
            } else {
                if (ex instanceof LockedException) {
                    MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u8be5\u65b9\u6848\u6b63\u88ab\u7f16\u8f91\uff0c\u4e0d\u80fd\u5220\u9664\u3002");
                    return;
                }
                throw ex;
            }
        }
        this.action_refresh();
    }

    private void action_import() throws Exception {
        Importer importer = new Importer((Component)((Object)this), this.getFacade(), new PropertyDialogChecker(null), this._editingContext.isStandardMaker());
        if (importer.imports()) {
            this.action_refresh();
        }
    }

    private void action_export() throws Exception {
        IRow row = KDTableUtil.getSelectedRow((KDTable)this._table);
        if (row == null) {
            MessageUtil.msgboxInfo((Component)((Object)this), (String)"\u8bf7\u9009\u4e2d\u76ee\u6807\u65b9\u6848\u3002");
            return;
        }
        SchemaBriefModel data = (SchemaBriefModel)row.getUserObject();
        SchemaBriefModel model = new SchemaBriefModel();
        model.setId(data.getId());
        model.setName(data.getName());
        if (!data.isCurrentDs()) {
            model.setOutsideDb(data.getOutsideDb());
        }
        Exporter exporter = new Exporter((Component)((Object)this), this.getFacade(), model);
        exporter.export();
    }

    private PropertyDialog createPropertyDialog(String title, String id, SchemaBriefModel preAsk) throws Exception {
        PropertyDialog dlg = PropertyDialog.create((Component)((Object)this));
        dlg.setTitle(title);
        dlg.setChecker(new PropertyDialogChecker(id));
        if (preAsk == null) {
            dlg.setOutsideDbList(this.getFacade().getOutsideDsList());
        } else {
            String[] outsideDbList = (String[])preAsk.getExtProperty("outDbList");
            dlg.setOutsideDbList(outsideDbList);
            Boolean canModifyOutsideDb = (Boolean)preAsk.getExtProperty("outDb_canModify");
            if (!Boolean.TRUE.equals(canModifyOutsideDb)) {
                dlg.setOutsideDbForbidance();
            }
        }
        return dlg;
    }

    private class PropertyDialogChecker
    implements PropertyDialog.IChecker {
        private String _exceptId;

        public PropertyDialogChecker(String selfId) {
            this._exceptId = selfId;
        }

        @Override
        public boolean isNameExist(String name) {
            int c = SchemaManageUI.this._table.getRowCount();
            for (int i = 0; i < c; ++i) {
                IRow row = SchemaManageUI.this._table.getRow(i);
                SchemaBriefModel model = (SchemaBriefModel)row.getUserObject();
                if (model.getId().equals(this._exceptId) || !name.equalsIgnoreCase(model.getName())) continue;
                return true;
            }
            return false;
        }
    }

    private class ButtonActionHandler
    implements ActionListener {
        private ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object ctrl = e.getSource();
            try {
                if (ctrl == SchemaManageUI.this._btnRefresh) {
                    SchemaManageUI.this.action_refresh();
                } else if (ctrl == SchemaManageUI.this._btnEdit) {
                    SchemaManageUI.this.action_edit();
                } else if (ctrl == SchemaManageUI.this._btnProperty) {
                    SchemaManageUI.this.action_property();
                } else if (ctrl == SchemaManageUI.this._btnNew) {
                    SchemaManageUI.this.action_new();
                } else if (ctrl == SchemaManageUI.this._btnImport) {
                    SchemaManageUI.this.action_import();
                } else if (ctrl == SchemaManageUI.this._btnExport) {
                    SchemaManageUI.this.action_export();
                } else if (ctrl == SchemaManageUI.this._btnDelete) {
                    SchemaManageUI.this.action_delete();
                }
            }
            catch (Exception ex) {
                SchemaManageUI.this.handUIException(ex);
            }
        }
    }
}

