/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.manage.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.server.ServerUtil;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.design.server.DesigntimeManager;
import com.kingdee.bos.ctrl.semantic.design.server.SchemaDesigntimeState;
import com.kingdee.bos.ctrl.semantic.design.server.SemanticDesignFacade;
import com.kingdee.bos.ctrl.semantic.manage.ISemanticManageFacade;
import com.kingdee.bos.ctrl.semantic.manage.exception.LockedException;
import com.kingdee.bos.ctrl.semantic.manage.exception.NotExistException;
import com.kingdee.bos.ctrl.semantic.manage.exception.SemanticManageException;
import com.kingdee.bos.ctrl.semantic.manage.server.ExportImpl;
import com.kingdee.bos.ctrl.semantic.manage.server.ImportImpl;
import com.kingdee.bos.ctrl.semantic.manage.server.SchemasAccess;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.bos.ctrl.semantic.model.trans.checkin.BosCheckinModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ExportModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.IImportModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportDecisionModel;
import com.kingdee.bos.ctrl.semantic.model.trans.imexport.ImportPreference;
import com.kingdee.bos.ctrl.semantic.model.trans.kicker.KickerModel;
import com.kingdee.bos.orm.template.ORMObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SemanticManageFacade
extends ORMObject
implements ISemanticManageFacade {
    public SemanticManageFacade() {
        this.registerInterface(ISemanticManageFacade.class, this);
    }

    @Override
    public String[] getOutsideDsList() throws SemanticManageException {
        String[] result;
        try {
            result = SchemasAccess.getOutsideDsList();
        }
        catch (BOSException ex) {
            throw SemanticManageException.wrap((Exception)((Object)ex));
        }
        return result;
    }

    @Override
    public SchemaBriefModel[] refresh() throws SemanticManageException {
        try {
            return SchemasAccess.refresh();
        }
        catch (SQLException ex) {
            throw SemanticManageException.wrap(ex);
        }
    }

    @Override
    public SchemaBriefModel createSchema(SchemaBriefModel params) throws SemanticManageException {
        return SchemasAccess.createSchema(params);
    }

    @Override
    public void deleteSchema(SchemaBriefModel params) throws SemanticManageException {
        SchemasAccess.deleteSchema(params);
    }

    @Override
    public SchemaBriefModel preModifyProperty(SchemaBriefModel params) throws SemanticManageException {
        return SchemasAccess.preModifyProperty(params);
    }

    @Override
    public SchemaBriefModel modifyProperty(SchemaBriefModel params) throws SemanticManageException {
        return SchemasAccess.modifyProperty(params);
    }

    @Override
    public boolean registerEdit(String id) throws SemanticManageException {
        if (!SchemasAccess.isIdExist(id)) {
            throw new NotExistException("Not exist: " + id);
        }
        try {
            return DesigntimeManager.getInst().getState(id).registerEdit(ServerUtil.getUserName());
        }
        catch (com.kingdee.bos.ctrl.semantic.design.exception.LockedException ex) {
            throw new LockedException(ex.getMessage());
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
    }

    @Override
    public void unregisterEdit(String id) throws SemanticManageException {
        try {
            DesigntimeManager.getInst().getState(id).unregisterEdit(ServerUtil.getUserName());
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
    }

    @Override
    public KickerModel[] kickerRefresh() throws SemanticManageException {
        SchemaBriefModel[] refresh = this.refresh();
        HashMap<String, String> schemaNames = new HashMap<String, String>();
        int c = refresh.length;
        for (int i = 0; i < c; ++i) {
            schemaNames.put(refresh[i].getId(), refresh[i].getName());
        }
        ArrayList<KickerModel> result = new ArrayList<KickerModel>();
        SchemaDesigntimeState[] states = DesigntimeManager.getInst().getAllState();
        for (int i = 0; i < states.length; ++i) {
            List locks;
            SchemaDesigntimeState state = states[i];
            String schemaName = (String)schemaNames.get(state.getSchemaId());
            List regs = state.getAllEditRegister(schemaName);
            try {
                locks = state.getAllEntityLock(schemaName);
            }
            catch (SemanticDesignException ex) {
                throw SemanticManageException.wrap(ex);
            }
            int jc = regs.size();
            for (int j = 0; j < jc; ++j) {
                KickerModel reg = (KickerModel)regs.get(j);
                result.add(reg);
                for (int k = locks.size() - 1; k >= 0; --k) {
                    KickerModel lock = (KickerModel)locks.get(k);
                    if (!StringUtil.equals((String)lock.getUser(), (String)reg.getUser())) continue;
                    result.add(lock);
                    locks.remove(k);
                }
            }
            result.addAll(locks);
        }
        return result.toArray(new KickerModel[0]);
    }

    @Override
    public void kick(KickerModel[] kickerModels) throws SemanticManageException {
        for (KickerModel mo : kickerModels) {
            SchemaDesigntimeState state;
            try {
                state = DesigntimeManager.getInst().getState(mo.getSchemaId());
            }
            catch (SemanticDesignException ex) {
                throw SemanticManageException.wrap(ex);
            }
            if (mo.isEntityLock()) {
                state.unlockEntity(mo.getEntityId(), mo.getUser());
                continue;
            }
            state.unregisterEdit(mo.getUser());
        }
    }

    @Override
    public int[] getAutoKickerPerference() {
        return DesigntimeManager.getInst().getAutoKickerPerference();
    }

    @Override
    public void setAutoKickerPerference(int[] values) {
        DesigntimeManager.getInst().setAutoKickerPerference(values);
    }

    @Override
    public ExportModel export(String schemaId, String path, int segmentIdx) throws SemanticManageException {
        return ExportImpl.getExportModel(schemaId, path, segmentIdx);
    }

    @Override
    public void importsUpload(String schemaName, byte[] segment, int segmentIdx, ImportPreference preference) throws SemanticManageException {
        ImportImpl importer = ImportImpl.getInstance(schemaName, false);
        try {
            importer.upload(segment, segmentIdx, preference);
        }
        catch (SemanticManageException ex) {
            importer.destroy();
            throw ex;
        }
        catch (Exception ex) {
            importer.destroy();
            throw SemanticManageException.wrap(ex);
        }
    }

    @Override
    public IImportModel importsDecision(String schemaName, ImportDecisionModel decisionModel, boolean isCancel) throws SemanticManageException {
        if (isCancel) {
            try {
                ImportImpl importer = ImportImpl.getInstance(schemaName, true);
                importer.destroy();
            }
            catch (NotExistException importer) {
                // empty catch block
            }
            return null;
        }
        ImportImpl importer = ImportImpl.getInstance(schemaName, true);
        try {
            return importer.imports(decisionModel);
        }
        catch (SemanticManageException ex) {
            importer.destroy();
            throw ex;
        }
        catch (Exception ex) {
            importer.destroy();
            throw SemanticManageException.wrap(ex);
        }
    }

    @Override
    public boolean askInitDemoData() throws SemanticManageException {
        return this.refresh().length == 0;
    }

    @Override
    public boolean initDemoData(BosCheckinModel.Request[] requests) throws SemanticManageException {
        SchemaBriefModel sbm = new SchemaBriefModel();
        sbm.setName("\u65b9\u6848\u6837\u4f8b");
        sbm.setCurrentDs(true);
        sbm = SchemasAccess.createSchema(sbm);
        BosCheckinModel.Preference preference = new BosCheckinModel.Preference();
        preference.setStandardMaker(false);
        preference.setPathPolicy(1);
        preference.setErrorPolicy(1);
        try {
            new SemanticDesignFacade().bosMetaCheckin(sbm.getId(), requests, preference);
        }
        catch (SemanticDesignException ex) {
            throw SemanticManageException.wrap(ex);
        }
        return true;
    }
}

