/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.model.trans;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticDataType;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticExprField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticTable;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticView;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContent;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class HeavyContentIO {
    private static final Logger log = LogUtil.getPackageLogger(HeavyContentIO.class);

    public static void save(AbstractSemanticEntity model, HeavyContent hc) throws SemanticDesignException {
        HeavyContentIO.saveEntity(model, hc);
        HeavyContentIO.saveRelations(model, hc);
    }

    private static void saveEntity(AbstractSemanticEntity model, HeavyContent hc) throws SemanticDesignException {
        int i;
        Element xmlEntity;
        if (model instanceof SemanticTable) {
            xmlEntity = new Element("Table");
        } else if (model instanceof SemanticView) {
            xmlEntity = new Element("View");
            if (((SemanticView)model).isDbView()) {
                xmlEntity.setAttribute("db", "T");
            }
            Element xmlSql = new Element("Sql");
            CDATA data = new CDATA(((SemanticView)model).getSQL());
            xmlSql.addContent((Content)data);
            xmlEntity.addContent((Content)xmlSql);
        } else {
            throw new RuntimeException("You must modify code.");
        }
        Rectangle rect = (Rectangle)model.getProperty("rect");
        xmlEntity.setAttribute("x", String.valueOf(rect.x));
        xmlEntity.setAttribute("y", String.valueOf(rect.y));
        xmlEntity.setAttribute("w", String.valueOf(rect.width));
        xmlEntity.setAttribute("h", String.valueOf(rect.height));
        int c = model.getFieldCount();
        for (i = 0; i < c; ++i) {
            xmlEntity.addContent((Content)HeavyContentIO.createFieldXml(model.getField(i)));
        }
        c = model.getExprFieldCount();
        for (i = 0; i < c; ++i) {
            xmlEntity.addContent((Content)HeavyContentIO.createFieldXml(model.getExprField(i)));
        }
        hc.setXml(HeavyContentIO.element2String(xmlEntity));
    }

    private static Element createFieldXml(AbstractSemanticField field) {
        Element xmlField;
        if (field instanceof SemanticField) {
            xmlField = new Element("F");
            if (((SemanticField)field).isPK()) {
                xmlField.setAttribute("pk", "T");
            }
        } else if (field instanceof SemanticExprField) {
            xmlField = new Element("EF");
            CDATA data = new CDATA(((SemanticExprField)field).getExpr());
            xmlField.addContent((Content)data);
        } else {
            throw new RuntimeException("You must modify code.");
        }
        xmlField.setAttribute("lN", field.getLogicalName());
        xmlField.setAttribute("pN", field.getPhysicalName());
        xmlField.setAttribute("tp", field.getDataType().getSaveString());
        if (field.isStandard()) {
            xmlField.setAttribute("st", "T");
        }
        if (field.isHide()) {
            xmlField.setAttribute("hd", "T");
        }
        return xmlField;
    }

    private static void saveRelations(AbstractSemanticEntity model, HeavyContent hc) throws SemanticDesignException {
        hc.removeAllRelations();
        int c = model.getRelationsCount();
        for (int i = 0; i < c; ++i) {
            String desc;
            SemanticRelation relation = model.getRelation(i);
            Element xmlRelation = new Element("Relation");
            if (relation.isStandard()) {
                xmlRelation.setAttribute("st", "T");
            }
            if (!StringUtil.isEmptyString((String)(desc = relation.getDescription()))) {
                xmlRelation.setAttribute("des", desc);
            }
            Rectangle rect = (Rectangle)relation.getSupplier().getProperty("rect");
            xmlRelation.setAttribute("x", String.valueOf(rect.x));
            xmlRelation.setAttribute("y", String.valueOf(rect.y));
            xmlRelation.setAttribute("w", String.valueOf(rect.width));
            xmlRelation.setAttribute("h", String.valueOf(rect.height));
            xmlRelation.setAttribute("tp", relation.getJoinType().getSaveString());
            for (int j = 0; j < relation.getConditionCount(); ++j) {
                SemanticRelation.ICondition rc = relation.getCondition(j);
                if (rc instanceof SemanticRelation.JoinLine) {
                    Element xmlLink = new Element("Link");
                    xmlLink.setAttribute("cf", ((SemanticRelation.JoinLine)rc).getClientField());
                    xmlLink.setAttribute("sf", ((SemanticRelation.JoinLine)rc).getSupplierField());
                    xmlRelation.addContent((Content)xmlLink);
                    continue;
                }
                if (!(rc instanceof SemanticRelation.CustomExpr)) continue;
                CDATA data = new CDATA(((SemanticRelation.CustomExpr)rc).getExpr());
                xmlRelation.addContent((Content)data);
            }
            String supplierId = (String)relation.getSupplier().getProperty("id");
            hc.addRelation(supplierId, HeavyContentIO.element2String(xmlRelation));
        }
    }

    private static String element2String(Element node) throws SemanticDesignException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        format.setEncoding("UTF-8");
        format.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        format.setLineSeparator("\n");
        XMLOutputter outter = new XMLOutputter(format);
        try {
            outter.output(node, (OutputStream)baos);
        }
        catch (IOException ex) {
            log.error((Object)"", (Throwable)ex);
            throw SemanticDesignException.wrap(ex);
        }
        try {
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"", (Throwable)ex);
            throw SemanticDesignException.wrap(ex);
        }
    }

    public static void load(HeavyContent hc, AbstractSemanticEntity model, Map mapSuppliers) throws SemanticDesignException {
        HeavyContentIO.loadEntity(hc, model);
        HeavyContentIO.loadRelations(hc, model, mapSuppliers);
    }

    public static void loadEntity(HeavyContent hc, AbstractSemanticEntity model) throws SemanticDesignException {
        Element xmlEntity = HeavyContentIO.string2Element(hc.getXml());
        if (!(model instanceof SemanticTable) && model instanceof SemanticView) {
            ((SemanticView)model).setDbView("T".equals(xmlEntity.getAttributeValue("db")));
            Element xmlSql = xmlEntity.getChild("Sql");
            ((SemanticView)model).setSQL(xmlSql.getText());
        }
        Rectangle rect = new Rectangle();
        rect.x = Integer.parseInt(xmlEntity.getAttributeValue("x"));
        rect.y = Integer.parseInt(xmlEntity.getAttributeValue("y"));
        rect.width = Integer.parseInt(xmlEntity.getAttributeValue("w"));
        rect.height = Integer.parseInt(xmlEntity.getAttributeValue("h"));
        model.setProperty("rect", rect);
        HeavyContentIO.loadFields(model, xmlEntity);
    }

    private static void loadFields(AbstractSemanticEntity model, Element xmlEntity) {
        List children = xmlEntity.getChildren();
        int c = children.size();
        for (int i = 0; i < c; ++i) {
            Element xmlChild = (Element)children.get(i);
            AbstractSemanticField field = HeavyContentIO.parseFieldXml(xmlChild);
            if (field instanceof SemanticField) {
                model.addField((SemanticField)field);
                continue;
            }
            if (!(field instanceof SemanticExprField)) continue;
            model.addExprField((SemanticExprField)field);
        }
    }

    private static AbstractSemanticField parseFieldXml(Element xmlChild) {
        AbstractSemanticField field;
        if ("F".equals(xmlChild.getName())) {
            field = new SemanticField();
            ((SemanticField)field).setPK("T".equals(xmlChild.getAttributeValue("pk")));
        } else if ("EF".equals(xmlChild.getName())) {
            field = new SemanticExprField();
            ((SemanticExprField)field).setExpr(xmlChild.getText());
        } else {
            return null;
        }
        field.setPhysicalName(xmlChild.getAttributeValue("pN"));
        field.setLogicalName(xmlChild.getAttributeValue("lN"));
        field.setDataType(SemanticDataType.getInst(xmlChild.getAttributeValue("tp")));
        field.setStandard("T".equals(xmlChild.getAttributeValue("st")));
        field.setHide("T".equals(xmlChild.getAttributeValue("hd")));
        return field;
    }

    private static void loadRelations(HeavyContent heavyContent, AbstractSemanticEntity model, Map mapSuppliers) throws SemanticDesignException {
        int c = heavyContent.getRelationContentCount();
        for (int i = 0; i < c; ++i) {
            HeavyContent.RelationContent rc = heavyContent.getRelationContent(i);
            Element xmlRelation = HeavyContentIO.string2Element(rc.getXml());
            SemanticRelation relation = HeavyContentIO.createRelation(xmlRelation);
            AbstractSemanticEntity supplier = null;
            InfoWrapper supplierInfoWrapper = null;
            if (mapSuppliers != null) {
                supplierInfoWrapper = (InfoWrapper)mapSuppliers.get(rc.getSupplierId());
            }
            if (supplierInfoWrapper != null) {
                LazyInfo supplierInfo = supplierInfoWrapper.getInfo();
                supplier = AbstractSemanticEntity.create(supplierInfo.getType());
                HeavyContentIO.loadEntity(supplierInfoWrapper.getContent(), supplier);
                supplier.setLogicalName(supplierInfo.getLogicalName());
                supplier.setPhysicalName(supplierInfo.getPhysicalName());
            }
            if (supplier == null) {
                supplier = new SemanticTable();
                supplier.setProperty("notFound", Boolean.TRUE);
            }
            Rectangle rect = new Rectangle();
            rect.x = Integer.parseInt(xmlRelation.getAttributeValue("x"));
            rect.y = Integer.parseInt(xmlRelation.getAttributeValue("y"));
            rect.width = Integer.parseInt(xmlRelation.getAttributeValue("w"));
            rect.height = Integer.parseInt(xmlRelation.getAttributeValue("h"));
            supplier.setProperty("rect", rect);
            supplier.setProperty("id", rc.getSupplierId());
            relation.setSupplier(supplier);
            relation.setClient(model);
            model.addRelation(relation);
        }
    }

    private static SemanticRelation createRelation(Element xmlRelation) throws SemanticDesignException {
        SemanticRelation relation = new SemanticRelation();
        relation.setStandard("T".equals(xmlRelation.getAttributeValue("st")));
        relation.setDescription(xmlRelation.getAttributeValue("des"));
        relation.setJoinType(SemanticRelation.JoinType.getInst(xmlRelation.getAttributeValue("tp")));
        List xmlLinks = xmlRelation.getChildren();
        if (xmlLinks.size() == 0) {
            String condition = xmlRelation.getText();
            if (!StringUtil.isEmptyString((String)condition)) {
                SemanticRelation.CustomExpr expr = new SemanticRelation.CustomExpr();
                expr.setExpr(condition);
                relation.addCondition(expr);
            }
        } else {
            for (int j = 0; j < xmlLinks.size(); ++j) {
                Element xmlLink = (Element)xmlLinks.get(j);
                SemanticRelation.JoinLine line = new SemanticRelation.JoinLine(xmlLink.getAttributeValue("cf"), xmlLink.getAttributeValue("sf"));
                relation.addCondition(line);
            }
        }
        return relation;
    }

    private static Element string2Element(String xml) throws SemanticDesignException {
        byte[] bytes;
        try {
            bytes = xml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"", (Throwable)ex);
            throw SemanticDesignException.wrap(ex);
        }
        try {
            return XmlUtil.loadXmlBytes((byte[])bytes);
        }
        catch (IOException ex) {
            log.error((Object)"", (Throwable)ex);
            throw SemanticDesignException.wrap(ex);
        }
        catch (JDOMException ex) {
            log.error((Object)"", (Throwable)ex);
            throw SemanticDesignException.wrap((Exception)((Object)ex));
        }
    }

    public static SemanticRelation createRelation(String xml) throws SemanticDesignException {
        return HeavyContentIO.createRelation(HeavyContentIO.string2Element(xml));
    }

    public static void loadFields(AbstractSemanticEntity model, String xmlEntity) throws SemanticDesignException {
        Element xml = HeavyContentIO.string2Element(xmlEntity);
        HeavyContentIO.loadFields(model, xml);
    }
}

