/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.use.client;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

class EntityPositionSearcher {
    private static final int[][] PARAM = new int[][]{{1, 1, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 1, 10, 0, 1, 0}, {0, -1, -1, 0, 0, 0, 0, 1}, {1, 1, 0, 1, 1, 0, 0, 0}, {0, -1, -1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, -10, -1, 1, 0}, {1, 1, 0, 0, -1, -1, 0, 0}, {0, -1, -1, 0, -1, -1, 0, 0}};
    private static final int HSPACE = 100;
    private static final int VSPACE = 10;
    private static final int STEP = 20;
    private Rectangle[] _exists;

    EntityPositionSearcher() {
    }

    public void setExists(Rectangle[] rects) {
        this._exists = rects;
    }

    public Point lookForPosition(Rectangle sourceRect, Dimension size) {
        Rectangle rect = new Rectangle(size);
        for (int i = 0; i < PARAM.length; ++i) {
            int vSearchDistance;
            int[] p = PARAM[i];
            int hSearchDistance = (sourceRect.width - 50) * p[6];
            if (hSearchDistance < 0) {
                hSearchDistance = 0;
            }
            if ((vSearchDistance = (sourceRect.height - 50) * p[7]) < 0) {
                vSearchDistance = 0;
            }
            for (int xDelta = 0; xDelta <= hSearchDistance; xDelta += 20) {
                for (int yDelta = 0; yDelta <= vSearchDistance; yDelta += 20) {
                    rect.x = sourceRect.x + p[0] * sourceRect.width + p[1] * 100 + p[2] * size.width + xDelta;
                    rect.y = sourceRect.y + p[3] * sourceRect.height + p[4] * 10 + p[5] * size.height + yDelta;
                    if (this.isIntersectant(rect)) continue;
                    return new Point(rect.x, rect.y);
                }
            }
        }
        rect.x = sourceRect.x + sourceRect.width + 100;
        rect.y = sourceRect.y + sourceRect.height + 10;
        do {
            rect.y += 20;
        } while (this.isIntersectant(rect));
        return new Point(rect.x, rect.y);
    }

    private boolean isIntersectant(Rectangle rect) {
        for (int j = 0; j < this._exists.length; ++j) {
            if (!rect.intersects(this._exists[j])) continue;
            return true;
        }
        return false;
    }
}

