/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.use.client;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.semantic.common.client.ClientUtil;
import com.kingdee.bos.ctrl.semantic.common.client.icon.SemanticIcons;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticExprField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

class EntityUI
extends KDPanel {
    private KDLabel _labTitle;
    private KDWorkButton _btnPrimaryKey;
    private KDTree _treFields;
    private KDScrollPane _scpContent;
    private KDLabel _labResize;
    private KDCheckBox _chkSelectAll;
    private KDLabel _labClose;
    private AbstractSemanticEntity _preparedModel;
    private AbstractSemanticEntity _checkedModel;
    private IOperateListener _listener;

    public EntityUI(AbstractSemanticEntity entityModel) {
        this._preparedModel = entityModel;
        this._checkedModel = entityModel.thinClone();
        this.cutForSelectionModel(this._checkedModel);
        this.init();
        this.initListener();
        this.initData(this._preparedModel);
    }

    private void cutForSelectionModel(AbstractSemanticEntity entityModel) {
        entityModel.removeFields();
        entityModel.removeExprFields();
        entityModel.removeRelations();
    }

    private void init() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this._btnPrimaryKey = new KDWorkButton("\u67e5\u627e\u4e3b\u952e\u5173\u7cfb");
        this._treFields = new KDTree();
        this._treFields.setRootVisible(false);
        this._treFields.setShowCheckBox(true);
        this._scpContent = new KDScrollPane();
        this._scpContent.setBorder(null);
        this._chkSelectAll = new KDCheckBox("\u5168\u9009");
        this._labResize = new KDLabel(){

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Dimension size = this.getSize();
                int x = size.width - 2;
                int y = size.height - 2;
                Color oriColor = g.getColor();
                for (int i = 1; i < 12; i += 4) {
                    g.setColor(Color.GRAY);
                    g.drawLine(x, y - i, x - i, y);
                    g.setColor(Color.GRAY);
                    g.drawLine(x, y - i - 1, x - i - 1, y);
                    g.setColor(Color.WHITE);
                    g.drawLine(x, y - i - 2, x - i - 2, y);
                }
                g.setColor(oriColor);
            }
        };
        this._labResize.setCursor(Cursor.getPredefinedCursor(5));
        this._labResize.setToolTipText(null);
        TableLayout2 ly = new TableLayout2(3, 4);
        ly.setFixedHeight(0, 20);
        ly.setRatableHeight(1, 100);
        ly.setFixedHeight(2, 20);
        ly.setRowsSpacing(TableLayout2.ALL, 1);
        ly.setFixedWidth(0, 60);
        ly.setRatableWidth(1, 100);
        ly.setFixedWidth(2, 20);
        ly.setFixedWidth(3, 1);
        this.setLayout((LayoutManager)ly);
        this.add((Component)this.createTitleBar(), TableLayout2.param((int)0, (int)0, (int)0, (int)2));
        this.add((Component)this._scpContent, TableLayout2.param((int)1, (int)0, (int)1, (int)3));
        this.add((Component)this._chkSelectAll, TableLayout2.param((int)2, (int)0));
        this.add((Component)this._labResize, TableLayout2.param((int)2, (int)2, (int)2, (int)3));
    }

    private KDPanel createTitleBar() {
        this._labTitle = new KDLabel();
        this._labTitle.setOpaque(false);
        this._labTitle.setForeground(Color.WHITE);
        this._labTitle.setCursor(Cursor.getPredefinedCursor(13));
        this._labTitle.setIcon(SemanticIcons.createEmptyIcon(2));
        this._labClose = new KDLabel();
        this._labClose.setOpaque(true);
        this._labClose.setText("X");
        this._labClose.setFont(new Font("", 1, 12));
        this._labClose.setToolTipText(null);
        this._labClose.setHorizontalAlignment(0);
        this._labClose.setBorder(BorderFactory.createRaisedBevelBorder());
        TableLayout2 ly = new TableLayout2(3, 3);
        ly.setRatableHeight(0, 50);
        ly.setFixedHeight(1, 14);
        ly.setRatableHeight(2, 50);
        ly.setRatableWidth(0, 100);
        ly.setFixedWidth(1, 14);
        ly.setFixedWidth(2, 2);
        KDPanel pan = new KDPanel((LayoutManager)ly);
        pan.add((Component)this._labTitle, (Object)TableLayout2.param((int)1, (int)0));
        pan.add((Component)this._labClose, (Object)TableLayout2.param((int)1, (int)1));
        pan.setOpaque(true);
        pan.setBackground(new Color(100, 130, 180));
        return pan;
    }

    private void initListener() {
        Move move = new Move();
        this._labTitle.addMouseMotionListener((MouseMotionListener)move);
        this._labTitle.addMouseListener((MouseListener)move);
        Resize resize = new Resize();
        this._labResize.addMouseMotionListener((MouseMotionListener)resize);
        this._labResize.addMouseListener((MouseListener)resize);
        this._chkSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityUI.this._scpContent.getVerticalScrollBar().setValue(0);
                boolean isSelected = EntityUI.this._chkSelectAll.isSelected();
                DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)EntityUI.this._treFields.getModel().getRoot();
                Enumeration enu = root.breadthFirstEnumeration();
                while (enu.hasMoreElements()) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enu.nextElement();
                    node.setChecked(isSelected);
                }
                EntityUI.this.repaint();
            }
        });
        this._labClose.addMouseListener((MouseListener)new MouseAdapter(){
            private Point clickStart;

            @Override
            public void mousePressed(MouseEvent evt) {
                EntityUI.this._labClose.setBorder(BorderFactory.createLoweredBevelBorder());
                this.clickStart = evt.getPoint();
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                EntityUI.this._labClose.setBorder(BorderFactory.createRaisedBevelBorder());
                Point clickEnd = evt.getPoint();
                if (Math.abs(this.clickStart.x - clickEnd.x) < 5 && Math.abs(this.clickStart.y - clickEnd.y) < 5) {
                    EntityUI.this._listener.close(EntityUI.this);
                }
                this.clickStart = null;
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
            }
        });
        this._btnPrimaryKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EntityUI.this._listener.expandClient(EntityUI.this)) {
                    EntityUI.this._btnPrimaryKey.setEnabled(false);
                }
            }
        });
        this._treFields.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                EntityUI.this._listener.checkField();
            }
        });
    }

    private void initData(AbstractSemanticEntity entityModel) {
        DefaultKingdeeTreeNode node;
        int i;
        this._labTitle.setText(entityModel.getLogicalName());
        this._labTitle.setToolTipText(entityModel.getPhysicalName());
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        int c = entityModel.getFieldCount();
        for (i = 0; i < c; ++i) {
            SemanticField f = entityModel.getField(i);
            if (f.isHide()) continue;
            node = new DefaultKingdeeTreeNode();
            node.setUserObject((Object)f);
            node.setText(f.getLogicalName());
            node.setCustomIcon(SemanticIcons.createEmptyIcon(1));
            root.add((MutableTreeNode)node);
        }
        c = entityModel.getExprFieldCount();
        for (i = 0; i < c; ++i) {
            SemanticExprField ef = entityModel.getExprField(i);
            if (ef.isHide()) continue;
            node = new DefaultKingdeeTreeNode();
            node.setUserObject((Object)ef);
            node.setText(ef.getLogicalName());
            node.setCustomIcon(SemanticIcons.createEmptyIcon(1));
            root.add((MutableTreeNode)node);
        }
        this._treFields.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.initScrollPane(entityModel);
    }

    private void initScrollPane(AbstractSemanticEntity entityModel) {
        int relationsCount = entityModel.getRelationsCount();
        int rows = 1 + relationsCount + 1;
        TableLayout2 ly = new TableLayout2(rows, 3);
        ly.setFixedHeight(TableLayout2.ALL, 20);
        ly.setRatableHeight(0, 1);
        ly.setRowsSpacing(TableLayout2.ALL, 3);
        ly.setRowSpacing(rows - 2, 6);
        ly.setRowSpacing(0, 0);
        ly.setFixedWidth(0, 10);
        ly.setRatableWidth(1, 1);
        ly.setFixedWidth(2, 10);
        KDPanel pan = new KDPanel((LayoutManager)ly);
        pan.setBackground(this._treFields.getBackground());
        pan.setCustomInsets(new Insets(0, 0, 2, 0));
        pan.add((Component)this._treFields, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)2));
        pan.add((Component)this._btnPrimaryKey, (Object)TableLayout2.param((int)(rows - 1), (int)1));
        for (int i = 0; i < relationsCount; ++i) {
            SemanticRelation relation = entityModel.getRelation(i);
            String text = relation.getDescription();
            if (text == null || text.trim().length() == 0) {
                String fieldPhyName;
                SemanticField clientField;
                SemanticRelation.ICondition condition = null;
                if (relation.getConditionCount() > 0) {
                    condition = relation.getCondition(0);
                }
                if (condition instanceof SemanticRelation.JoinLine && (clientField = entityModel.getField(fieldPhyName = ((SemanticRelation.JoinLine)condition).getClientField())) != null) {
                    text = clientField.getLogicalName();
                }
            }
            KDWorkButton btn = new KDWorkButton();
            btn.setUserObject((Object)relation);
            btn.setIcon(SemanticIcons.ICN_FK);
            btn.setText(text);
            btn.setHorizontalAlignment(2);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDWorkButton btn = (KDWorkButton)e.getSource();
                    SemanticRelation relation = (SemanticRelation)btn.getUserObject();
                    if (EntityUI.this._listener.expandSupplier(EntityUI.this, relation)) {
                        btn.setEnabled(false);
                    }
                }
            });
            pan.add((Component)btn, (Object)TableLayout2.param((int)(1 + i), (int)1));
        }
        Dimension dim = this._treFields.getPreferredSize();
        dim.height += 26;
        dim.height += 23 * relationsCount;
        pan.setPreferredSize(dim);
        this._scpContent.getViewport().add((Component)pan);
    }

    public AbstractSemanticEntity getCheckedModel() {
        return this._checkedModel;
    }

    public AbstractSemanticEntity getPreparedModel() {
        return this._preparedModel;
    }

    public void setListener(IOperateListener l) {
        this._listener = l;
    }

    public void setFkButtonEnabled(SemanticRelation relation, boolean enabled) {
        KDPanel pan = (KDPanel)this._scpContent.getViewport().getComponent(0);
        for (int i = pan.getComponentCount() - 1; i >= 0; --i) {
            Object uo;
            Component c = pan.getComponent(i);
            if (!(c instanceof KDWorkButton) || !((uo = ((KDWorkButton)c).getUserObject()) instanceof SemanticRelation) || ((SemanticRelation)uo).getSupplier() != relation.getSupplier()) continue;
            ((KDWorkButton)c).setEnabled(enabled);
            return;
        }
    }

    public void setPkButtonEnabled(boolean enabled) {
        this._btnPrimaryKey.setEnabled(enabled);
    }

    public void accpetFieldsSelection() {
        this._checkedModel.removeFields();
        this._checkedModel.removeExprFields();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this._treFields.getModel().getRoot();
        String langPostfix = ClientUtil.getLangPostfix();
        int c = root.getChildCount();
        for (int i = 0; i < c; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (!node.isChecked()) continue;
            AbstractSemanticField f = (AbstractSemanticField)node.getUserObject();
            if (f instanceof SemanticField) {
                this.tryAppendLangPostfix((SemanticField)f, langPostfix);
                this._checkedModel.addField((SemanticField)f);
                continue;
            }
            if (!(f instanceof SemanticExprField)) continue;
            this._checkedModel.addExprField((SemanticExprField)f);
        }
    }

    private void tryAppendLangPostfix(SemanticField field, String langPostfix) {
        String[] fieldsNames = (String[])this._checkedModel.getProperty("dbFieldsNames");
        if (fieldsNames == null) {
            return;
        }
        String fieldName = field.getPhysicalName();
        if (!EntityUI.isFieldNameExist(fieldsNames, fieldName) && EntityUI.isFieldNameExist(fieldsNames, fieldName = fieldName + langPostfix)) {
            field.setPhysicalName(fieldName);
        }
    }

    private static boolean isFieldNameExist(String[] fieldsNames, String fieldName) {
        for (int i = 0; i < fieldsNames.length; ++i) {
            if (!StringUtil.equalsIgnoreCase((String)fieldsNames[i], (String)fieldName)) continue;
            return true;
        }
        return false;
    }

    public AbstractSemanticField[] checkFieldsSelection(AbstractSemanticField[] fields) {
        int i;
        ArrayList<AbstractSemanticField> listNotFounds = new ArrayList<AbstractSemanticField>();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this._treFields.getModel().getRoot();
        int size = root.getChildCount();
        HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>(size);
        for (i = 0; i < size; ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            AbstractSemanticField f = (AbstractSemanticField)node.getUserObject();
            map.put(f.getPhysicalName(), node);
        }
        for (i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getPhysicalName();
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)map.get(fieldName);
            if (node == null) {
                fieldName = ClientUtil.cutLangPostfix(fieldName);
                node = (DefaultKingdeeTreeNode)map.get(fieldName);
            }
            if (node == null) {
                listNotFounds.add(fields[i]);
                continue;
            }
            node.setChecked(true);
        }
        if (listNotFounds.size() > 0) {
            return listNotFounds.toArray(new AbstractSemanticField[0]);
        }
        return null;
    }

    public static interface IOperateListener {
        public void move(EntityUI var1, MouseEvent var2, Point var3);

        public void resize(EntityUI var1, MouseEvent var2, Dimension var3);

        public void close(EntityUI var1);

        public boolean expandSupplier(EntityUI var1, SemanticRelation var2);

        public boolean expandClient(EntityUI var1);

        public void checkField();
    }

    private class Resize
    extends MouseAdapter
    implements MouseMotionListener {
        private int xPress;
        private int yPress;
        private int w = 0;
        private int h = 0;
        private boolean isDraged;

        private Resize() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.xPress = e.getX();
            this.yPress = e.getY();
            this.isDraged = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Graphics g2d = EntityUI.this.getParent().getGraphics();
            g2d.setColor(Color.WHITE);
            g2d.setXORMode(Color.DARK_GRAY);
            if (this.isDraged) {
                g2d.drawRect(EntityUI.this.getX() - 1, EntityUI.this.getY() - 1, this.w, this.h);
            }
            this.w = EntityUI.this.getWidth() + e.getX() - this.xPress;
            this.h = EntityUI.this.getHeight() + e.getY() - this.yPress;
            this.w = this.w < 100 ? 100 : this.w;
            this.h = this.h < 75 ? 75 : this.h;
            g2d.drawRect(EntityUI.this.getX() - 1, EntityUI.this.getY() - 1, this.w, this.h);
            this.isDraged = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isDraged) {
                EntityUI.this._listener.resize(EntityUI.this, e, new Dimension(this.w, this.h));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class Move
    extends MouseAdapter
    implements MouseMotionListener {
        private int xPress;
        private int yPress;
        private int x = 0;
        private int y = 0;
        private boolean isDraged;

        private Move() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.xPress = e.getX();
            this.yPress = e.getY();
            this.isDraged = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int w = EntityUI.this.getWidth();
            int h = EntityUI.this.getHeight();
            Graphics g = EntityUI.this.getParent().getGraphics();
            g.setColor(Color.DARK_GRAY);
            g.setXORMode(Color.WHITE);
            if (this.isDraged) {
                g.drawRect(this.x, this.y, w, h);
            }
            this.x = EntityUI.this.getX() + e.getX() - this.xPress;
            this.y = EntityUI.this.getY() + e.getY() - this.yPress;
            if (this.x < 0) {
                this.x = 0;
            }
            if (this.y < 0) {
                this.y = 0;
            }
            g.drawRect(this.x, this.y, w, h);
            this.isDraged = true;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isDraged) {
                EntityUI.this._listener.move(EntityUI.this, e, new Point(this.x, this.y));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

