/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.use.client;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.semantic.common.client.relation.RelationRenderModel;
import com.kingdee.bos.ctrl.semantic.common.client.relation.RelationRenderer;
import com.kingdee.bos.ctrl.semantic.design.exception.SemanticDesignException;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticField;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticTable;
import com.kingdee.bos.ctrl.semantic.model.base.SemanticView;
import com.kingdee.bos.ctrl.semantic.model.trans.HeavyContentIO;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.use.ISemanticUsedFacade;
import com.kingdee.bos.ctrl.semantic.use.PkRelationModel;
import com.kingdee.bos.ctrl.semantic.use.SemanticUsetimeModel;
import com.kingdee.bos.ctrl.semantic.use.SemanticUsetimeModelIO;
import com.kingdee.bos.ctrl.semantic.use.client.EntityPositionSearcher;
import com.kingdee.bos.ctrl.semantic.use.client.EntityUI;
import com.kingdee.bos.ctrl.semantic.use.client.ExpandClientSelectionPane;
import com.kingdee.bos.ctrl.semantic.use.client.SemanticUseEditor;
import com.kingdee.bos.ctrl.semantic.use.exception.EntitiesNotFoundException;
import com.kingdee.bos.ctrl.semantic.use.exception.RelationsNotFoundException;
import com.kingdee.bos.ctrl.semantic.use.exception.SemanticUsedException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import org.apache.log4j.Logger;

class SelectedShower
extends KDPanel {
    private static final Logger log = LogUtil.getPackageLogger(SelectedShower.class);
    static final String DB_FIELDS_NAMES = "dbFieldsNames";
    private static final int INIT_W = 160;
    private static final int INIT_H = 200;
    private ISemanticUsedFacade _facade;
    private SemanticUsetimeModel _model;
    private SemanticUseEditor.IBridge _listener;

    public SelectedShower(ISemanticUsedFacade facade, SemanticUseEditor.IBridge listener) {
        this._facade = facade;
        this._listener = listener;
        this.setLayout(null);
        this.setBackground(Color.WHITE);
    }

    private ISemanticUsedFacade getFacade() {
        return this._facade;
    }

    public SemanticUsetimeModel getModel() {
        return this._model;
    }

    public void setInitModel(SemanticUsetimeModel mo) {
        this._model = mo;
    }

    public String[] setPreloadModel(SemanticUsetimeModel mo) throws SemanticUsedException {
        this._model = mo;
        String[] notFoundFields = SemanticUsetimeModelIO.load(mo, new LoadEnv());
        mo.setXmlPreload(null);
        return notFoundFields;
    }

    public boolean isEldestBorn() {
        return this._model.getEntities().length > 0;
    }

    public void addEldestEntity(InfoWrapper infoWraper) throws SemanticUsedException {
        Rectangle rect = new Rectangle(10, 10, 160, 200);
        this.addEntity(infoWraper, rect);
    }

    private AbstractSemanticEntity addEntity(InfoWrapper infoWraper, Rectangle rect) throws SemanticUsedException {
        AbstractSemanticEntity entityModel = this.createEntityModel(infoWraper);
        EntityUI ui = this.appendCtrl(entityModel, rect);
        AbstractSemanticEntity checkedModel = ui.getCheckedModel();
        this._model.addEntity(checkedModel);
        return checkedModel;
    }

    private boolean expandSupplierEntity(EntityUI clientEntityUi, SemanticRelation relation, InfoWrapper infoWraper) {
        AbstractSemanticEntity supplierModel;
        try {
            supplierModel = this.createEntityModel(infoWraper);
        }
        catch (SemanticUsedException ex) {
            this.showException("\u5c55\u5f00\u5b50\u5bf9\u8c61", "\u4e0d\u80fd\u6b63\u786e\u521b\u5efa\u5bf9\u8c61\u3002", ex);
            return false;
        }
        Rectangle supplierRect = this.lookForRect(clientEntityUi);
        Rectangle clientRect = clientEntityUi.getBounds();
        EntityUI supplierEntityUi = this.appendCtrl(supplierModel, supplierRect);
        supplierEntityUi.setPkButtonEnabled(false);
        this.scrollNewRectVisible(clientRect, supplierRect);
        supplierModel = supplierEntityUi.getCheckedModel();
        this._model.addEntity(supplierModel);
        AbstractSemanticEntity clientModel = clientEntityUi.getCheckedModel();
        relation.setClient(clientModel);
        relation.setSupplier(supplierModel);
        clientModel.addRelation(relation);
        this.repaint();
        return true;
    }

    private boolean expandClientEntity(EntityUI supplierEntityUi, String relationXml, InfoWrapper infoWraper) {
        AbstractSemanticEntity clientEntity;
        SemanticRelation relation;
        try {
            relation = HeavyContentIO.createRelation(relationXml);
        }
        catch (SemanticDesignException ex) {
            this.showException("\u5c55\u5f00\u7236\u5bf9\u8c61", "\u4e0d\u80fd\u6b63\u786e\u521b\u5efa\u5173\u7cfb\u3002", ex);
            return false;
        }
        relation.setSupplier(supplierEntityUi.getCheckedModel());
        try {
            clientEntity = this.createEntityModel(infoWraper);
        }
        catch (SemanticUsedException ex) {
            this.showException("\u5c55\u5f00\u7236\u5bf9\u8c61", "\u4e0d\u80fd\u6b63\u786e\u521b\u5efa\u5bf9\u8c61\u3002", ex);
            return false;
        }
        relation = SelectedShower.lookForSameRelation(clientEntity, relation, true);
        if (relation == null) {
            this.showInfo("\u5c55\u5f00\u7236\u5bf9\u8c61", "\u6570\u636e\u9519\u8bef");
            return false;
        }
        Rectangle clientRect = this.lookForRect(supplierEntityUi);
        Rectangle supplierRect = supplierEntityUi.getBounds();
        EntityUI clientEntityUi = this.appendCtrl(clientEntity, clientRect);
        clientEntityUi.setFkButtonEnabled(relation, false);
        this.scrollNewRectVisible(supplierRect, clientRect);
        clientEntity = clientEntityUi.getCheckedModel();
        this._model.addEntity(clientEntity);
        relation.setClient(clientEntity);
        relation.setSupplier(supplierEntityUi.getCheckedModel());
        clientEntity.addRelation(relation);
        this.repaint();
        return true;
    }

    private static SemanticRelation lookForSameRelation(AbstractSemanticEntity prepareClientEntity, SemanticRelation relation, boolean isStrictCompare) {
        String supplierId = (String)relation.getSupplier().getProperty("id");
        for (int i = prepareClientEntity.getRelationsCount() - 1; i >= 0; --i) {
            SemanticRelation temp = prepareClientEntity.getRelation(i);
            if (!StringUtil.equals((String)supplierId, (String)((String)temp.getSupplier().getProperty("id"))) || !(isStrictCompare ? SemanticRelation.strictCompare(relation, temp) : SemanticRelation.looseCompare(relation, temp))) continue;
            return temp;
        }
        return null;
    }

    private void closeEntity(EntityUI entityUi, boolean isWithChildren) {
        this.closeEntityRecursion(entityUi, isWithChildren);
        this.updateChildrenLocation();
    }

    private void closeEntityRecursion(EntityUI entityUi, boolean isWithChildren) {
        SemanticRelation relation;
        AbstractSemanticEntity entityModel = entityUi.getCheckedModel();
        if (isWithChildren) {
            for (int i = entityModel.getRelationsCount() - 1; i >= 0; --i) {
                AbstractSemanticEntity childModel = entityModel.getRelation(i).getSupplier();
                this.closeEntityRecursion(this.searchEntityUI(childModel), isWithChildren);
            }
        }
        if ((relation = this._model.searchParentRelation(entityModel)) != null) {
            relation.getClient().removeRelation(relation);
            this.searchEntityUI(relation.getClient()).setFkButtonEnabled(relation, true);
        }
        this._model.removeEntity(entityModel);
        this.remove((Component)((Object)entityUi));
        if (!isWithChildren) {
            for (int i = entityModel.getRelationsCount() - 1; i >= 0; --i) {
                AbstractSemanticEntity childModel = entityModel.getRelation(i).getSupplier();
                this.searchEntityUI(childModel).setPkButtonEnabled(true);
            }
        }
    }

    private AbstractSemanticEntity createEntityModel(InfoWrapper infoWraper) throws SemanticUsedException {
        AbstractSemanticEntity entityModel;
        LazyInfo info = infoWraper.getInfo();
        if (info.getType() == 1) {
            entityModel = new SemanticTable();
            String outsideDb = this._listener.getOutsideDb();
            try {
                String[] fieldsNames = this.getFacade().getDbFieldsNames(info.getPhysicalName(), outsideDb);
                entityModel.setProperty(DB_FIELDS_NAMES, fieldsNames);
            }
            catch (SemanticUsedException ex) {
                log.error((Object)"Get outside data-center error.", (Throwable)ex);
            }
        } else if (info.getType() == 2) {
            entityModel = new SemanticView();
        } else {
            throw new RuntimeException("You must modify code.");
        }
        entityModel.setProperty("id", info.getId());
        entityModel.setLogicalName(info.getLogicalName());
        entityModel.setPhysicalName(info.getPhysicalName());
        try {
            HeavyContentIO.load(infoWraper.getContent(), entityModel, infoWraper.getSuppliers());
        }
        catch (SemanticDesignException ex) {
            throw SemanticUsedException.wrap(ex);
        }
        return entityModel;
    }

    private EntityUI appendCtrl(AbstractSemanticEntity entityModel, Rectangle rect) {
        EntityUI entityUi = new EntityUI(entityModel);
        this.add((Component)((Object)entityUi));
        entityUi.setBounds(rect);
        this.updatePreferredSize();
        entityUi.setListener(new EntityOperateHandler());
        return entityUi;
    }

    private void scrollNewRectVisible(final Rectangle oldRect, final Rectangle newRect) {
        new Thread(){

            @Override
            public void run() {
                Rectangle realVidibleRect = oldRect.intersection(SelectedShower.this.getVisibleRect());
                float stepX = (newRect.x - realVidibleRect.x) / 10;
                float stepY = (newRect.y - realVidibleRect.y) / 10;
                for (int i = 10; i >= 0; --i) {
                    Rectangle tempRedt = new Rectangle(newRect);
                    tempRedt.x = (int)((float)tempRedt.x - (float)i * stepX);
                    tempRedt.y = (int)((float)tempRedt.y - (float)i * stepY);
                    SelectedShower.this.scrollRectToVisible(tempRedt);
                    try {
                        Thread.sleep(20L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Container owner = SelectedShower.this.getParent();
                while (!(owner instanceof KDScrollPane)) {
                    owner = owner.getParent();
                }
                owner.repaint();
            }
        }.start();
    }

    public void paint(Graphics g) {
        super.paint(g);
        AbstractSemanticEntity[] entities = this._model.getEntities();
        for (int i = 0; i < entities.length; ++i) {
            AbstractSemanticEntity entity = entities[i];
            for (int j = 0; j < entity.getRelationsCount(); ++j) {
                SemanticRelation relation = entity.getRelation(j);
                EntityUI clientUi = this.searchEntityUI(relation.getClient());
                EntityUI supplierUi = this.searchEntityUI(relation.getSupplier());
                Rectangle clientRect = new Rectangle(clientUi.getX(), clientUi.getY(), clientUi.getWidth(), clientUi.getHeight());
                Rectangle supplierRect = new Rectangle(supplierUi.getX(), supplierUi.getY(), supplierUi.getWidth(), supplierUi.getHeight());
                RelationRenderModel rrm = new RelationRenderModel();
                rrm.update(clientRect, supplierRect);
                String role = relation.getDescription();
                if (StringUtil.isEmptyString((String)role) && !relation.isCustomExpr() && relation.getConditionCount() > 0) {
                    String fieldName = ((SemanticRelation.JoinLine)relation.getCondition(0)).getClientField();
                    SemanticField field = clientUi.getPreparedModel().getField(fieldName);
                    if (field != null) {
                        role = field.getLogicalName();
                    }
                }
                RelationRenderer.paintLine(g, rrm, role);
            }
        }
    }

    private EntityUI searchEntityUI(AbstractSemanticEntity entityModel) {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            EntityUI ui = (EntityUI)((Object)this.getComponent(i));
            if (ui.getCheckedModel() != entityModel) continue;
            return ui;
        }
        return null;
    }

    private Rectangle lookForRect(EntityUI source) {
        Rectangle rectSource = null;
        ArrayList<Rectangle> existRects = new ArrayList<Rectangle>();
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            EntityUI ui = (EntityUI)((Object)this.getComponent(i));
            Rectangle rect = new Rectangle(ui.getBounds());
            if (ui == source) {
                rectSource = rect;
                continue;
            }
            rect.x -= 10;
            rect.y -= 10;
            rect.width += 20;
            rect.height += 20;
            existRects.add(rect);
        }
        Dimension size = new Dimension(160, 200);
        Rectangle result = new Rectangle(size);
        EntityPositionSearcher searcher = new EntityPositionSearcher();
        searcher.setExists(existRects.toArray(new Rectangle[0]));
        Point pt = searcher.lookForPosition(rectSource, size);
        if (pt.x < 0 || pt.y < 0) {
            int deltaX = 0;
            int deltaY = 0;
            if (pt.x < 0) {
                deltaX = -pt.x;
                pt.x = 0;
            }
            if (pt.y < 0) {
                deltaY = -pt.y;
                pt.y = 0;
            }
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                EntityUI ui = (EntityUI)((Object)this.getComponent(i));
                int x = ui.getX() + deltaX;
                int y = ui.getY() + deltaY;
                ui.setLocation(x, y);
            }
            Rectangle oriVisibleRect = this.getVisibleRect();
            oriVisibleRect.x += deltaX;
            oriVisibleRect.y += deltaY;
            this.scrollRectToVisible(oriVisibleRect);
        }
        result.x = pt.x;
        result.y = pt.y;
        return result;
    }

    private Dimension getChildrenMaxRightBottom() {
        int wMax = 0;
        int hMax = 0;
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Rectangle rect = this.getComponent(i).getBounds();
            if (rect.x + rect.width > wMax) {
                wMax = rect.x + rect.width;
            }
            if (rect.y + rect.height <= hMax) continue;
            hMax = rect.y + rect.height;
        }
        return new Dimension(wMax + 100, hMax + 100);
    }

    private void updatePreferredSize() {
        this.setPreferredSize(this.getChildrenMaxRightBottom());
        this.revalidate();
        this.repaint();
    }

    private Point getChildrenMinLeftTop() {
        int xMin = Integer.MAX_VALUE;
        int yMin = Integer.MAX_VALUE;
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Point pt = this.getComponent(i).getLocation();
            if (pt.x < xMin) {
                xMin = pt.x;
            }
            if (pt.y >= yMin) continue;
            yMin = pt.y;
        }
        return new Point(xMin, yMin);
    }

    private void updateChildrenLocation() {
        Point pt = this.getChildrenMinLeftTop();
        if (pt.x > 100 || pt.y > 100) {
            int deltaX = 0;
            int deltaY = 0;
            if (pt.x > 100) {
                deltaX = pt.x - 10;
            }
            if (pt.y > 100) {
                deltaY = pt.y - 10;
            }
            final int stepX = deltaX / 10;
            final int stepY = deltaY / 10;
            new Thread(){

                @Override
                public void run() {
                    for (int s = 0; s < 10; ++s) {
                        for (int i = SelectedShower.this.getComponentCount() - 1; i >= 0; --i) {
                            EntityUI ui = (EntityUI)((Object)SelectedShower.this.getComponent(i));
                            int x = ui.getX() - stepX;
                            int y = ui.getY() - stepY;
                            ui.setLocation(x, y);
                        }
                        SelectedShower.this.repaint();
                        try {
                            Thread.sleep(20L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    SelectedShower.this.updatePreferredSize();
                }
            }.start();
        } else {
            this.updatePreferredSize();
        }
    }

    public void accpetFieldsSelection() {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            EntityUI ui = (EntityUI)((Object)this.getComponent(i));
            ui.accpetFieldsSelection();
            ui.getCheckedModel().setProperty("rect", ui.getBounds());
        }
    }

    public AbstractSemanticEntity[] getAllPreparedEntities() {
        ArrayList<AbstractSemanticEntity> result = new ArrayList<AbstractSemanticEntity>();
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            EntityUI ui = (EntityUI)((Object)this.getComponent(i));
            result.add(ui.getPreparedModel());
        }
        return result.toArray(new AbstractSemanticEntity[0]);
    }

    private void showInfo(String title, String msg) {
        MessageUtil.msgboxInfo((Component)((Object)this), (String)msg);
    }

    private void showException(String title, String msg, Exception ex) {
        log.error((Object)"", (Throwable)ex);
        MessageUtil.msgboxWarning((Component)((Object)this), (String)msg, (Exception)ex);
    }

    private class LoadEnv
    implements SemanticUsetimeModelIO.ILoadEnv {
        private LoadEnv() {
        }

        @Override
        public InfoWrapper[] loadEntities(String schemaId, String[] entitiesNames) throws SemanticUsedException, EntitiesNotFoundException {
            return SelectedShower.this.getFacade().loadEntities(schemaId, entitiesNames);
        }

        @Override
        public AbstractSemanticEntity addEntity(InfoWrapper infoWraper, Rectangle rect) throws SemanticUsedException {
            return SelectedShower.this.addEntity(infoWraper, rect);
        }

        @Override
        public AbstractSemanticField[] addFields(AbstractSemanticEntity entityModel, AbstractSemanticField[] fields) throws SemanticUsedException {
            EntityUI entityUi = SelectedShower.this.searchEntityUI(entityModel);
            return entityUi.checkFieldsSelection(fields);
        }

        @Override
        public void addRelation(AbstractSemanticEntity entityModel, SemanticRelation relation) throws SemanticUsedException, RelationsNotFoundException {
            AbstractSemanticEntity supplier = relation.getSupplier();
            EntityUI entityUi = SelectedShower.this.searchEntityUI(entityModel);
            AbstractSemanticEntity prepareEntityModel = entityUi.getPreparedModel();
            SemanticRelation sameRelation = SelectedShower.lookForSameRelation(prepareEntityModel, relation, false);
            if (sameRelation == null) {
                throw new RelationsNotFoundException(relation);
            }
            sameRelation.setClient(entityModel);
            sameRelation.setSupplier(supplier);
            entityModel.addRelation(sameRelation);
            entityUi.setFkButtonEnabled(sameRelation, false);
            SelectedShower.this.searchEntityUI(supplier).setPkButtonEnabled(false);
        }

        @Override
        public void destoryWhenNotFound() {
            SelectedShower.this._model.removeAllEntities();
            for (int i = SelectedShower.this.getComponentCount() - 1; i >= 0; --i) {
                EntityUI ui = (EntityUI)((Object)SelectedShower.this.getComponent(i));
                SelectedShower.this.remove((Component)((Object)ui));
            }
        }
    }

    private static class ClosingAsker
    extends KDPanel {
        private KDRadioButton _radOnlySelf = new KDRadioButton("\u4ec5\u5173\u95ed\u81ea\u5df1");
        private KDRadioButton _radWithChildren = new KDRadioButton("\u540c\u65f6\u5173\u95ed\u6240\u6709\u5b50\u5bf9\u8c61");
        private KDLabel _labPrompt;

        public ClosingAsker() {
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this._radOnlySelf);
            bg.add((AbstractButton)this._radWithChildren);
            this._labPrompt = new KDLabel();
            TableLayout2 ly = new TableLayout2(4, 1);
            ly.setFixedHeight(TableLayout2.ALL, 20);
            ly.setRatableHeight(3, 100);
            this.setLayout((LayoutManager)ly);
            this.add((Component)this._labPrompt, TableLayout2.param((int)0, (int)0));
            this.add((Component)this._radOnlySelf, TableLayout2.param((int)1, (int)0));
            this.add((Component)this._radWithChildren, TableLayout2.param((int)2, (int)0));
        }

        public void setTitle(String name) {
            this._labPrompt.setText("\u60a8\u786e\u5b9a\u5173\u95ed\u3010" + name + "\u3011\u5417?");
        }

        public void setState(boolean hasParent, int childCount) {
            if (!hasParent && childCount <= 1 || childCount == 0) {
                this._radOnlySelf.setEnabled(true);
                this._radOnlySelf.setSelected(true);
            } else {
                this._radOnlySelf.setEnabled(false);
                this._radWithChildren.setSelected(true);
                this._radOnlySelf.setText(this._radOnlySelf.getText() + "\uff08\u53ea\u6709\u5904\u4e8e\u672b\u7aef\u7684\u5bf9\u8c61\u53ef\u4ee5\uff09");
            }
            this._radWithChildren.setEnabled(childCount != 0);
        }

        public boolean isSelectedWithChildren() {
            return this._radWithChildren.isSelected();
        }
    }

    private class EntityOperateHandler
    implements EntityUI.IOperateListener {
        private EntityOperateHandler() {
        }

        @Override
        public void checkField() {
            SelectedShower.this._listener.contentChanged();
        }

        @Override
        public void move(EntityUI sourceUi, MouseEvent e, Point newPosition) {
            sourceUi.setLocation(newPosition);
            SelectedShower.this.updatePreferredSize();
        }

        @Override
        public void resize(EntityUI sourceUi, MouseEvent e, Dimension newSize) {
            sourceUi.setSize(newSize);
            SelectedShower.this.updatePreferredSize();
        }

        @Override
        public void close(EntityUI sourceUi) {
            SelectedShower.this._listener.contentChanged();
            AbstractSemanticEntity entityModel = sourceUi.getCheckedModel();
            boolean hasParent = SelectedShower.this._model.searchParentRelation(entityModel) != null;
            int childCount = entityModel.getRelationsCount();
            ClosingAsker asker = new ClosingAsker();
            asker.setTitle(entityModel.getLogicalName());
            asker.setState(hasParent, childCount);
            SimpleDialog dlg = SimpleDialog.create((Component)((Object)SelectedShower.this));
            dlg.setComponent((Component)((Object)asker));
            dlg.setTitle("\u5173\u95ed");
            dlg.setSize(320, 150);
            if (dlg.showDialog()) {
                boolean isWithChildren = asker.isSelectedWithChildren();
                SelectedShower.this.closeEntity(sourceUi, isWithChildren);
            }
        }

        @Override
        public boolean expandSupplier(EntityUI sourceUi, SemanticRelation relation) {
            InfoWrapper infoWrapper;
            SelectedShower.this._listener.contentChanged();
            String supplierId = (String)relation.getSupplier().getProperty("id");
            try {
                infoWrapper = SelectedShower.this.getFacade().getEntity(SelectedShower.this._model.getSchemaId(), supplierId);
            }
            catch (SemanticUsedException ex) {
                SelectedShower.this.showException("\u5c55\u5f00\u5b50\u5bf9\u8c61", "", ex);
                return false;
            }
            return SelectedShower.this.expandSupplierEntity(sourceUi, relation, infoWrapper);
        }

        @Override
        public boolean expandClient(EntityUI sourceUi) {
            PkRelationModel[] clients;
            SelectedShower.this._listener.contentChanged();
            String title = "\u4e3b\u952e\u5173\u7cfb\u67e5\u627e";
            AbstractSemanticEntity supplier = sourceUi.getCheckedModel();
            String supplierId = (String)supplier.getProperty("id");
            try {
                clients = SelectedShower.this.getFacade().getClientEntities(SelectedShower.this._model.getSchemaId(), supplierId);
            }
            catch (SemanticUsedException ex) {
                SelectedShower.this.showException(title, "", ex);
                return false;
            }
            ExpandClientSelectionPane ui = new ExpandClientSelectionPane();
            ui.setTitle(supplier.getLogicalName());
            ui.setData(clients);
            SimpleDialog dlg = SimpleDialog.create((Component)((Object)SelectedShower.this));
            dlg.setComponent((Component)((Object)ui));
            dlg.setTitle(title);
            if (dlg.showDialog()) {
                InfoWrapper infoWrapper;
                PkRelationModel selected = ui.getSelected();
                if (selected == null) {
                    return false;
                }
                String clientId = selected.getClientEntityId();
                try {
                    infoWrapper = SelectedShower.this.getFacade().getEntity(SelectedShower.this._model.getSchemaId(), clientId);
                }
                catch (SemanticUsedException ex) {
                    SelectedShower.this.showException(title, "", ex);
                    return false;
                }
                return SelectedShower.this.expandClientEntity(sourceUi, selected.getRelationXml(), infoWrapper);
            }
            return false;
        }
    }
}

