/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.semantic.use.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ORMRPCServiceLocator;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.semantic.common.client.TreeBuilder;
import com.kingdee.bos.ctrl.semantic.common.client.icon.SemanticIcons;
import com.kingdee.bos.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.bos.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.bos.ctrl.semantic.model.trans.LazyInfo;
import com.kingdee.bos.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.bos.ctrl.semantic.use.ISemanticUsedFacade;
import com.kingdee.bos.ctrl.semantic.use.SemanticUsetimeModel;
import com.kingdee.bos.ctrl.semantic.use.client.SelectedShower;
import com.kingdee.bos.ctrl.semantic.use.exception.EntitiesNotFoundException;
import com.kingdee.bos.ctrl.semantic.use.exception.RelationsNotFoundException;
import com.kingdee.bos.ctrl.semantic.use.exception.SemanticUsedException;
import com.kingdee.bos.ctrl.semantic.use.server.SemanticUsedFacade;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class SemanticUseEditor
extends KDPanel {
    private static Logger log = LogUtil.getPackageLogger(SemanticUseEditor.class);
    private KDSplitPane _sppLeftRight;
    private KDWorkButton _btnFullScreen;
    private KDComboBox _cmbSchemas;
    private KDTreeView _trvSchema;
    private KDScrollPane _scpShower;
    private ISemanticUsedFacade _facade;
    private SelectedShower _shower;
    private Map _bakOthers = new HashMap();
    private IBridge _listener;
    private boolean _isToFireSchemaChanged;

    public SemanticUseEditor() {
        this.init();
        this.initListener();
        this.initData();
    }

    private void init() {
        this._cmbSchemas = new KDComboBox();
        KDLabelContainer lbcSchemas = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbSchemas, (String)"\u65b9\u6848", (int)50);
        KDTree tree = new KDTree((TreeModel)new KingdeeTreeModel((TreeNode)new DefaultKingdeeTreeNode((Object)"Root")));
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setShowCheckBox(false);
        this._trvSchema = new KDTreeView(tree);
        this._trvSchema.setShowButton(false);
        this._trvSchema.setTitle("\u8868/\u89c6\u56fe");
        this._btnFullScreen = new KDWorkButton();
        this._btnFullScreen.setUserObject((Object)Boolean.TRUE);
        this.changeFullScreenButtonState();
        this._scpShower = new KDScrollPane();
        this._scpShower.setBorder(BorderFactory.createEtchedBorder());
        TableLayout2 ly = new TableLayout2(2, 2);
        ly.setFixedHeight(0, 20);
        ly.setRowSpacing(0, 6);
        ly.setRatableHeight(1, 1);
        ly.setFixedWidth(0, 40);
        ly.setColSpacing(0, 20);
        ly.setRatableWidth(1, 1);
        KDPanel panLeft = new KDPanel((LayoutManager)ly);
        panLeft.add((Component)this._btnFullScreen, (Object)TableLayout2.param((int)0, (int)0));
        panLeft.add((Component)lbcSchemas, (Object)TableLayout2.param((int)0, (int)1));
        panLeft.add((Component)this._trvSchema, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        this._sppLeftRight = new KDSplitPane();
        this._sppLeftRight.setDividerLocation(260);
        this._sppLeftRight.setLeftComponent((Component)panLeft);
        this._sppLeftRight.setRightComponent((Component)this._scpShower);
        this.setLayout(new BorderLayout());
        this.add((Component)this._sppLeftRight, "Center");
    }

    private void changeFullScreenButtonState() {
        if (Boolean.TRUE == this._btnFullScreen.getUserObject()) {
            this._btnFullScreen.setUserObject((Object)Boolean.FALSE);
            this._btnFullScreen.setText("\u5168\u5c4f");
        } else {
            this._btnFullScreen.setUserObject((Object)Boolean.TRUE);
            this._btnFullScreen.setText("\u8fd4\u56de");
        }
    }

    private void initListener() {
        this._btnFullScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Boolean.TRUE == SemanticUseEditor.this._btnFullScreen.getUserObject()) {
                    SwingUtilities.getWindowAncestor((Component)SemanticUseEditor.this._btnFullScreen).dispose();
                } else {
                    SemanticUseEditor.this.remove((Component)SemanticUseEditor.this._sppLeftRight);
                    KDPanel pan = new KDPanel((LayoutManager)new BorderLayout());
                    pan.setCustomInsets(new Insets(10, 10, 10, 10));
                    pan.add((Component)SemanticUseEditor.this._sppLeftRight, (Object)"Center");
                    KDDialog dlg = (KDDialog)WindowUtil.createWindow(KDDialog.class, (Component)((Object)SemanticUseEditor.this));
                    dlg.getContentPane().setLayout(new BorderLayout());
                    dlg.getContentPane().add((Component)pan, "Center");
                    dlg.setModal(true);
                    dlg.setTitle("\u5168\u5c4f");
                    WindowUtil.makeDialogFullScreen((KDDialog)dlg);
                    SemanticUseEditor.this.changeFullScreenButtonState();
                    dlg.setVisible(true);
                    SemanticUseEditor.this.changeFullScreenButtonState();
                    SemanticUseEditor.this.add((Component)SemanticUseEditor.this._sppLeftRight, "Center");
                    SemanticUseEditor.this.validate();
                    SemanticUseEditor.this.repaint();
                }
            }
        });
        this._cmbSchemas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SemanticUseEditor.this._isToFireSchemaChanged) {
                    SchemaBriefModel schema = SemanticUseEditor.this.syncAfterSchemaChanged();
                    SemanticUseEditor.this._listener.schemaChanged(schema);
                }
            }
        });
        this.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() != 2 || !SwingUtilities.isLeftMouseButton(evt)) {
                    return;
                }
                TreePath treePath = SemanticUseEditor.this.getTree().getSelectionPath();
                if (treePath == null) {
                    return;
                }
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
                Object obj = node.getUserObject();
                if (!(obj instanceof LazyInfo)) {
                    return;
                }
                LazyInfo info = (LazyInfo)obj;
                if (info.getType() == 0) {
                    return;
                }
                if (SemanticUseEditor.this._shower.isEldestBorn()) {
                    MessageUtil.msgboxInfo((Component)((Object)SemanticUseEditor.this), (String)"\u60a8\u5df2\u7ecf\u521b\u5efa\u4e86\u7b2c\u4e00\u4e2a\u5bf9\u8c61\uff08\u8868/\u89c6\u56fe\uff09\uff0c\u53ea\u80fd\u4ece\u53f3\u4fa7\u5df2\u9009\u5bf9\u8c61\u7684\u5173\u7cfb\u4e2d\u7ee7\u7eed\u5c55\u5f00\u3002");
                    return;
                }
                String schemaId = SemanticUseEditor.this.getCurrentModel().getSchemaId();
                String entityId = info.getId();
                try {
                    InfoWrapper infoWrapper = SemanticUseEditor.this.getFacade().getEntity(schemaId, entityId);
                    SemanticUseEditor.this._shower.addEldestEntity(infoWrapper);
                }
                catch (SemanticUsedException ex) {
                    log.error((Object)"", (Throwable)ex);
                    MessageUtil.msgboxWarning((Component)((Object)SemanticUseEditor.this), (String)"", (Exception)ex);
                    return;
                }
            }
        });
    }

    private ISemanticUsedFacade getFacade() throws SemanticUsedException {
        if (this._facade == null) {
            String rpcUrl = ORMRPCServiceLocator.getCurrentServiceURL();
            try {
                this._facade = (ISemanticUsedFacade)BOSObjectFactory.createRemoteObject((String)rpcUrl, (String)SemanticUsedFacade.class.getName(), ISemanticUsedFacade.class);
            }
            catch (BOSException ex) {
                throw SemanticUsedException.wrap((Exception)((Object)ex));
            }
        }
        return this._facade;
    }

    private void initData() {
        this._isToFireSchemaChanged = false;
        try {
            this._cmbSchemas.addItems((Object[])this.getFacade().getSchemas());
        }
        catch (SemanticUsedException e) {
            this._cmbSchemas.insertItemAt((Object)"\u83b7\u53d6\u65b9\u6848\u5f02\u5e38", 0);
            this._cmbSchemas.setSelectedIndex(0);
            this._cmbSchemas.setEnabled(false);
            return;
        }
        this._cmbSchemas.setSelectedIndex(-1);
        this._isToFireSchemaChanged = true;
    }

    private KDTree getTree() {
        return this._trvSchema.getTree();
    }

    private SchemaBriefModel syncAfterSchemaChanged() {
        SchemaBriefModel schema;
        if (this._shower != null) {
            SemanticUsetimeModel mo = this.getCurrentModel();
            this._bakOthers.put(mo.getSchemaId(), this._shower);
        }
        if ((schema = this.updateTreeData()) == null) {
            this._shower = null;
            this._scpShower.getViewport().removeAll();
        } else {
            this._shower = (SelectedShower)((Object)this._bakOthers.get(schema.getId()));
            try {
                if (this._shower == null) {
                    this._shower = new SelectedShower(this.getFacade(), this._listener);
                    this._shower.setInitModel(new SemanticUsetimeModel(schema));
                }
                this._scpShower.getViewport().add((Component)((Object)this._shower));
            }
            catch (SemanticUsedException ex) {
                log.error((Object)"", (Throwable)ex);
            }
        }
        return schema;
    }

    private SchemaBriefModel updateTreeData() {
        LazyInfo[] infos;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.getTree().getModel().getRoot();
        this.getTree().removeAllChildrenFromParent((MutableTreeNode)root);
        Object selected = this._cmbSchemas.getSelectedItem();
        if (!(selected instanceof SchemaBriefModel)) {
            this.getTree().setRootVisible(false);
            return null;
        }
        SchemaBriefModel schema = (SchemaBriefModel)selected;
        root.setText(schema.getName());
        this.getTree().setRootVisible(true);
        String schemaId = schema.getId();
        try {
            infos = this.getFacade().refreshTree(schemaId);
        }
        catch (SemanticUsedException ex) {
            log.error((Object)"", (Throwable)ex);
            root.setText(ex.getMessage());
            return null;
        }
        TreeBuilder treeBuilder = new TreeBuilder(this.getTree());
        TreeBuilderBehavior behavior = new TreeBuilderBehavior();
        treeBuilder.setCustomBehavior(behavior);
        treeBuilder.refreshRoot(infos);
        TreeBuilder.sort(this.getTree(), root);
        this.getTree().expandPath(new TreePath(root.getPath()));
        return schema;
    }

    public void setCommunicatingBridge(IBridge listener) {
        this._listener = listener;
    }

    private SemanticUsetimeModel getCurrentModel() {
        return this._shower.getModel();
    }

    public AbstractSemanticEntity[] getEditResultsMetas() {
        if (this._shower == null) {
            return null;
        }
        return this._shower.getAllPreparedEntities();
    }

    public SemanticUsetimeModel getEditResult() {
        if (this._shower == null) {
            return null;
        }
        this._shower.accpetFieldsSelection();
        return this.getCurrentModel();
    }

    public boolean setEditData(SemanticUsetimeModel semanticModel) {
        SchemaBriefModel schema = this.searchSameSchema(semanticModel);
        if (schema == null) {
            semanticModel.setInvalid(true);
            this.promptSchemaNotFound(semanticModel);
            return false;
        }
        semanticModel.updateSchema(schema);
        this._isToFireSchemaChanged = false;
        this._cmbSchemas.setSelectedItem((Object)schema);
        this._isToFireSchemaChanged = true;
        this.syncAfterSchemaChanged();
        if (this._shower != null) {
            String[] notFoundFields;
            try {
                notFoundFields = this._shower.setPreloadModel(semanticModel);
            }
            catch (EntitiesNotFoundException ex) {
                semanticModel.setInvalid(true);
                this.promptEntityNotFound(ex, schema);
                return false;
            }
            catch (RelationsNotFoundException ex) {
                semanticModel.setInvalid(true);
                this.promptRelationNotFound(ex, schema);
                return false;
            }
            catch (SemanticUsedException ex) {
                semanticModel.setInvalid(true);
                log.error((Object)"\u89e3\u6790\u9884\u52a0\u8f7d\u6a21\u578b\u51fa\u9519", (Throwable)ex);
                MessageUtil.msgboxWarning((Component)((Object)this), (String)"\u6570\u636e\u6a21\u578b\u52a0\u8f7d\u5931\u8d25\u3002", (Exception)ex);
                return false;
            }
            if (notFoundFields != null) {
                this.promptFieldsNotFound(notFoundFields);
            }
        }
        semanticModel.setInvalid(false);
        return true;
    }

    private void promptFieldsNotFound(String[] notFoundFields) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u8bf7\u6ce8\u610f\uff0c\u539f\u5148\u5f15\u7528\u7684\u5b57\u6bb5\u627e\u4e0d\u5230\uff1a");
        sb.append(StringUtil.RETURN);
        for (int i = 0; i < notFoundFields.length; ++i) {
            sb.append(notFoundFields[i]);
            sb.append(StringUtil.RETURN);
        }
        this.promptNotFound(sb);
    }

    private void promptSchemaNotFound(SemanticUsetimeModel semanticModel) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u5f53\u524d\u6570\u636e\u96c6\u5f15\u7528\u7684\u8bed\u4e49\u5c42\u65b9\u6848\u627e\u4e0d\u5230\uff1a");
        sb.append(StringUtil.RETURN);
        sb.append(semanticModel.getSchemaName());
        sb.append(StringUtil.RETURN);
        this.promptNotFound(sb);
    }

    private void promptEntityNotFound(EntitiesNotFoundException ex, SchemaBriefModel schema) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u5f53\u524d\u6570\u636e\u96c6\u5f15\u7528\u7684 \u8868/\u89c6\u56fe \u627e\u4e0d\u5230\uff1a");
        sb.append(StringUtil.RETURN);
        int c = ex.getCount();
        for (int i = 0; i < c; ++i) {
            sb.append("\u3000");
            sb.append(ex.getEntityName(i));
            sb.append(StringUtil.RETURN);
        }
        this.appendAtSchema(sb, schema);
        this.promptNotFound(sb);
    }

    private void promptRelationNotFound(RelationsNotFoundException ex, SchemaBriefModel schema) {
        StringBuffer sb = new StringBuffer();
        sb.append("\u5f53\u524d\u6570\u636e\u96c6\u5f15\u7528\u7684 \u5173\u7cfb \u627e\u4e0d\u5230\uff1a");
        sb.append(StringUtil.RETURN);
        sb.append(ex.getPrompt());
        sb.append(StringUtil.RETURN);
        this.appendAtSchema(sb, schema);
        this.promptNotFound(sb);
    }

    private void appendAtSchema(StringBuffer sb, SchemaBriefModel schema) {
        sb.append("\u5728\u8bed\u4e49\u5c42\u65b9\u6848");
        sb.append("\u3010");
        sb.append(schema.getName());
        sb.append("\u3011");
        sb.append("\u4e2d\u3002");
        sb.append(StringUtil.RETURN);
    }

    private void promptNotFound(StringBuffer sb) {
        log.error((Object)sb.toString());
        MessageUtil.msgboxWarning((Component)((Object)this), (String)sb.toString());
    }

    private SchemaBriefModel searchSameSchema(SemanticUsetimeModel semanticModel) {
        String id = semanticModel.getSchemaId();
        for (int i = this._cmbSchemas.getItemCount() - 1; i >= 0; --i) {
            Object obj = this._cmbSchemas.getItemAt(i);
            if (!(obj instanceof SchemaBriefModel) || !StringUtil.equals((String)((SchemaBriefModel)obj).getId(), (String)id)) continue;
            return (SchemaBriefModel)obj;
        }
        String name = semanticModel.getSchemaName();
        for (int i = this._cmbSchemas.getItemCount() - 1; i >= 0; --i) {
            Object obj = this._cmbSchemas.getItemAt(i);
            if (!(obj instanceof SchemaBriefModel) || !StringUtil.equals((String)((SchemaBriefModel)obj).getName(), (String)name)) continue;
            return (SchemaBriefModel)obj;
        }
        return null;
    }

    private class TreeBuilderBehavior
    implements TreeBuilder.ICustomBehavior {
        private TreeBuilderBehavior() {
        }

        @Override
        public void addEntityNode(DefaultKingdeeTreeNode parent, LazyInfo info) {
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setAllowsChildren(false);
            node.setText(info.getLogicalName());
            node.setUserObject((Object)info);
            if (info.getType() == 1) {
                node.setCustomIcon(SemanticIcons.ICN_TABLE);
            } else if (info.getType() == 2) {
                node.setCustomIcon(SemanticIcons.ICN_VIEW);
            }
            SemanticUseEditor.this.getTree().addNodeInto((MutableTreeNode)node, (MutableTreeNode)parent);
        }

        @Override
        public DefaultKingdeeTreeNode createFolder(String path, String name) {
            LazyInfo tempInfo = new LazyInfo();
            tempInfo.setType(0);
            tempInfo.setPhysicalName(name);
            tempInfo.setPath(path);
            DefaultKingdeeTreeNode tempNode = new DefaultKingdeeTreeNode();
            tempNode.setAllowsChildren(true);
            tempNode.setUserObject((Object)tempInfo);
            tempNode.setText(name);
            return tempNode;
        }
    }

    public static interface IBridge {
        public void schemaChanged(SchemaBriefModel var1);

        public void contentChanged();

        public String getOutsideDb();
    }
}

