/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cloud.http;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.PermissionBO;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionKind;
import com.kingdee.eas.rpts.statistics.EASExtStatisticsInfoService;
import com.kingdee.eas.rpts.statistics.info.EnterpriseInfo;
import com.kingdee.eas.rpts.statistics.util.ServiceUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class CloudRptCenterHttpFetcher {
    private static final Logger logger = CommonLogger.getLogger(CloudRptCenterHttpFetcher.class);

    public static boolean isUserAgreementSigned(String userNumber) {
        try {
            EnterpriseInfo enterpriseInfo = EASExtStatisticsInfoService.fetchEnterpriseInfo(null);
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod("http://bos.kingdee.com/crc/rptcenter/resources/userAgreement?ts=" + new Date().getTime());
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new NameValuePair("licenseId", enterpriseInfo.getUuid()));
            params.add(new NameValuePair("dbCode", enterpriseInfo.getDbCode()));
            params.add(new NameValuePair("userId", userNumber));
            params.add(new NameValuePair("ts", new Date().getTime() + ""));
            get.setQueryString(params.toArray(new NameValuePair[0]));
            client.executeMethod((HttpMethod)get);
            String respStr = get.getResponseBodyAsString();
            JSONObject respJson = new JSONObject(respStr);
            JSONObject data = respJson.getJSONObject("data");
            return data.getBoolean("agreed");
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static String getUserAgreement(String userNumber) {
        try {
            EnterpriseInfo enterpriseInfo = EASExtStatisticsInfoService.fetchEnterpriseInfo(null);
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod("http://bos.kingdee.com/crc/rptcenter/resources/userAgreement");
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new NameValuePair("licenseId", enterpriseInfo.getUuid()));
            params.add(new NameValuePair("dbCode", enterpriseInfo.getDbCode()));
            params.add(new NameValuePair("userId", userNumber));
            get.setQueryString(params.toArray(new NameValuePair[0]));
            client.executeMethod((HttpMethod)get);
            String respStr = get.getResponseBodyAsString();
            JSONObject respJson = new JSONObject(respStr);
            JSONObject data = respJson.getJSONObject("data");
            return data.getString("text");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void reportCloudRptUsage(String rptId) {
        try {
            DefineReportInfo info = DefineReportBO.getReportInfo(null, rptId);
            Book book = MiscUtil.unpack((byte[])info.getContent());
            String cloudRptUuid = book.getCloudRptUuid();
            if (StringUtil.isEmptyString((String)cloudRptUuid)) {
                return;
            }
            EnterpriseInfo enterpriseInfo = EASExtStatisticsInfoService.fetchEnterpriseInfo(null);
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ArrayList<Object> queryValues = new ArrayList<Object>();
            String POSITION_NAME = "";
            if (userInfo.getPerson() != null) {
                queryValues.add(userInfo.getPerson().getId().toString());
                String sql = "SELECT  \"POSITION\".FName_l2 \"POSITION.NAME\" \tFrom T_BD_PERSON \"PERSON\" \tLEFT JOIN T_ORG_PositionMember \"POSITIONMEMBER\" ON \"PERSON\".FID = \"POSITIONMEMBER\".FPersonID \tLEFT JOIN T_ORG_Position \"POSITION\" ON \"POSITIONMEMBER\".FPositionID = \"POSITION\".FID \twhere \"PERSON\".FID = ?";
                IRowSet rowSet = ServiceUtil.DBUtil.executeQuery(null, sql, queryValues);
                if (rowSet.next()) {
                    POSITION_NAME = rowSet.getString("POSITION.NAME");
                }
            }
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod("http://bos.kingdee.com/crc/rptcenter/resources/rptUsage");
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new NameValuePair("cloudRptId", cloudRptUuid));
            params.add(new NameValuePair("isTemplateModified", String.valueOf(book.getUserObjectValue("CLOUD_REPORT_DEMO_BOOK_DATA") == null)));
            params.add(new NameValuePair("rptName", info.getName()));
            params.add(new NameValuePair("customerId", enterpriseInfo.getUuid()));
            params.add(new NameValuePair("customerName", enterpriseInfo.getName()));
            params.add(new NameValuePair("customerDBCode", enterpriseInfo.getDbCode()));
            params.add(new NameValuePair("userAccount", userInfo.getNumber()));
            params.add(new NameValuePair("userName", userInfo.getName()));
            params.add(new NameValuePair("userTitle", POSITION_NAME));
            params.add(new NameValuePair("executor", "GUI"));
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            boolean hasPermission = PermissionBO.hasDataPermissionByReportId(null, userInfo.getId().toString(), orgId, rptId, PermissionKind.VIEW);
            params.add(new NameValuePair("isAuthed", String.valueOf(hasPermission)));
            get.setQueryString(params.toArray(new NameValuePair[0]));
            client.executeMethod((HttpMethod)get);
            get.releaseConnection();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

