/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.cloud.tool;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.bos.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.io.kds.KdsToBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIFrameUtil;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.client.SelectedReportSingleUI;
import com.kingdee.eas.rpts.ctrlreport.mobile.util.MobileTemplateUtil;
import com.kingdee.eas.rpts.ctrlreport.model.ExtCallbackImpl;
import com.kingdee.eas.rpts.statistics.dynamic.DefaultExtStatisticsRunner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CloudReportMaker
extends KDDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CommonLogger.getLogger(CloudReportMaker.class);
    private SelectedReportSingleUI reportSelector;
    private boolean isMobile;
    private KDFileChooser fileChooser;
    private ExtReportManageUI ui;
    private Component sourceGlassPane;

    public CloudReportMaker(ExtReportManageUI ui) {
        super((Frame)((KDFrame)UIFrameUtil.getCurrMainFrame((Component)((Object)ui))));
        this.ui = ui;
        this.sourceGlassPane = ((KDFrame)SwingUtilities.getWindowAncestor((Component)((Object)ui))).getGlassPane();
        this.init();
        this.setLocationRelativeTo((Component)((KDFrame)UIFrameUtil.getCurrMainFrame((Component)((Object)ui))));
    }

    public boolean doExport() {
        String password = JOptionPane.showInputDialog(null, "\u8bf7\u8f93\u5165\u7ba1\u7406\u5458\u5bc6\u7801\uff1a", "", 3);
        boolean matcher = false;
        try {
            UserInfo info = UserFactory.getRemoteInstance().getUserByID((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
            matcher = PermissionUtils.matchPasswordWithSecurity((UserInfo)info, (String)password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (matcher) {
            this.show();
            if (!this.reportSelector.isCanceled()) {
                this.exportReport(((DefObj[])this.reportSelector.getData())[0].getName());
            }
            return !this.reportSelector.isCanceled();
        }
        return false;
    }

    private void exportReport(final String rptId) {
        final KDFrame frame = (KDFrame)SwingUtilities.getWindowAncestor((Component)((Object)this.ui));
        frame.setGlassPane((Component)new KDPanel(){
            private static final long serialVersionUID = 1L;

            public void paintComponent(Graphics g) {
                this.setOpaque(false);
                g.setColor(new Color(128, 128, 128, 128));
                g.fillRect(0, 0, frame.getWidth(), frame.getHeight());
                g.setColor(Color.black);
                g.setFont(new Font("Dialog", 1, 30));
                g.drawString("\u8bf7\u5728\u62a5\u8868\u6267\u884c\u5668\u4e2d\u7f16\u8f91\u6837\u4f8b\u6570\u636e\u7ed3\u679c\uff0c\u7f16\u8f91\u5b8c\u6210\u4e4b\u540e\uff0c\u76f4\u63a5\u5173\u95ed\u6267\u884c\u5668\u5373\u53ef\uff01", 100, 300);
                super.paintComponent(g);
            }
        });
        ((KDFrame)SwingUtilities.getWindowAncestor((Component)((Object)this.ui))).getGlassPane().setVisible(true);
        try {
            DefineReportInfo rptInfo = DefineReportBO.getReportInfo(null, rptId);
            this.fileChooser.setSelectedFile(new File(this.fileChooser.getCurrentDirectory().getPath() + File.separator + rptInfo.getName() + ".cloudkds"));
            int action = this.fileChooser.showOpenDialog((Component)((Object)this.ui));
            final File file = this.fileChooser.getSelectedFile();
            if (action != 0 || file == null) {
                frame.setGlassPane(this.sourceGlassPane);
                frame.getGlassPane().setVisible(false);
                this.doExport();
                return;
            }
            final Book book = MiscUtil.unpack((byte[])rptInfo.getContent());
            ExtCallbackImpl callbackImpl = new ExtCallbackImpl(rptInfo, false, false);
            UIContext uiContext = new UIContext((Object)this.ui);
            uiContext.put((Object)"checkLicense", (Object)"true");
            uiContext.put((Object)"UIClassParam", (Object)rptInfo.getId().toString());
            uiContext.put((Object)"MainMenuName", (Object)rptInfo.getName());
            uiContext.put((Object)"canExcute", (Object)"true");
            uiContext.put((Object)"isEntryFromMenu", (Object)"false");
            uiContext.put((Object)"managerUiName", (Object)ExtReportManageUI.class.getName());
            uiContext.put((Object)"isLimitRecord", (Object)"false");
            callbackImpl.setUIContext((Map)uiContext);
            final ExtGuiExecutor executor = new ExtGuiExecutor(rptInfo.getContent(), (IExtRuntimeDataProvider)callbackImpl, false);
            KDFrame display = executor.executeWithinWindow();
            display.setAlwaysOnTop(true);
            executor.getSpreadContext().getSpread().setEditable(true);
            display.addWindowListener((WindowListener)new WindowAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void windowClosed(WindowEvent e) {
                    FileOutputStream out = null;
                    try {
                        book.addCloudDemoData(executor.getSpreadContext().getBook());
                        String schedule = MobileTemplateUtil.loadExtMobileRptScheduleDefine(rptId);
                        if (schedule != null) {
                            book.setUserObject("EXTReportScheduleModelString", (Object)schedule);
                        }
                        book.setUserObject("ExtCloudRptSourceEASUuid", (Object)rptId);
                        out = new FileOutputStream(file);
                        out.write(DefaultExtStatisticsRunner.innerMacroDefine(null, new KdsToBook().load(DefaultExtStatisticsRunner.innerlinkDS(null, BookIOUtil.pack((Book)book)))));
                        out.flush();
                        CloudReportMaker.this.initContent();
                        CloudReportMaker.this.fileChooser.setSelectedFile(file.getParentFile());
                        MessageUtil.msgboxInfo((Component)((Object)CloudReportMaker.this.ui), (String)("\u4e91\u62a5\u8868\u5236\u4f5c\u5b8c\u6210\uff0c\u672c\u6b21\u4fdd\u5b58\u8def\u5f84\u4e3a\uff1a" + file.getAbsolutePath()));
                    }
                    catch (Throwable th) {
                        try {
                            th.printStackTrace();
                            MessageUtil.msgboxWarning((Component)((Object)CloudReportMaker.this.ui), (String)"\u4e91\u62a5\u8868\u5236\u4f5c\u5931\u8d25\uff0c\u8bf7\u53c2\u8003\u9519\u8bef\u65e5\u5fd7\u3002");
                        }
                        catch (Throwable throwable) {
                            CloseUtil.close((Closeable[])new Closeable[]{out});
                            throw throwable;
                        }
                        CloseUtil.close((Closeable[])new Closeable[]{out});
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{out});
                    frame.setGlassPane(CloudReportMaker.this.sourceGlassPane);
                    frame.getGlassPane().setVisible(false);
                    CloudReportMaker.this.doExport();
                }
            });
        }
        catch (Throwable th) {
            th.printStackTrace();
            MessageUtil.msgboxWarning((Component)((Object)this.ui), (String)"\u4e91\u62a5\u8868\u5236\u4f5c\u5931\u8d25\uff0c\u8bf7\u53c2\u8003\u9519\u8bef\u65e5\u5fd7\u3002");
            frame.setGlassPane(this.sourceGlassPane);
            frame.getGlassPane().setVisible(false);
        }
    }

    private void init() {
        KDToolBar toolBar = new KDToolBar();
        toolBar.add((Action)new AbstractAction("\u5207\u6362\u5230\u79fb\u52a8\u62a5\u8868\u89c6\u56fe"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudReportMaker.this.isMobile = !CloudReportMaker.this.isMobile;
                if (CloudReportMaker.this.isMobile) {
                    this.putValue("Name", "\u5207\u6362\u5230\u684c\u9762\u62a5\u8868\u89c6\u56fe");
                } else {
                    this.putValue("Name", "\u5207\u6362\u5230\u79fb\u52a8\u62a5\u8868\u89c6\u56fe");
                }
                CloudReportMaker.this.initContent();
            }
        });
        this.addToolBar((JToolBar)toolBar);
        this.initContent();
        this.setTitle("\u4e91\u62a5\u8868\u5236\u4f5c");
        this.setModal(true);
        this.setResizable(false);
        this.fileChooser = new KDFileChooser();
        this.fileChooser.setDialogType(1);
        this.fileChooser.setDialogTitle("\u9009\u62e9\u4e91\u62a5\u8868\u4fdd\u5b58\u8def\u5f84");
        this.fileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "\u4e91\u62a5\u8868\u6570\u636e\u6587\u4ef6";
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".cloudkds");
            }
        });
    }

    private void initContent() {
        this.getContentPane().removeAll();
        try {
            DefObj[] defs;
            String selectedTreeNode = "";
            if (this.reportSelector != null && (defs = (DefObj[])this.reportSelector.getData()) != null && defs.length > 0) {
                selectedTreeNode = (String)defs[0].getProperty("systemID");
            }
            this.reportSelector = new SelectedReportSingleUI(ExtCallbackImpl.class.getName(), false);
            this.reportSelector.setSelectedTreeNode(selectedTreeNode);
            this.reportSelector.setIsMobile(this.isMobile);
            this.reportSelector.initLayout();
            this.reportSelector.onLoad();
            this.getContentPane().add((Component)((Object)this.reportSelector));
            this.setSize((int)this.reportSelector.getSize().getWidth(), (int)this.reportSelector.getSize().getHeight());
        }
        catch (Exception e) {
            logger.error((Object)"init report selector fail", (Throwable)e);
        }
        this.getContentPane().validate();
    }
}

