/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.command.ICommand;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.bos.ctrl.kds.expans.model.data.FieldPermission;
import com.kingdee.bos.ctrl.kds.expans.model.data.ReportFieldUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ReportFields;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.data.PermissionType;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.eas.rpts.sumreport.client.task.statusMgr.IntList;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TableManager {
    private static final String CONNECTOR = ".";

    public static void rowSelected(KDTable kDTable_List, String[] selectedIDs) {
        if (null == selectedIDs || selectedIDs.length <= 0) {
            return;
        }
        ArrayList<String> lstSelected = new ArrayList<String>();
        int rowCount = kDTable_List.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                HashMap map = (HashMap)kDTable_List.getRow(i).getUserObject();
                String fid = CtrlReportUtil.getObjectString(map.get("fid"));
                if (!TableManager.exitsSelectedRow(fid, selectedIDs)) continue;
                lstSelected.add(String.valueOf(i));
            }
        }
        TableManager.setTableSelected(kDTable_List, lstSelected);
    }

    public static void rowSelected(KDTable kDTable_List, String[] selectedIDs, String keyField) {
        if (null == selectedIDs || selectedIDs.length <= 0) {
            return;
        }
        kDTable_List.getSelectManager().removeAll();
        ArrayList<String> lstSelected = new ArrayList<String>();
        int rowCount = kDTable_List.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                HashMap map = (HashMap)kDTable_List.getRow(i).getUserObject();
                String fid = CtrlReportUtil.getObjectString(map.get(keyField.toLowerCase()));
                if (!TableManager.exitsSelectedRow(fid, selectedIDs)) continue;
                lstSelected.add(String.valueOf(i));
            }
        }
        TableManager.setTableSelected(kDTable_List, lstSelected);
    }

    private static boolean exitsSelectedRow(String fid, String[] selectedIDs) {
        boolean flag = false;
        for (int i = 0; i < selectedIDs.length; ++i) {
            String id = selectedIDs[i];
            if (!id.equals(fid)) continue;
            return true;
        }
        return flag;
    }

    public static final void setTableSelected(final KDTable table, ArrayList lstSelected) {
        for (int i = 0; i < lstSelected.size(); ++i) {
            final int rowIndex = Integer.parseInt(CtrlReportUtil.getObjectString(lstSelected.get(i)));
            if (table.getRow(rowIndex) == null) continue;
            table.getSelectManager().add(rowIndex, 0);
            table.getLayoutManager().addCommand(new ICommand(){

                public void execute() {
                    table.scrollToVisible(rowIndex, 0);
                }

                public boolean isReversible() {
                    return false;
                }

                public void unexecute() {
                }
            });
        }
    }

    public static final ArrayList getSelectedTableIndexs(KDTable kt) {
        ArrayList<String> lst = new ArrayList<String>();
        ArrayList blocks = kt.getSelectManager().getBlocks();
        int size = blocks.size();
        if (size == 1) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int i = top; i <= bottom; ++i) {
                lst.add(String.valueOf(i));
            }
        } else if (size > 1) {
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
                int top = block.getTop();
                int bottom = block.getBottom();
                for (int n = top; n <= bottom; ++n) {
                    lst.add(String.valueOf(n));
                }
            }
        }
        lst.trimToSize();
        return lst;
    }

    public static final int[] getSelectedTableIndexs2(KDTable kt) {
        IntList lst;
        block4: {
            int size;
            ArrayList blocks;
            block3: {
                lst = new IntList();
                blocks = kt.getSelectManager().getBlocks();
                size = blocks.size();
                if (size != 1) break block3;
                KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
                int top = block.getTop();
                int bottom = block.getBottom();
                for (int i = top; i <= bottom; ++i) {
                    lst.add(i);
                }
                break block4;
            }
            if (size <= 1) break block4;
            for (int i = 0; i < size; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
                int top = block.getTop();
                int bottom = block.getBottom();
                for (int n = top; n <= bottom; ++n) {
                    lst.add(n);
                }
            }
        }
        return lst.toArray();
    }

    public static final boolean isExistRowData(KDTable selectedTable, String valueField, String currentValue) {
        for (int i = 0; i < selectedTable.getRowCount(); ++i) {
            IRow row = selectedTable.getRow(i);
            HashMap map = (HashMap)row.getUserObject();
            String value = CtrlReportUtil.getObjectString(map.get(valueField));
            if (!value.equals(currentValue)) continue;
            return true;
        }
        return false;
    }

    public static final void removeExistData(KDTable selectedTable, String valueField, String currentValue) {
        for (int i = 0; i < selectedTable.getRowCount(); ++i) {
            IRow row = selectedTable.getRow(i);
            HashMap map = (HashMap)row.getUserObject();
            String value = CtrlReportUtil.getObjectString(map.get(valueField));
            if (!value.equals(currentValue)) continue;
            selectedTable.removeRow(i);
        }
    }

    public static final void insertToTable(KDTable selectedTable, String valueField, HashMap mapData, Object[] values) {
        TableManager.insertToTable(selectedTable, valueField, mapData, values, true);
    }

    public static final void insertToTable(KDTable selectedTable, String valueField, HashMap mapData, Object[] values, boolean isLocked) {
        if (null != valueField) {
            String valueField_value = CtrlReportUtil.getObjectString(mapData.get(valueField));
            TableManager.removeExistData(selectedTable, valueField, valueField_value);
        }
        IRow irow = selectedTable.addRow();
        irow.getStyleAttributes().setLocked(isLocked);
        for (int i = 0; i < values.length; ++i) {
            irow.getCell(i).setValue(values[i]);
        }
        irow.setUserObject((Object)mapData);
    }

    public static final void removeRow(KDTable table, boolean isConfirm, String message) {
        ArrayList listSelect = TableManager.getSelectedTableIndexs(table);
        if (listSelect.isEmpty()) {
            return;
        }
        if (isConfirm) {
            if (message == null) {
                message = "\u786e\u5b9a\u79fb\u9664\uff1f";
            }
            if (!MessageUtil.showConfirm(message, false)) {
                return;
            }
        }
        int size = listSelect.size();
        for (int i = size - 1; i >= 0; --i) {
            int iR = Integer.parseInt(listSelect.get(i).toString());
            table.removeRow(iR);
        }
        table.getSelectManager().removeAll();
    }

    public static List<ReportFields> getDefinedFields(String reportId, Book book) throws Exception {
        String fieldXml = (String)book.getUserObjectValue("FIELD_PERMISSION_DEFINED");
        if (StringUtil.isEmptyString((String)fieldXml)) {
            return new ArrayList<ReportFields>();
        }
        return ReportFieldUtil.fromXml((String)fieldXml);
    }

    public static void setTableReportField(KDTable tableField, String reportId, Map<String, List<FieldPermission>> mapFieldValue) {
        tableField.removeRows();
        List<FieldPermission> fieldPList = mapFieldValue.get(reportId);
        Iterator<FieldPermission> iter = fieldPList.iterator();
        while (iter.hasNext()) {
            IRow row = tableField.addRow();
            FieldPermission fieldP = iter.next();
            StringBuffer fieldName = new StringBuffer();
            row.getCell(0).setValue((Object)fieldName.append(fieldP.getDataSetAlias()).append(CONNECTOR).append(fieldP.getFieldAlias()));
            row.getCell(1).setValue((Object)fieldP.isHasPermission());
        }
    }

    public static void setTableReportField(KDTable tableField, List<ReportFields> fieldsList, String reportId, Book book, Map<String, List<FieldPermission>> mapFieldValue) throws Exception {
        tableField.removeRows();
        if (fieldsList == null || fieldsList.isEmpty()) {
            return;
        }
        ArrayList<FieldPermission> fieldPList = new ArrayList<FieldPermission>();
        for (int i = 0; i < fieldsList.size(); ++i) {
            ReportFields fields = fieldsList.get(i);
            ExtDataSet datsSet = TableManager.getDataSetAliasById(fields.getDataSetId(), book);
            String dataSetAlias = datsSet.getAlias();
            Iterator fieldNameIter = fields.getFieldNames().iterator();
            while (fieldNameIter.hasNext()) {
                IRow row = tableField.addRow();
                String fieldName = (String)fieldNameIter.next();
                String fieldAlias = TableManager.getFieldAlias(datsSet, fieldName);
                row.getCell(0).setValue((Object)(dataSetAlias + CONNECTOR + fieldAlias));
                row.getCell(1).setValue((Object)Boolean.TRUE);
                FieldPermission fieldP = new FieldPermission();
                fieldP.setReportId(reportId);
                fieldP.setDataSetId(fields.getDataSetId());
                fieldP.setFieldName(fieldName);
                fieldP.setHasPermission(Boolean.TRUE.booleanValue());
                fieldP.setDataSetAlias(dataSetAlias);
                fieldP.setFieldAlias(fieldAlias);
                fieldPList.add(fieldP);
            }
        }
        if (!fieldPList.isEmpty()) {
            mapFieldValue.put(reportId, fieldPList);
        }
    }

    private static ExtDataSet getDataSetAliasById(String dataSetId, Book book) {
        ExtDataSetManager manager = book.getDataSetManager();
        for (int i = manager.size() - 1; i >= 0; --i) {
            if (!dataSetId.equals(ReportFieldUtil.getDataSetId((String)manager.getAt(i).getDefine()))) continue;
            return manager.getAt(i);
        }
        return null;
    }

    private static String getFieldAlias(ExtDataSet dataSet, String fieldName) {
        for (int j = dataSet.getColumnCount() - 1; j >= 0; --j) {
            ExtColumn col = dataSet.getColumnsArray()[j];
            if (!fieldName.equals(col.getName())) continue;
            return col.getAlias();
        }
        return "";
    }

    public static String getCurrentReportId(KDTable tableAccReport, String key) {
        IRow row = tableAccReport.getRow(tableAccReport.getSelectManager().getActiveRowIndex());
        if (row == null) {
            return "";
        }
        HashMap map = (HashMap)row.getUserObject();
        return (String)map.get(key);
    }

    private static List<FieldPermission> getPermissionFieldByReportId(String reportId, Book book, HashMap userObject, List<ReportFields> fieldsList) throws Exception {
        FieldPermission fieldP;
        StringBuilder sql = new StringBuilder();
        PermissionType objectType = PermissionType.getPermissionType(CtrlReportUtil.getObjectString(userObject.get("fpermissiontype")));
        switch (objectType.intValue()) {
            case 0: {
                sql.append("select * from T_EXT_FPermission where FReportId='").append(reportId).append("' and ").append("FUserId='").append(userObject.get("fuserid")).append("' and FOrgid='").append(userObject.get("forgid")).append("'");
                break;
            }
            case 1: {
                sql.append("select * from T_EXT_FPermission where FReportId='").append(reportId).append("' and ").append("FRoleId='").append(userObject.get("froleid")).append("'");
                break;
            }
            case 2: {
                sql.append("select * from T_EXT_FPermission where FReportId='").append(reportId).append("' and ").append("FUserId='").append(userObject.get("fuserid")).append("'");
            }
        }
        ArrayList<FieldPermission> fieldPList = new ArrayList<FieldPermission>();
        IRowSet rowSet = ExtDBUtil.executeQuery(null, sql.toString(), null);
        while (rowSet != null && rowSet.next()) {
            fieldP = new FieldPermission();
            fieldP.setReportId(rowSet.getString("FReportId"));
            fieldP.setDataSetId(rowSet.getString("FDataSetId"));
            fieldP.setFieldName(rowSet.getString("FFieldName"));
            fieldP.setHasPermission(rowSet.getInt("FHasPermission") == 1);
            ExtDataSet datsSet = TableManager.getDataSetAliasById(fieldP.getDataSetId(), book);
            if (null != datsSet) {
                fieldP.setDataSetAlias(datsSet.getAlias());
                fieldP.setFieldAlias(TableManager.getFieldAlias(datsSet, fieldP.getFieldName()));
            }
            fieldPList.add(fieldP);
        }
        if (fieldPList.isEmpty()) {
            for (int i = 0; i < fieldsList.size(); ++i) {
                ReportFields fields = fieldsList.get(i);
                ExtDataSet datsSet = TableManager.getDataSetAliasById(fields.getDataSetId(), book);
                String dataSetAlias = datsSet.getAlias();
                for (String fieldName : fields.getFieldNames()) {
                    fieldP = new FieldPermission();
                    fieldP.setReportId(reportId);
                    fieldP.setDataSetId(fields.getDataSetId());
                    fieldP.setDataSetAlias(dataSetAlias);
                    fieldP.setFieldName(fieldName);
                    fieldP.setHasPermission(Boolean.TRUE.booleanValue());
                    fieldP.setFieldAlias(TableManager.getFieldAlias(datsSet, fieldName));
                    fieldPList.add(fieldP);
                }
            }
        }
        return fieldPList;
    }

    public static boolean updateFieldPermission(Map<String, List<FieldPermission>> mapFieldValue, int permissionType, ArrayList<String> fidList) throws BOSException {
        RptParams params = new RptParams();
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.permission.FieldPermissionDAO");
        params.setString("MethodName", "updateFieldPermission");
        params.setObject("field_permission_list", mapFieldValue);
        params.setInt("fpermissiontype", permissionType);
        params.setObject("fid_list", fidList);
        params = FacadeFactory.commonExecute(null, params);
        return params.getBoolean("update_success");
    }

    public static void setTableReportField(KDTable selectedTable, KDTable tableReportField) {
        tableReportField.removeRows();
        String reportId = TableManager.getCurrentReportId(selectedTable, "freportid");
        List<FieldPermission> fieldPList = null;
        if (StringUtil.isEmptyString((String)reportId)) {
            return;
        }
        HashMap userObject = (HashMap)selectedTable.getRow(selectedTable.getSelectManager().getActiveRowIndex()).getUserObject();
        try {
            DefineReportInfo reportInfo = DefineReportBO.getReportInfo(null, reportId);
            Book book = BookIOUtil.unpack((byte[])reportInfo.getContent());
            List<ReportFields> fieldsList = TableManager.getDefinedFields(reportId, book);
            fieldPList = TableManager.getPermissionFieldByReportId(reportId, book, userObject, fieldsList);
        }
        catch (Exception e1) {
            System.out.println("\u83b7\u53d6\u62a5\u8868\u5b57\u6bb5\u6743\u9650\u5931\u8d25\uff01");
            e1.printStackTrace();
        }
        if (fieldPList == null || fieldPList.isEmpty()) {
            return;
        }
        for (FieldPermission fieldP : fieldPList) {
            Object[] values = new Object[]{fieldP.getDataSetAlias() + CONNECTOR + fieldP.getFieldAlias(), fieldP.isHasPermission()};
            TableManager.insertToTable(tableReportField, null, new HashMap(), values);
        }
    }

    public static void setFieldValue(KDTable table, boolean value) {
        for (int i = table.getRowCount() - 1; i >= 0; --i) {
            table.getRow(i).getCell(1).setValue((Object)value);
        }
    }
}

