/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.audittool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.DefineReportInfo;
import com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditDAO;
import com.kingdee.eas.rpts.ctrlreport.data.PublishType;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportAuditUtil {
    private static final Logger log = CommonLogger.getLogger(ReportAuditUtil.class);

    public static synchronized void updateAuditTable(Context ctx, DefineReportInfo info, long executeTime, int deployType) {
        RptParams params = new RptParams();
        params.setInt("deployType", deployType);
        params.setObject("reportInfo", (Object)info);
        params.setLong("executeTime", executeTime);
        if (ctx != null) {
            ReportAuditDAO dao = new ReportAuditDAO();
            dao.updateAuditTable(ctx, params);
            return;
        }
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditDAO");
        params.setString("MethodName", "updateAuditTable");
        try {
            FacadeFactory.commonExecute(null, params);
        }
        catch (BOSException e) {
            log.info((Object)("\u66f4\u65b0\u62a5\u8868(" + info.getName() + ")\u7edf\u8ba1\u7ed3\u679c\u5931\u8d25\uff01"), (Throwable)e);
        }
    }

    public static boolean isDeployReport(DefineReportInfo info) {
        return PublishType.isPublished(info);
    }

    public static int getPathType(Map map) {
        int pathType = 0;
        pathType = "com.kingdee.eas.rpts.ctrlreport.client.ReportStudioUI".equals(map.get("managerUiName")) ? 4 : ("com.kingdee.eas.rpts.ctrlreport.client.ExtReportManageUI".equals(map.get("managerUiName")) ? 5 : ("com.kingdee.eas.rpts.ctrlreport.client.ExtReportManageStdUI".equals(map.get("managerUiName")) ? 6 : 1));
        return pathType;
    }

    public static synchronized void insertAuditExport(Context ctx, DefineReportInfo info, long executeTime, int deployType) {
        long exportTime = System.currentTimeMillis();
        RptParams params = new RptParams();
        params.setObject("reportInfo", (Object)info);
        params.setInt("deployType", deployType);
        params.setLong("exportTime", exportTime);
        params.setLong("executeTime", executeTime);
        if (ctx != null) {
            ReportAuditDAO dao = new ReportAuditDAO();
            dao.insertAuditExport(ctx, params);
            return;
        }
        params.setString("FullName", "com.kingdee.eas.rpts.ctrlreport.audittool.ReportAuditDAO");
        params.setString("MethodName", "insertAuditExport");
        try {
            FacadeFactory.commonExecute(null, params);
        }
        catch (BOSException e) {
            log.info((Object)("\u66f4\u65b0\u62a5\u8868(" + info.getName() + ")\u7edf\u8ba1\u7ed3\u679c\u5931\u8d25\uff01"), (Throwable)e);
        }
    }
}

