/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.bo;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlreport.AttemperProxyInfo;
import com.kingdee.eas.rpts.ctrlreport.IReportAttemper;
import com.kingdee.eas.rpts.ctrlreport.ReportAttemperFactory;
import com.kingdee.eas.rpts.ctrlreport.ReportAttemperInfo;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.model.ExtDBUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ReportAttemperBO {
    private static Logger log = LogUtil.getPackageLogger(ReportAttemperBO.class);
    private static String beanFullName = "com.kingdee.eas.rpts.ctrlreport.app.ReportAttemperControllerBean";
    private static final String JobNamePre = "\u6269\u5c55\u62a5\u8868_";

    public static ArrayList getReportAttemperList(Context ctx) throws BOSException, SQLException {
        String strOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(strOrgID);
        String strLocal = SysContext.getSysContext().getLocale().toString();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.FID, s.FReportID, d.FDeployPath, s.FJobProcessDefID, j.ftitle, ");
        sbSQL.append("s.Fname_").append(strLocal).append(" as attempername, ");
        sbSQL.append("s.FMemo_").append(strLocal).append(" as memo, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as reportname, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("s.fcreatorid, s.FCreateTime, s.FLastUpdateUserID, s.flastupdatetime ");
        sbSQL.append("from T_EXT_ReportAttemper s ");
        sbSQL.append("LEFT OUTER JOIN T_BAS_DefineReport d on s.freportid = d.fid ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on s.FCreatorID = u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_JOB_DEF j on s.FJobProcessDefID = j.fjobdefid ");
        sbSQL.append("where s.FOrgID = ? ");
        sbSQL.append("order by s.flastupdatetime desc");
        log.debug((Object)("getReportAttemperList sql = " + sbSQL.toString()));
        return ExtDBUtil.getResultListBySql(ctx, sbSQL.toString(), queryValue);
    }

    public static HashMap getReportAttemperInfoByID(Context ctx, String fid, String strLocal) throws BOSException, SQLException {
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(fid);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select s.FID, s.FReportID, s.FFilterXml, s.FJobProcessDefID, s.FMsgSendType, s.FIsTakeFile, s.FSaveType, s.FEmail, s.FSendMail, s.FLang, ");
        sbSQL.append("s.FLang, d.fsystemid, d.forgid, '-1' as fsnaptype, j.ftitle, ");
        sbSQL.append("d.Fname_").append(strLocal).append(" as reportname ");
        sbSQL.append("from T_EXT_ReportAttemper s ");
        sbSQL.append("LEFT OUTER JOIN T_BAS_DefineReport d on s.freportid = d.fid ");
        sbSQL.append("LEFT OUTER JOIN T_JOB_DEF j on s.FJobProcessDefID = j.fjobdefid ");
        sbSQL.append("where s.fid = ? ");
        log.debug((Object)("getReportAttemperInfoByID sql = " + sbSQL.toString()));
        return ExtDBUtil.getResultMapBySql(ctx, sbSQL.toString(), queryValue);
    }

    public static ArrayList getAttemperProxyList(Context ctx, String attemperID, String strLocal) throws BOSException, SQLException {
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(attemperID);
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append("select a.FID, a.FAttemperID, a.FUserID, a.FOrgID, ");
        sbSQL.append("u.Fname_").append(strLocal).append(" as user_name, ");
        sbSQL.append("org.Fname_").append(strLocal).append(" as orgname ");
        sbSQL.append("from T_EXT_AttemperProxy a ");
        sbSQL.append("LEFT OUTER JOIN t_pm_user u on a.FUserID = u.fid ");
        sbSQL.append("LEFT OUTER JOIN T_ORG_BaseUnit org on a.FOrgID=org.fid ");
        sbSQL.append("where FAttemperID = ? ");
        return ExtDBUtil.getResultListBySql(ctx, sbSQL.toString(), queryValue);
    }

    public static synchronized HashMap getJobInstInfo(Context ctx, String fJobProcessDefID) throws BOSException, SQLException {
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(fJobProcessDefID);
        String sql = "select fjobinstid from  t_job_inst where fstate = 'Running' and fjobdefid = ?";
        log.debug((Object)("getJobInstInfo sql = " + sql));
        return ExtDBUtil.getResultMapBySql(ctx, sql, queryValue);
    }

    public static ArrayList getReportAttemperByReportID(Context ctx, String reportID) throws BOSException {
        String sql = "select fid from T_EXT_ReportAttemper where FReportID = ?";
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(reportID);
        return ExtDBUtil.getResultListBySql(ctx, sql, queryValue);
    }

    public static ReportAttemperInfo getReportAttemperInfo(Context ctx, String fid) throws BOSException, SQLException, EASBizException {
        IReportAttemper factory = null;
        factory = ctx == null ? ReportAttemperFactory.getRemoteInstance() : ReportAttemperFactory.getLocalInstance(ctx);
        ReportAttemperInfo info = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)fid, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection collection = factory.getCollection(entityViewInfo);
        if (collection != null && !collection.isEmpty()) {
            info = (ReportAttemperInfo)collection.get(0);
        }
        return info;
    }

    public static boolean isexist(Context ctx, String strId, String fname, String strLocal) throws BOSException {
        ArrayList<String> queryValue = new ArrayList<String>();
        StringBuffer sbSQL = new StringBuffer();
        String fOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (strId.length() == 0) {
            sbSQL.append("SELECT FID FROM T_EXT_ReportAttemper WHERE fOrgID = ? And ");
            sbSQL.append("FName_").append(strLocal).append(" = ?");
            queryValue.add(fOrgID);
            queryValue.add(fname);
        } else {
            sbSQL.append("SELECT FID FROM T_EXT_ReportAttemper WHERE fid <> ? And fOrgID = ? And ");
            sbSQL.append("FName_").append(strLocal).append(" = ?");
            queryValue.add(strId);
            queryValue.add(fOrgID);
            queryValue.add(fname);
        }
        RptParams pr = new RptParams();
        pr.setString("MethodName", "exitsRecordBySQL");
        pr.setString("sql", sbSQL.toString());
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
        return ps_r.getBoolean("flag");
    }

    public static boolean isexistJobDef(String fTitle) throws BOSException {
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(fTitle);
        String sql = "SELECT fjobdefid FROM T_JOB_DEF WHERE fTitle = ?";
        RptParams pr = new RptParams();
        pr.setString("MethodName", "exitsRecordBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(null, pr);
        return ps_r.getBoolean("flag");
    }

    public static String insert(ReportAttemperInfo info, AttemperProxyInfo[] proxyInfos) throws BOSException, EASBizException {
        return ReportAttemperBO.insert(null, info, proxyInfos);
    }

    private static String insert(Context ctx, ReportAttemperInfo attemperInfo, AttemperProxyInfo[] proxyInfos) throws BOSException {
        RptParams pr = new RptParams();
        pr.setObject("FullName", (Object)beanFullName);
        pr.setObject("MethodName", (Object)"insert");
        pr.setObject("ReportAttemperInfo", (Object)attemperInfo);
        pr.setObject("AttemperProxyInfos", (Object)proxyInfos);
        RptParams pr_r = FacadeFactory.commonExecuteRequired(ctx, pr);
        String newPKID = pr_r.getString("Flag");
        return newPKID;
    }

    public static void updateByJob(String fid, ReportAttemperInfo info) throws BOSException, EASBizException {
        IReportAttemper factory = ReportAttemperFactory.getRemoteInstance();
        BOSUuid bid = BOSUuid.read((String)fid);
        ObjectUuidPK pK = new ObjectUuidPK("id", bid);
        info.setId(bid);
        factory.update((IObjectPK)pK, info);
    }

    public static void update(String fid, ReportAttemperInfo info, AttemperProxyInfo[] proxyInfos) throws BOSException, EASBizException {
        BOSUuid bid = BOSUuid.read((String)fid);
        info.setId(bid);
        ReportAttemperBO.update(info, proxyInfos);
    }

    private static void update(ReportAttemperInfo attemperInfo, AttemperProxyInfo[] proxyInfos) throws BOSException {
        RptParams pr = new RptParams();
        pr.setObject("FullName", (Object)beanFullName);
        pr.setObject("MethodName", (Object)"update");
        pr.setObject("ReportAttemperInfo", (Object)attemperInfo);
        pr.setObject("AttemperProxyInfos", (Object)proxyInfos);
        FacadeFactory.commonExecuteRequired(null, pr);
    }

    private static void delete(ReportAttemperInfo[] attemperInfos) throws BOSException {
        RptParams pr = new RptParams();
        pr.setObject("FullName", (Object)beanFullName);
        pr.setObject("MethodName", (Object)"delete");
        pr.setObject("ReportAttemperInfos", (Object)attemperInfos);
        FacadeFactory.commonExecuteRequired(null, pr);
    }

    public static void delete(ArrayList lstInfo) throws BOSException, EASBizException {
        ReportAttemperInfo[] attemperInfos = new ReportAttemperInfo[lstInfo.size()];
        for (int i = 0; i < lstInfo.size(); ++i) {
            HashMap mapInfo = (HashMap)lstInfo.get(i);
            String fid = mapInfo.get("fid").toString();
            String jobProcessDefID = CtrlReportUtil.getObjectString(mapInfo.get("fjobprocessdefid"));
            ReportAttemperInfo attemperInfo = new ReportAttemperInfo();
            attemperInfo.setId(BOSUuid.read((String)fid));
            if (!jobProcessDefID.equals("")) {
                attemperInfo.setJobProcessDefID(jobProcessDefID);
            }
            attemperInfos[i] = attemperInfo;
        }
        ReportAttemperBO.delete(attemperInfos);
    }

    private static EASWfServiceClient getWorkflowClient() throws BOSException {
        EASWfServiceClient workflowClient = new EASWfServiceClient();
        workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        return workflowClient;
    }

    private static final FunctionObjectInfo getFunction() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.rpts.ctrlreport.app.ReportAttemperFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }

    private static final OperationInfo getOperationInfo(FunctionObjectInfo function) {
        OperationCollection operCols = function.getOperation();
        OperationInfo operation = null;
        operation = operCols.get(0);
        return operation;
    }

    public static boolean release(String[] arrID) throws EASBizException, BOSException, SQLException {
        EASWfServiceClient workflowClient = ReportAttemperBO.getWorkflowClient();
        FunctionObjectInfo function = ReportAttemperBO.getFunction();
        OperationInfo operation = ReportAttemperBO.getOperationInfo(function);
        for (int i = 0; i < arrID.length; ++i) {
            String fid = arrID[i];
            ReportAttemperInfo infoDetail = ReportAttemperBO.getReportAttemperInfo(null, fid);
            String jobDefName = JobNamePre + infoDetail.getName();
            int intCount = ReportAttemperBO.getJobDefCount(jobDefName);
            if (intCount > 0) {
                boolean flagExist;
                while (flagExist = ReportAttemperBO.isexistJobDef(jobDefName = jobDefName + intCount)) {
                    ++intCount;
                }
            }
            String jobProcessDefID = ReportAttemperBO.insertJobProcessDef(workflowClient, function, operation, infoDetail.getId().toString(), jobDefName, infoDetail.getScheduleXml(), infoDetail.getLang());
            ReportAttemperInfo updateInfo = new ReportAttemperInfo();
            updateInfo.setJobProcessDefID(jobProcessDefID);
            ReportAttemperBO.updateByJob(fid, updateInfo);
        }
        return true;
    }

    public static int getJobDefCount(String fTitle) throws BOSException, SQLException, EASBizException {
        int intRet = 0;
        ArrayList<String> queryValue = new ArrayList<String>();
        queryValue.add(fTitle);
        String sql = "select count(*) as totalcount from T_JOB_DEF where ftitle = ?";
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getInfoMapBySQL");
        pr.setString("sql", sql);
        pr.setObject("lstValue", queryValue);
        RptParams ps_r = FacadeFactory.commonExecuteNever(null, pr);
        HashMap map = (HashMap)ps_r.getObject("object");
        String strCount = CtrlReportUtil.getObjectString(map.get("totalcount"));
        if (!strCount.equals("")) {
            intRet = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("totalcount")));
        }
        return intRet;
    }

    private static String insertJobProcessDef(EASWfServiceClient workflowClient, FunctionObjectInfo function, OperationInfo operation, String fid, String name, String scheduleXml, String strLocal) throws BOSException {
        HashMap<String, String> jobContext = new HashMap<String, String>();
        jobContext.put("id", fid);
        jobContext.put("strLocal", strLocal);
        String jobProcessDefID = workflowClient.createJobProcessDef(name, function, operation, jobContext, scheduleXml, SysContext.getSysContext().getLocale());
        return jobProcessDefID;
    }

    public static void updateJobProcessDef(String procDefId, String scheduleXml) throws BOSException {
        EASWfServiceClient workflowClient = ReportAttemperBO.getWorkflowClient();
        workflowClient.updateProcessSchedule(procDefId, scheduleXml);
    }

    public static void setJobHolderNull(String procDefId) {
        try {
            RptParams pr = new RptParams();
            ArrayList<String> queryValue = new ArrayList<String>();
            queryValue.add(procDefId);
            String sql = "update T_JOB_TRIGGER set fholderid = null where fjobdefid = ?";
            pr.setString("sql", sql);
            pr.setObject("lstValue", queryValue);
            pr.setString("MethodName", "maintainRecord");
            ReportFacadeFactory.getRemoteInstance().commonExecute(pr);
        }
        catch (Exception e) {
            log.error((Object)"setJobHolderNull", (Throwable)e);
        }
    }
}

