/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.rpts.ctrlreport.client.NodeClickListener2;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;
import javax.swing.Icon;

public class CellTreeNode2 {
    public static final int TREE_LEVEL_MARK = 255;
    public static final int COLLAPSE_MARK = 256;
    public static final int INITIAL_VALUE = 13312;
    public static final int TREE_TYPE = 65536;
    public static final int TREE_DUMMYMODEL = 131072;
    public static final int TREE_HASCHILDREN = 262144;
    private int mark = 13312;
    private Object value;
    private HashSet clickListeners;
    private static final String SPAN = "   ";
    private int x = 0;
    private int y = 0;
    private int iconWidth = 0;
    private Icon icon = null;
    private ICell cell;
    private KDTable table;
    boolean isSetLastNode = false;
    boolean isLastNode = true;

    public CellTreeNode2(KDTable table, ICell cell) {
        this.table = table;
        this.cell = cell;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public int getTreeLevel() {
        return this.getTreeLevel(this.mark);
    }

    public void setTreeLevel(int newValue) {
        this.mark = this.setTreeLevel(this.mark, newValue);
    }

    public boolean isCollapse() {
        return this.isCollapse(this.mark);
    }

    public void setCollapse(boolean newValue) {
        this.mark = this.setCollapse(this.mark, newValue);
    }

    public boolean isHasChildren() {
        return this.isHasChildren(this.mark);
    }

    public void setHasChildren(boolean newValue) {
        this.mark = this.setHasChildren(this.mark, newValue);
    }

    public boolean isVirtualModel() {
        return this.isDummyModel(this.mark);
    }

    public void setVirtualModel(boolean newValue) {
        this.mark = this.setDummyModel(this.mark, newValue);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int level = this.getTreeLevel();
        for (int i = 0; i < level; ++i) {
            sb.append(SPAN);
        }
        if (this.getValue() != null) {
            sb.append(this.getValue().toString());
        }
        return sb.toString();
    }

    public void doClick(KDTable table, EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            int px = mouseEvent.getX();
            int py = mouseEvent.getY();
            if (px >= this.x && px <= this.x + this.iconWidth && py >= this.y && py <= this.y + this.iconWidth) {
                this.doTreeClick(table);
                this.fireClick(table);
            }
        }
    }

    private void fireClick(KDTable table) {
        if (this.clickListeners == null) {
            return;
        }
        ICell cell2 = table.getEditManager().getEditCell();
        for (NodeClickListener2 listener : this.clickListeners) {
            listener.doClick(this, cell2);
        }
    }

    public void addClickListener(NodeClickListener2 listener) {
        if (this.clickListeners == null) {
            this.clickListeners = new HashSet();
        }
        this.clickListeners.add(listener);
    }

    public void doTreeClick(KDTable table) {
        this.doTreeClick(table, table.getEditManager().getEditCell());
    }

    public void doTreeClick(KDTable table, ICell cell2) {
        if (cell2 == null || cell2.getKDTCell() == null) {
            return;
        }
        ICell fcell = null;
        if (this.isHasChildren()) {
            boolean old = table.isRefresh();
            table.setRefresh(false);
            this.setCollapse(!this.isCollapse());
            int rowindex = 0;
            int colindex = cell2.getColumnIndex();
            for (rowindex = cell2.getRowIndex() + 1; rowindex >= 0 && rowindex < table.getRowCount() && this.getCellLevel(table, rowindex, colindex) > this.getTreeLevel(); ++rowindex) {
                if (this.isCollapse()) {
                    table.getRow(rowindex).getStyleAttributes().setHided(true);
                    continue;
                }
                fcell = this.getFatherRow(table.getCell(rowindex, cell2.getColumnIndex()), table);
                if (fcell != null) {
                    if (this.isCellCollapse(fcell)) {
                        table.getRow(rowindex).getStyleAttributes().setHided(true);
                        continue;
                    }
                    table.getRow(rowindex).getStyleAttributes().setHided(false);
                    continue;
                }
                table.getRow(rowindex).getStyleAttributes().setHided(false);
            }
            table.setRefresh(old);
            table.repaint();
        }
    }

    public boolean isLastNode() {
        if (this.isSetLastNode) {
            return this.isLastNode;
        }
        ICell fcell = null;
        for (int i = this.cell.getRowIndex() + 1; i < this.table.getRowCount(); ++i) {
            fcell = this.table.getCell(i, this.cell.getColumnIndex());
            if (this.getCellLevel(fcell) == this.getCellLevel(this.cell)) {
                this.isSetLastNode = true;
                this.isLastNode = false;
                return false;
            }
            if (this.getCellLevel(fcell) >= this.getCellLevel(this.cell)) continue;
            this.isSetLastNode = true;
            this.isLastNode = true;
            return true;
        }
        this.isSetLastNode = true;
        this.isLastNode = true;
        return true;
    }

    private ICell getFatherRow(ICell cell, KDTable table) {
        ICell fcell = null;
        for (int i = cell.getRowIndex() - 1; i >= 0 && this.getCellLevel(fcell = table.getCell(i, cell.getColumnIndex())) >= this.getCellLevel(cell); --i) {
        }
        return fcell;
    }

    private int getCellLevel(KDTable table, int r, int c) {
        IRow row = null;
        row = table.getRow(r);
        if (row != null) {
            ICell cell = row.getCell(c);
            return this.getCellLevel(cell);
        }
        return 0;
    }

    private int getCellLevel(ICell cell) {
        Object value;
        if (cell != null && (value = cell.getValue()) instanceof CellTreeNode2) {
            CellTreeNode2 node = (CellTreeNode2)value;
            return node.getTreeLevel();
        }
        return 0;
    }

    private boolean isCellCollapse(ICell cell) {
        Object value;
        if (cell != null && (value = cell.getValue()) instanceof CellTreeNode2) {
            CellTreeNode2 node = (CellTreeNode2)value;
            return node.isCollapse();
        }
        return false;
    }

    public void setIconPosition(int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.iconWidth = width;
    }

    private boolean isCollapse(int mark) {
        return (mark & 0x100) != 0;
    }

    private int setCollapse(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x100) : (mark &= 0xFFFFFEFF);
        return mark;
    }

    private int getTreeLevel(int mark) {
        return mark & 0xFF;
    }

    private int setTreeLevel(int mark, int treeLevel) {
        mark &= 0xFFFFFF00;
        return mark |= (treeLevel &= 0xFF);
    }

    private boolean isDummyModel(int mark) {
        return (mark & 0x20000) != 0;
    }

    private int setDummyModel(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x20000) : (mark &= 0xFFFDFFFF);
        return mark;
    }

    private boolean isHasChildren(int mark) {
        return (mark & 0x40000) != 0;
    }

    private int setHasChildren(int mark, boolean newValue) {
        mark = newValue ? (mark |= 0x40000) : (mark &= 0xFFFBFFFF);
        return mark;
    }
}

