/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.kdf.util.render.AbstractBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.rpts.ctrlreport.client.CellTreeNode2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.ImageIcon;

public class CellTreeRender3
extends AbstractBasicRender {
    private TextRender render_Text;
    private Color baseColor = Color.decode("#597197");
    private static ImageIcon groupHandlerImage = ResourceManager.getImageIcon((String)"group_handler_icon.png");

    public CellTreeRender3() {
        this.render_Text = new TextRender();
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        if (object instanceof CellTreeNode2) {
            int space;
            Graphics2D g2d = (Graphics2D)graphics;
            CellTreeNode2 cell = (CellTreeNode2)object;
            String text = cell.getValue() != null ? cell.getValue().toString() : "";
            int level = cell.getTreeLevel();
            Rectangle rect = clip.getBounds();
            int x = rect.x + level * 20;
            int y = rect.y + (rect.height - 12) / 2;
            graphics.setColor(Color.BLACK);
            Stroke stroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            Color color = g2d.getColor();
            g2d.setColor(this.baseColor);
            if (level != 0) {
                for (int i = 1; i <= level; ++i) {
                    int lineX = rect.x + i * 20;
                    if (i == level) {
                        if (cell.isLastNode()) {
                            this.drawDashedVerticalLine(graphics, lineX + 6, rect.y, rect.y + rect.height / 2);
                            this.drawDashedHorizontalLine(graphics, rect.y + rect.height / 2, lineX + 6, lineX + 18);
                            continue;
                        }
                        this.drawDashedVerticalLine(graphics, lineX + 6, rect.y, rect.y + rect.height);
                        this.drawDashedHorizontalLine(graphics, rect.y + rect.height / 2, lineX + 6, lineX + 18);
                        continue;
                    }
                    this.drawDashedVerticalLine(graphics, lineX + 6, rect.y, rect.y + rect.height);
                }
            }
            if (cell.isHasChildren()) {
                cell.setIconPosition(x, y, 12);
                if (cell.isCollapse()) {
                    groupHandlerImage.paintIcon(null, g2d, x, y);
                    g2d.drawLine(x + 6, y + 3, x + 6, y + 9);
                    g2d.drawLine(x + 3, y + 6, x + 9, y + 6);
                } else {
                    groupHandlerImage.paintIcon(null, g2d, x, y);
                    g2d.drawLine(x + 3, y + 6, x + 9, y + 6);
                }
                x = x + 12 + 8;
                if (cell.getIcon() != null) {
                    y = rect.y + (rect.height - cell.getIcon().getIconHeight()) / 2;
                    cell.getIcon().paintIcon(null, graphics, x, y);
                }
            } else {
                x = x + 12 + 8;
                if (cell.getIcon() != null) {
                    y = rect.y + (rect.height - cell.getIcon().getIconHeight()) / 2;
                    cell.getIcon().paintIcon(null, graphics, x, y);
                }
            }
            g2d.setColor(color);
            g2d.setStroke(stroke);
            if (cell.getIcon() != null) {
                space = level * 8 + 12 + cell.getIcon().getIconWidth() + 8;
                rect.setRect(x + cell.getIcon().getIconWidth() + 8, rect.y, rect.getWidth() - (double)space, rect.getHeight());
            } else {
                space = level * 8 + 12;
                rect.setRect(x, rect.y, rect.getWidth() - (double)space, rect.getHeight());
            }
            this.render_Text.draw(graphics, (Shape)rect, text, cellStyle);
        }
    }

    protected void drawDashedVerticalLine(Graphics g, int x, int y1, int y2) {
        y1 += y1 % 3;
        for (int y = y1; y <= y2; y += 3) {
            g.drawLine(x, y, x, y);
        }
    }

    protected void drawDashedHorizontalLine(Graphics g, int y, int x1, int x2) {
        x1 += x1 % 3;
        for (int x = x1; x <= x2; x += 3) {
            g.drawLine(x, y, x, y);
        }
    }

    public float getPreferredWidth(Graphics g, Shape clip, String text, Style style, Object extObj) {
        if (extObj instanceof CellTreeNode2) {
            CellTreeNode2 cell = (CellTreeNode2)extObj;
            text = cell.getValue() == null ? null : cell.getValue().toString();
            return super.getPreferredWidth(g, clip, text, style, null) + (float)((cell.getTreeLevel() + 2) * 20);
        }
        return super.getPreferredWidth(g, clip, text, style, null);
    }
}

