/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.ThemeReportTreeNode;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.cloud.service.ExtCloudRptCategoryControllerFacade;
import com.kingdee.eas.rpts.cloud.service.IExtCloudRptCategoryController;
import com.kingdee.eas.rpts.ctrlreport.ReportFacadeFactory;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractChoosedTreePanel;
import com.kingdee.eas.rpts.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.client.InputDialog;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlreport.util.PortalReportMenuUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ChoosedBITreeUI
extends AbstractChoosedTreePanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ChoosedBITreeUI.class);

    public ChoosedBITreeUI() throws Exception {
    }

    public ChoosedBITreeUI(ExtReportManageUI reportUI) throws Exception {
        this.reportUI = reportUI;
    }

    @Override
    public void onLoad() {
        this.initTree();
        this.treeView.getControlPane().removeAll();
        this.appendTreeOpbtn();
        this.updateFolderBtn.setToolTipText("\u91cd\u547d\u540d\u6587\u4ef6\u5939");
    }

    @Override
    public void showSelector() {
        this.onLoad();
    }

    @Override
    protected void initTree() {
        TreeModel treeModel = null;
        RptParams prModel = new RptParams();
        prModel.setString("MethodName", "getBIMenuPath");
        try {
            RptParams ps_r = ReportFacadeFactory.getRemoteInstance().commonExecuteNever(prModel);
            treeModel = (TreeModel)ps_r.getObject("TreeModel");
            DefaultKingdeeTreeNode cloudRptCenterTreeNode = null;
            for (int index = 0; index < treeModel.getChildCount(treeModel.getRoot()); ++index) {
                DefaultKingdeeTreeNode temp = (DefaultKingdeeTreeNode)treeModel.getChild(treeModel.getRoot(), index);
                if (!"\u4e91\u62a5\u8868\u4e2d\u5fc3".equals(temp.getText())) continue;
                cloudRptCenterTreeNode = temp;
                break;
            }
            if (cloudRptCenterTreeNode != null) {
                IExtCloudRptCategoryController controller = ExtCloudRptCategoryControllerFacade.getRemoteInst();
                ArrayList<DefaultKingdeeTreeNode> removeNodes = new ArrayList<DefaultKingdeeTreeNode>();
                for (int index = 0; index < cloudRptCenterTreeNode.getChildCount(); ++index) {
                    DefaultKingdeeTreeNode temp = (DefaultKingdeeTreeNode)cloudRptCenterTreeNode.getChildAt(index);
                    if (temp.getChildCount() > 0 || controller.hasCloudReport(temp.getText())) continue;
                    removeNodes.add(temp);
                }
                for (DefaultKingdeeTreeNode temp : removeNodes) {
                    temp.removeFromParent();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"initTree:", (Throwable)e);
            MessageUtil.showInfo("label166", true);
        }
        if (treeModel != null) {
            ThemeReportTreeNode root = (ThemeReportTreeNode)treeModel.getRoot();
            root.setText("\u9876\u7ea7\u76ee\u5f55");
            root.setFolder();
            this.convertToKingdeeTreeNode(root);
        }
        this.treeMain.setModel(treeModel);
        this.treeMain.getSelectionModel().setSelectionMode(1);
        this.tl = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getSource() != null) {
                    ThemeReportTreeNode selectedNode = ChoosedBITreeUI.this.getSelectedNode();
                    if (selectedNode != null && selectedNode.isFolder()) {
                        if (!selectedNode.isRoot()) {
                            ThemeReportTreeNode parentNode = (ThemeReportTreeNode)selectedNode.getParent();
                            if (parentNode.isRoot()) {
                                if ("\u4e91\u62a5\u8868\u4e2d\u5fc3".equals(selectedNode.getName())) {
                                    ChoosedBITreeUI.this.setTreeBtnstate(false, true);
                                    return;
                                }
                            } else {
                                ThemeReportTreeNode parentNode2 = (ThemeReportTreeNode)parentNode.getParent();
                                if (parentNode2.isRoot() && "\u4e91\u62a5\u8868\u4e2d\u5fc3".equals(parentNode.getName())) {
                                    ChoosedBITreeUI.this.setTreeBtnstate(false, true);
                                    return;
                                }
                            }
                            ChoosedBITreeUI.this.setTreeBtnstate(true, true);
                        } else {
                            ChoosedBITreeUI.this.setTreeBtnstate(true, true);
                        }
                    } else {
                        ChoosedBITreeUI.this.setTreeBtnstate(false, false);
                    }
                }
            }
        };
        this.treeMain.addTreeSelectionListener(this.tl);
        this.treeMain.setShowsRootHandles(true);
        this.treeMain.setRootVisible(true);
    }

    @Override
    public Object getData() {
        HashMap mapName = this.getMapData();
        if (mapName == null || mapName.isEmpty()) {
            return null;
        }
        DefObj def = new DefObj();
        String path = (String)mapName.get("path");
        def.setName(path);
        def.setAlias("/" + mapName.get("pathText"));
        def.setProperty("path", (Object)path);
        def.setProperty("pathText", mapName.get("pathText"));
        def.setProperty("lstName", mapName.get("lstName"));
        return def;
    }

    private ThemeReportTreeNode getSelectedNode() {
        TreePath tp = this.treeMain.getSelectionPath();
        if (tp == null) {
            return null;
        }
        return (ThemeReportTreeNode)tp.getLastPathComponent();
    }

    @Override
    protected void delFolderBtn_actionPerformed(ActionEvent e) throws Exception {
        ThemeReportTreeNode tn = this.getSelectedNode();
        if (null == tn.getParent()) {
            MessageUtil.showWarning(null, "\u9876\u7ea7\u76ee\u5f55\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            return;
        }
        if (!this.isAllFolder(tn)) {
            MessageUtil.showWarning(null, "\u5b50\u8282\u70b9\u5305\u542b\u62a5\u8868\uff0c\u8bf7\u5148\u53d6\u6d88\u53d1\u5e03\u62a5\u8868\u540e\u518d\u884c\u5220\u9664\uff01");
            return;
        }
        int inputValue = JOptionPane.showConfirmDialog(null, "\u786e\u5b9a\u5220\u9664\uff1f", "\u786e\u8ba4", 2);
        if (inputValue != 0) {
            return;
        }
        RptParams prModel = new RptParams();
        prModel.setString("MethodName", "delBIMenuDir");
        prModel.setString("bipath", tn.getRepositoryPath());
        RptParams ret = ReportFacadeFactory.getRemoteInstance().commonExecuteNever(prModel);
        if (ret.getString("er") == null) {
            MessageUtil.showInfo("\u5220\u9664\u6210\u529f", false);
            this.treeMain.removeTreeSelectionListener(this.tl);
            this.initTree();
            this.setTreeBtnstate(false, false);
        } else {
            MessageUtil.showInfo(ret.getString("er"), false);
        }
    }

    private void setTreeBtnstate(boolean editState, boolean selectState) {
        if (this.addFolderBtn != null) {
            this.addFolderBtn.setEnabled(editState);
        }
        if (this.btnSelect != null) {
            this.btnSelect.setEnabled(selectState);
        }
        if (this.delFolderBtn != null) {
            this.delFolderBtn.setEnabled(editState);
        }
        if (this.updateFolderBtn != null) {
            this.updateFolderBtn.setEnabled(editState);
        }
    }

    private boolean isAllFolder(ThemeReportTreeNode tn) {
        boolean isAllFolder = true;
        int count = tn.getChildCount();
        if (!tn.isFolder()) {
            return false;
        }
        for (int i = 0; i < count && (isAllFolder = this.isAllFolder((ThemeReportTreeNode)tn.getChildAt(i))); ++i) {
        }
        return isAllFolder;
    }

    @Override
    protected void updateFolderBtn_actionPerformed(ActionEvent e) throws Exception {
        ThemeReportTreeNode tn = this.getSelectedNode();
        if (null == tn.getParent()) {
            MessageUtil.showWarning(null, "\u9876\u7ea7\u76ee\u5f55\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
            return;
        }
        boolean isEmptyValue = true;
        String inputValue = null;
        inputValue = tn.getName();
        InputDialog dialog = InputDialog.create((Component)((Object)this), "\u91cd\u547d\u540d\u6587\u4ef6\u5939");
        dialog.setOldName(inputValue);
        if (!dialog.showDialog()) {
            return;
        }
        inputValue = dialog.getNewName();
        RptParams prModel = new RptParams();
        prModel.setString("MethodName", "updateBIMenuDir");
        prModel.setString("parentNodePath", ((ThemeReportTreeNode)tn.getParent()).getRepositoryPath());
        prModel.setString("oldName", tn.getName());
        prModel.setString("newName", inputValue);
        RptParams ret = ReportFacadeFactory.getRemoteInstance().commonExecuteNever(prModel);
        if (ret.getString("er") == null) {
            MessageUtil.showInfo("\u91cd\u547d\u540d\u6210\u529f", false);
            this.treeMain.removeTreeSelectionListener(this.tl);
            this.initTree();
            this.setTreeBtnstate(false, false);
        } else {
            MessageUtil.showInfo(ret.getString("er"), false);
        }
    }

    @Override
    protected void addFolderBtn_actionPerformed(ActionEvent e) throws Exception {
        InputDialog dialog = InputDialog.create((Component)((Object)this), "\u65b0\u5efa\u6587\u4ef6\u5939");
        if (dialog.showDialog()) {
            String inputValue = dialog.getNewName();
            ThemeReportTreeNode tn = this.getSelectedNode();
            boolean isSuccess = PortalReportMenuUtil.addPortalMenuDir(null, tn.getRepositoryPath(), inputValue);
            if (isSuccess) {
                MessageUtil.showInfo("\u4fdd\u5b58\u6210\u529f", false);
                this.treeMain.removeTreeSelectionListener(this.tl);
                this.initTree();
                this.setTreeBtnstate(false, false);
            } else {
                MessageUtil.showInfo("\u6587\u4ef6\u5939\u540d\u5df2\u5b58\u5728\uff0c\u91cd\u65b0\u8f93\u5165\uff01", false);
            }
        }
    }

    private void convertToKingdeeTreeNode(ThemeReportTreeNode nodeRoot) {
        int icount = nodeRoot.getChildCount();
        for (int i = 0; i < icount; ++i) {
            ThemeReportTreeNode subNode = (ThemeReportTreeNode)nodeRoot.getChildAt(i);
            if (subNode.isLeaf() && subNode.isFolder()) {
                subNode.setCustomIcon(UIManager.getIcon("Tree.closedIcon"));
            }
            this.convertToKingdeeTreeNode(subNode);
        }
    }

    private String getPathText(ThemeReportTreeNode currentNode) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> lst = new ArrayList<String>();
        lst.add(currentNode.getText());
        while (null != (currentNode = (ThemeReportTreeNode)currentNode.getParent())) {
            lst.add(currentNode.getText());
        }
        for (int i = lst.size() - 1; i >= 0; --i) {
            sb.append(lst.get(i).toString());
            if (i <= 0) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    @Override
    protected void btnSelect_actionPerformed(ActionEvent e) throws Exception {
        String name;
        ThemeReportTreeNode subNode;
        int i;
        int icount;
        DefaultKingdeeTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode == null) {
            return;
        }
        boolean isLeaf = false;
        ArrayList<String> lstName = new ArrayList<String>();
        String path = null;
        String pathText = null;
        ThemeReportTreeNode currentNode = (ThemeReportTreeNode)treeNode;
        if (treeNode.isLeaf()) {
            ThemeReportTreeNode parentNode = (ThemeReportTreeNode)currentNode.getParent();
            if (currentNode.isFolder()) {
                path = currentNode.getRepositoryPath();
                pathText = this.getPathText(currentNode);
            } else if (null != parentNode) {
                path = parentNode.getRepositoryPath();
                if (null == path) {
                    MessageUtil.showInfo("label209", true);
                    return;
                }
                pathText = this.getPathText(parentNode);
                icount = currentNode.getChildCount();
                for (i = 0; i < icount; ++i) {
                    subNode = (ThemeReportTreeNode)currentNode.getChildAt(i);
                    name = subNode.getText();
                    lstName.add(name);
                }
            }
            isLeaf = true;
        } else {
            path = currentNode.getRepositoryPath();
            pathText = this.getPathText(currentNode);
        }
        if (!isLeaf) {
            icount = currentNode.getChildCount();
            for (i = 0; i < icount; ++i) {
                subNode = (ThemeReportTreeNode)currentNode.getChildAt(i);
                name = subNode.getText();
                lstName.add(name);
            }
        }
        this.mapData.put("path", path);
        this.mapData.put("pathText", pathText);
        this.mapData.put("lstName", lstName);
        this.isOk = true;
        this.isCanceled = false;
        this.closeWin();
    }

    @Override
    protected void treeMain_mouseClicked(MouseEvent e) throws Exception {
        DefaultKingdeeTreeNode treeNode;
        if (e.getClickCount() == 2 && (treeNode = this.getSelectedTreeNode()) != null && treeNode.isLeaf()) {
            this.btnSelect_actionPerformed(null);
        }
    }

    List<String> getBrotherName(String repositoryPath, String menuName) {
        TreeModel treeModel;
        if (repositoryPath == null) {
            return new ArrayList<String>();
        }
        RptParams prModel = new RptParams();
        prModel.setString("MethodName", "getBIMenuPath");
        try {
            RptParams ps_r = ReportFacadeFactory.getRemoteInstance().commonExecuteNever(prModel);
            treeModel = (TreeModel)ps_r.getObject("TreeModel");
        }
        catch (BOSException e) {
            logger.error((Object)"initTree:", (Throwable)e);
            return new ArrayList<String>();
        }
        Object treeNode = treeModel.getRoot();
        ArrayList<String> lstName = new ArrayList<String>();
        if (!"".equals(repositoryPath)) {
            treeNode = this.findLastDir(repositoryPath, treeNode, treeModel);
        }
        if (treeNode != null) {
            int len = treeModel.getChildCount(treeNode);
            for (int index = 0; index < len; ++index) {
                ThemeReportTreeNode temp = (ThemeReportTreeNode)treeModel.getChild(treeNode, index);
                if (menuName == null || menuName.equals(temp.getName())) continue;
                lstName.add(temp.getName());
            }
        }
        return lstName;
    }

    private ThemeReportTreeNode findLastDir(String repositoryPath, Object treeNode, TreeModel treeModel) {
        int len = treeModel.getChildCount(treeNode);
        for (int index = 0; index < len; ++index) {
            ThemeReportTreeNode temp = (ThemeReportTreeNode)treeModel.getChild(treeNode, index);
            if (!repositoryPath.startsWith(temp.getRepositoryPath())) continue;
            if (repositoryPath.equals(temp.getRepositoryPath())) {
                return temp;
            }
            return this.findLastDir(repositoryPath, temp, treeModel);
        }
        return null;
    }
}

