/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.CloudReportAuthBaseFactory;
import com.kingdee.eas.rpts.ctrlreport.CloudReportAuthBaseInfo;
import com.kingdee.eas.rpts.ctrlreport.ICloudReportAuthBase;
import com.kingdee.eas.rpts.ctrlreport.bo.CloudReportAuthBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractCloudReportAuthUI;
import com.kingdee.eas.rpts.ctrlreport.data.CloudReportAuthVO;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CloudReportAuthUI
extends AbstractCloudReportAuthUI {
    private static final Logger logger = CoreUIObject.getLogger(CloudReportAuthUI.class);
    private static final int COL_NAME = 0;
    private static final int COL_VIEW = 1;
    private static final int COL_EXPORT = 2;
    private static final int COL_PRINT = 3;
    private static final int COL_MESSAGE_VIEW = 2;
    private String _authId;
    private boolean _isDirty;
    private boolean _isFirstAuth = true;
    private KDPanel _panelUser;
    private KDTable _tableNormal;
    private KDTable _tableMobile;
    private KDWorkButton _btnMSelectAll;
    private KDWorkButton _btnMUnselectAll;
    private KDWorkButton _btnSelectAll;
    private KDWorkButton _btnUnselectAll;
    private KDWorkButton _btnAuth;
    private KDWorkButton _btnFinish;
    private KDCheckBox _checkBoxView;
    private KDCheckBox _checkBoxExport;
    private KDCheckBox _checkBoxPrint;
    private KDCheckBox _checkBoxMobileView;
    private boolean _hasToolPerm;

    public KDMenuBar getUIMenuBar() {
        return null;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        TableLayout2 layout = new TableLayout2(1, 1);
        layout.setRatableHeight(0, 1);
        layout.setRatableWidth(0, 1);
        this.setLayout((LayoutManager)layout);
        this.setPreferredSize(new Dimension(600, 600));
    }

    @Override
    public KDToolBar[] getUIMultiToolBar() {
        return super.getUIMultiToolBar();
    }

    public KDToolBar getUIToolBar() {
        KDToolBar toolBar = super.getUIToolBar();
        toolBar.add((Component)this._btnAuth);
        toolBar.add((Component)this._btnFinish);
        return toolBar;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.removeMainStatusBar();
        this.init();
    }

    private void init() throws BOSException, EASBizException {
        CloudReportAuthVO authVo = null;
        List<CloudReportAuthVO> voList = null;
        Object oAuthId = this.getUIContext().get("ID");
        if (oAuthId != null) {
            this._authId = oAuthId.toString();
        }
        try {
            authVo = CloudReportAuthBO.getCloudReportAuthUser(null, this._authId);
            voList = CloudReportAuthBO.getCloudReportAuth(null, this._authId);
        }
        catch (BOSException be) {
            String errorInfo = "\u83b7\u53d6\u4e91\u62a5\u8868\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff01";
            MessageUtil.showInfo(errorInfo, false);
            logger.error((Object)errorInfo, (Throwable)be);
        }
        if (authVo == null) {
            authVo = new CloudReportAuthVO();
        }
        if (authVo.getLastUpdateTime().compareTo(authVo.getCreateTime()) > 0) {
            this._isFirstAuth = false;
        }
        KDPanel panelBase = new KDPanel();
        panelBase.setCustomInsets(new Insets(5, 8, 8, 8));
        panelBase.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.add((Component)panelBase, TableLayout2.param((int)0, (int)0));
        KDLabel labelTips = new KDLabel();
        labelTips.setCustomInsets(new Insets(5, 50, 5, 10));
        labelTips.setText("\u5907\u6ce8\uff1a\u6309\u3010\u4ec5\u7528\u6237\u3011\u65b9\u5f0f\u6388\u6743");
        labelTips.setLocation(10, labelTips.getY());
        labelTips.setForeground(Color.BLUE);
        this._panelUser = this.createPanelUser(authVo);
        KDPanel containerReport = this.createContainerReport(voList);
        TableLayout2 layout = new TableLayout2(3, 2);
        panelBase.setLayout((LayoutManager)layout);
        layout.setFixedHeight(0, 22);
        layout.setFixedHeight(1, 80);
        layout.setRowSpacing(1, 5);
        layout.setRatableHeight(2, 1);
        layout.setRatableWidth(1, 1);
        layout.setFixedWidth(1, 50);
        panelBase.add((Component)labelTips, (Object)TableLayout2.param((int)0, (int)0, (int)0, (int)1));
        panelBase.add((Component)this._panelUser, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)1));
        panelBase.add((Component)containerReport, (Object)TableLayout2.param((int)2, (int)0, (int)2, (int)1));
    }

    protected void initListener() {
        if (this._checkBoxMobileView != null) {
            this._checkBoxMobileView.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CloudReportAuthUI.this.setMessagePermissionLink(CloudReportAuthUI.this._tableMobile, CloudReportAuthUI.this._checkBoxMobileView);
                    CloudReportAuthUI.this.handleDirty(true);
                }
            });
        }
        if (this._checkBoxView != null) {
            this._checkBoxView.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CloudReportAuthUI.this.setPermissionLink(CloudReportAuthUI.this._tableNormal, CloudReportAuthUI.this._checkBoxView);
                    CloudReportAuthUI.this.handleDirty(true);
                }
            });
        }
        if (this._checkBoxExport != null) {
            this._checkBoxExport.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CloudReportAuthUI.this.setPermissionLink(CloudReportAuthUI.this._tableNormal, CloudReportAuthUI.this._checkBoxExport);
                    CloudReportAuthUI.this.handleDirty(true);
                }
            });
        }
        if (this._checkBoxPrint != null) {
            this._checkBoxPrint.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CloudReportAuthUI.this.setPermissionLink(CloudReportAuthUI.this._tableNormal, CloudReportAuthUI.this._checkBoxPrint);
                    CloudReportAuthUI.this.handleDirty(true);
                }
            });
        }
        if (this._btnSelectAll != null) {
            this._btnSelectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloudReportAuthUI.this.selectAllCheckBox(CloudReportAuthUI.this._tableNormal, true);
                    CloudReportAuthUI.this.handleDirty(true);
                }
            });
        }
        if (this._btnUnselectAll != null) {
            this._btnUnselectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloudReportAuthUI.this.selectAllCheckBox(CloudReportAuthUI.this._tableNormal, false);
                    CloudReportAuthUI.this.handleDirty(true);
                }
            });
        }
        if (this._btnMSelectAll != null) {
            this._btnMSelectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloudReportAuthUI.this.selectAllCheckBox(CloudReportAuthUI.this._tableMobile, true);
                    CloudReportAuthUI.this.handleDirty(true);
                }
            });
        }
        if (this._btnMUnselectAll != null) {
            this._btnMUnselectAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CloudReportAuthUI.this.selectAllCheckBox(CloudReportAuthUI.this._tableMobile, false);
                    CloudReportAuthUI.this.handleDirty(true);
                }
            });
        }
        if (this._btnAuth != null) {
            this._btnAuth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (CloudReportAuthUI.this.submit()) {
                        CloudReportAuthUI.this.handleDirty(false);
                        MessageUtil.showInfo("\u63d0\u4ea4\u6210\u529f\uff01", false);
                    }
                }
            });
        }
        if (this._btnFinish != null) {
            this._btnFinish.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean option = MessageUtil.showConfirm((Component)((Object)CloudReportAuthUI.this), "\u786e\u5b9a\u7ed3\u675f\u5f53\u524d\u6d41\u7a0b\uff1f");
                    if (option && CloudReportAuthUI.this.finishProcess()) {
                        CloudReportAuthUI.this.handleDirty(false);
                        CloudReportAuthUI.this.destroyWindow();
                    }
                }
            });
        }
    }

    private void handleDirty(boolean isDirty) {
        if (this._isDirty == isDirty) {
            return;
        }
        this._isDirty = isDirty;
        Window w = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (w instanceof KDDialog) {
            KDDialog dialog = (KDDialog)w;
            String title = dialog.getTitle();
            title = isDirty ? title + " *" : title.replaceAll(" \\*", "");
            dialog.setTitle(title);
        } else {
            KDFrame frame = (KDFrame)w;
            String title = frame.getTitle();
            title = isDirty ? title + " *" : title.replaceAll(" \\*", "");
            frame.setTitle(title);
        }
    }

    public boolean destroyWindow() {
        if (!this._isDirty) {
            return super.destroyWindow();
        }
        int option = MessageUtil.showConfirm3((Component)((Object)this), "\u60a8\u6709\u672a\u4fdd\u5b58\u7684\u6570\u636e\uff0c\u662f\u5426\u4fdd\u5b58\uff1f\n\u70b9\u51fb[\u662f]\u4fdd\u5b58\u5e76\u5173\u95ed\uff1b\u70b9\u51fb[\u5426]\u4e0d\u4fdd\u5b58\u5e76\u5173\u95ed\uff1b\u70b9\u51fb[\u53d6\u6d88]\u5219\u8fd4\u56de\u3002");
        switch (option) {
            case 0: {
                if (this.savePermission()) break;
                return false;
            }
            case 1: {
                break;
            }
            case 2: {
                return false;
            }
        }
        return super.destroyWindow();
    }

    private void selectAllCheckBox(KDTable table, boolean isSelect) {
        if (table == null) {
            return;
        }
        int colCount = table.getColumnCount();
        int rowCount = table.getRowCount();
        for (int c = 1; c < colCount; ++c) {
            for (int r = 0; r < rowCount; ++r) {
                table.getCell(r, c).setValue((Object)isSelect);
            }
        }
    }

    private KDPanel createPanelUser(CloudReportAuthVO authVo) {
        KDPanel panelUser = new KDPanel();
        panelUser.setUserObject((Object)authVo);
        panelUser.setCustomInsets(new Insets(18, 20, 10, 5));
        panelUser.setBorder((Border)BorderFactory.createTitledBorder("\u7533\u8bf7\u4eba\u4fe1\u606f"));
        int labelLength = 60;
        KDLabelContainer conUser = new KDLabelContainer("\u7533\u8bf7\u4eba\uff1a ");
        conUser.getBoundLabel().setVerticalAlignment(0);
        conUser.setBoundLabelLength(labelLength);
        KDLabel labelUser = new KDLabel(authVo.getUserName());
        conUser.setBoundEditor((JComponent)labelUser);
        KDLabelContainer conTel = new KDLabelContainer("\u8054\u7cfb\u7535\u8bdd\uff1a");
        conTel.getBoundLabel().setVerticalAlignment(0);
        conTel.setBoundLabelLength(labelLength);
        KDLabel labelTel = new KDLabel(authVo.getTelNumber());
        conTel.setBoundEditor((JComponent)labelTel);
        KDLabelContainer conDepartment = new KDLabelContainer("\u6240\u5c5e\u7ec4\u7ec7\uff1a");
        conDepartment.getBoundLabel().setVerticalAlignment(0);
        conDepartment.setBoundLabelLength(labelLength);
        KDLabel labelDepartment = new KDLabel(authVo.getOrgName());
        conDepartment.setBoundEditor((JComponent)labelDepartment);
        KDLabelContainer conCreateTime = new KDLabelContainer("\u7533\u8bf7\u65f6\u95f4\uff1a");
        conCreateTime.getBoundLabel().setVerticalAlignment(0);
        conCreateTime.setBoundLabelLength(labelLength);
        KDLabel labelCreateTime = new KDLabel(authVo.getCreateTime());
        conCreateTime.setBoundEditor((JComponent)labelCreateTime);
        TableLayout2 layout = new TableLayout2(2, 2);
        panelUser.setLayout((LayoutManager)layout);
        panelUser.add((Component)conUser, (Object)TableLayout2.param((int)0, (int)0));
        panelUser.add((Component)conTel, (Object)TableLayout2.param((int)0, (int)1));
        panelUser.add((Component)conDepartment, (Object)TableLayout2.param((int)1, (int)0));
        panelUser.add((Component)conCreateTime, (Object)TableLayout2.param((int)1, (int)1));
        return panelUser;
    }

    private KDPanel createContainerReport(List<CloudReportAuthVO> voList) {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        String userId = userInfo.getId().toString();
        try {
            this._hasToolPerm = CloudReportAuthBO.hasReportToolAuth(null, userId);
            boolean hasMobilePerm = CloudReportAuthBO.hasMobileReportToolAuth(null, userId);
            this._hasToolPerm = this._hasToolPerm || hasMobilePerm;
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        String strSelect = "\u5168\u9009";
        String strClear = "\u5168\u6e05";
        ImageIcon iconSelect = ResourceManager.getImageIcon((String)"tbtn_SelectAll.gif");
        ImageIcon iconClear = ResourceManager.getImageIcon((String)"tbtn_deleteall.gif");
        KDPanel panelReport = new KDPanel();
        panelReport.setCustomInsets(new Insets(0, 4, 0, 4));
        TableLayout2 layout = new TableLayout2(1, 1);
        panelReport.setLayout((LayoutManager)layout);
        KDSplitPane splitPanel = new KDSplitPane();
        splitPanel.setOrientation(0);
        splitPanel.setArrowType(0);
        splitPanel.setDividerLocation(224);
        KDPanel splitLeftPanel = new KDPanel();
        splitLeftPanel.setMinimumSize(new Dimension(0, 0));
        layout = new TableLayout2(2, 3);
        splitLeftPanel.setLayout((LayoutManager)layout);
        layout.setFixedHeight(0, 20);
        layout.setRatableHeight(1, 1);
        layout.setRatableWidth(0, 1);
        layout.setFixedWidth(1, 55);
        layout.setFixedWidth(2, 55);
        layout.setColSpacing(1, 3);
        layout.setRowSpacing(0, 4);
        this._tableNormal = new KDTable();
        this._tableNormal.addColumns(4);
        this._tableNormal.getColumn(0).setWidth(180);
        this._tableNormal.getColumn(0).getStyleAttributes().setLocked(true);
        this._checkBoxView = new KDCheckBox();
        this._tableNormal.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)this._checkBoxView));
        this._checkBoxExport = new KDCheckBox();
        this._tableNormal.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)this._checkBoxExport));
        this._checkBoxPrint = new KDCheckBox();
        this._tableNormal.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)this._checkBoxPrint));
        IRow row = this._tableNormal.addHeadRow();
        row.getCell(0).setValue((Object)"\u684c\u9762\u62a5\u8868\u540d\u79f0");
        row.getCell(1).setValue((Object)"\u67e5\u770b\u6743");
        row.getCell(2).setValue((Object)"\u5bfc\u51fa\u6743");
        row.getCell(3).setValue((Object)"\u6253\u5370\u6743");
        splitLeftPanel.add((Component)this._tableNormal, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        this._btnSelectAll = new KDWorkButton(strSelect);
        this._btnSelectAll.setIcon((Icon)iconSelect);
        this._btnUnselectAll = new KDWorkButton(strClear);
        this._btnUnselectAll.setIcon((Icon)iconClear);
        splitLeftPanel.add((Component)this._btnSelectAll, (Object)TableLayout2.param((int)0, (int)1));
        splitLeftPanel.add((Component)this._btnUnselectAll, (Object)TableLayout2.param((int)0, (int)2));
        KDPanel splitRightPanel = new KDPanel();
        splitRightPanel.setMinimumSize(new Dimension(0, 0));
        layout = new TableLayout2(2, 3);
        splitRightPanel.setLayout((LayoutManager)layout);
        layout.setFixedHeight(0, 20);
        layout.setRatableHeight(1, 1);
        layout.setRatableWidth(0, 1);
        layout.setFixedWidth(1, 55);
        layout.setFixedWidth(2, 55);
        layout.setColSpacing(1, 3);
        layout.setRowSpacing(0, 4);
        this._tableMobile = new KDTable();
        this._tableMobile.addColumns(3);
        this._tableMobile.getColumn(0).setWidth(180);
        this._tableMobile.getColumn(0).getStyleAttributes().setLocked(true);
        this._checkBoxMobileView = new KDCheckBox();
        this._tableMobile.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)this._checkBoxMobileView));
        this._tableMobile.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)this._checkBoxMobileView));
        row = this._tableMobile.addHeadRow();
        row.getCell(0).setValue((Object)"\u79fb\u52a8\u62a5\u8868\u540d\u79f0");
        row.getCell(1).setValue((Object)"\u67e5\u770b\u6743");
        row.getCell(2).setValue((Object)"\u6d88\u606f\u63a5\u6536\u6743");
        splitRightPanel.add((Component)this._tableMobile, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        this._btnMSelectAll = new KDWorkButton(strSelect);
        this._btnMSelectAll.setIcon((Icon)iconSelect);
        this._btnMUnselectAll = new KDWorkButton(strClear);
        this._btnMUnselectAll.setIcon((Icon)iconClear);
        splitRightPanel.add((Component)this._btnMSelectAll, (Object)TableLayout2.param((int)0, (int)1));
        splitRightPanel.add((Component)this._btnMUnselectAll, (Object)TableLayout2.param((int)0, (int)2));
        splitPanel.setLeftComponent((Component)splitLeftPanel);
        splitPanel.setRightComponent((Component)splitRightPanel);
        panelReport.add((Component)splitPanel, (Object)TableLayout2.param((int)0, (int)0));
        this._btnAuth = new KDWorkButton("\u63d0\u4ea4");
        this._btnAuth.setIcon(EASResource.getIcon((String)"imgTbtn_popedomsetting"));
        this._btnFinish = new KDWorkButton("\u4e0d\u5904\u7406");
        this._btnFinish.setIcon((Icon)ResourceManager.getImageIcon((String)"tbtn_refusepopedom.gif"));
        KDPanel containerReport = new KDPanel();
        containerReport.setCustomInsets(new Insets(16, 5, 8, 5));
        containerReport.setBorder((Border)BorderFactory.createTitledBorder("\u8bf7\u6c42\u6388\u6743\u7684\u4e91\u62a5\u8868"));
        containerReport.setLayout((LayoutManager)new BorderLayout());
        containerReport.add((Component)panelReport, (Object)"Center");
        this.fillTableData(voList, this._tableNormal, this._tableMobile);
        if (this._tableMobile.getRowCount() <= 0) {
            splitPanel.remove((Component)splitRightPanel);
            splitPanel.setDividerSize(-1);
        } else if (this._tableNormal.getRowCount() <= 0) {
            splitPanel.remove((Component)splitLeftPanel);
            splitPanel.setDividerSize(-1);
        }
        if (!this._hasToolPerm) {
            this._btnAuth.setEnabled(false);
            this._btnFinish.setEnabled(false);
            this._btnSelectAll.setEnabled(false);
            this._btnUnselectAll.setEnabled(false);
            this._btnMSelectAll.setEnabled(false);
            this._btnMUnselectAll.setEnabled(false);
            this._tableNormal.setEnabled(false);
            this._tableMobile.setEnabled(false);
        }
        return containerReport;
    }

    private void setButtonEnble(KDTable table, boolean enble) {
    }

    private void fillTableData(List<CloudReportAuthVO> voList, KDTable tableNormal, KDTable tableMobile) {
        if (voList == null || voList.isEmpty()) {
            return;
        }
        for (CloudReportAuthVO vo : voList) {
            String permission = vo.getPermission();
            boolean perView = false;
            boolean perExport = false;
            boolean perPrint = false;
            boolean perMessageView = false;
            if (!StringUtil.isEmptyString((String)permission)) {
                String[] perms = permission.split(";");
                perView = "1".equals(perms[0]);
                perExport = "1".equals(perms[1]);
                boolean bl = perPrint = "1".equals(perms[2]);
                if (perms.length >= 5) {
                    perMessageView = "1".equals(perms[4]);
                }
            } else if (this._hasToolPerm && this._isFirstAuth) {
                perMessageView = true;
                perPrint = true;
                perExport = true;
                perView = true;
            }
            IRow row = null;
            if (-1 == Integer.valueOf(vo.getTemplateType())) {
                if (tableNormal != null) {
                    row = tableNormal.addRow();
                    row.getCell(1).setValue((Object)perView);
                    row.getCell(2).setValue((Object)perExport);
                    row.getCell(3).setValue((Object)perPrint);
                }
            } else if (tableMobile != null) {
                row = tableMobile.addRow();
                row.getCell(1).setValue((Object)perView);
                row.getCell(2).setValue((Object)perMessageView);
            }
            if (row == null) continue;
            row.setUserObject((Object)vo);
            row.getCell(0).setValue((Object)vo.getReportName());
        }
    }

    private void setMessagePermissionLink(KDTable table, KDCheckBox cbObj) {
        int currentRowIndex = table.getSelectManager().getActiveRowIndex();
        int currentColIndex = table.getSelectManager().getActiveColumnIndex();
        boolean currentValue = cbObj.isSelected();
        if (currentColIndex == 1) {
            if (!currentValue) {
                table.getRow(currentRowIndex).getCell(2).setValue((Object)Boolean.FALSE);
            }
        } else if (currentColIndex == 2 && currentValue) {
            table.getRow(currentRowIndex).getCell(1).setValue((Object)Boolean.TRUE);
        }
    }

    private void setPermissionLink(KDTable table, KDCheckBox cbObj) {
        int currentRowIndex = table.getSelectManager().getActiveRowIndex();
        int currentColIndex = table.getSelectManager().getActiveColumnIndex();
        boolean currentValue = cbObj.isSelected();
        if (currentColIndex == 1) {
            if (!currentValue) {
                table.getRow(currentRowIndex).getCell(2).setValue((Object)Boolean.FALSE);
                table.getRow(currentRowIndex).getCell(3).setValue((Object)Boolean.FALSE);
            }
        } else if ((currentColIndex == 2 || currentColIndex == 3) && currentValue) {
            table.getRow(currentRowIndex).getCell(1).setValue((Object)Boolean.TRUE);
        }
    }

    private boolean savePermission() {
        ArrayList<CloudReportAuthVO> listVo = new ArrayList<CloudReportAuthVO>();
        listVo.addAll(this.getCloudReportAuthVOList(this._tableNormal));
        listVo.addAll(this.getCloudReportAuthVOList(this._tableMobile));
        try {
            CloudReportAuthBO.updateCloudReportAuth(null, listVo);
        }
        catch (BOSException e) {
            logger.error((Object)"\u4fdd\u5b58\u5931\u8d25\uff01", (Throwable)e);
            MessageUtil.showDetailAndOK((Dialog)SwingUtilities.getWindowAncestor((Component)((Object)this)), "\u4fdd\u5b58\u5931\u8d25\uff01", (Exception)((Object)e));
            return false;
        }
        return true;
    }

    private boolean submit() {
        if (!this.savePermission()) {
            return false;
        }
        if (!this.finishProcess()) {
            MessageUtil.showInfo("\u8f6c\u5230\u6d41\u7a0b\u4e0b\u4e00\u8282\u70b9\u5904\u7406\u65f6\u51fa\u9519\uff01", false);
            return false;
        }
        return true;
    }

    private boolean finishProcess() {
        CloudReportAuthVO vo = new CloudReportAuthVO();
        vo.setAuthId(this._authId);
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        vo.setLastUpdateUserId(userInfo.getId().toString());
        try {
            CloudReportAuthBO.updateAuthTime(null, vo);
            ICloudReportAuthBase authBase = CloudReportAuthBaseFactory.getRemoteInstance();
            authBase.savePermission((IObjectValue)((CloudReportAuthBaseInfo)authBase.getValue((IObjectPK)new ObjectUuidPK(this._authId))));
        }
        catch (AlreadyInProcessQueueException ae) {
            logger.info((Object)"\u6d41\u7a0b\u6b63\u5728\u5904\u7406", (Throwable)ae);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private List<CloudReportAuthVO> getCloudReportAuthVOList(KDTable table) {
        if (table == null) {
            return null;
        }
        table.getEditManager().stopEditing();
        CloudReportAuthVO voUserObject = (CloudReportAuthVO)this._panelUser.getUserObject();
        int rowCount = table.getRowCount();
        ArrayList<CloudReportAuthVO> listVo = new ArrayList<CloudReportAuthVO>();
        for (int r = 0; r < rowCount; ++r) {
            IRow row = table.getRow(r);
            CloudReportAuthVO voRptObject = (CloudReportAuthVO)row.getUserObject();
            CloudReportAuthVO vo = new CloudReportAuthVO();
            vo.setAuthId(this._authId);
            vo.setUserId(voUserObject.getUserId());
            vo.setReportId(voRptObject.getReportId());
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            vo.setLastUpdateUserId(userInfo.getId().toString());
            String permission = this.getPermissoinUnion(row);
            vo.setPermission(permission);
            listVo.add(vo);
        }
        return listVo;
    }

    private String getPermissoinUnion(IRow row) {
        String viewStr = this.isPermissionSelected(row, 1);
        if ("0".endsWith(viewStr)) {
            return "0;0;0;100";
        }
        CloudReportAuthVO voRptObject = (CloudReportAuthVO)row.getUserObject();
        if (2 == Integer.valueOf(voRptObject.getTemplateType())) {
            String messageStr = this.isPermissionSelected(row, 2);
            return viewStr + ";" + "0" + ";" + "0" + ";" + 100 + ";" + messageStr;
        }
        String exportStr = this.isPermissionSelected(row, 2);
        String printStr = this.isPermissionSelected(row, 3);
        return viewStr + ";" + exportStr + ";" + printStr + ";" + 100;
    }

    private String isPermissionSelected(IRow row, int cell) {
        boolean view;
        ICell cll = row.getCell(cell);
        if (cll == null) {
            return "1";
        }
        if (cll.getValue() != null && (view = Boolean.valueOf(cll.getValue().toString()).booleanValue())) {
            return "1";
        }
        return "0";
    }
}

