/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.rpts.ctrlreport.adapter.ExtReportFilterManager;
import com.kingdee.eas.rpts.ctrlreport.adapter.IFilter;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.adapter.TreeManager;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractDatasourceSelectUI;
import com.kingdee.eas.rpts.ctrlreport.client.PreviewDbSourceUI;
import com.kingdee.eas.rpts.ctrlreport.client.ReportDialog;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportQuery;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.SQLCustomType;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DatasourceSelectUI
extends AbstractDatasourceSelectUI
implements IFilter {
    private static final long serialVersionUID = -6225169710505311370L;
    public static final String TYPE = "type";
    public static final String PATH = "path";
    public static final String SelectedList = "selectedList";
    public static final String SystemID = "systemID";
    public static final int TreeModelType_Normal = 0;
    public static final int TreeModelType_Mobile = 1;
    DatasourceSelectUI datasourceSelectUI;
    private String tableFlag = null;
    private String systemID = null;
    private String path = null;
    private HashMap selectedInfo = new HashMap();
    private boolean isOk = false;
    private boolean isMobile = false;
    private String firstPath = "";
    private KDTSortManager sm = null;
    KDTDefaultCellEditor ceF7Filter;
    ExtReportFilterManager efm;
    boolean isStopChange = false;
    KDWorkButton btnChangeTreeModel;
    private int treeModelType = 0;

    public DatasourceSelectUI() throws Exception {
        this.datasourceSelectUI = this;
        this.putClientProperty("ShowToolBar", this.toolBar);
        this.btnChangeTreeModel = new KDWorkButton();
        this.btnChangeTreeModel.setText("\u5207\u6362\u5230\u62a5\u8868\u5de5\u5177\u6570\u636e\u96c6");
        this.btnChangeTreeModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasourceSelectUI.this.beforeActionPerformed(e);
                try {
                    DatasourceSelectUI.this.btnChangeTreeModel_actionPerformed(e);
                }
                catch (Exception exc) {
                    DatasourceSelectUI.this.handUIException(exc);
                }
                finally {
                    DatasourceSelectUI.this.afterActionPerformed(e);
                }
            }
        });
    }

    protected void btnChangeTreeModel_actionPerformed(ActionEvent e) {
        if (this.treeModelType == 1) {
            this.treeModelType = 0;
            this.btnChangeTreeModel.setText("\u5207\u6362\u5230\u79fb\u52a8\u62a5\u8868\u5de5\u5177\u6570\u636e\u96c6");
        } else {
            this.treeModelType = 1;
            this.btnChangeTreeModel.setText("\u5207\u6362\u5230\u62a5\u8868\u5de5\u5177\u6570\u636e\u96c6");
        }
        this.tableFlag = null;
        this.kDTable_List.removeRows();
        this.initTree();
    }

    public DatasourceSelectUI(String firstPath) throws Exception {
        this();
        this.kDTable_List.checkParsed();
        this.firstPath = firstPath;
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        if (this.isMobile) {
            this.toolBar.add((Component)this.btnChangeTreeModel);
        }
    }

    public void onLoad() throws Exception {
        this.initTree();
    }

    private void setReptsNode(DefaultKingdeeTreeNode nodeRoot) {
        if (nodeRoot.isLeaf()) {
            this.addExtNode(nodeRoot);
        } else {
            Enumeration enume = nodeRoot.children();
            while (enume.hasMoreElements()) {
                DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
                this.setReptsNode(repNode);
            }
            if (!nodeRoot.isRoot()) {
                this.addExtNode(nodeRoot);
            }
        }
    }

    private void addExtNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode DKTreeNode2 = new DefaultKingdeeTreeNode();
        DKTreeNode2.setText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.ReportsResource", (String)"ksqlReport"));
        DKTreeNode2.setCustomIcon((Icon)ResourceManager.getIcon(DatasourceSelectUI.class, (String)"tbtn_sql.gif"));
        DKTreeNode2.setUserObject((Object)"2");
        node.add((MutableTreeNode)DKTreeNode2);
        if (this.treeModelType != 1) {
            DefaultKingdeeTreeNode DKTreeNode6 = new DefaultKingdeeTreeNode();
            DKTreeNode6.setText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.ReportsResource", (String)"reportEnum"));
            DKTreeNode6.setCustomIcon((Icon)ResourceManager.getIcon(DatasourceSelectUI.class, (String)"tbtn_enu.gif"));
            DKTreeNode6.setUserObject((Object)"6");
            node.add((MutableTreeNode)DKTreeNode6);
        }
    }

    private boolean expandOld(DefaultKingdeeTreeNode nodeRoot, String selectedPath) {
        boolean flag = true;
        Enumeration enume = nodeRoot.children();
        while (enume.hasMoreElements()) {
            DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
            Object[] pathtoRoot = repNode.getPath();
            TreePath path = new TreePath(pathtoRoot);
            String pathString = RunReportParam.getPathString(pathtoRoot);
            if (StringUtil.equals((String)pathString, (String)selectedPath)) {
                this.kDTree1.expandPath(path);
                this.kDTree1.setSelectionPath(path);
                this.kDTree1.scrollPathToVisible(path);
                flag = false;
                break;
            }
            flag = this.expandOld(repNode, selectedPath);
            if (flag) continue;
            break;
        }
        return flag;
    }

    private void rowSelected() {
        ArrayList selectedList = (ArrayList)this.selectedInfo.get(SelectedList);
        int size = selectedList.size();
        String[] selectedIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            String id;
            HashMap mapDBSource = (HashMap)selectedList.get(i);
            selectedIDs[i] = id = CtrlReportUtil.getObjectString(mapDBSource.get("fid"));
        }
        TableManager.rowSelected(this.kDTable_List, selectedIDs);
    }

    private void initTree() {
        DefaultKingdeeTreeNode nodeRoot;
        switch (this.treeModelType) {
            case 1: {
                nodeRoot = CommonTreeModel.getMobileTreeModel();
                break;
            }
            default: {
                nodeRoot = CommonTreeModel.getPackageTreeModel(null);
            }
        }
        this.setReptsNode(nodeRoot);
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)nodeRoot));
        ((KingdeeTreeModel)this.kDTree1.getModel()).setAsksAllowsChildren(false);
        this.kDTree1.getSelectionModel().setSelectionMode(1);
        this.kDTree1.setAutoscrolls(true);
        this.kDTable_List.getSelectManager().setSelectMode(10);
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.kDTable_List);
            this.sm.setSortAuto(true);
        }
        if (!this.selectedInfo.isEmpty()) {
            this.expandOld(nodeRoot, CtrlReportUtil.getObjectString(this.selectedInfo.get(PATH)));
            this.rowSelected();
        } else {
            this.expandOld(nodeRoot, this.firstPath);
        }
    }

    @Override
    protected void kDTree1_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.isStopChange) {
            this.isStopChange = false;
            return;
        }
        Object object = this.kDTree1.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
            JTree tree = (JTree)e.getSource();
            this.path = RunReportParam.getPathString(tree.getSelectionPath().getPath());
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)object;
            this.tableFlag = selectedNode.getUserObject().toString();
            DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)selectedNode.getParent();
            if (parentNode.getUserObject() instanceof IBriefViewTreeNode) {
                IBriefViewTreeNode bvNode = (IBriefViewTreeNode)parentNode.getUserObject();
                this.systemID = bvNode.getFullName();
            } else if (parentNode.getUserObject() instanceof PubAcctsDAO.PubAcct) {
                PubAcctsDAO.PubAcct bvNode = (PubAcctsDAO.PubAcct)((DefaultKingdeeTreeNode)selectedNode.getParent()).getUserObject();
                this.systemID = bvNode.fid;
            }
            this.showTable();
            this.getDataList();
        } else {
            this.tableFlag = null;
            this.kDTable_List.removeRows();
        }
    }

    @Override
    protected void kDTable_List_tableClicked(KDTMouseEvent e) throws Exception {
        ArrayList blocks;
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.setDBSourceInfo();
            this.isOk = true;
            this.closeWin();
            return;
        }
        if (e.getClickCount() == 1 && e.getType() == 1 && !(blocks = this.kDTable_List.getSelectManager().getBlocks()).isEmpty()) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
            int top = block.getTop();
            int bottom = block.getBottom();
            if (bottom - top == 0) {
                HashMap mapData = (HashMap)this.kDTable_List.getRow(top).getUserObject();
                TreeManager ta = new TreeManager(this);
                ta.expandExtTreeSelected(this.kDTree1, CtrlReportUtil.getObjectString(mapData.get("fsystemid")));
            }
        }
    }

    private void setDBSourceInfo() {
        ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.kDTable_List);
        if (lstIndex.isEmpty()) {
            return;
        }
        ArrayList<HashMap> lstSelected = new ArrayList<HashMap>();
        for (int i = 0; i < lstIndex.size(); ++i) {
            int rowIndex = Integer.parseInt(lstIndex.get(i).toString());
            HashMap mapDBSource = (HashMap)this.kDTable_List.getRow(rowIndex).getUserObject();
            lstSelected.add(mapDBSource);
        }
        this.selectedInfo.put(SelectedList, lstSelected);
        this.selectedInfo.put(TYPE, this.tableFlag);
        this.selectedInfo.put(PATH, this.path);
        this.selectedInfo.put(SystemID, this.systemID);
    }

    private void showTable() {
        RptTableHeader header = this.getTableHeader(this.tableFlag);
        this.kDTable_List.removeColumns();
        KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.kDTable_List);
        if (this.sm != null) {
            this.sm.clear();
        }
        this.kDTable_List.getColumn(0).setSortable(true);
        this.kDTable_List.getColumn(1).setSortable(true);
    }

    private RptTableHeader getTableHeader(String flag) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        int w = this.kDTable_List.getWidth();
        if (w == 0) {
            w = 530;
        }
        Object[][] titleObject_s = null;
        if (flag.equals("2")) {
            titleObject_s = new Object[1][2];
            titleObject_s[0][0] = EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.TableHeadResource", (String)"dbname");
            titleObject_s[0][1] = EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.TableHeadResource", (String)"customType");
            col = new RptTableColumn("");
            col.setWidth(350);
            header.addColumn(col);
            col = new RptTableColumn("");
            col.setWidth(100);
            header.addColumn(col);
        } else if (flag.equals("6")) {
            titleObject_s = new Object[1][2];
            titleObject_s[0][0] = EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.TableHeadResource", (String)"dbname");
            titleObject_s[0][1] = MessageUtil.getMsgInfo("label404");
            col = new RptTableColumn("");
            col.setWidth((w /= 2) - 28);
            header.addColumn(col);
            col = new RptTableColumn("");
            col.setWidth(w - 28);
            header.addColumn(col);
        }
        header.setLabels(titleObject_s);
        return header;
    }

    public void getDataList() throws Exception {
        ArrayList lst = new ArrayList();
        if (this.tableFlag.equals("2")) {
            lst = CtrlReportQuery.getDbSourceListBySystemID(this.tableFlag, this.systemID);
        } else if (this.tableFlag.equals("6")) {
            lst = CtrlReportQuery.getDbSourceListBySystemID(this.tableFlag, this.systemID);
            for (HashMap map : lst) {
                map.put("fsystemid", this.getSystemID());
            }
        }
        this.fillData(lst);
    }

    @Override
    public void fillData(ArrayList lst) throws Exception {
        block3: {
            block2: {
                this.kDTable_List.removeRows();
                if (!this.tableFlag.equals("2")) break block2;
                for (HashMap map : lst) {
                    String customtype = CtrlReportUtil.getObjectString(map.get("fcustomtype"));
                    if (this.isMobile && !customtype.equals("1") && !customtype.equals("5") && !customtype.equals("2") && !customtype.equals("3")) continue;
                    IRow irow = this.kDTable_List.addRow();
                    irow.getCell(0).setValue((Object)CtrlReportUtil.getObjectString(map.get("fname")));
                    irow.getCell(1).setValue((Object)SQLCustomType.getType(CtrlReportUtil.getObjectString(map.get("fcustomtype"))));
                    irow.setUserObject((Object)map);
                }
                break block3;
            }
            if (!this.tableFlag.equals("6")) break block3;
            for (HashMap map : lst) {
                IRow irow = this.kDTable_List.addRow();
                irow.getCell(0).setValue((Object)CtrlReportUtil.getObjectString(map.get("fname")));
                irow.getCell(1).setValue((Object)CtrlReportUtil.getObjectString(map.get("fid")));
                irow.setUserObject((Object)map);
            }
        }
    }

    public void clear() {
        this.selectedInfo.clear();
    }

    public HashMap getSelectedInfo() {
        return this.selectedInfo;
    }

    public void setSelectedInfo(HashMap selectedInfo) {
        this.selectedInfo = selectedInfo;
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.tableFlag) {
            MessageUtil.showInfo("\u8bf7\u9009\u62e9\u6570\u636e\u6e90\u8282\u70b9", false);
            return;
        }
        if (this.efm == null) {
            this.efm = new ExtReportFilterManager(this);
        }
        this.efm.filte(false);
    }

    @Override
    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.kDTable_List);
        if (lstIndex.isEmpty()) {
            MessageUtil.showInfo(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label8"), false);
            return;
        }
        this.setDBSourceInfo();
        this.isOk = true;
        this.closeWin();
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isOk = false;
        this.closeWin();
    }

    @Override
    protected void btnPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.kDTable_List);
        if (lstIndex.isEmpty()) {
            MessageUtil.showInfo(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label8"), false);
            return;
        }
        if (lstIndex.size() > 1) {
            MessageUtil.showInfo(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label12"), false);
            return;
        }
        HashMap mapDBSource = null;
        for (int i = 0; i < lstIndex.size(); ++i) {
            int rowIndex = Integer.parseInt(lstIndex.get(i).toString());
            mapDBSource = (HashMap)this.kDTable_List.getRow(rowIndex).getUserObject();
        }
        ExtDataSetType extDataSetType = DatasourceSelectUI.getExtDataSetTypeByDbType(this.tableFlag);
        String sql_xx = null;
        if (null != extDataSetType) {
            sql_xx = extDataSetType.getPrefixedString("");
        }
        String reportid = null;
        String dbSourceName = null;
        if (null != mapDBSource) {
            reportid = CtrlReportUtil.getObjectString(mapDBSource.get("fid"));
            dbSourceName = CtrlReportUtil.getObjectString(mapDBSource.get("fname"));
        }
        StringBuilder define = new StringBuilder();
        define.append(sql_xx);
        define.append(this.path);
        define.append("\\");
        define.append(dbSourceName);
        define.append("\\");
        define.append(SysContext.getSysContext().getCurrentOrgUnit().getId().toString()).append(" ");
        define.append(CtrlReportUtil.getObjectString(SysContext.getSysContext().getCurrentOrgUnit().getName()));
        define.append("\\");
        define.append(this.systemID);
        define.append("\\");
        define.append(reportid);
        PreviewDbSourceUI preUI = new PreviewDbSourceUI();
        preUI.setDefine(define.toString());
        preUI.execute(false);
        if (preUI.isCancel()) {
            return;
        }
        ReportDialog.showDialog((CoreUIObject)preUI, EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.MessageResource", (String)"label74") + "--" + dbSourceName, true, true);
    }

    public static final ExtDataSetType getExtDataSetTypeByDbType(String type) {
        ExtDataSetType extDataSetType = null;
        if (type.equals("2")) {
            extDataSetType = ExtDataSetType.SQL_KSQL;
        } else if (type.equals("3")) {
            extDataSetType = ExtDataSetType.SQL_BOSQUERY;
        } else if (type.equals("4")) {
            extDataSetType = ExtDataSetType.SQL_FIX;
        } else if (type.equals("6")) {
            extDataSetType = ExtDataSetType.SQL_ENUM;
        }
        return extDataSetType;
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    @Override
    public String getTableFlag() {
        return this.tableFlag;
    }

    @Override
    public String getSystemID() {
        return this.systemID;
    }

    @Override
    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }

    @Override
    public void setStopChange(boolean isStopChange) {
        this.isStopChange = isStopChange;
    }

    public boolean isOk() {
        return this.isOk;
    }

    public int getTreeModelType() {
        return this.treeModelType;
    }

    public boolean isMobile() {
        return this.isMobile;
    }

    public void setIsMobile(boolean isMobile) {
        this.isMobile = isMobile;
        this.treeModelType = isMobile ? 1 : 0;
    }
}

