/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extendcontrols.ExtendResultObject;
import com.kingdee.bos.ctrl.extendcontrols.IF7ObjectProvider;
import com.kingdee.bos.ctrl.extendcontrols.IKDPromptIsCUSelector;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.QueryAgent;
import com.kingdee.bos.ctrl.extendcontrols.util.BosHelper;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractDeployAccreditSelectUserOnlyUI;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class DeployAccreditSelectUserOnlyUI
extends AbstractDeployAccreditSelectUserOnlyUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DeployAccreditSelectUserOnlyUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = true;
    private KDTable tableAccUser;
    EntityViewInfo view;

    public DeployAccreditSelectUserOnlyUI() throws Exception {
        this.kDButtonGroup1.add((AbstractButton)this.rbCurrent);
        this.kDButtonGroup1.add((AbstractButton)this.rbAll);
        this.rbCurrent.setSelected(true);
    }

    public DeployAccreditSelectUserOnlyUI(KDTable tableAccUser) throws Exception {
        this();
        this.tableAccUser = tableAccUser;
    }

    public void onLoad() throws Exception {
        this.initUserOneUserF7();
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.kDLabelContainer1.setBoundLabelLength(60);
    }

    private void initUserOneUserF7() throws BOSException, EASBizException {
        if (this.rbCurrent.isSelected() && null == this.view) {
            IObjectPK currentUserPK = this.getCurrentUserPK();
            this.view = this.getUserCondition(currentUserPK);
        }
        this.pmtUser.setEntityViewInfo(this.view);
        this.pmtUser.setEnabledMultiSelection(true);
        this.pmtUser.setCommitParser((IParser)new MyParser(this.pmtUser));
    }

    private EntityViewInfo getUserCondition(IObjectPK currentUserPK) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter = Administrator.isCUAdmin(null, (IObjectPK)currentUserPK) ? this.getAdminUserCondition(currentUserPK, true) : (Administrator.isBizAdmin(null, (IObjectPK)currentUserPK) ? this.getAdminUserCondition(currentUserPK, false) : this.getCommonUserCondition(currentUserPK));
        filter.mergeFilter(this.getAdminExceptFilter(), "and");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    private FilterInfo getAdminUserCondition(IObjectPK currentUserPK, boolean isCUAdmin) throws BOSException, EASBizException {
        List manageCuIDList = null;
        manageCuIDList = isCUAdmin ? PermissionRangeHelper.getUserOrgId(null, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE) : PermissionRangeHelper.getUserOrgId(null, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.MANAGE_ORG_TYPE);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ToolUtils.aryToStr((List)manageCuIDList), CompareType.INNER));
        return filterInfo;
    }

    private FilterInfo getCommonUserCondition(IObjectPK currentUserPK) {
        FilterInfo filter = new FilterInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT DISTINCT FUserID FROM T_PM_OrgRange ").append(" WHERE FOrgID IN (SELECT FOrgID FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(currentUserPK).append("' ").append(" AND FType = ").append(10).append(") ").append(" AND FType = ").append(10).append(" ").append(" AND FUserID <> '").append(currentUserPK.toString()).append("' ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), CompareType.INNER));
        return filter;
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    private FilterInfo getForbidden() {
        FilterInfo userFilterInfo = new FilterInfo();
        userFilterInfo.getFilterItems().add(new FilterItemInfo("forbidden", (Object)"1", CompareType.NOTEQUALS));
        return userFilterInfo;
    }

    private FilterInfo getAdminExceptFilter() {
        return Administrator.getNotAdminUserFilter();
    }

    @Override
    protected void rbAll_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.pmtUser.setEntityViewInfo(null);
        }
    }

    @Override
    protected void rbCurrent_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.initUserOneUserF7();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        Object[] objecs = (Object[])this.pmtUser.getData();
        int size = objecs.length;
        String[] selectedIDs = new String[size];
        for (int i = 0; i < size; ++i) {
            String fid;
            UserInfo userInfo = (UserInfo)objecs[i];
            if (userInfo == null) {
                MessageUtil.showInfo("\u8bf7\u9009\u62e9\u7528\u6237", false);
                this.pmtUser.requestFocus();
                return;
            }
            String id = CtrlReportUtil.getObjectString(userInfo.getId());
            String name = CtrlReportUtil.getObjectString(userInfo.getName());
            selectedIDs[i] = fid = id;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fid", fid);
            Object[] values = new String[]{name};
            TableManager.insertToTable(this.tableAccUser, "fid", map, values);
        }
        TableManager.rowSelected(this.tableAccUser, selectedIDs, "fid");
        this.isCancel = false;
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    class MyParser
    extends KDBizPromptBox.DefaultParser {
        public MyParser(KDBizPromptBox pb) {
            super(pb);
        }

        public MyParser(String str, KDBizPromptBox pb) {
            super(str, pb);
        }

        public Object stringToValue(String t) {
            if (t != null && t.indexOf("\t") > 0) {
                t = t.substring(0, t.lastIndexOf("\t"));
            }
            if (StringUtil.isEmptyString((String)t)) {
                return null;
            }
            QueryAgent agent = this.prompt.getQueryAgent();
            if (agent == null) {
                return null;
            }
            String extendImpClassName = this.getExtendImpClassName(BosHelper.getQuery((MetaDataPK)agent.getQueryInfoPK()));
            Object o = new Object();
            o = extendImpClassName == null || extendImpClassName.length() == 0 ? this.stringToValueImp(t, agent, KDPromptBox.DEFAULTVALUE) : this.stringToValueExtendImp(t, agent, KDPromptBox.DEFAULTVALUE, extendImpClassName);
            agent.resetRuntimeEntityView();
            return o;
        }

        protected Object stringToValueImp(String t, QueryAgent agent, Object defaultValue) {
            Object o = defaultValue;
            int PAGELENGTH = 100;
            Map[] maps = this.getConditionMaps(t);
            this.prompt.getQueryAgent().setQueryExecutor(null);
            IRowSet equalRowSet = null;
            if (this.prompt.getSelector() instanceof IKDPromptIsCUSelector) {
                IKDPromptIsCUSelector isCUSelector = (IKDPromptIsCUSelector)this.prompt.getSelector();
                boolean orgF7isCuFilter = isCUSelector.isCUFilter();
                this.prompt.getQueryAgent().setHasCUDefaultFilter(orgF7isCuFilter);
            } else {
                this.prompt.getQueryAgent().setHasCUDefaultFilter(false);
            }
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOriginEqual(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return defaultValue;
            }
            EntityViewInfo eviFromAgent = null;
            try {
                eviFromAgent = new EntityViewInfo(this.prompt.getQueryAgent().getRuntimeEntityView().toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            equalRowSet = this.prompt.getQueryAgent().executeQuery(0, 100);
            int equalRowSetSize = 0;
            if (equalRowSet != null) {
                equalRowSetSize = equalRowSet.size();
            }
            if (equalRowSetSize == 1 && this.prompt.isOnlyReturn()) {
                o = agent.isEnabledMultiSelection() ? this.buildReturnValue(this.prompt.getQueryAgent(), equalRowSet, 1) : ((o = this.buildReturnValue(this.prompt.getQueryAgent(), equalRowSet, 1)) != null && o instanceof Object[] && ((Object[])o).length > 0 ? o[0] : defaultValue);
                return o;
            }
            this.prompt.getQueryAgent().setQueryExecutor(null);
            IRowSet likeRowSet = null;
            IRowSet rowSet = null;
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOriginLike(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return defaultValue;
            }
            likeRowSet = this.prompt.getQueryAgent().executeQuery(0, 100 - equalRowSetSize);
            try {
                if (equalRowSet != null) {
                    if (likeRowSet == null) {
                        rowSet = equalRowSet;
                    } else {
                        rowSet = DynamicRowSet.create((IRowSet)equalRowSet);
                        ((DynamicRowSet)rowSet).insertRows(equalRowSet);
                        ((DynamicRowSet)rowSet).insertRows(likeRowSet);
                        rowSet.beforeFirst();
                    }
                } else {
                    rowSet = likeRowSet;
                }
            }
            catch (SQLException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
            if (rowSet == null) {
                return defaultValue;
            }
            int size = rowSet.size();
            if (size < 1) {
                return defaultValue;
            }
            this.prompt.getQueryAgent().setQueryExecutor(null);
            if (!this.prompt.getQueryAgent().upgradeEntityViewFromOrigin(maps)) {
                logger.info((Object)"warning: view set filter failed!");
                return defaultValue;
            }
            if (equalRowSetSize < 100) {
                try {
                    eviFromAgent = new EntityViewInfo(this.prompt.getQueryAgent().getEntityViewInfo().toString());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            o = agent.isEnabledMultiSelection() ? this.buildReturnValue(this.prompt.getQueryAgent(), rowSet, size) : this.buildReturnValue(this.prompt.getQueryAgent(), rowSet, 1)[0];
            return o;
        }

        protected Object stringToValueExtendImp(String t, QueryAgent agent, Object defaultValue, String className) {
            try {
                Class<?> classDefinition = Class.forName(className);
                IF7ObjectProvider provider = (IF7ObjectProvider)classDefinition.newInstance();
                UIContext uictx = this.prompt.gettMaintainUIContext();
                uictx.put((Object)"F7", (Object)this.prompt);
                EntityViewInfo eviFromAgent = null;
                try {
                    eviFromAgent = new EntityViewInfo(agent.getRuntimeEntityView().toString());
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                String queryInfo = this.prompt.getQueryInfo();
                queryInfo = queryInfo.replaceAll("\\\\", ".");
                ExtendResultObject ero = provider.stringToValueImp(t, queryInfo, agent.getRuntimeEntityView(), this.prompt.getCurrentMainBizOrgUnit(), uictx);
                if (ero == null || !ero.isExecuteQuery()) {
                    return this.stringToValueImp(t, agent, KDPromptBox.DEFAULTVALUE);
                }
                IRowSet rowset = ero.getRowset();
                Object o = defaultValue;
                if (rowset == null) {
                    return defaultValue;
                }
                int size = rowset.size();
                if (size < 1) {
                    return defaultValue;
                }
                o = agent.isEnabledMultiSelection() ? this.buildReturnValue(agent, rowset, size) : this.buildReturnValue(agent, rowset, 1)[0];
                return o;
            }
            catch (Exception e) {
                e.printStackTrace();
                return defaultValue;
            }
        }
    }
}

