/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.PermissionRangeHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.client.f7.NewOrgF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractDeployAccreditSelectUserUI;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.param.SnapOrgSelector;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class DeployAccreditSelectUserUI
extends AbstractDeployAccreditSelectUserUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DeployAccreditSelectUserUI.class);
    private boolean isinitLayout = false;
    private boolean isCancel = true;
    private boolean isInitOrgOne = false;
    private KDTable tableAccUser;

    public DeployAccreditSelectUserUI() throws Exception {
        this.kDButtonGroup1.add((AbstractButton)this.rbOrgOne);
        this.kDButtonGroup1.add((AbstractButton)this.rbUserOne);
        this.rbUserOne.setSelected(true);
    }

    public DeployAccreditSelectUserUI(KDTable tableAccUser) throws Exception {
        this();
        this.tableAccUser = tableAccUser;
    }

    public void onLoad() throws Exception {
        this.initUserOneUserF7();
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private void initUserOneUserF7() throws BOSException, EASBizException {
        this.pbUserOneUser.setEnabledMultiSelection(false);
        this.pbUserOneOrg.setEnabled(false);
    }

    private EntityViewInfo getUserCondition(IObjectPK currentUserPK) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter = Administrator.isCUAdmin(null, (IObjectPK)currentUserPK) ? this.getAdminUserCondition(currentUserPK, true) : (Administrator.isBizAdmin(null, (IObjectPK)currentUserPK) ? this.getAdminUserCondition(currentUserPK, false) : this.getCommonUserCondition(currentUserPK));
        filter.mergeFilter(this.getAdminExceptFilter(), "and");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    private FilterInfo getAdminUserCondition(IObjectPK currentUserPK, boolean isCUAdmin) throws BOSException, EASBizException {
        List manageCuIDList = null;
        manageCuIDList = isCUAdmin ? PermissionRangeHelper.getUserOrgId(null, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.BIZ_ORG_TYPE) : PermissionRangeHelper.getUserOrgId(null, (IObjectPK)currentUserPK, (OrgRangeType)OrgRangeType.MANAGE_ORG_TYPE);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ToolUtils.aryToStr((List)manageCuIDList), CompareType.INNER));
        return filterInfo;
    }

    private FilterInfo getCommonUserCondition(IObjectPK currentUserPK) {
        FilterInfo filter = new FilterInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT DISTINCT FUserID FROM T_PM_OrgRange ").append(" WHERE FOrgID IN (SELECT FOrgID FROM T_PM_OrgRange ").append(" WHERE FUserID = '").append(currentUserPK).append("' ").append(" AND FType = ").append(10).append(") ").append(" AND FType = ").append(10).append(" ").append(" AND FUserID <> '").append(currentUserPK.toString()).append("' ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)buffer.toString(), CompareType.INNER));
        return filter;
    }

    private void initOrgOneOrgF7() throws BOSException, EASBizException {
        IObjectPK selectedOrgPK;
        if (!this.isInitOrgOne) {
            NewOrgF7 orgF7 = new NewOrgF7((IUIObject)this);
            SnapOrgSelector.setReportOrgF7Property(orgF7, (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
            this.pbOrgOneOrg.setSelector((KDPromptSelector)orgF7);
            this.pbOrgOneOrg.setEnabledMultiSelection(false);
            this.pbOrgOneOrg.setDisplayFormat("$name$");
            this.pbOrgOneOrg.setEditFormat("$number$");
            this.pbOrgOneOrg.setCommitFormat("$number$");
            this.isInitOrgOne = true;
        }
        if ((selectedOrgPK = this.getSelectedOrgPK()) == null) {
            this.pbOrgOneUser.setEnabled(false);
        }
    }

    private IObjectPK getCurrentUserPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    }

    private IObjectPK getCurrentCUPK() {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    private FilterInfo getAdminExceptFilter() {
        return Administrator.getNotAdminUserFilter();
    }

    private IObjectPK getSelectedUserPK() {
        if (this.pbUserOneUser.getData() == null) {
            return null;
        }
        return new ObjectUuidPK(((UserInfo)this.pbUserOneUser.getData()).getId());
    }

    private IObjectPK getSelectedOrgPK() {
        if (this.pbOrgOneOrg.getData() == null) {
            return null;
        }
        IObjectValue orgOV = (IObjectValue)this.pbOrgOneOrg.getData();
        String id = CtrlReportUtil.getObjectString(orgOV.get("id"));
        return new ObjectUuidPK(id);
    }

    @Override
    protected void pbUserOneUser_dataChanged(DataChangeEvent e) throws Exception {
        IObjectPK selectedUserPK = this.getSelectedUserPK();
        this.pbUserOneOrg.setData(null);
        if (selectedUserPK != null) {
            this.pbUserOneOrg.setEnabled(true);
            NewOrgF7 orgF7 = new NewOrgF7((IUIObject)this);
            SnapOrgSelector.setReportOrgF7Property(orgF7, this.getSelectedUserPK());
            orgF7.setMultiSelect(true);
            this.pbUserOneOrg.setSelector((KDPromptSelector)orgF7);
            this.pbUserOneOrg.setDisplayFormat("$name$");
            this.pbUserOneOrg.setEditFormat("$number$");
            this.pbUserOneOrg.setCommitFormat("$number$");
        } else {
            this.pbUserOneOrg.setEnabled(false);
        }
    }

    public static FilterInfo getOrgUserFilter(Context ctx, IObjectPK orgPK, OrgRangeType type) throws Exception {
        FilterInfo ret = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo("id", (Object)DeployAccreditSelectUserUI.getUserIdSetByOrg(ctx, orgPK, type), CompareType.INCLUDE);
        ret.getFilterItems().add(item);
        return ret;
    }

    public static Set getUserIdSetByOrg(Context ctx, IObjectPK orgPK, OrgRangeType type) throws Exception {
        IOrgRange iOrgRange = null;
        iOrgRange = ctx == null ? OrgRangeFactory.getRemoteInstance() : OrgRangeFactory.getLocalInstance((Context)ctx);
        HashSet<String> userIdSet = new HashSet<String>();
        OrgRangeCollection orgRangeCol = iOrgRange.getOrgRangeCollection("where org.id='" + orgPK.toString() + "' and type=" + type.getValue());
        for (int i = 0; i < orgRangeCol.size(); ++i) {
            userIdSet.add(orgRangeCol.get(i).getUser().getId().toString());
        }
        return userIdSet;
    }

    @Override
    protected void pbOrgOneOrg_dataChanged(DataChangeEvent e) throws Exception {
        IObjectPK selectedOrgPK = this.getSelectedOrgPK();
        this.pbOrgOneUser.setData(null);
        if (selectedOrgPK != null) {
            this.pbOrgOneUser.setEnabled(true);
            EntityViewInfo view = new EntityViewInfo();
            ObjectUuidPK orgPk = new ObjectUuidPK("id", selectedOrgPK.toString());
            FilterInfo filterInfo = DeployAccreditSelectUserUI.getOrgUserFilter(null, (IObjectPK)orgPk, OrgRangeType.BIZ_ORG_TYPE);
            view.setFilter(filterInfo);
            this.pbOrgOneUser.setEntityViewInfo(view);
            this.pbOrgOneUser.setEnabledMultiSelection(true);
        } else {
            this.pbOrgOneUser.setEnabled(false);
        }
    }

    @Override
    protected void rbUserOne_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.pbUserOneUser.setEnabled(true);
            this.pbOrgOneOrg.setEnabled(false);
            this.pbOrgOneUser.setEnabled(false);
            this.pbUserOneOrg.setEnabled(this.pbUserOneUser.getData() != null);
        }
    }

    @Override
    protected void rbOrgOne_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 1) {
            this.pbUserOneOrg.setEnabled(false);
            this.pbUserOneUser.setEnabled(false);
            this.pbOrgOneOrg.setEnabled(true);
            this.pbOrgOneUser.setEnabled(true);
            this.initOrgOneOrgF7();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.rbUserOne.isSelected()) {
            IObjectValue userOV = (IObjectValue)this.pbUserOneUser.getData();
            if (userOV == null) {
                MessageUtil.showInfo("\u8bf7\u9009\u62e9\u7528\u6237", false);
                this.pbUserOneUser.requestFocus();
                return;
            }
            String userID = CtrlReportUtil.getObjectString(userOV.get("id"));
            String userName = CtrlReportUtil.getObjectString(userOV.get("name"));
            IObjectValue[] orgOVs = (IObjectValue[])this.pbUserOneOrg.getData();
            if (orgOVs == null) {
                MessageUtil.showInfo("\u8bf7\u9009\u62e9\u7ec4\u7ec7", false);
                this.pbUserOneOrg.requestFocus();
                return;
            }
            int size = orgOVs.length;
            String[] selectedIDs = new String[size];
            for (int i = 0; i < size; ++i) {
                String fid;
                IObjectValue orgOV = orgOVs[i];
                String orgID = CtrlReportUtil.getObjectString(orgOV.get("id"));
                String orgName = CtrlReportUtil.getObjectString(orgOV.get("name"));
                selectedIDs[i] = fid = userID + "\\" + orgID;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fid", fid);
                map.put("username", userName);
                map.put("orgname", orgName);
                Object[] values = new String[]{userName, orgName};
                TableManager.insertToTable(this.tableAccUser, "fid", map, values);
            }
            TableManager.rowSelected(this.tableAccUser, selectedIDs, "fid");
        } else if (this.rbOrgOne.isSelected()) {
            IObjectValue iv = (IObjectValue)this.pbOrgOneOrg.getData();
            if (iv == null) {
                MessageUtil.showInfo("\u8bf7\u9009\u62e9\u7ec4\u7ec7", false);
                this.pbUserOneOrg.requestFocus();
                return;
            }
            String orgID = CtrlReportUtil.getObjectString(iv.get("id"));
            String orgName = CtrlReportUtil.getObjectString(iv.get("name"));
            Object[] objecs = (Object[])this.pbOrgOneUser.getData();
            int size = objecs.length;
            String[] selectedIDs = new String[size];
            for (int i = 0; i < size; ++i) {
                String fid;
                UserInfo userInfo = (UserInfo)objecs[i];
                if (userInfo == null) {
                    MessageUtil.showInfo("\u8bf7\u9009\u62e9\u7528\u6237", false);
                    this.pbOrgOneUser.requestFocus();
                    return;
                }
                String userID = CtrlReportUtil.getObjectString(userInfo.getId());
                String userName = CtrlReportUtil.getObjectString(userInfo.getName());
                selectedIDs[i] = fid = userID + "\\" + orgID;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fid", fid);
                map.put("username", userName);
                map.put("orgname", orgName);
                Object[] values = new String[]{userName, orgName};
                TableManager.insertToTable(this.tableAccUser, "fid", map, values);
            }
            TableManager.rowSelected(this.tableAccUser, selectedIDs, "fid");
        }
        this.isCancel = false;
        CtrlReportUtil.closeWin((CoreUIObject)this);
    }
}

