/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.cloud.model.RptCategoryVO;
import com.kingdee.eas.rpts.ctrlreport.IPopupSelector;
import com.kingdee.eas.rpts.ctrlreport.adapter.ExtReportFilterManager;
import com.kingdee.eas.rpts.ctrlreport.adapter.IFilter;
import com.kingdee.eas.rpts.ctrlreport.adapter.TableManager;
import com.kingdee.eas.rpts.ctrlreport.adapter.TreeManager;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractDeploySelectedUI;
import com.kingdee.eas.rpts.ctrlreport.client.DeployBatchUI;
import com.kingdee.eas.rpts.ctrlreport.client.ExtReportManageUI;
import com.kingdee.eas.rpts.ctrlreport.mobile.model.AbstractMobileVO;
import com.kingdee.eas.rpts.ctrlreport.mobile.model.MobileType;
import com.kingdee.eas.rpts.ctrlreport.mobile.server.PubAcctsDAO;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlreport.model.ExtReportViewType;
import com.kingdee.eas.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.eas.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.eas.rpts.sumreport.enumtype.TempletType;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class DeploySelectedUI
extends AbstractDeploySelectedUI
implements IFilter,
IPopupSelector {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(DeploySelectedUI.class);
    private boolean isinitLayout = false;
    private boolean isCanceled = true;
    boolean isStopChange = false;
    private String systemID = null;
    private String tableFlag = "1";
    ArrayList lstSelected = new ArrayList();
    ExtReportFilterManager efm;
    DeploySelectedUI deploySelectedUI = this;
    String uiFlag;
    boolean isMulteSelected = true;
    boolean isF7 = false;
    String selectedTreeNode = "";
    private boolean isStdManagerRuntime;
    private int publishType = 1;
    private String leafParentTreePathString;
    private ExtReportViewType viewType;

    public DeploySelectedUI() throws Exception {
        this.tableReport.checkParsed();
        this.tableSelected.checkParsed();
        this.initLayout();
        this.putClientProperty("ShowToolBar", this.toolBar);
    }

    public DeploySelectedUI(String uiFlag) throws Exception {
        this();
        this.uiFlag = uiFlag;
    }

    public DeploySelectedUI(String uiFlag, boolean isF7) throws Exception {
        this(uiFlag);
        this.isF7 = isF7;
    }

    public void setIsStdManagerRuntime(boolean isStdManagerRuntime) {
        this.isStdManagerRuntime = isStdManagerRuntime;
    }

    public void setPublishType(int publishType) {
        this.publishType = publishType;
    }

    public void onLoad() throws Exception {
        if (this.isF7) {
            return;
        }
        this.initCtrl();
    }

    public void initLayout() {
        if (!this.isinitLayout) {
            super.initLayout();
            this.isinitLayout = true;
        }
    }

    private void initCtrl() {
        DefaultKingdeeTreeNode nodeRoot;
        if (this.isF7) {
            this.lstSelected.clear();
            this.tableSelected.removeRows();
        }
        this.isCanceled = true;
        if (this.viewType.isMobileExtReportView()) {
            if (this.viewType.isCloudRptView()) {
                nodeRoot = CommonTreeModel.getMobileCloudRptTreeModel();
            } else {
                nodeRoot = CommonTreeModel.getMobileTreeModel();
                this.setReptsNode(nodeRoot);
            }
        } else if (this.viewType.isCloudRptView()) {
            nodeRoot = CommonTreeModel.getCloudRptTreeModel();
        } else {
            nodeRoot = CommonTreeModel.getPackageTreeModel(null);
            this.setReptsNode(nodeRoot);
        }
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)nodeRoot));
        this.kDTree1.getSelectionModel().setSelectionMode(1);
        ((KingdeeTreeModel)this.kDTree1.getModel()).setAsksAllowsChildren(false);
        this.kDTree1.setAutoscrolls(true);
        this.tableReport.getStyleAttributes().setLocked(true);
        if (this.isMulteSelected) {
            this.tableReport.getSelectManager().setSelectMode(10);
        } else {
            this.tableReport.getSelectManager().setSelectMode(2);
        }
        TableLayout tAll = TableLayout.split((int)2, (int)1);
        tAll.rowStyle(0).setHeight(19);
        tAll.rowStyle(0).setMarginBottom(3);
        tAll.rowStyle(1).setPriY(1);
        Table tTop = tAll.cell(0).split(1, 3);
        tTop.colStyle(0).setPriX(1);
        tTop.colStyle(1).setWidth(80);
        tTop.colStyle(1).setMarginRight(3);
        tTop.colStyle(2).setWidth(80);
        this.kDPanel1.removeAll();
        this.kDPanel1.setLayout((LayoutManager)tAll);
        this.kDPanel1.add((Component)this.selectedTitle, (Object)tTop.cell(0));
        this.kDPanel1.add((Component)this.btnAdd, (Object)tTop.cell(1));
        this.kDPanel1.add((Component)this.btnDelete, (Object)tTop.cell(2));
        this.kDPanel1.add((Component)this.tableSelected, (Object)tAll.cell(1, 0));
        TreeManager.treeSelected(this.kDTree1, nodeRoot, this.tableFlag, this.selectedTreeNode);
    }

    private void setReptsNode(DefaultKingdeeTreeNode nodeRoot) {
        if (nodeRoot.isLeaf()) {
            this.addExtNode(nodeRoot);
        } else {
            Enumeration enume = nodeRoot.children();
            while (enume.hasMoreElements()) {
                DefaultKingdeeTreeNode repNode = (DefaultKingdeeTreeNode)enume.nextElement();
                this.setReptsNode(repNode);
            }
            if (!nodeRoot.isRoot()) {
                this.addExtNode(nodeRoot);
            }
        }
    }

    private void addExtNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode DKTreeNode1 = new DefaultKingdeeTreeNode();
        DKTreeNode1.setText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.ReportsResource", (String)"defineReport"));
        DKTreeNode1.setCustomIcon((Icon)ResourceManager.getIcon(ExtReportManageUI.class, (String)"tbtn_ext.gif"));
        DKTreeNode1.setUserObject((Object)"1");
        node.add((MutableTreeNode)DKTreeNode1);
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        if (null == this.tableFlag) {
            MessageUtil.showInfo("label332", true);
            return;
        }
        if (this.efm == null) {
            this.efm = new ExtReportFilterManager(this);
        }
        this.efm.filte(false);
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.closeWin();
    }

    @Override
    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        int length = this.tableSelected.getRowCount();
        if (length <= 0) {
            MessageUtil.showInfo("label8", true);
            return;
        }
        this.selectedTreeNode = this.getSystemID();
        for (int i = 0; i < length; ++i) {
            Object obj = this.tableSelected.getRow(i).getUserObject();
            this.lstSelected.add(obj);
        }
        this.isCanceled = false;
        this.closeWin();
    }

    private void insertToSelected(HashMap mapData) {
        String fid = mapData.get("fid").toString();
        String fname = mapData.get("fname").toString();
        if (DeployBatchUI.isExistReport(this.tableSelected, fid)) {
            return;
        }
        IRow irow = this.tableSelected.addRow();
        irow.getStyleAttributes().setLocked(true);
        irow.getCell(0).setValue((Object)fname);
        irow.setUserObject((Object)mapData);
    }

    @Override
    protected void tableReport_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            return;
        }
        int row = this.tableReport.getSelectManager().getActiveRowIndex();
        HashMap mapData = (HashMap)this.tableReport.getRow(row).getUserObject();
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.insertToSelected(mapData);
        } else {
            TreeManager ta = new TreeManager(this);
            ta.expandExtTreeSelected(this.kDTree1, CtrlReportUtil.getObjectString(mapData.get("fsystemid")));
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        ArrayList lstIndex = TableManager.getSelectedTableIndexs(this.tableReport);
        if (lstIndex.isEmpty()) {
            return;
        }
        for (int i = 0; i < lstIndex.size(); ++i) {
            int rowIndex = Integer.parseInt(lstIndex.get(i).toString());
            HashMap mapData = (HashMap)this.tableReport.getRow(rowIndex).getUserObject();
            this.insertToSelected(mapData);
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        int selEnd;
        KDTSelectBlock sel = this.tableSelected.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int selBegin = sel.getBeginRow();
        for (int i = selEnd = sel.getEndRow(); i >= selBegin; --i) {
            this.tableSelected.removeRow(i);
        }
    }

    @Override
    protected void tableSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            int row = this.tableSelected.getSelectManager().getActiveRowIndex();
            this.tableSelected.removeRow(row);
        }
    }

    @Override
    protected void kDTree1_valueChanged(TreeSelectionEvent e) throws Exception {
        if (this.isStopChange) {
            this.isStopChange = false;
            return;
        }
        Object object = this.kDTree1.getLastSelectedPathComponent();
        if (object != null && object instanceof DefaultKingdeeTreeNode && ((DefaultKingdeeTreeNode)object).isLeaf()) {
            Object bvNode;
            this.leafParentTreePathString = RunReportParam.getPathString(this.kDTree1.getSelectionPath().getParentPath().getPath());
            DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)object;
            DefaultKingdeeTreeNode parentNode = (DefaultKingdeeTreeNode)selectedNode.getParent();
            if (parentNode.getUserObject() instanceof IBriefViewTreeNode) {
                bvNode = (IBriefViewTreeNode)parentNode.getUserObject();
                this.systemID = bvNode.getFullName();
                this.tableFlag = selectedNode.getUserObject().toString();
            } else if (parentNode.getUserObject() instanceof PubAcctsDAO.PubAcct) {
                bvNode = (PubAcctsDAO.PubAcct)((DefaultKingdeeTreeNode)selectedNode.getParent()).getUserObject();
                this.systemID = ((PubAcctsDAO.PubAcct)bvNode).fid;
                this.tableFlag = selectedNode.getUserObject().toString();
            } else if (selectedNode.getUserObject() != null && selectedNode.getUserObject() instanceof MobileType) {
                bvNode = (MobileType)selectedNode.getUserObject();
                this.systemID = ((AbstractMobileVO)bvNode).getId();
                this.tableFlag = "1";
            } else if (selectedNode.getUserObject() != null && selectedNode.getUserObject() instanceof RptCategoryVO) {
                bvNode = (RptCategoryVO)selectedNode.getUserObject();
                this.systemID = ((RptCategoryVO)bvNode).getId();
                this.tableFlag = "1";
            }
            ArrayList lst = null;
            if (this.uiFlag.equals(DeployBatchUI.class.getName())) {
                lst = this.isStdManagerRuntime ? DefineReportBO.getStdReportListBySystemID(this.systemID, this.publishType) : DefineReportBO.getReportListBySystemID(this.systemID, this.publishType, this.viewType.isCloudRptView());
            } else {
                lst = DefineReportBO.getReportListBySystemID(this.systemID, this.uiFlag, this.viewType.isCloudRptView());
                if (this.isStdManagerRuntime && lst != null) {
                    Iterator iter = lst.iterator();
                    while (iter.hasNext()) {
                        HashMap item = (HashMap)iter.next();
                        String fisstdproduct = CtrlReportUtil.getObjectString(item.get("fisstdproduct"));
                        if ("1".equals(fisstdproduct)) continue;
                        iter.remove();
                    }
                }
            }
            this.fillData(lst);
        } else {
            this.systemID = "-1";
            this.tableReport.removeRows();
        }
    }

    @Override
    public void fillData(ArrayList lst) throws Exception {
        this.tableReport.removeRows();
        for (HashMap map : lst) {
            TempletType ftemplettype = TempletType.getTempletType(CtrlReportUtil.getObjectString(map.get("ftemplettype")));
            IRow irow = this.tableReport.addRow();
            String fisstdproduct = CtrlReportUtil.getObjectString(map.get("fisstdproduct"));
            if (fisstdproduct.equals("1")) {
                irow.getStyleAttributes().setBackground(new Color(255, 255, 200));
            }
            String fname = CtrlReportUtil.getObjectString(map.get("fname"));
            irow.getCell(0).setValue((Object)fname);
            String extReportPath = this.leafParentTreePathString + "/" + fname;
            extReportPath = ExtStringUtil.replace(extReportPath, "\\", "/");
            map.put("reportFullPathCaption", extReportPath);
            irow.setUserObject((Object)map);
        }
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    @Override
    public void setStopChange(boolean isStopChange) {
        this.isStopChange = isStopChange;
    }

    @Override
    public String getSystemID() {
        return this.systemID;
    }

    @Override
    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }

    public ArrayList getLstSelected() {
        return this.lstSelected;
    }

    @Override
    public String getTableFlag() {
        return this.tableFlag;
    }

    public String getUiFlag() {
        return this.uiFlag;
    }

    public void setUiFlag(String uiFlag) {
        this.uiFlag = uiFlag;
    }

    public void setSelectedTreeNode(String selectedTreeNode) {
        this.selectedTreeNode = selectedTreeNode;
    }

    @Override
    public Component getComponentSelector() {
        return this;
    }

    @Override
    public Object getData() {
        int size = this.lstSelected.size();
        DefObj[] defs = new DefObj[this.lstSelected.size()];
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)this.lstSelected.get(i);
            DefObj def = new DefObj();
            def.setName(CtrlReportUtil.getObjectString(map.get("fid")));
            def.setAlias(CtrlReportUtil.getObjectString(map.get("fname")));
            defs[i] = def;
        }
        return defs;
    }

    @Override
    public int getHeightSelector() {
        return this.getHeight();
    }

    @Override
    public KDToolBar getToolBarSelector() {
        return this.toolBar;
    }

    @Override
    public int getWidthSelector() {
        return this.getWidth();
    }

    @Override
    public void initLayoutSelector() {
        this.initLayout();
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void onLoadSelector() throws Exception {
        this.onLoad();
    }

    @Override
    public void showSelector() {
        this.initCtrl();
    }

    @Override
    public void setParamMap(HashMap paramMap) {
    }

    public void setViewType(ExtReportViewType viewType) {
        this.viewType = viewType;
    }

    public ExtReportViewType getViewType() {
        return this.viewType;
    }
}

