/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractDiscretePermissionUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DiscretePermissionUI
extends AbstractDiscretePermissionUI {
    private static final long serialVersionUID = 8300074614560626251L;
    private HashMap exitsReport = new HashMap();
    private boolean isCanceled = false;
    private HashMap mapExpanded = new HashMap();

    public DiscretePermissionUI() throws Exception {
        this.initTree();
    }

    private void initTree() {
        BOSObjectType[] types = new BOSObjectType[]{MetaDataTypeList.PACKAGE};
        IBriefViewTreeNode root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_packages", (BOSObjectType[])types);
        DefaultKingdeeTreeNode nodeRoot = new DefaultKingdeeTreeNode((Object)"EAS");
        nodeRoot.setText(EASResource.getString((String)"com.kingdee.eas.rpts.ctrlreport.ReportsResource", (String)"reportRoot"));
        nodeRoot.setUserObject((Object)root);
        nodeRoot = this.convertToKingdeeTreeNode(root, nodeRoot);
        this.kDTree1.setModel((TreeModel)new KingdeeTreeModel((TreeNode)nodeRoot));
        ((KingdeeTreeModel)this.kDTree1.getModel()).setAsksAllowsChildren(true);
        this.kDTree1.setShowCheckBox(true);
        this.kDTree1.getSelectionModel().setSelectionMode(1);
        this.kDTree1.setAutoscrolls(true);
        this.kDTree1.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                try {
                    DiscretePermissionUI.this.changedShow(event);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private DefaultKingdeeTreeNode convertToKingdeeTreeNode(IBriefViewTreeNode root, DefaultKingdeeTreeNode nodeRoot) {
        nodeRoot.setCheckBoxVisible(false);
        Enumeration enu = root.children();
        while (enu.hasMoreElements()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)enu.nextElement();
            String strNodeName = bvNode.getAlias() + "(" + bvNode.getName() + ")";
            DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode();
            node.setText(strNodeName);
            node.setUserObject((Object)bvNode);
            nodeRoot.add((MutableTreeNode)node);
            this.convertToKingdeeTreeNode(bvNode, node);
        }
        return nodeRoot;
    }

    @Override
    protected void kDTree1_treeExpanded(TreeExpansionEvent e) throws Exception {
        TreePath treePath = e.getPath();
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)treePath.getLastPathComponent();
        if (!selectedNode.isRoot()) {
            IBriefViewTreeNode bvNode = (IBriefViewTreeNode)selectedNode.getUserObject();
            String fsystemid = bvNode.getFullName();
            if (this.mapExpanded.containsKey(fsystemid)) {
                return;
            }
            ArrayList lst = DefineReportBO.getDepReportList(fsystemid, false);
            if (!lst.isEmpty()) {
                for (HashMap map : lst) {
                    DefaultKingdeeTreeNode dktNode = new DefaultKingdeeTreeNode();
                    dktNode.setText(String.valueOf(map.get("fname")));
                    dktNode.setAllowsChildren(false);
                    dktNode.setCheckBoxVisible(true);
                    dktNode.setUserObject((Object)map);
                    ((DefaultTreeModel)this.kDTree1.getModel()).insertNodeInto((MutableTreeNode)dktNode, (MutableTreeNode)selectedNode, selectedNode.getChildCount());
                }
            }
            this.mapExpanded.put(fsystemid, null);
        }
    }

    private void changedShow(TreeNodeStateChangeEvent event) throws Exception {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getNode();
        int value = node.getCheckedValue();
        if (value == 32) {
            HashMap map = (HashMap)node.getUserObject();
            this.exitsReport.put(map.get("fid"), map);
        } else {
            HashMap map = (HashMap)node.getUserObject();
            this.exitsReport.remove(map.get("fid"));
        }
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.closeWin();
    }

    @Override
    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = false;
        this.closeWin();
    }

    private void closeWin() {
        Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
        parent.setVisible(false);
        parent.dispose();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public HashMap getExitsReport() {
        return this.exitsReport;
    }
}

