/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.rpts.ctrlreport.adapter.ExtReportFilterManager;
import com.kingdee.eas.rpts.ctrlreport.adapter.IFilter;
import com.kingdee.eas.rpts.ctrlreport.bo.DefineReportBO;
import com.kingdee.eas.rpts.ctrlreport.bo.LicenseBo;
import com.kingdee.eas.rpts.ctrlreport.bo.MainMenuItemBO;
import com.kingdee.eas.rpts.ctrlreport.client.AbstractExtReportLicenseListUI;
import com.kingdee.eas.rpts.ctrlreport.model.CommonTreeModel;
import com.kingdee.eas.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.eas.rpts.ctrlsqldesign.model.RunReportParam;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ExtReportLicenseListUI
extends AbstractExtReportLicenseListUI
implements IFilter {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(ExtReportLicenseListUI.class);
    DefaultKingdeeTreeNode nodeRoot;
    KDTSortManager sm = null;
    ExtReportFilterManager efm;

    public ExtReportLicenseListUI() throws Exception {
        this.tblMain.checkParsed();
    }

    public void onLoad() throws Exception {
        this.setUITitle(String.valueOf(this.getUIContext().get("MainMenuName")));
        this.tblMain.getColumn(0).setWidth(200);
        this.tblMain.getColumn(1).setWidth(200);
        this.tblMain.getColumn(2).setWidth(200);
        this.tblMain.getColumn(3).setWidth(200);
        this.tblMain.getColumn(4).setWidth(200);
        this.tblMain.addColumn(5).setWidth(200);
        this.tblMain.addColumn(6).setWidth(200);
        this.tblMain.getHeadRow(0).getCell(5).setValue((Object)"Portlet\u540d\u79f0");
        this.tblMain.getHeadRow(0).getCell(6).setValue((Object)"\u5e94\u7528\u4e2d\u5fc3\u540d\u79f0");
        if (this.sm == null) {
            this.sm = new KDTSortManager(this.tblMain);
            this.sm.setSortAuto(true);
        }
        int ic = this.tblMain.getColumnCount();
        for (int i = 0; i < ic; ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        if (this.efm == null) {
            this.efm = new ExtReportFilterManager(this);
        }
        if (!this.efm.filte(false)) {
            this.abort();
        }
    }

    private void setCount() {
        int licenseCount = LicenseBo.getLicenseCount(null);
        int licenseFreeCount = 3;
        if (licenseCount > 0) {
            licenseFreeCount = 10;
        }
        int deployCount = 0;
        int stdCount = 0;
        try {
            HashMap map = DefineReportBO.getDeployListCount(null);
            deployCount = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("intNoStdcount")));
            stdCount = Integer.parseInt(CtrlReportUtil.getObjectString(map.get("intStdcount")));
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
        this.purchaseCount.setText(String.valueOf(licenseCount));
        this.freeCount.setText(String.valueOf(licenseFreeCount));
        this.useCount.setText(String.valueOf(deployCount));
        this.spareCount.setText(String.valueOf(licenseCount + licenseFreeCount - deployCount));
        this.stdCount.setText(String.valueOf(stdCount));
    }

    @Override
    public void fillData(ArrayList lst) throws Exception {
        if (this.nodeRoot == null) {
            this.nodeRoot = CommonTreeModel.getPackageTreeModel(null);
        }
        HashMap map2 = null;
        IRow row = null;
        int i = 0;
        this.tblMain.removeRows();
        for (HashMap map2 : lst) {
            int len;
            this.tblMain.addRow();
            row = this.tblMain.getRow(i);
            String fisstdproduct = CtrlReportUtil.getObjectString(map2.get("fisstdproduct"));
            if (fisstdproduct.equals("1")) {
                row.getStyleAttributes().setBackground(new Color(255, 255, 200));
            }
            row.getCell(0).setValue((Object)CtrlReportUtil.getObjectString(map2.get("reportname")));
            String fpath = RunReportParam.getSystemFullLabel(this.nodeRoot, CtrlReportUtil.getObjectString(map2.get("fsystemid")));
            if (null == fpath) {
                fpath = CtrlReportUtil.getObjectString(map2.get("fsystemid"));
            }
            if ((len = fpath.indexOf("\\")) != -1) {
                fpath = fpath.substring(len + 1);
            }
            row.getCell(1).setValue((Object)fpath);
            row.getCell(2).setValue((Object)CtrlReportUtil.getObjectString(map2.get("orgname")));
            row.getCell(3).setValue((Object)MainMenuItemBO.getDeployName(CtrlReportUtil.getObjectString(map2.get("fdeploypath"))));
            row.getCell(4).setValue((Object)MainMenuItemBO.getDeployName(CtrlReportUtil.getObjectString(map2.get("fbipath"))));
            row.getCell(5).setValue((Object)MainMenuItemBO.getDeployName(CtrlReportUtil.getObjectString(map2.get("fportletname"))));
            row.getCell(6).setValue((Object)MainMenuItemBO.getDeployName(CtrlReportUtil.getObjectString(map2.get("feaswebappcenterpath"))));
            ++i;
        }
        this.setCount();
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        if (this.efm == null) {
            this.efm = new ExtReportFilterManager(this);
        }
        this.efm.filte(false);
    }

    @Override
    public String getSystemID() {
        return null;
    }

    @Override
    public String getTableFlag() {
        return null;
    }

    @Override
    public void setStopChange(boolean isStopChange) {
    }

    @Override
    public void setSystemID(String systemID) {
    }
}

